 
 
 **************************************************
 **             环境监管与人力资本积累           **
 **************************************************
 
 
 global path "E:\OneDrive\workingpaper\environmental_regulation_and_human_capital_accumulation"
 cd $path\results
 global graphpath $path\graph
 
 use $path\data\er_and_hc.dta,clear
 
 global ctrl "han sex hukou_3"
 
 global mis "han sex hukou_3 treat post countyid provcd birthyear"
 
 global fe "provcd#birthyear countyid birthyear cmonth interviewerid18"
 
 
 
 **************************
 **    表1 描述性统计    **
 **************************
 
 use $path\data\er_and_hc.dta,clear
 egen mis= rowmiss($mis)
 drop if mis
 drop mis
 
 sum treat_pre post highschool university mathtest wordtest cognitive $ctrl
 
 
 
 
 ************************
 **   表2 基准结果     **
 ************************
 
 //是否读高中
 
 egen mis= rowmiss($mis)
 drop if mis
 drop mis
 
 reghdfe highschool c.treat#c.post treat,a(provcd#birthyear) cluster(countyid#birthyear)
 
 est store a1
 
 reghdfe highschool c.treat#c.post,a(provcd#birthyear countyid) cluster(countyid#birthyear)
 
 est store a2
 
 reghdfe highschool c.treat#c.post $ctrl,a(provcd#birthyear countyid) cluster(countyid#birthyear)
 
 est store a3
 
 reghdfe highschool c.treat#c.post $ctrl,a($fe) cluster(countyid#birthyear)
 
 est store a4
 
 outreg2 [a2 a3 a4] using 环境监管与人力资本积累基准结果_高中,excel bracket e(N_full) se dec(3) replace
 
 
 //是否读大学
 
 use $path\data\er_and_hc.dta,clear
 egen mis= rowmiss($mis)
 drop if mis
 drop mis
 
 reghdfe university c.treat#c.post treat,a(provcd#birthyear) cluster(countyid#birthyear)
 
 est store a1
 
 reghdfe university c.treat#c.post,a(provcd#birthyear countyid) cluster(countyid#birthyear)
 
 est store a2
 
 reghdfe university c.treat#c.post $ctrl,a(provcd#birthyear countyid) cluster(countyid#birthyear)
 
 est store a3
 
 reghdfe university c.treat#c.post $ctrl,a($fe) cluster(countyid#birthyear)
 
 est store a4
 
 outreg2 [a2 a3 a4] using 环境监管与人力资本积累基准结果_大学,excel bracket e(N_full) se dec(3) replace
 
 
 
 ******************************
 **   图1 基准结果动态效应   **
 ******************************
 
 //高中
 
 use $path\data\er_and_hc.dta,clear
 egen mis= rowmiss($mis)
 drop if mis
 drop mis
 
 reghdfe highschool treat_dist1 treat_dist2 treat_dist3 treat_dist4 treat_dist5 ///
         treat_dist6 treat_dist7 treat_dist8 $ctrl,a($fe) cluster(countyid#birthyear)
 
 gen t=aperiod+2
 
 gen coef=.
 forvalues i = 1(1)8 {
    replace coef = _b[treat_dist`i'] if t==`i'
 }
 
 gen se=.
 forvalues i = 1/8 {
    replace se = _se[treat_dist`i'] if t==`i'
 }
 
 gen aa = invttail(e(df_r),0.05)
 
 recode t (1=8) (2=7) (3=6) (4=5) (5=4) (6=3) (7=2) (8=1)
 gen se_plus=coef+aa*se
 gen se_minus=coef-aa*se
 keep coef se_plus se_minus t
 
 duplicates drop t,force
 
 sort t
 
 eclplot coef se_minus se_plus t,  ///
    graphregion(color(white)) bgcolor(white) plotregion(color(white)) ///
    estopts(msize(medium) mcolor(black) lc(black) lp(dash)) ciopts(lc(black) lp(solid) ///
	lw(*1) msize(large)) ytitle("估计系数",size(medium)) title("（1）高中学历",size(medium)) ///
	xtitle("政策实施时个体年龄",margin(t+3) size(medium)) ylabel(#4, format(%6.2f) grid) ///
	yline(0, lp(solid) lc(gs0) lw(thin)) xlabel(1 "12-13" 2 "10-11" 3 "8-9" 4 "6-7" 5 "4-5" 6 "2-3" 7 "0-1" 8 "-1") ///
	plotr(margin(r+3 l+3)) xline(4.5,lp(solid) lc(black) lw(thin)) ///
	xlabel(,nogrid) ylabel(,nogrid)
 
 graph save Graph $path\graph\动态效应_高中.gph,replace
 
  
 //是否读大学
 
 use $path\data\er_and_hc.dta,clear
 egen mis= rowmiss($mis)
 drop if mis
 drop mis
 
 reghdfe university treat_dist1 treat_dist2 treat_dist3 treat_dist4 treat_dist5 ///
         treat_dist6 treat_dist7 treat_dist8 $ctrl,a($fe) cluster(countyid#birthyear)
 
 gen t=aperiod+2
 
 gen coef=.
 forvalues i = 1(1)8 {
    replace coef = _b[treat_dist`i'] if t==`i'
 }
 
 gen se=.
 forvalues i = 1/8 {
    replace se = _se[treat_dist`i'] if t==`i'
 }
 
 gen aa = invttail(e(df_r),0.05)
 
 recode t (1=8) (2=7) (3=6) (4=5) (5=4) (6=3) (7=2) (8=1)
 
 gen se_plus=coef+aa*se
 
 gen se_minus=coef-aa*se
 
 keep coef se_plus se_minus t
 
 duplicates drop t,force
 
 sort t
 
 eclplot coef se_minus se_plus t,  ///
    graphregion(color(white)) bgcolor(white) plotregion(color(white)) ///
    estopts(msize(medium) mcolor(black) lc(black) lp(dash)) ciopts(lc(black) lp(solid) ///
	lw(*1) msize(large)) ytitle("估计系数",size(medium)) title("（2）大学学历",size(medium)) ///
	xtitle("政策实施时个体年龄",margin(t+3) size(medium)) ylabel(#3, format(%6.2f) grid) ///
	yline(0, lp(solid) lc(gs0) lw(thin)) xlabel(1 "12-13" 2 "10-11" 3 "8-9" 4 "6-7" 5 "4-5" 6 "2-3" 7 "0-1" 8 "-1") ///
	plotr(margin(r+3 l+3)) xline(4.5,lp(solid) lc(black) lw(thin)) ///
	xlabel(,nogrid) ylabel(,nogrid)
	
 graph save Graph $path\graph\动态效应_大学.gph,replace
 
 
 
 ************************
 **   表3 认知能力     **
 ************************
 
 use $path\data\er_and_hc.dta,clear
 
 egen mis= rowmiss($mis)
 drop if mis
 drop mis
 
 reghdfe mathtest c.treat#c.post $ctrl,a($fe) cluster(countyid#birthyear)
 
 est store b1
 
 reghdfe wordtest c.treat#c.post $ctrl,a($fe) cluster(countyid#birthyear)
 
 est store b2
 
 reghdfe cognitive c.treat#c.post $ctrl,a($fe) cluster(countyid#birthyear)
 
 est store b3
 
 outreg2 [b1 b2 b3] using 认知能力,excel bracket e(N_full) se dec(3) replace
 
 
 
 ************************
 **   图2 异质性分析   **
 ************************
 
 use $path\data\er_and_hc.dta,clear
 egen mis= rowmiss($mis)
 drop if mis
 drop mis
 
 gen did=treat*post
 gen did2=acidrain*post
 gen did3=sulfurdioxide*post
 
 ////高中
 
 //性别
 reghdfe highschool did $ctrl if sex==1,a($fe) cluster(countyid#birthyear)
 
 gen beta1=_b[did]
 gen se_plus1 = 1.68*_se[did] + _b[did]
 gen se_minus1 = -1.68*_se[did] + _b[did]
 
 reghdfe highschool did $ctrl if sex==0,a($fe) cluster(countyid#birthyear)
 
 gen beta2=_b[did]
 gen se_plus2 = 1.68*_se[did] + _b[did]
 gen se_minus2 = -1.68*_se[did] + _b[did]
 
 //父亲教育水平
 reghdfe highschool did $ctrl if edu_f_dummy==1,a($fe) cluster(countyid#birthyear)
 
 gen beta3=_b[did]
 gen se_plus3 = 1.68*_se[did] + _b[did]
 gen se_minus3 = -1.68*_se[did] + _b[did]
 
 reghdfe highschool did $ctrl if edu_f_dummy==0,a($fe) cluster(countyid#birthyear)
 
 gen beta4=_b[did]
 gen se_plus4 = 1.68*_se[did] + _b[did]
 gen se_minus4 = -1.68*_se[did] + _b[did]
 
 //经济发展水平
 reghdfe highschool did $ctrl if 初始经济发展水平是否较高==1,a($fe) cluster(countyid#birthyear)
 
 gen beta5=_b[did]
 gen se_plus5 = 1.68*_se[did] + _b[did]
 gen se_minus5 = -1.68*_se[did] + _b[did]
 
 reghdfe highschool did $ctrl if 初始经济发展水平是否较高==0,a($fe) cluster(countyid#birthyear)
 
 gen beta6=_b[did]
 gen se_plus6 = 1.68*_se[did] + _b[did]
 gen se_minus6 = -1.68*_se[did] + _b[did]
 
 //控制区类别
 reghdfe highschool did2 $ctrl,a($fe) cluster(countyid#birthyear)
 
 gen beta7=_b[did]
 gen se_plus7 = 1.68*_se[did2] + _b[did2]
 gen se_minus7 = -1.68*_se[did2] + _b[did2]
 
 reghdfe highschool did3 $ctrl,a($fe) cluster(countyid#birthyear)
 
 gen beta8=_b[did]
 gen se_plus8 = 1.68*_se[did3] + _b[did3]
 gen se_minus8 = -1.68*_se[did3] + _b[did3]
 
 keep beta* se_*
 
 duplicates drop beta1,force
 
 gen id=_n
 
 reshape long beta se_plus se_minus,i(id) j(year)
 
 keep year beta se_plus se_minus
 
 replace year=year+1 if year>=3
 
 replace year=year+1 if year>=6
 
 replace year=year+1 if year>=9
 
 eclplot beta se_minus se_plus year, hori ///
    graphregion(color(white)) bgcolor(white) plotregion(color(white)) ///
	estopts(msize(medium) mcolor(black) lc(black) lp(dash)) ciopts(lc(black) lp(solid) ///
	lw(*1) msize(large)) ytitle("",size(medium)) ///
    xlabel(#3,grid) xline(0,lp(dash) lc(black) lw(*0.8)) ///
	xtitle("估计系数",margin(t+3) size(*0.9)) ylabel( ,nogrid) ///
	plotr(margin(r+3 l+3)) yline(3,lp(dash) lw(*1)) ///
	yline(6,lp(dash) lw(*1)) yline(9,lp(dash) lw(*1)) ///
	title("（1）高中学历",size(*0.8))	///
	ylabel(1 "男性" 2 "女性" 3 " " 4 "父亲教育水平较高" ///
	5 "父亲教育水平较低" 6 " " 7 "经济发展水平较高" 8 "经济发展水平较低" ///
	9 " " 10 "酸雨控制区" 11 "二氧化硫控制区", labsize(*0.9))
 
 graph save Graph $path\graph\异质性分析_高中.gph,replace
 
 
 ////大学
 
 use $path\data\er_and_hc.dta,clear
 egen mis= rowmiss($mis)
 drop if mis
 drop mis
 
 gen did=treat*post
 gen did2=acidrain*post
 gen did3=sulfurdioxide*post
 
 //性别
 reghdfe university did $ctrl if sex==1,a($fe) cluster(countyid#birthyear)
 
 gen beta1=_b[did]
 gen se_plus1 = 1.68*_se[did] + _b[did]
 gen se_minus1 = -1.68*_se[did] + _b[did]
 
 reghdfe university did $ctrl if sex==0,a($fe) cluster(countyid#birthyear)
 
 gen beta2=_b[did]
 gen se_plus2 = 1.68*_se[did] + _b[did]
 gen se_minus2 = -1.68*_se[did] + _b[did]
 
 //父亲教育水平
 reghdfe university did $ctrl if edu_f_dummy==1,a($fe) cluster(countyid#birthyear)
 
 gen beta3=_b[did]
 gen se_plus3 = 1.68*_se[did] + _b[did]
 gen se_minus3 = -1.68*_se[did] + _b[did]
 
 reghdfe university did $ctrl if edu_f_dummy==0,a($fe) cluster(countyid#birthyear)
 
 gen beta4=_b[did]
 gen se_plus4 = 1.68*_se[did] + _b[did]
 gen se_minus4 = -1.68*_se[did] + _b[did]
 
 //经济发展水平
 reghdfe university did $ctrl if 初始经济发展水平是否较高==1,a($fe) cluster(countyid#birthyear)
 
 gen beta5=_b[did]
 gen se_plus5 = 1.68*_se[did] + _b[did]
 gen se_minus5 = -1.68*_se[did] + _b[did]
 
 reghdfe university did $ctrl if 初始经济发展水平是否较高==0,a($fe) cluster(countyid#birthyear)
 
 gen beta6=_b[did]
 gen se_plus6 = 1.68*_se[did] + _b[did]
 gen se_minus6 = -1.68*_se[did] + _b[did]
 
 //控制区类别
 reghdfe university did2 $ctrl,a($fe) cluster(countyid#birthyear)
 
 gen beta7=_b[did]
 gen se_plus7 = 1.68*_se[did2] + _b[did2]
 gen se_minus7 = -1.68*_se[did2] + _b[did2]
 
 reghdfe university did3 $ctrl,a($fe) cluster(countyid#birthyear)
 
 gen beta8=_b[did]
 gen se_plus8 = 1.68*_se[did3] + _b[did3]
 gen se_minus8 = -1.68*_se[did3] + _b[did3]
 
 keep beta* se_*
 
 duplicates drop beta1,force
 
 gen id=_n
 
 reshape long beta se_plus se_minus,i(id) j(year)
 
 keep year beta se_plus se_minus
 
 replace year=year+1 if year>=3
 
 replace year=year+1 if year>=6
 
 replace year=year+1 if year>=9
 
 eclplot beta se_minus se_plus year, hori ///
    graphregion(color(white)) bgcolor(white) plotregion(color(white)) ///
	estopts(msize(medium) mcolor(black) lc(black) lp(dash)) ciopts(lc(black) lp(solid) ///
	lw(*1) msize(large)) ytitle("",size(medium)) ///
    xlabel(#3,grid) xline(0,lp(dash) lc(black) lw(*0.8)) ///
	xtitle("估计系数",margin(t+3) size(*0.9)) ylabel( ,nogrid) ///
	plotr(margin(r+3 l+3)) yline(3,lp(dash) lw(*1)) ///
	yline(6,lp(dash) lw(*1)) yline(9,lp(dash) lw(*1)) ///
	title("（2）大学学历", size(*0.8))	///
	ylabel(1 "男性" 2 "女性" 3 " " 4 "父亲教育水平较高" ///
	5 "父亲教育水平较低" 6 " " 7 "经济发展水平较高" 8 "经济发展水平较低" ///
	9 " " 10 "酸雨控制区" 11 "二氧化硫控制区", labsize(*0.9))
 
 graph save Graph $path\graph\异质性分析_大学.gph,replace
 
 graph combine ///
       $path\graph\异质性分析_高中.gph ///
	   $path\graph\异质性分析_大学.gph, ///
	   cols(2) plotr(c(white) lc(black) lw(*1)) graphr(c(white) lc(black) lw(*.5))
 
 graph export $path\graph\异质性分析.png, as(png) replace
 
 
 
 
 ************************
 **   附录 稳健性检验  **
 ************************
 
 //表I1 政策实施混淆因素的排除
 
 use $path\data\er_and_hc.dta,clear
 egen mis= rowmiss($mis)
 drop if mis
 drop mis
 
 global ctfe1 "c.lnPGDP#birthyear c.lnpop_1997#birthyear c.urbanrate_1997#birthyear c.tiovrate_1997#birthyear"
 global ctfe2 "c.pm25_1997#birthyear c.废气排放强度_1998#birthyear c.二氧化硫排放强度_1998#birthyear c.烟尘排放强度_1998#birthyear"
 global ctfe3 "c.yedu_1990#birthyear"
 
 **高中
 
 reghdfe highschool c.treat#c.post $ctrl,a($fe $ctfe1) cluster(countyid#birthyear)
 est store f1
 
 reghdfe highschool c.treat#c.post $ctrl,a($fe $ctfe1 $ctfe2) cluster(countyid#birthyear)
 est store f2
 
 reghdfe highschool c.treat#c.post $ctrl,a($fe $ctfe1 $ctfe2 $ctfe3) cluster(countyid#birthyear)
 est store f3
 
 outreg2 [f1 f2 f3] using 控制事前社会经济指标_高中,excel bracket e(N_full) se dec(3) replace
 
 
 **大学
 use $path\data\er_and_hc.dta,clear
 egen mis= rowmiss($mis)
 drop if mis
 drop mis
 
 reghdfe university c.treat#c.post $ctrl,a($fe $ctfe1) cluster(countyid#birthyear)
 est store g1
 
 reghdfe university c.treat#c.post $ctrl,a($fe $ctfe1 $ctfe2) cluster(countyid#birthyear)
 est store g2
 
 reghdfe university c.treat#c.post $ctrl,a($fe $ctfe1 $ctfe2 $ctfe3) cluster(countyid#birthyear)
 est store g3
 
 outreg2 [g1 g2 g3] using 控制事前社会经济指标_大学,excel bracket e(N_full) se dec(3) replace
 
 
 
 
 //表II1 同期干扰政策排除
 
 use $path\data\er_and_hc.dta,clear
 egen mis= rowmiss($mis)
 drop if mis
 drop mis
 
 **高中
 
 *WTO
 reghdfe highschool c.treat#c.post $ctrl,a($fe c.tariff_city#birthyear) cluster(countyid#birthyear)
 est store h1
 
 *环保重点城市
 reghdfe highschool c.treat#c.post $ctrl,a($fe c.env_key_city#birthyear) cluster(countyid#birthyear)
 est store h2
 
 *环境垂直管理
 reghdfe highschool c.treat#c.post $ctrl,a($fe c.垂管#birthyear) cluster(countyid#birthyear)
 est store h3
 
 *撤县设区
 reghdfe highschool c.treat#c.post $ctrl,a($fe c.ctod#birthyear) cluster(countyid#birthyear)
 est store h4
 
 *农业税取消
 reghdfe highschool c.treat#c.post $ctrl,a($fe c.agrtaxshock#birthyear) cluster(countyid#birthyear)
 est store h5
 
 *1998大洪水
 reghdfe highschool c.treat#c.post $ctrl,a($fe c.disaster#birthyear) cluster(countyid#birthyear)
 est store h6
 
 *所有
 reghdfe highschool c.treat#c.post $ctrl,a($fe c.tariff_city#birthyear c.env_key_city#birthyear c.垂管#birthyear c.ctod#birthyear c.agrtaxshock#birthyear c.disaster#birthyear) cluster(countyid#birthyear)
 est store h7
 
 outreg2 [h1 h2 h3 h4 h5 h6 h7] using 排除同期干扰因素_高中,excel bracket e(N_full) se dec(3) replace
 
 
 **大学

 *贸易自由化
 reghdfe university c.treat#c.post $ctrl,a($fe c.tariff_city#birthyear) cluster(countyid#birthyear)
 est store i1
 
 *环保重点城市
 reghdfe university c.treat#c.post $ctrl,a($fe c.env_key_city#birthyear) cluster(countyid#birthyear)
 est store i2
 
 *环境垂直管理
 reghdfe university c.treat#c.post $ctrl,a($fe c.垂管#birthyear) cluster(countyid#birthyear)
 est store i3
 
 *撤县设区
 reghdfe university c.treat#c.post $ctrl,a($fe c.ctod#birthyear) cluster(countyid#birthyear)
 est store i4
 
 *农业税取消
 reghdfe university c.treat#c.post $ctrl,a($fe c.agrtaxshock#birthyear) cluster(countyid#birthyear)
 est store i5
 
 *1998大洪水
 reghdfe university c.treat#c.post $ctrl,a($fe c.disaster#birthyear) cluster(countyid#birthyear)
 est store i6
 
 *所有
 reghdfe university c.treat#c.post $ctrl,a($fe c.tariff_city#birthyear c.env_key_city#birthyear c.垂管#birthyear c.ctod#birthyear c.agrtaxshock#birthyear c.disaster#birthyear) cluster(countyid#birthyear)
 est store i7
 
 outreg2 [i1 i2 i3 i4 i5 i6 i7] using 排除同期干扰因素_大学,excel bracket e(N_full) se dec(3) replace
 
 
 
 
 //表III1 替换核心变量衡量方式
 
 use $path\data\er_and_hc.dta,clear
 egen mis= rowmiss($mis)
 drop if mis
 drop mis
 
 *教育年限
 reghdfe yedu c.treat#c.post $ctrl,a($fe) cluster(countyid#birthyear)
 est store x1
 
 reghdfe highschool2 c.treat#c.post $ctrl,a($fe) cluster(countyid#birthyear)
 est store x2
 
 reghdfe university2 c.treat#c.post $ctrl,a($fe) cluster(countyid#birthyear)
 est store x3
 
 outreg2 [x1 x2 x3] using 替换变量衡量方式,excel bracket e(N_full) se dec(3) replace
 
 
 
 //表IV1 其他稳健性检验
 
 use $path\data\er_and_hc.dta,clear
 egen mis= rowmiss($mis)
 drop if mis
 drop mis
 
 **高中
 
 *溢出效应_地级市层面构造实验组控制组
 reghdfe highschool c.treat2#c.post $ctrl,a($fe) cluster(countyid#birthyear)
 est store j1
 
 *溢出效应_删除临近区县
 reghdfe highschool c.treat3#c.post $ctrl,a($fe) cluster(countyid#birthyear)
 est store j2
 
 *删除直辖市样本
 reghdfe highschool c.treat#c.post $ctrl if 是否直辖市==0,a($fe) cluster(countyid#birthyear)
 est store j3
 
 *调整聚类1
 reghdfe highschool c.treat#c.post $ctrl,a($fe) cluster(countyid)
 est store j4
 
 outreg2 [j1 j2 j3 j4] using 其他稳健性检验_高中,excel bracket e(N_full) se dec(3) replace
 

 **大学
  
 *溢出效应_地级市层面构造实验组控制组
 reghdfe university c.treat2#c.post $ctrl,a($fe) cluster(countyid#birthyear)
 est store k1

 *溢出效应_删除临近区县
 reghdfe university c.treat3#c.post $ctrl,a($fe) cluster(countyid#birthyear)
 est store k2
 
 *删除直辖市样本
 reghdfe university c.treat#c.post $ctrl if 是否直辖市==0,a($fe) cluster(countyid#birthyear)
 est store k3
 
 *调整聚类
 reghdfe university c.treat#c.post $ctrl,a($fe) cluster(countyid)
 est store k4
 
 outreg2 [k1 k2 k3 k4] using 其他稳健性检验_大学,excel bracket e(N_full) se dec(3) replace
 
 