

/*******************************************************************************
*
*	2024-00250_图片导出程序代码
*
*******************************************************************************/	


	
	clear all                 //Remove everything from the memory, refresh.
    cap log close             //Close any open log file.
	log using "C:\Users\49030\Desktop\2024-00250_数据\2024-00250_补充文件（运行日志+图表截图）\2024-00250_图片程序代码log.smcl" ,replace
    set more off              //Show the result all at once.
    set rmsg on

	gl root="C:\Users\49030\Desktop\2024-00250_数据"         //设定工作路径
	cd $root
	
	
	gl dofiles="$root\2024-00250_程序代码"
	gl working_data="$root\2024-00250_使用数据"
	gl tables="$root\2024-00250_日志文件"
    gl xlist1="人口规模 城镇化水平 交通便利性 第二产业规模 第三产业规模 财政状况 福利保障"
	
	
	
	*----------------- data1 指标含义 -----------------*
	
/*  工业企业密集度：新增工业企业注册数（个/平方公里）；
    劳动力密集度：第二产业从业人员数（人/平方公里）；
	监测网设立：地市层面设立监测网=1，否则=0；
	dummy_0_5：各区县到最近监测站的距离小于等于5km=1，否则=0；
	dummy_n_m：距离虚拟变量，各区县到最近监测站的距离大于nkm小于等于mkm则=1，否则=0；
	event_city：当年年份-监测网设立年份；
	监管强度：各区县的监测站数量（个）；
	人口规模：户籍人口数（万人）；
	城镇化水平：城镇用地占区县总面积的比；
	交通便利性：工交建设用地占区县总面积的比；
	第二产业规模：第二产业产值占区县总产值的比；
	第三产业规模：第三产业产值占区县总产值的比；
	财政状况：（财政支出-财政收入）/财政收入；
	福利保障：各种社会福利收养性单位（个）。       */

	
		
	*----------------- data3 指标含义 -----------------*

/*  城区制造业就业人员数（万人）：城镇单位制造业就业人员（万人）；
    城区人均工业增加值（万元）：城区工业增加值/户籍人口（万元）；
	县域人均工业增加值（万元）：县域工业增加值/户籍人口（万元）。
*/
	
	
	
	*----------------- 正文的图 -----------------*
	
***********************# 图1a 城区制造业劳动力变动图 #***********************	
    use $working_data\data3.dta ,clear

    drop if 年份<2005
    drop if 年份>2019
	
    twoway (connected 城区制造业就业人员数（万人） 年份,yaxis(2) xline(2014, lp(dash) lc(gs0) lw(thin)) graphregion(color(white)) )
	graph save "Graph" $tables\图1a.gph,replace 
  

***********************# 图1b 区域工业发展趋势图 #***********************	
	 use $working_data\data3.dta ,clear

    drop if 年份<2005
    drop if 年份>2019
	
    twoway (connected 城区人均工业增加值（万元） 年份 ) (connected 县域人均工业增加值（万元） 年份 ,yaxis(2) xline(2014, lp(dash) lc(gs0) lw(thin)) graphregion(color(white)) )
	graph save "Graph" $tables\图1b.gph,replace 
	
***********************# 图2a 各区县工业企业的空间溢出效应检验图 #***********************	
    use $working_data\data1.dta ,clear

    drop if 年份<=2002
    drop if 年份==2020	
	
	xtreg 工业企业密集度 dummy_0_5-dummy_65_70  $xlist1 i.年份 ,fe vce(cluster 市代码)   
coefplot, ///
    keep(dummy_0_5 dummy_5_10 dummy_10_15 dummy_15_20 dummy_20_25 dummy_25_30 dummy_30_35 dummy_35_40 dummy_40_45 dummy_45_50 dummy_50_55 dummy_55_60 dummy_60_65 dummy_65_70)  ///保留回归系数
 	  coeflabels(dummy_0_5 = "5"               ///定义横坐标的距离刻度
 	  dummy_5_10 = "10"   ///
  	  dummy_10_15 = "15"              ///
  	  dummy_15_20 = "20"              ///
      dummy_20_25  = "25"              ///
      dummy_25_30  = "30"              ///
      dummy_30_35  = "35"              ///
      dummy_35_40  = "40"              ///
      dummy_40_45  = "45"             ///
      dummy_45_50 = "50"              ///
      dummy_50_55 = "55"              ///
      dummy_55_60 = "60"              ///
      dummy_60_65 = "65"              ///
      dummy_65_70 = "70")             ///
      omit                        ///
      vertical                    ///
      yline(0, lcolor(edkblue*0.8) )                    ///
      ylabel(,labsize(*0.75)) xlabel(,labsize(*0.75))          ///
      ytitle("空间溢出效应", size(small))              ///
      xtitle("空间距离（千米）", size(small)) ///
      addplot(line @b @at)        ///
      ciopts(lpattern(dash) recast(rcap) msize(medium) )        ///
      scheme(s1mono)
    graph save "Graph" $tables\图2a.gph,replace 


***********************# 图2b 各区县劳动力的空间溢出效应检验图 #***********************		
    use $working_data\data1.dta ,clear

    drop if 年份<=2002
    drop if 年份==2020	
	
	xtreg 劳动力密集度 dummy_0_5-dummy_65_70  $xlist1 i.年份 ,fe vce(cluster 市代码)   
coefplot, ///
    keep(dummy_0_5 dummy_5_10 dummy_10_15 dummy_15_20 dummy_20_25 dummy_25_30 dummy_30_35 dummy_35_40 dummy_40_45 dummy_45_50 dummy_50_55 dummy_55_60 dummy_60_65 dummy_65_70)  ///保留回归系数
 	  coeflabels(dummy_0_5 = "5"               ///定义横坐标的距离刻度
 	  dummy_5_10 = "10"   ///
  	  dummy_10_15 = "15"              ///
  	  dummy_15_20 = "20"              ///
      dummy_20_25  = "25"              ///
      dummy_25_30  = "30"              ///
      dummy_30_35  = "35"              ///
      dummy_35_40  = "40"              ///
      dummy_40_45  = "45"             ///
      dummy_45_50 = "50"              ///
      dummy_50_55 = "55"              ///
      dummy_55_60 = "60"              ///
      dummy_60_65 = "65"              ///
      dummy_65_70 = "70")             ///
      omit                        ///
      vertical                    ///
      yline(0, lcolor(edkblue*0.8) )                    ///
      ylabel(,labsize(*0.75)) xlabel(,labsize(*0.75))          ///
      ytitle("空间溢出效应", size(small))              ///
      xtitle("空间距离（千米）", size(small)) ///
      addplot(line @b @at)        ///
      ciopts(lpattern(dash) recast(rcap) msize(medium) )        ///
      scheme(s1mono)
    graph save "Graph" $tables\图2b.gph,replace 

	

	*----------------- 附录的图 -----------------*

		
***********************# 图V1 城区工业企业密集度的平行趋势检验图 #***********************		
    use $working_data\data1.dta ,clear

    drop if 年份<=2002
    drop if 年份==2020	
	
	keep if 类型=="市辖区"
	
	*构建时间虚拟变量
	replace event_city = -5 if event_city <= -5
	replace event_city = -5 if event_city >= 1000
	replace event_city = 3 if event_city >= 3
	tab event_city, gen(eventt)  
	forvalues i = 1/9{
		replace eventt`i' = 0 if eventt`i' == .
	}
	replace eventt5 = 0
	
	*获得回归系数
	xtreg 工业企业密集度 eventt* 监管强度 $xlist1 i.年份,fe vce(cluster 市代码) 
	
	*画图
	coefplot, ///
	   keep(eventt*)  ///保留回归系数
	   coeflabels(eventt1 = "-5"               ///定义横坐标的时间刻度
	   eventt2 = "-4"   ///
	   eventt3 = "-3"              ///
	   eventt4 = "-2"              ///
	   eventt5  = "-1"              ///
	   eventt6  = "0"              ///
	   eventt7  = "1"             ///
	   eventt8  = "2"              ///
	   eventt9  = "3")             ///
	   omit                        ///
	   vertical                    ///
	   yline(0, lcolor(edkblue*0.8) )                    ///
	   xline(5, lwidth(vthin) lpattern(dash) lcolor(teal) )                    ///
	   ylabel(,labsize(*0.75)) xlabel(,labsize(*0.75))          ///
	   ytitle("政策动态效应", size(small))              ///
	   xtitle("政策时点", size(small)) ///
	   addplot(line @b @at)        ///
	   ciopts(lpattern(dash) recast(rcap) msize(medium) )        ///
	   scheme(s1mono)
	   graph save "Graph" $tables\图V1.gph,replace

	
	
***********************# 图V2 城区劳动力密集度的平行趋势检验图 #***********************	
    use $working_data\data1.dta ,clear

    drop if 年份<=2002
    drop if 年份==2020	
	
	keep if 类型=="市辖区"
	
	*构建时间虚拟变量
	replace event_city = -5 if event_city <= -5
	replace event_city = -5 if event_city >= 1000
	replace event_city = 3 if event_city >= 3
	tab event_city, gen(eventt) 
	forvalues i = 1/9{
		replace eventt`i' = 0 if eventt`i' == .
	}
	replace eventt5 = 0
	
	*获得回归系数
	xtreg 劳动力密集度 eventt* 监管强度 $xlist1 i.年份,fe vce(cluster 市代码) 
	
	*画图
	coefplot, ///
	   keep(eventt*)  ///保留回归系数
	   coeflabels(eventt1 = "-5"               ///定义横坐标的时间刻度
	   eventt2 = "-4"   ///
	   eventt3 = "-3"              ///
	   eventt4 = "-2"              ///
	   eventt5  = "-1"              ///
	   eventt6  = "0"              ///
	   eventt7  = "1"             ///
	   eventt8  = "2"              ///
	   eventt9  = "3")             ///
	   omit                        ///
	   vertical                    ///
	   yline(0, lcolor(edkblue*0.8) )                    ///
	   xline(5, lwidth(vthin) lpattern(dash) lcolor(teal) )                    ///
	   ylabel(,labsize(*0.75)) xlabel(,labsize(*0.75))          ///
	   ytitle("政策动态效应", size(small))              ///
	   xtitle("政策时点", size(small)) ///
	   addplot(line @b @at)        ///
	   ciopts(lpattern(dash) recast(rcap) msize(medium) )        ///
	   scheme(s1mono)
	   graph save "Graph" $tables\图V2.gph,replace
	
	
	
***********************# 图V3 县域工业企业密集度的平行趋势检验图 #***********************	
    use $working_data\data1.dta ,clear

    drop if 年份<=2002
    drop if 年份==2020	
	
	keep if 类型!="市辖区"
	
	*构建时间虚拟变量
	replace event_city = -5 if event_city <= -5
	replace event_city = -5 if event_city >= 1000
	replace event_city = 3 if event_city >= 3
	tab event_city, gen(eventt) 
	forvalues i = 1/9{
		replace eventt`i' = 0 if eventt`i' == .
	}
	replace eventt5 = 0
	
	*获得回归系数
	xtreg 工业企业密集度 eventt* 监管强度 $xlist1 i.年份,fe vce(cluster 市代码) 
	
	*画图
	coefplot, ///
	   keep(eventt*)  ///保留回归系数
	   coeflabels(eventt1 = "-5"               ///定义横坐标的时间刻度
	   eventt2 = "-4"   ///
	   eventt3 = "-3"              ///
	   eventt4 = "-2"              ///
	   eventt5  = "-1"              ///
	   eventt6  = "0"              ///
	   eventt7  = "1"             ///
	   eventt8  = "2"              ///
	   eventt9  = "3")             ///
	   omit                        ///
	   vertical                    ///
	   yline(0, lcolor(edkblue*0.8) )                    ///
	   xline(5, lwidth(vthin) lpattern(dash) lcolor(teal) )                    ///
	   ylabel(,labsize(*0.75)) xlabel(,labsize(*0.75))          ///
	   ytitle("政策动态效应", size(small))              ///
	   xtitle("政策时点", size(small)) ///
	   addplot(line @b @at)        ///
	   ciopts(lpattern(dash) recast(rcap) msize(medium) )        ///
	   scheme(s1mono)
	   graph save "Graph" $tables\图V3.gph,replace

	
	
	
***********************# 图V4 县域劳动力密集度的平行趋势检验图 #***********************		
    use $working_data\data1.dta ,clear

    drop if 年份<=2002
    drop if 年份==2020	
	
	keep if 类型!="市辖区"
	
	*构建时间虚拟变量
	replace event_city = -5 if event_city <= -5
	replace event_city = -5 if event_city >= 1000
	replace event_city = 3 if event_city >= 3
	tab event_city, gen(eventt)                 //构建时间虚拟变量
	forvalues i = 1/9{
		replace eventt`i' = 0 if eventt`i' == .
	}
	replace eventt5 = 0
	
	*获得回归系数
	xtreg 劳动力密集度 eventt* 监管强度 $xlist1 i.年份,fe vce(cluster 市代码) 
	
	*画图
	coefplot, ///
	   keep(eventt*)  ///保留回归系数
	   coeflabels(eventt1 = "-5"               ///定义横坐标的时间刻度
	   eventt2 = "-4"   ///
	   eventt3 = "-3"              ///
	   eventt4 = "-2"              ///
	   eventt5  = "-1"              ///
	   eventt6  = "0"              ///
	   eventt7  = "1"             ///
	   eventt8  = "2"              ///
	   eventt9  = "3")             ///
	   omit                        ///
	   vertical                    ///
	   yline(0, lcolor(edkblue*0.8) )                    ///
	   xline(5, lwidth(vthin) lpattern(dash) lcolor(teal) )                    ///
	   ylabel(,labsize(*0.75)) xlabel(,labsize(*0.75))          ///
	   ytitle("政策动态效应", size(small))              ///
	   xtitle("政策时点", size(small)) ///
	   addplot(line @b @at)        ///
	   ciopts(lpattern(dash) recast(rcap) msize(medium) )        ///
	   scheme(s1mono)
	   graph save "Graph" $tables\图V4.gph,replace

	
	
	
***********************# 图VI1 城区工业企业密集度的安慰剂检验图 #***********************	
    use $working_data\data1.dta ,clear

    drop if 年份<=2002
    drop if 年份==2020	
	
	keep if 类型=="市辖区"
	
	*获得回归系数
	xtreg 工业企业密集度 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码) 
	estimates store did1
	
	*画图
	didplacebo did1 , treatvar(监测网设立) pbounit rep(500) seed(1)
	graph save "pbounit" $tables\图VI1.gph,replace


***********************# 图VI2 城区劳动力密集度的安慰剂检验图 #***********************	
    use $working_data\data1.dta ,clear

    drop if 年份<=2002
    drop if 年份==2020	
	
	keep if 类型=="市辖区"
	
	*获得回归系数
	xtreg 劳动力密集度 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码) 
	estimates store did1
	
	*画图
	didplacebo did1 , treatvar(监测网设立) pbounit rep(500) seed(1)
	graph save "pbounit" $tables\图VI2.gph,replace


***********************# 图VI3 县域工业企业密集度的安慰剂检验图 #***********************	
    use $working_data\data1.dta ,clear

    drop if 年份<=2002
    drop if 年份==2020	
	
	keep if 类型!="市辖区"
	
	*获得回归系数
	xtreg 工业企业密集度 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码) 
	estimates store did1
	
	*画图
	didplacebo did1 , treatvar(监测网设立) pbounit rep(500) seed(1)
	graph save "pbounit" $tables\图VI3.gph,replace


***********************# 图VI4 县域劳动力密集度的安慰剂检验图 #***********************	
    use $working_data\data1.dta ,clear

    drop if 年份<=2002
    drop if 年份==2020	
	
	keep if 类型!="市辖区"
	
	*获得回归系数
	xtreg 劳动力密集度 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码) 
	estimates store did1
	
	*画图
	didplacebo did1 , treatvar(监测网设立) pbounit rep(500) seed(1)
	graph save "pbounit" $tables\图VI4.gph,replace
	
	
	log close
















