
*********************************文章实证代码************************************

clear all
cd /Users/cxsong/Desktop/2024-00456_数据/2024-00456_研究数据
/// 设定工作路径（根据文件在电脑中的位置自行设定）

log using "日志文件路径和名称.log", replace
/// 打开日志记录


*****************************************************************
*
*               第一部分：核心变量生成
*
*****************************************************************

  use 核心变量设定.dta, clear

**  核心变量设定.dta中的变量说明：

  * pinterest：生产借贷利率
  * cinterest：消费借贷利率
  * productive：生产借贷金额
  * cproductive：消费借贷金额
  * total：借贷总额
  * winterest：利率（加权月利率）
  * pfd：产量向下波动
  * borrow5：前五年借贷金额
  * debt：总债务
  * gddebt：深陷债务
  * povertyt：贫困陷阱


  ************** 加权利率变量生成 **************
  
  gen winterest= (productive/total)*pinterest+(cproductive/total)*cinterest
      /// 生成加权利率变量


  ************** 贫困陷阱变量生成 **************

  gen povertyt=.
  replace povertyt=1 if gddebt==1 & pfd==1
      /// 同时出现深陷债务与产量向下波动则陷入贫困陷阱，赋值为1

  replace povertyt=0 if povertyt==.
      /// 其他情况则表明未处于贫困陷阱，赋值为0



*****************************************************************
*
*                   第二部分：正文内容
*
*****************************************************************

  use 实证分析数据.dta, clear

**  实证分析数据.dta中的变量说明：

  * povertyt：贫困陷阱
  * winterest：利率（加权月利率）
  * relativec：是否亲属借贷
  * pland：人均耕地面积
  * lnpland：人均耕地面积的对数值
  * size：家庭人口
  * alabor：农业劳动力
  * livestock：役畜数量
  * nonae：非农就业
  * network：社会网络
  * lnnetwork：社会网络对数值
  * save：储蓄金额
  * lnsave：储蓄金额的对数值
  * rice：水稻种植占比
  * tax：田税
  * interestc：县平均利率
  * pawn：典当数量
  * location：市场距离
  * relief：政府救济
  * flood：水灾次数
  * drought：旱灾次数
  * region：农区
  * winterest3：月利率3分阈值
  * pinterest15：年利率15阈值
  * health：重要男性劳动力是否生病
  * socialins：农民与地主冲突次数
  * newfina：是否有现代银行
  * poppre：人口密度
  * poutput：人均粮食产量
  * apovertyp：主成分分析方法测度的资产指数
  * apovertyp_D：主成分分析方法测度的资产贫困陷阱二元变量
  * apovertyr：生计回归分析方法测度的资产指数
  * apovertyr_D：生计回归分析方法测度的资产贫困陷阱二元变量
  * rent：地租率
  * winteresty：年利率
  * rentD：年利率是否超过地租率（是=1；否=0）
  * profit：剩余比例
  * surplus：年利率是否超过剩余比例（是=1；否=0）
  * surplusC_q：年利率超出剩余比例程度（六等份，赋值为1-6）
  
  ************** 表1：1929-1933年中国农户借贷利率比较T检验 **************

  ttest winterest,by(povertyt)
  ttest winterest if winterest>0,by(povertyt)

  
  ************** 表2：变量定义及统计描述 **************
  
  gen lnpland=log(1+pland)
  gen lnnetwork=log(1+network)
  gen lnsave=log(1+save)
  su winterest povertyt relativec lnpland size alabor livestock nonae lnnetwork lnsave rice tax interestc pawn location relief flood drought

  
  ************** 表3：贫困陷阱与利率的联立方程模型回归结果 **************
  
  global control "relativec lnpland size alabor livestock nonae lnnetwork lnsave rice tax flood drought"
      /// 设定计量模型中的控制变量

  reg3 (winterest povertyt $control interestc pawn i.region) (povertyt winterest $control location relief i.region), 3sls 
  est store r1

  outreg2 [r1] using 正文表3.doc, tstat bdec(3) tdec(2) replace

  
  ************** 表4：不同借贷利率与贫困陷阱的回归结果 **************
  
  reg3 (cinterest povertyt $control interestc pawn i.region) (povertyt cinterest $control location relief i.region), 3sls
  est store r11

  reg3 (pinterest povertyt $control interestc pawn i.region) (povertyt pinterest $control location relief i.region), 3sls
  est store r22
  
  reg3 (cinterest povertyt $control interestc pawn i.region) (povertyt cinterest $control location relief i.region) if pinterest==., 3sls
  est store r33
      /// 该条命令为表格注释内容，文中未汇报。if ‘pinterest==.’表示仅考虑消费借贷的情形

  reg3 (pinterest povertyt $control interestc pawn i.region) (povertyt pinterest $control location relief i.region) if cinterest==., 3sls
  est store r44
      /// 该条命令为表格注释内容，文中未汇报。if `uninterest==.'表示仅考虑生产借贷的情形

  outreg2 [r11 r22 r33 r44] using 正文表4.doc, tstat bdec(3) tdec(2) replace

  
  ************** 表5：关于利率和投资回报率比较的回归结果 **************
  
  * 以月利率3分为阈值的划分
  gen winterest3=winterest
  replace winterest3=0 if winterest3<3
  replace winterest3=1 if winterest3>=3

  reg3 (winterest3 povertyt $control interestc pawn i.region) (povertyt winterest3 $control location relief i.region) , 3sls
  est store r111

  * 以年利率15为阈值的划分
  gen pinterest15=pinterest*12
  replace pinterest15=0 if pinterest15<15
  replace pinterest15=1 if pinterest15>=15
  replace pinterest15=. if pinterest==.

  reg3 (pinterest15 povertyt $control interestc pawn i.region) (povertyt pinterest15 $control location relief i.region), 3sls
  est store r222

  * 以利率是否高于地租率为标准的回归
  gen winteresty=winterest*12
  gen rentD=winteresty-rent
  replace rentD=0 if rentD<=0
  replace rentD=1 if rentD>0
  replace rentD=. if rent==.
  ///  以上命令生成rentD变量（利率是否超过地租率）

  reg3 (rentD povertyt $control interestc pawn i.region) (povertyt rentD $control location relief i.region), 3sls
  est store r333
  
  * 以利率是否高于剩余比例为标准的回归
  gen profit=100-rent
  gen surplus=winteresty-profit
  replace surplus=0 if surplus<=0
  replace surplus=1 if surplus>0
  replace surplus=. if rent==.
  ///  以上命令生成surplus变量（利率是否超过剩余比例）
  
  reg3 (surplus povertyt $control interestc pawn i.region) (povertyt surplus $control location relief i.region), 3sls
  est store r444
  
  * 以利率高出剩余比例程度为标准的回归 
  gen surplusC=winteresty-profit
  astile surplusC_q=surplusC, nq(6)
  /// 将变量划分为六等份
  /// 以上命令生成surplusC_q变量（利率超过剩余比例的程度）
  
  reg3 (surplusC_q povertyt $control interestc pawn i.region) (povertyt surplusC_q $control location relief i.region), 3sls
  est store r555
  
  outreg2 [r111 r222 r333 r444 r555] using 正文表5.doc, tstat bdec(3) tdec(2) replace


*****************************************************************
*
*                  第三部分：附录内容
*
*****************************************************************


  ************ 附录Ⅲ 表A1 近代中国借贷农户生活程度衡量指标 ************

  use 核心变量设定.dta, clear

  /// code1=安徽；code2=福建；code3=甘肃；code4=广东；code5=广西；code7=河北；code8=河南；code9=湖北；code10=湖南；code11=江苏；
  /// code12=江西；code14=宁夏；code15=青海；code16=山东；code17=山西；code18=陕西；code19=四川；code21=云南；code22=浙江
  
  * pfd：产量向下波动
  * gddebt：深陷债务
  * povertyt：贫困陷阱

  su pfd gddebt povertyt if code==1 
  su pfd gddebt povertyt if code==2 
  su pfd gddebt povertyt if code==3
  su pfd gddebt povertyt if code==4
  su pfd gddebt povertyt if code==5
  su pfd gddebt povertyt if code==7
  su pfd gddebt povertyt if code==8
  su pfd gddebt povertyt if code==9
  su pfd gddebt povertyt if code==10
  su pfd gddebt povertyt if code==11
  su pfd gddebt povertyt if code==12
  su pfd gddebt povertyt if code==14
  su pfd gddebt povertyt if code==15
  su pfd gddebt povertyt if code==16
  su pfd gddebt povertyt if code==17
  su pfd gddebt povertyt if code==18
  su pfd gddebt povertyt if code==19
  su pfd gddebt povertyt if code==21
  su pfd gddebt povertyt if code==22


  ************** 附录Ⅲ 图A1与图A2 **************
  
  use 省份对比数据.dta, clear
  
  * povertytp：省级贫困陷阱农户占比
  * surplusp：省级收支有余农户占比
  * graincp：省级粮食借贷农户占比
  
  twoway sc povertyt surplusp || lfit povertyt surplusp
  graph save 附录Ⅲ图A1, replace
  
  twoway sc povertyt graincp || lfit povertyt graincp
  graph save 附录Ⅲ图A2, replace
  ///未对图片进行美化
  
  
  ************** 附录Ⅲ 表A2资产指数指标体系 **************
  
  use 资产指数测度数据.dta, clear

**  资产贫困指数测度数据.dta中的变量说明：

  * land：家庭总耕地面积
  * lnland：家庭总耕地面积的对数值
  * save：储蓄金额
  * lnsave：储蓄金额的对数值
  * livestock：役畜数量
  * lnlivestock：役畜数量的对数值
  * farmh：农舍面积
  * lnfarmh：农舍面积的对数值
  * man：健全男子数量（人力资本）
  * lnman：健全男子数量的对数值
  * social：社会资本
  * lnsocial：社会资本的对数值
  * apovertyp：主成分分析方法测度的资产贫困指数
  
  * lnlandq：耕地面积的平方项
  * lnsaveq：储蓄的平方项
  * lnlivestockq：役畜数量的平方项
  * lnfarmhq：农舍面积的平方项
  * lnmanq：健全男子数量的平方项
  * lnsocialq：社会资本的平方项
  * lnlandsave：lnland与lnsave的交互项
  * lnlandlive：lnland与lnlivestock的交互项
  * lnlandfarm：lnland与lnfarmh的交互项
  * lnlandman：lnland与lnman的交互项
  * lnlandsoci：lnland与lnsocial的交互项
  * lnsavelive：lnsave与lnlivestock的交互项
  * lnsavefarm：lnsave与lnfarmh的交互项
  * lnsaveman：lnsave与lnman的交互项
  * lnsavesoci：lnsave与lnsocial的交互项
  * lnlivefarm：lnlivestock与lnfarmh的交互项
  * lnliveman：lnlivestock与lnman的交互项
  * lnlivesoci：lnlivestock与lnsocial的交互项
  * lnfarmman：lnfarmh与lnman的交互项
  * lnfarmsoci：lnfarmh与lnsocial的交互项
  * lnmansoci：lnman与lnsocial的交互项
  * poutput：人均粮食产量
  * apovertyr：生计回归方法测度的资产贫困指数

  gen lnland=log(1+land)
  gen lnfarmh=log(1+farmh)
  gen lnlivestock=log(1+livestock)
  gen lnsave=log(1+save)
  gen lnman=log(1+man)
  gen lnsocial=log(1+social)
  
  su lnland lnfarmh lnlivestock lnsave lnman lnsocial


  ************** 附录Ⅲ 表A3资产指数均值差异的T检验结果 **************
  
** 利用主成分分析法测度资产指数

  * 第一步：检验KMO和Bartlett
  ssc install factortest
  factortest lnland lnfarmh lnlivestock lnsave lnman lnsocial

  * 第二步：主成分分析
  pca lnland lnfarmh lnlivestock lnsave lnman lnsocial
  factor lnland lnfarmh lnlivestock lnsave lnman lnsocial, pcf

  * 第三步：计算主成分得分
  gen Comp1 = 0.5078*lnland+0.4607*lnfarmh+0.5494*lnlivestock+0.0716*lnsave+0.4511*lnman+0.1395*lnsocial

  gen Comp2 = (-0.3557)*lnland+0.0920*lnfarmh+0.0730*lnlivestock+0.3175*lnsave+(-0.1005)*lnman+0.8653*lnsocial

  gen Comp3 = 0.0904*lnland+0.1937*lnfarmh+(-0.2269)*lnlivestock+0.8979*lnsave+(-0.0725)*lnman+(-0.3022)*lnsocial

  gen Comp4 = (-0.1180)*lnland+(-0.5963)*lnfarmh+(-0.0546)*lnlivestock+0.2003*lnsave+0.7656*lnman+0.0349*lnsocial
  /// 上述系数值由第二步得到

  * 第四步：计算综合指标
  gen apovertyp=(0.3165*Comp1+0.1763*Comp2+0.1697*Comp3+0.1315*Comp4)/0.7940


** 利用生计回归法测度资产指数

  * 第一步：生成变量的平方项与交互项
  gen Y=poutput/200

  gen lnlandq=lnland^2
  gen lnsaveq=lnsave^2
  gen lnlivestockq=lnlivestock^2
  gen lnfarmhq=lnfarmh^2
  gen lnmanq=lnman^2
  gen lnsocialq=lnsocial^2

  gen lnlandsave=lnland*lnsave
  gen lnlandlive=lnland*lnlivestock
  gen lnlandfarm=lnland*lnfarmh
  gen lnlandman=lnland*lnman
  gen lnlandsoci=lnland*lnsocial

  gen lnsavelive=lnsave*lnlivestock
  gen lnsavefarm=lnsave*lnfarmh
  gen lnsaveman=lnsave*lnman
  gen lnsavesoci=lnsave*lnsocial

  gen lnlivefarm=lnlivestock*lnfarmh
  gen lnliveman=lnlivestock*lnman
  gen lnlivesoci=lnlivestock*lnsocial

  gen lnfarmman=lnfarmh*lnman
  gen lnfarmsoci=lnfarmh*lnsocial

  gen lnmansoci=lnman*lnsocial

  * 第二步：通过回归得到相应系数
  reg Y lnland lnsave lnlivestock lnfarmh lnman lnsocial lnlandq lnsaveq lnlivestockq lnfarmhq lnmanq lnsocialq lnlandsave lnlandlive lnlandfarm lnlandman lnlandsoci lnsavelive lnsavefarm lnsaveman lnsavesoci lnlivefarm lnliveman lnlivesoci lnfarmman lnfarmsoci lnmansoci
 

  * 第三步：代入系数得到资产贫困指数
  gen apovertyr=(-0.5529721)*lnland+0.1053375*lnsave+2.053654*lnlivestock+0.01485143*lnfarmh+0.2981684*lnman+(-0.5242665)*lnsocial+0.3563827*lnlandq+0.0646911*lnsaveq+(-0.0721111)*lnlivestockq+18.916367*lnfarmhq+(-0.131317)*lnmanq+0.1587965*lnsocialq+(-0.1224634)*lnlandsave+(-0.3492916)*lnlandlive+(-3.532924)*lnlandfarm+(-0.2314319)*lnlandman+0.0390557*lnlandsoci+(-0.0836152)*lnsavelive+(-1.505635)*lnsavefarm+0.0109318*lnsaveman+0.065498*lnsavesoci+0.2482786*lnlivefarm+0.1185006*lnliveman+(-0.1196241)*lnlivesoci+(-1.502023)*lnfarmman+1.679227*lnfarmsoci+(-0.0146325)*lnmansoci
      ///通过以上命令可得到两个指标：基于主成分分析法的资产指数apovertyp，基于生计回归法的资产指数apovertyr，将其匹配至实证数据中，通过如下code可得到表A3结果
  
  use 实证分析数据.dta, clear
  
  ttest apovertyp,by(povertyt)
  ttest apovertyr,by(povertyt)

  
  ************** 附录Ⅴ：表Ⅴ1 更换估计方法的回归结果**************

  use 实证分析数据.dta, clear
  
  global control "relativec lnpland size alabor livestock nonae lnnetwork lnsave rice tax flood drought"
      /// 设定计量模型中的控制变量

  * 表Ⅴ1中的回归1:
  reg3 (winterest povertyt $control interestc pawn i.region) (povertyt winterest $control location relief i.region), 2sls
  est store r2

  * 表Ⅴ1中的回归2:
  reg3 (winterest povertyt $control interestc pawn i.region) (povertyt winterest $control location relief i.region), ols
  est store r3

  outreg2 [r2 r3] using 附录Ⅴ表Ⅴ1.doc, tstat bdec(3) tdec(2) replace

  
  ************** 附录Ⅴ：表Ⅴ2 资产贫困陷阱的回归结果**************
    
  global control2 "relativec lnpland size alabor nonae rice tax flood drought"
      /// 设定控制变量（使用资产指数回归时，控制变量中剔除了用于测度资产指数的变量）

  * 表Ⅴ2中的回归1:
  reg3 (winterest apovertyp $control2 interestc pawn i.region) (apovertyp winterest $control2 location relief i.region), 3sls
  est store a1
  
  * 表Ⅴ2中的回归2:
  su apovertyp if poutput<=220.26
  gen apovertyp_D=apovertyp
  replace apovertyp_D=0 if apovertyp_D>=0.923644
  replace apovertyp_D=1 if apovertyp_D!=0

  reg3 (winterest apovertyp_D $control2 interestc pawn i.region) (apovertyp_D winterest $control2 location relief i.region), 3sls
  est store a2

  * 表Ⅴ2中的回归3:
  reg3 (winterest apovertyr $control2 interestc pawn i.region) (apovertyr winterest $control2 location relief i.region), 3sls
  est store a3
  
  * 表Ⅴ2中的回归4:
  su apovertyr if poutput<=220.26
  gen apovertyr_D=apovertyr
  replace apovertyr_D=0 if apovertyr_D>=0.3732027
  replace apovertyr_D=1 if apovertyr_D!=0

  reg3 (winterest apovertyr_D $control2 interestc pawn i.region) (apovertyr_D winterest $control2 location relief i.region), 3sls
  est store a4

  outreg2 [a1 a2 a3 a4] using 附录Ⅴ表Ⅴ2.doc, tstat bdec(3) tdec(2) replace
  
  
  ************** 附录Ⅴ：表Ⅴ3 限定样本的回归结果 **************

  * 表Ⅴ3中的回归1:
  reg3 (winterest povertyt $control interestc pawn i.region) (povertyt winterest $control location relief i.region) if winterest>0, 3sls
  est store a11
  
  * 表Ⅴ3中的回归2:
  reg3 (winterest povertyt $control interestc pawn i.region) (povertyt winterest $control location relief i.region) if health==0, 3sls
  est store a22
  
  * 表Ⅴ3中的回归3:
  reg3 (winterest povertyt $control interestc pawn i.region) (povertyt winterest $control location relief i.region) if  winterest>0 & health==0, 3sls
  est store a33
  
  outreg2 [a11 a22 a33] using 附录Ⅴ表Ⅴ3.doc, tstat bdec(3) tdec(2) replace
  
  
  ************** 附录Ⅴ：表Ⅴ4 排除竞争性假说的回归结果 ************** 
  
  * 表Ⅴ4中的回归1:
  reg3 (winterest povertyt $control interestc pawn socialins i.region) (povertyt winterest $control location relief socialins i.region), 3sls
  est store a111

  * 表Ⅴ4中的回归2:
  reg3 (winterest povertyt $control interestc pawn newfina i.region) (povertyt winterest $control location relief newfina i.region), 3sls
  est store a222
  
  * 表Ⅴ4中的回归3:
  reg3 (winterest povertyt $control interestc pawn poppre i.region) (povertyt winterest $control location relief poppre i.region), 3sls
  est store a333
  
  * 表Ⅴ4中的回归4:
  reg3 (winterest povertyt $control interestc pawn socialins newfina poppre i.region) (povertyt winterest $control location relief socialins newfina poppre i.region), 3sls
  est store a444
  
  outreg2 [a111 a222 a333 a444] using 附录Ⅴ表Ⅴ4.doc, tstat bdec(3) tdec(2) replace
  

  ************** 附录Ⅴ：表Ⅴ5至表Ⅴ7 的PSM估计结果 ************** 

  use PSM回归数据.dta, clear

  **（1）一方面考察贫困陷阱对借贷利率的影响

  * 将数据随机排序
  set seed 10101
  gen ranorder = runiform()
  sort ranorder

  global control "relativec lnpland size alabor livestock nonae lnnetwork lnsave rice tax flood drought"
  /// 设定控制变量
  
  
  * 近邻匹配，k=5
  psmatch2 povertyt $control interestc pawn i.region, outcome(winterest) n(5) ate ties logit common
  
  * 自助法得到标注误：
  bootstrap r(att)r(atu)r(ate),reps(500): psmatch2 povertyt $control interestc pawn i.region, outcome(winterest) n(5) ate ties logit common
  est store p1
  
  * 考察匹配结果平衡性
  pstest $control interestc pawn i.region,both graph
      /// 由此code可以得到表Ⅴ5控制变量平衡性检验以及表Ⅴ6匹配平衡性假定检验结果


  * 卡尺匹配
  psmatch2 povertyt $control interestc pawn i.region, outcome(winterest) radius cal(0.03) ate ties logit common quietly 
  
  * 自助法得到标注误：
  bootstrap r(att)r(atu)r(ate),reps(500): psmatch2 povertyt $control interestc pawn i.region, outcome(winterest) radius cal(0.03) ate ties logit common
  est store p2
  
  
  * 核匹配
  psmatch2 povertyt $control interestc pawn i.region, outcome(winterest) kernel ate ties logit common quietly 
  
  * 自助法得到标注误：
  bootstrap r(att)r(atu)r(ate),reps(500): psmatch2 povertyt $control interestc pawn i.region, outcome(winterest) kernel ate ties logit common
  est store p3

  
  * 局部线性回归匹配
  psmatch2 povertyt $control interestc pawn i.region, outcome(winterest) llr ate ties logit common quietly 
  
  * 自助法得到标注误：
  bootstrap r(att)r(atu)r(ate),reps(500): psmatch2 povertyt $control interestc pawn i.region, outcome(winterest) llr ate ties logit common
  est store p4
  

  **（2）另一方面考察借贷利率对贫困陷阱的影响

  * 生成利率二元变量
  gen winterest_D=winterest
  replace winterest_D=0 if winterest_D<3
  replace winterest_D=1 if winterest_D>=3

  
  * 近邻匹配，k=5
  psmatch2 winterest_D $control location relief i.region, outcome(povertyt) n(5) ate ties logit common
  
  * 自助法得到标注误：
  bootstrap r(att)r(atu)r(ate),reps(500): psmatch2 winterest_D $control location relief i.region, outcome(povertyt) n(5) ate ties logit common
  est store p5

  
  * 卡尺匹配
  psmatch2 winterest_D $control location relief i.region, outcome(povertyt) radius cal(0.03) ate ties logit common quietly 
  
  * 自助法得到标注误：
  bootstrap r(att)r(atu)r(ate),reps(500): psmatch2 winterest_D $control location relief i.region, outcome(povertyt) radius cal(0.03) ate ties logit common
  est store p6

  
  * 核匹配
  psmatch2 winterest_D $control location relief i.region, outcome(povertyt) kernel ate ties logit common quietly 
  
  * 自助法得到标注误：
  bootstrap r(att)r(atu)r(ate),reps(500): psmatch2 winterest_D $control location relief i.region, outcome(povertyt) kernel ate ties logit common
  est store p7

  
  * 局部线性回归匹配
  psmatch2 winterest_D $control location relief i.region, outcome(povertyt) llr ate ties logit common quietly 
  
  * 自助法得到标注误：
  bootstrap r(att)r(atu)r(ate),reps(500): psmatch2 winterest_D $control location relief i.region, outcome(povertyt) llr ate ties logit common
  est store p8
  
  outreg2 [p1 p2 p3 p4 p5 p6 p7 p8] using 附录Ⅴ表Ⅴ7.doc, tstat bdec(3) tdec(2) replace
  
  
  log close
  /// 结束日志记录
