        *****************************************************************
                          *                   货币锚测算程序                      *
                           *                时间：2023年11月                   *
        *****************************************************************   
/*
      1. 此程序用于《人民币具备网络外部性了吗？论文中有关货币锚数据测算，对应文中式（10）
	  2. 前期数据已经整理完毕，该程序不包含数据整理程序
	  3. 时间区间：1995m1-2023m9。
	  4. 该版本在回归时加入了VIX和布伦特原油期货指数变化率。
*/ 
       ****************************************************************
                       ***********       一、滚动回归       ************
       ****************************************************************     
	global path0 E:\论文写作投稿\网络外部性\货币锚估计   //可根据实际目录调整

**************************
  *1.分国家滚动回归（四年）
**************************  

  *注：1）基准回归：分国家按照4年，48个月进行滚动
	  *2）对1995-2023年181个经济体样本进行回归
 
  
  *（1）对非五大SDR经济体
  cd "$path0"
  use ersdr_1995_2022.dta,replace

  *叙利亚（160）2018年之后，没有汇率数据
  *委内瑞拉（177）2018年7月之后，没有汇率数据
  *津巴布韦year1不从1开始，从20开始
	global x1 dlnusdsdr dlneursdr dlnjpysdr dlngbpsdr dlncnysdr_e  dlnvix dlnbrentoil 
  
  sum cntry year1  //year=345，country=181
	  cls
	  numlist "1(1)298"
      global yr  `r(numlist)'
      macro list yr
  constraint 1 dlnusdsdr +dlneursdr +dlnjpysdr +dlngbpsdr +dlncnysdr_e=1   
 forvalues i=1(1)181 {
      
	  matrix panel`i' = J(298,11,.)
      matrix colnames panel`i' = coef_usd coef_eur coef_jpy coef_gbp coef_cny p_usd p_eur p_jpy p_gbp  p_cny e_sd
      matrix rowname  panel`i' = $yr
      matrix list panel`i'
	  local irow = 0
    *部分国家样本期内数据缺失，比如科索沃、黑山、帕劳、塞尔维亚和津巴布韦前期数据缺失，从而导致循环程序中断，需要手动调整程序的时间起始点对这些国家进行单独估计。
 forvalues j=1(1)121{   
	  local k=`j'+47
	 
    qui cnsreg dlnersdr  $x1 if year1<=`k' & year1>=`j' & cntry==`i',c(1)
      predict ehat if year1<=`k' & year1>=`j' & cntry==`i',residual
	  egen sde=sd(ehat)
	  sum sde
	  scalar sdem=r(mean)
	  
    qui cnsreg dlnersdr $x1  if year1<=`k' & year1>=`j' & cntry==`i', c(1)
      return list
	  local irow = `irow'+1
      
	  matrix b`i'`j' = r(table)

	  scalar b1`i'`j' = b`i'`j'[1,1] 
      scalar b2`i'`j' = b`i'`j'[1,2]
      scalar b3`i'`j' = b`i'`j'[1,3]
	  scalar b4`i'`j' = b`i'`j'[1,4]
      scalar b5`i'`j' = b`i'`j'[1,5]

      scalar pb1`i'`j'=b`i'`j'[4,1]
      scalar pb2`i'`j'=b`i'`j'[4,2] 
      scalar pb3`i'`j'=b`i'`j'[4,3]
	  scalar pb4`i'`j'=b`i'`j'[4,4] 
      scalar pb5`i'`j'=b`i'`j'[4,5]	  
      
	  matrix panel`i'[`irow',1] = b1`i'`j'
	  matrix panel`i'[`irow',2] = b2`i'`j'
	  matrix panel`i'[`irow',3] = b3`i'`j'
	  matrix panel`i'[`irow',4] = b4`i'`j'
	  matrix panel`i'[`irow',5] = b5`i'`j'      
	  
	  matrix panel`i'[`irow',6] = pb1`i'`j'
	  matrix panel`i'[`irow',7] = pb2`i'`j'
	  matrix panel`i'[`irow',8] = pb3`i'`j'
	  matrix panel`i'[`irow',9] = pb4`i'`j'
	  matrix panel`i'[`irow',10] = pb5`i'`j'

	  matrix panel`i'[`irow',11] = sdem
	  drop ehat sde 
}
      *matrix list panel`i'
	  putexcel set `i'.xlsx, sheet(sheet1)
      putexcel A1=matrix(panel`i'),names 
  
 }
 

********************************************************************
* 2. 将存放结果的Excel文件导入stata（仅需变更数据目录）完整数据国家
********************************************************************

  *注：注意核对国家顺序，一般没有问题
  
clear
global y   Afghanistan	Albania	Algeria	Angola	Anguilla	Antigua_and_Barbuda	Argentina	Armenia	Aruba	Australia	Azerbaijan	Bahamas	Bahrain	Bangladesh	Barbados	Belarus	Belize	Benin	Bermuda	Bhutan	Bolivia	Bosnia_and_Herzegovina	Botswana	Brazil	Brunei_Darussalam	Bulgaria	Burkina_Faso	Burundi	Cabo_Verde	Cambodia	Cameroon	Canada	Cayman_Islands	Central_African	Chad	Chile	China_Hong_Kong	Colombia	Comoros	Congo_Dem	Congo_Rep	Costa_Rica	Croatia	Cyprus	Czech	Côte_d'Ivoire	Denmark	Djibouti	Dominica	Dominican_Rep	Ecuador	Egypt	El_Salvador	Equatorial_Guinea	Eritrea	Estonia	Eswatini	Ethiopia	Fiji	French_Polynesia	Gabon	Gambia	Georgia	Ghana	Gibraltar	Greece	Grenada	Guatemala	Guernsey	Guinea	Guinea-Bissau	Guyana	Haiti	Honduras	Hungary	Iceland	India	Indonesia	Iran	Iraq	Isle_of_Man	Israel	Jamaica	Jersey	Jordan	Kazakhstan	Kenya	Kiribati	Korea	Kosovo	Kuwait	Kyrgyz	Lao_People's_Dem	Latvia	Lebanon	Lesotho	Liberia	Libya	Lithuania	Madagascar	Malawi	Malaysia	Maldives	Mali	Malta	Mauritania	Mauritius	Mexico	Micronesia	Moldova	Mongolia	Montenegro	Montserrat	Morocco	Mozambique	Myanmar	Namibia	Nauru	Nepal	New_Caledonia	New_Zealand	Nicaragua	Niger	Nigeria	North_Macedonia	Norway	Oman	Pakistan	Palau	Panama	Papua_New_Guinea	Paraguay	Peru	Philippines	Poland	Qatar	Romania	Russian	Rwanda	Samoa	San_Marino	Saudi_Arabia	Senegal	Serbia	Seychelles	Sierra_Leone	Singapore	Slovak	Slovenia	Solomon_Islands	South_Africa	Sri_Lanka	St._Kitts_and_Nevis	St._Lucia	St._Vincent_and_the_Grenadines	Sudan	Suriname	Sweden	Switzerland	Syrian	São_Tomé_and_Príncipe	Taiwan_Province_of_China	Tajikistan	Tanzania	Thailand	Timor-Leste	Togo	Tonga	Trinidad_and_Tobago	Tunisia	Turkey	Uganda	Ukraine	United_Arab_Emirates	Uruguay	Vanuatu	Venezuela	Vietnam	Yemen	Zambia	Zimbabwe  

global ny: word count $y
forvalues file=1(1)$ny {
import excel "`file'.xlsx",clear firstrow
local yy: word `file' of $y
gen country="`yy'"

rename A year1
destring year1, replace
save `file'.dta, replace
clear
}


use 1.dta,clear
forvalues file=2(1)181 {
append using "`file'.dta"
}
gen country_= subinstr(country,"_"," ",.) 
drop country 
rename country_ country
order country year1
encode country,gen(cntry)
order country cntry year1
sum cntry

save 货币锚-4年-正文.dta,replace
  
       ****************************************************************
            ***********       三、估计结果处理       ************
       ****************************************************************

***************************************
  *1. 估计结果预处理：区分显著和不显著
***************************************
*1)对显著性进行处理，保证数据连续性
  /*
   注：为何要进行估计结果的预处理？
           为了保证估计结果的连续性。因为从估计结果来看，虽然估计参数没有明显变化，
		 但估计显著性发生变化。因此，采用两种方法进行处理：
		   第一，以0.109为节点，区分显著和不显著，将不显著的p值设为1，显著的设为0；
		   第二，在估计参数不发生结构性变化的情况下，如果出现1-2个显著性水平发生变化，
		 将其显著性修正为前后一致。
    
  */
  *使用文件夹\估计结果汇总\数据更新202309中的更新数据进行处理，文件夹\估计结果汇总中的文件"货币锚-季刊-原始估计结果"
  *记录原始估计数据，之后可以查阅。

  use 货币锚-4年-正文.dta,clear
  xtset cntry time
  foreach var of varlist p_usd p_eur  p_jpy p_gbp p_cny {  //
		
		replace `var'=0 if `var'<=0.109
		replace `var'=1 if `var'>0.109
		
		bysort cntry:replace `var'=0 if l.`var'==0 & f.`var'==0
		bysort cntry:replace `var'=0 if l.`var'==0 & f2.`var'==0
		bysort cntry:replace `var'=1 if l.`var'==1 & f.`var'==1
		bysort cntry:replace `var'=1 if l.`var'==1 & f2.`var'==1
	
  } 

replace p_usd=0 if coef_usd>0.99 & coef_usd<1.01
replace p_eur=0 if coef_eur>0.99 & coef_eur<1.01
replace p_gbp=0 if coef_gbp>0.99 & coef_gbp<1.01
replace p_jpy=0 if coef_jpy>0.99 & coef_jpy<1.01
replace p_cny=0 if coef_cny>0.99 & coef_cny<1.01

replace coef_cny=0 if year1<67 //2005年7月之前，人民币锚为0

save 货币锚-4年-正文.dta, replace

 /*
 注：对估计参数的处理，根据估计参数符号和显著性水平进行判断，将为负数且不显著的设为0		  	  
 */

   use 货币锚-4年-正文.dta,clear

  preserve
    
	replace coef_usd=0 if coef_usd<0 & p_usd==1
    replace coef_gbp=0 if coef_gbp<0 & p_gbp==1
    replace coef_eur=0 if coef_eur<0 & p_eur==1
    replace coef_jpy=0 if coef_jpy<0 & p_jpy==1
    replace coef_cny=0 if coef_cny<0 & p_cny==1
    
	foreach var of varlist coef_usd  coef_gbp  coef_eur coef_jpy coef_cny   {
		sort cntry time
		
		bysort cntry:replace `var'=0 if l.`var'==0 & f.`var'==0
		bysort cntry:replace `var'=0 if l.`var'==0 & f2.`var'==0
	
  }	   	   
	save 货币锚-4年-正文.dta ,replace 
	
  restore 
  
 
***********************
  *2. 将估计结果标准化
***********************  
  *注将参数之和标准化为1。
  use 货币锚-4年-正文.dta

  foreach var of varlist coef_usd  coef_gbp  coef_eur coef_jpy coef_cny   {
		
		replace `var'=0 if `var'==.
	    gen a`var'=abs(`var')    //取绝对值
  } 

  gen total=acoef_usd  + acoef_gbp + acoef_eur + acoef_jpy + acoef_cny
  gen usd=acoef_usd/total
  gen gbp=acoef_gbp/total
  gen eur=acoef_eur/total  
  gen jpy=acoef_jpy/total  
  gen cny=acoef_cny/total  
  
  order (usd  gbp  eur jpy cny),before(coef_usd)
  
  foreach var of varlist usd  gbp  eur jpy cny   {
		
		replace `var'=0 if `var'==.
	    replace `var'=0 if `var'<0.001
		replace `var'=1 if `var'>0.999
  }
  label var usd "美元"
  label var gbp "英镑"
  label var eur "欧元"
  label var jpy "日元"
  label var cny "人民币"
  save  货币锚-4年-正文.dta,replace
****************************************
  *3. 筛选本文样本：63国，2005m7-2022m2
**************************************** 
  keep if country=="Albania" | 	country=="Algeria" |	country=="Armenia" |	country=="Azerbaijan" |	country=="Bhutan" |country=="Botswana" |	country=="Brazil" |	country=="Cabo Verde" |	country=="Cambodia" |	country=="Chile" |	country=="Croatia" |	country=="Cyprus" |	country=="Egypt" |	country=="Eswatini" |	country=="Ethiopia" |	country=="Gambia" |	country=="Georgia" |	country=="Ghana" |	country=="Guinea" |	country=="Haiti" |	country=="Indonesia" |	country=="Jamaica" |	country=="Kazakhstan" |	country=="Kiribati" |	country=="Kuwait" |	country=="Kyrgyz" |	country=="Lao People's Dem"|	country=="Latvia" |	country=="Liberia" |	country=="Lithuania" |	country=="Madagascar" |	country=="Malawi" |	country=="Malaysia" |	country=="Malta" |	country=="Mauritania" |	country=="Mauritius" |	country=="Moldova" |	country=="Mongolia" |	country=="Mozambique" |	country=="Namibia" |	country=="Nauru" |	country=="Nepal" |	country=="Nigeria" |	country=="Paraguay" |	country=="Peru" |	country=="Philippines" |	country=="Poland" |	country=="Romania" |	country=="Samoa" |	country=="Serbia" |	country=="Seychelles" |	country=="Sierra Leone" |	country=="Slovak" |	country=="Tajikistan" |	country=="Tanzania" |	country=="Thailand" |	country=="Tonga" |	country=="Tunisia" |	country=="Uganda" |	country=="Uruguay" |	country=="Vanuatu" |	country=="Vietnam" |	country=="Zambia" 

  drop if time<tm(2005m7) | time>tm(2022m2)
  save  货币锚-4年-正文.dta,replace
  
  
  
  
  
  
  
  
