clear all
cd "D:\2024-00108-复现代码及数据\主要回归部分"
****************************************************************
**理论部分包含两张图（图1&图2），是为了解释人民币的动态变化路径。因此，其中的数据仅做示例，和本文数据无直接关联(正文中，图1，图2中的箭头在office中绘制)
clear 
input x y
0.0 0.0
0.5 0.5 
1 1 
end
generate str name = "A" in 1
replace  name = "B" in 2
replace  name = "C" in 3
gen pos=3
replace pos=12 in 1
twoway (function y=0.5*(tanh(8*x-4)+1),range(0 1) legend(label(1 `"{it:{&phi}d=0}"') ))  (function y=x,range(0 1) legend(label(2 `"{it:y{subscript:t}=y{subscript:t-1}}"')) color(black) lpattern(dash)) (scatter y x, msymbol(circle) mlabel(name) msize(small) mlabgap(.1cm) mc(gs0) mlabvposition(pos)) ,xtitle(`"{fontface "宋体":滞后一期人民币隐性锚指数}"',height(5)) ytitle(`"{fontface "宋体":当期人民币隐性锚指数}"',height(8)) xsize(2) ysize(2) graphregion(fcolor(white)) ylabel(,angle(0))  ylabel(,nogrid) xlabel(0 "0%" 0.2 "20%" 0.4 "40%" 0.6 "60%" 0.8 "80%" 1.0 "100%", angle(0)  ) ylabel(0 "0%" 0.2 "20%" 0.4 "40%" 0.6 "60%" 0.8 "80%" 1.0 "100%", angle(0) ) legend(region(lcolor(none)) lpattern(blank)) legend(size(medium) col(2)) legend(order(1 2) region(fcolor(none) lpattern(blank))) scheme(s2mono) 
graph export "D:\2024-00108-复现代码及数据\主要回归部分\图1-a.png", as(png) name("Graph") replace
clear 
input x y
0.07 0.07
1 1
end
generate str name = "D" in 1
replace  name= "E" in 2
twoway  (function y=0.5*(tanh(8*x-1.86)+1),range(0 1) legend(label(1 `"{it:{&phi}d={&phi}d*}"') size(small)))  (function y=x,range(0 1) legend(label(2 `"{it:y{subscript:t}=y{subscript:t-1}}"') size(small)) color(black) lpattern(dash)) (scatter y x, msymbol(circle) mlabel(name) msize(small) mlabgap(.1cm) mc(gs0) ) ,xtitle(`"{fontface "宋体":滞后一期人民币隐性锚指数}"',height(5)) ytitle(`"{fontface "宋体":当期人民币隐性锚指数}"',height(8)) xsize(2) ysize(2) graphregion(fcolor(white)) ylabel(,nogrid) ylabel(,angle(0))xlabel(0 "0%" 0.2 "20%" 0.4 "40%" 0.6 "60%" 0.8 "80%" 1.0 "100%", angle(0)  ) ylabel(0 "0%" 0.2 "20%" 0.4 "40%" 0.6 "60%" 0.8 "80%" 1.0 "100%", angle(0) ) legend(region(lcolor(none)) lpattern(blank)) legend(size(medium) col(2)) legend(order(1 2) region(fcolor(none) lpattern(blank))) scheme(s2mono) 
graph export "D:\2024-00108-复现代码及数据\主要回归部分\图1-b.png", as(png) name("Graph") replace


****************************************************************
****************************************************************
*****附录II：表A3:篮子货币的货币锚份额在不同地区的表现：2019—2022年（单位：%）
clear
use readyrun.dta
gen group=.
replace group=1 if esa==1  //东南亚 
replace group=2 if ea==1   //东亚 
replace group=3 if sa==1   //南亚 
replace group=4 if maeu==1  //中亚东欧
replace group=5 if wana==1  // 西亚北非 
replace group=6 if wu==1  //西欧 
replace group=7 if dyz==1  //大洋洲 
replace group=8 if ldmz==1  //拉丁美洲 
replace group=9 if sfz==1  //撒哈拉以南非洲 
save workdata.dta,replace
***保存了一个数据：差别只在于workdata.dta多了group变量
***时间范围：2019年1月-2022年2月
keep if time<202203
keep if time>201900
local colname_forall CNY sd(CNY) USD JPY GBP EUR
matrix  sum2=J(9,6,.)
matrix colnames sum2 = `colname_forall'
local rowname_forall 东南亚 东亚 南亚 中亚东欧 西亚北非 西欧 大洋洲 拉丁美洲 撒哈拉以南非洲 
matrix rownames  sum2 = `rowname_forall'
forvalues jj=1/9{
	summ cny if group == `jj'
	matrix sum2[`jj',1] = r(mean)*100
	matrix sum2[`jj',2] = r(sd)*100
	summ usdpercent if group == `jj'
	matrix sum2[`jj',3] = r(mean)*100
	summ jpypercent if group == `jj'
	matrix sum2[`jj',4] = r(mean)*100
	summ gbppercent if group == `jj'
	matrix sum2[`jj',5] = r(mean)*100
	summ eurpercent if group == `jj'
	matrix sum2[`jj',6] = r(mean)*100
}
putexcel set appendix_II&III,replace sheet(II_A3,replace)
putexcel A1=matrix(sum2),names

****************************************************************
*****附录III：表III1&表III2:样本经济体具体说明
clear
use workdata.dta
*因为是展示所选经济体以及对应区域，不随时间变化，保留一期数据即可（t=200是最后一期
keep if t==200
keep  国家 group bar fta bea
gen area=""
replace area="东南亚" if group==1
replace area="东亚" if group==2
replace area="南亚" if group==3
replace area="中亚东欧" if group==4
replace area="西亚北非" if group==5
replace area="西欧" if group==6
replace area="大洋洲" if group==7
replace area="拉丁美洲" if group==8
replace area="撒哈拉以南非洲" if group==9
sort group 国家
bysort group:gen sort=_n
list
save appendixIII.dta,replace
export excel using "D:\2024-00108-复现代码及数据\主要回归部分\appendix_II&III.xlsx", sheetmodify sheet(III1&III2,replace) firstrow(variables)
********************************************************************
****附录II：表A1：描述性统计
clear 
use workdata.dta
matrix  sum_var=J(13,5,.)
matrix rownames sum_var=y lcny trade ofdic cnyr1 fin lgdpspread  dgdpg dinf corr_gdpg lp2 gpr VIX
matrix colnames sum_var=均值 标准差 最小值 中位数 最大值 
gen jj=1
foreach var of varlist y lcny trade ofdic cnyr1 fin lgdpspread  dgdpg dinf corr_gdpg lp2 gpr VIX{
	sum `var',detail
	matrix sum_var[jj,1] = r(mean)
	matrix sum_var[jj,2] = r(sd)
	matrix sum_var[jj,3] = r(min)
	matrix sum_var[jj,4] = r(p50)
	matrix sum_var[jj,5] = r(max)
	replace jj=jj+1
}
mat list sum_var
putexcel set appendix_II&III,modify sheet(II_A1,replace)
putexcel A1=matrix(sum_var),names
****************************************************************
*****附录II：表A2：时间维度篮子货币的货币锚份额的统计特征
clear
use readyrun.dta
**本文研究的时间范围是2005年7月至2022年2月（月度数据）
keep if time>200506
keep if time<202203
local colname_forall CNY sd(CNY) USD JPY GBP EUR
matrix  sum1=J(18,6,.)
matrix colnames sum1= `colname_forall'
local rowname_forall 2005 2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 2016 2017 2018 2019 2020 2021 2022 
matrix rownames sum1= `rowname_forall'
*100是将单位化成%
forvalues jj=1/18{
	summ cny if year == `jj'+2004
	matrix sum1[`jj',1] = r(mean)*100
	matrix sum1[`jj',2] = r(sd)*100
	summ usdpercent if year == `jj'+2004
	matrix sum1[`jj',3] = r(mean)*100
	summ jpypercent if year == `jj'+2004
	matrix sum1[`jj',4] = r(mean)*100
	summ gbppercent if year == `jj'+2004
	matrix sum1[`jj',5] = r(mean)*100
	summ eurpercent if year == `jj'+2004
	matrix sum1[`jj',6] = r(mean)*100
}
matrix list  sum1
putexcel set appendix_II&III,modify sheet(II_A2,replace)
putexcel A1=matrix(sum1),names

************************************************************************
********************************************************************
******回归部分：正文表2:基准回归结果
clear
use workdata.dta
tab cnty,gen(cnty)
xtset cnty t
*过度识别检验(p>0.1，工具变量有效)
xtivreg y trade  t1 (lcny = l2cny l3cny), re 
xtoverid //p=0.1613
xtivreg y trade ofdic cnyr1 fin lgdpspread dgdpg dinf corr_gdpg lp2  gpr VIX t1 (lcny = l2cny l3cny), re 
xtoverid //p=0.1611
******1
xtivreg y trade ofdic i.cnty t1 (lcny = l2cny l3cny), re 
outreg2 using table2.doc,tstat dec(3) replace
******2
xtivreg y trade ofdic corr_gdpg  i.cnty t1 (lcny = l2cny l3cny), re
outreg2 using  table2.doc,tstat dec(3) append
******3
xtivreg y trade ofdic corr_gdpg lp2 lgdpspread dgdpg dinf i.cnty t1 (lcny = l2cny l3cny), re 
outreg2 using  table2.doc,tstat dec(3) append
******4
xtivreg y trade ofdic corr_gdpg lp2 lgdpspread dgdpg dinf gpr VIX i.cnty t1 (lcny = l2cny l3cny), re
outreg2 using  table2.doc,tstat dec(3) append 
******5
xtivreg y trade ofdic corr_gdpg  lp2 fin cnyr1 lgdpspread dgdpg dinf  i.cnty t1 (lcny = l2cny l3cny), re
outreg2 using  table2.doc,tstat dec(3) append
*****综合6
xtivreg y trade ofdic lp2 corr_gdpg fin cnyr1 lgdpspread dgdpg dinf gpr VIX i.cnty t1 (lcny = l2cny l3cny), re
outreg2 using  table2.doc,tstat sortvar(lcny trade ofdic corr_gdpg lp2 cnyr1 fin  lgdpspread dgdpg dinf gpr VIX  t1 i.cnty) dec(3) append

******************************************************************
*****准备进行政策效果分析
clear
use workdata.dta
gen bar_trade=bar*trade
gen bar_corr_gdpg=bar*corr_gdpg
gen fta_trade=fta*trade
gen fta_corr_gdpg=fta*corr_gdpg
gen bea_trade=bea*trade
gen bea_corr_gdpg=bea*corr_gdpg
gen bar_ofdic=bar*ofdic
gen fta_ofdic=fta*ofdic
gen bea_ofdic=bea*ofdic
save reg_policy.dta,replace
******************************************************************
*****政策效果分析：正文表3:不同政策影响人民币货币锚的调节作用
clear
use reg_policy.dta
xtivreg y trade ofdic lp2 corr_gdpg fin cnyr1 lgdpspread dgdpg dinf gpr VIX i.cnty t1 (lcny = l2cny l3cny), re
outreg2 using  table3.doc,tstat  replace
foreach policy of varlist fta bar bea {
 xtivreg y `policy' `policy'_trade trade ofdic lp2 corr_gdpg fin cnyr1 lgdpspread dgdpg dinf gpr VIX  i.cnty t1 (lcny = l2cny l3cny), re
outreg2 using  table3.doc,tstat  dec(3) append
xtivreg y `policy' `policy'_ofdic trade ofdic lp2 corr_gdpg fin cnyr1 lgdpspread dgdpg dinf gpr VIX  i.cnty t1 (lcny = l2cny l3cny), re
outreg2 using  table3.doc,tstat  dec(3) append
xtivreg y `policy' `policy'_corr_gdpg trade ofdic lp2 corr_gdpg fin cnyr1 lgdpspread dgdpg dinf gpr VIX  i.cnty t1 (lcny = l2cny l3cny), re
 outreg2 using  table3.doc,tstat  sortvar(lcny fta fta_trade fta_ofdic  fta_corr_gdpg bar bar_trade bar_ofdic bar_corr_gdpg bea bea_trade bea_ofdic bea_corr_gdpg  trade ofdic lp2 corr_gdpg fin cnyr1 lgdpspread dgdpg dinf gpr VIX t1 i.cnty  )  dec(3) append 
}

**************************************************************
**********准备附录II：表A4：模拟参数计算结果
clear
use workdata.dta
mat num_x=[14] //13个变量(含t);+常数项
mat num=[63]+num_x[1,1]
*********模拟参数计算结果******************************************
//保存关键估计结果到矩阵：moni0
xtivreg y trade ofdic corr_gdpg lp2 cnyr1 fin lgdpspread dgdpg dinf  gpr VIX t1 i.cnty (lcny = l2cny l3cny ), re 
matrix mntable=r(table)
matrix moni=mntable[1,1..num[1,1]] 
mat moni0=moni'
//按如下顺序重新排列：alpha beta gamma1 gamma2 gamma3 gamma4 gamma5 gamma6 gamma7 gamma8 gamma9 gamma10 gamma11 theta 
matrix tableA4_temp=J(14,1,1)
forvalues jj=1/13{ //包括trade ofdic cnyr1 fin lgdpspread dgdpg dinf corr_gdpg lp2 gpr VIX t系数
matrix tableA4_temp[`jj'+1,1]=moni0[`jj',1]
}
mat tableA4_temp[1,1]=moni0[num[1,1],1]    //常数项c
****************************************************
//表A4左半边
matrix rownames tableA4_temp= alpha beta gamma1 gamma2 gamma3 gamma4 gamma5 gamma6 gamma7 gamma8 gamma9 gamma10 gamma11 theta 
matrix colnames tableA4_temp= 回归参数计算结果
putexcel set appendix_II&III,modify sheet(II_A4-1,replace)
putexcel A1=matrix(tableA4_temp),names
//表A4右半边：根据回归参数和模拟参数之间一一对应的关系计算
matrix tableA4=J(14,1,1)
mat tableA4[1,1]=tableA4_temp[1,1]/2+tableA4_temp[2,1]/4
mat tableA4[2,1]=tableA4_temp[2,1]/4
forvalues jj=3/14{
mat tableA4[`jj',1]=tableA4_temp[`jj',1]/2 
}
matrix rownames tableA4= phi·c phi·rho phi·b1 phi·b2 phi·b3 phi·b4 phi·b5 phi·b6 phi·b7 phi·b8 phi·b9 phi·b10 phi·b11 phi·theta 
matrix colnames tableA4= 模拟参数计算结果
putexcel set appendix_II&III,modify sheet(II_A4-2,replace)
putexcel A1=matrix(tableA4),names

******************************************************************************
***********************预测部分*************************************
**********定义系数矩阵
clear
use workdata.dta
order 国家 country cnty
mat num_x=[14] //13个变量(含t);+常数项
mat num=[63]+num_x[1,1]
**********基准回归
xtivreg y trade ofdic cnyr1 fin lgdpspread dgdpg dinf corr_gdpg lp2  gpr VIX i.cnty t1 (lcny = l2cny l3cny ), re 
**整理系数:原始系数
matrix resulttable=r(table)
matrix result=resulttable[1..4,1..num[1,1]] 
matrix rownames result=系数 标准误 Z值 P值
matrix result0=result'
matrix rownames result0=lcny trade ofdic cnyr1 fin lgdpspread dgdpg dinf corr_gdpg lp2 gpr VIX 不丹 乌干达 乌拉圭 亚美尼亚 佛得角 克罗地亚 冈比亚 几内亚 利比里亚 加纳 博茨瓦纳 印度尼西亚 吉尔吉斯斯坦 哈萨克斯坦 坦桑尼亚 埃及 埃塞俄比亚 基里巴斯 塔吉克斯坦 塞尔维亚 塞拉利昂 塞浦路斯 塞舌尔 尼日利亚 尼泊尔 巴拉圭 巴西 拉脱维亚 摩尔多瓦 斯威士兰 斯洛伐克 智利 柬埔寨 格鲁吉亚 毛里塔尼亚 毛里求斯 汤加 波兰 泰国 海地 牙买加 瑙鲁 瓦努阿图 科威特 秘鲁 突尼斯 立陶宛 纳米比亚 罗马尼亚 老挝 莫桑比克 菲律宾 萨摩亚 蒙古 赞比亚 越南 阿塞拜疆 阿尔及利亚 阿尔巴尼亚 马拉维 马来西亚 马耳他 马达加斯加  t c

matrix ifix=result0[num_x[1,1]-1..num[1,1]-2,1..4]  //个体固定效应
**在变量中加入ifix,ifix+c,方便后续计算
gen ifix=0
gen p_ifix=0
forvalues i=1/63{ //
	replace ifix=ifix[`i',1]  if cnty==`i'   
}
label var ifix "个体固定效应得到的参数(原始回归参数)"
gen ifixandc=ifix+result0[num[1,1],1] 
label var ifixandc  "个体参数(原始固定效应参数+常数项)"
matrix beta=result0[1,1]  //beta是滞后项估计系数
matrix rho=beta[1,1]/4
**生成b0变量：1/2*(c+fix)=1/4*beta
gen b0= ifixandc/2 + beta[1,1]/4
label var b0 "1/2alpha+1/4beta"
save reg_forecast.dta,replace

**变成计算d的系数矩阵
**需要是列矩阵，第一行是1，第二行是trade……的系数/2
*注：为了满足乘完之后是我们想要的结果，我们把b0的变换（1/2a+1/4b)放在后面，但是对b1的变换这里就做了（除以2）
matrix dcoeff=J(num_x[1,1]-1,1,.)
matrix rownames dcoeff= 1  trade ofdic cnyr1 fin lgdpspread dgdpg dinf corr_gdpg lp2 gpr VIX t 
matrix colnames dcoeff=d系数
matrix dcoeff[1,1]=1  //第一行即将与常数项和固体效应相乘，因此为1
forvalues jj=2/12{ //包括trade ofdic cnyr1 fin lgdpspread dgdpg dinf corr_gdpg lp2 gpr VIX系数
matrix dcoeff[`jj',1]=result0[`jj',1]/2
}
mat dcoeff[num_x[1,1]-1,1]=result0[num[1,1]-1,1]/2 //t系数
matrix list dcoeff //模拟参数列矩阵

************************************************************
**准备绘制图3：不同地区（政策）人民币货币锚份额的动态变化过程
//求最近一年各变量均值（2021年3月到2022年2月
clear
use reg_forecast.dta,replace
xtset cnty t
order time t
keep if time>202102
keep if time<202203
save run_12m.dta,replace
matrix sum12m=J((num_x[1,1]-1),13,.)
matrix colnames  sum12m = 总样本 esa maeu ea sa wana wu dyz ldmz sfz bar fta bea
matrix rownames  sum12m = b0 trade ofdic cnyr1 fin lgdpspread dgdpg dinf corr_gdpg lp2 gpr VIX t
gen jj=1
foreach var of varlist b0 trade ofdic cnyr1 fin lgdpspread dgdpg dinf corr_gdpg lp2 gpr VIX t {
	sum `var'
	matrix sum12m[jj,1] = r(mean)
	sum `var' if esa==1
	matrix sum12m[jj,2] = r(mean)
	sum `var' if maeu==1
	matrix sum12m[jj,3] = r(mean)
	sum `var' if ea==1
	matrix sum12m[jj,4] = r(mean)
	sum `var' if sa==1
	matrix sum12m[jj,5] = r(mean)
	sum `var' if wana==1
	matrix sum12m[jj,6] = r(mean)
	sum `var' if wu==1
	matrix sum12m[jj,7] = r(mean)
	sum `var' if dyz==1
	matrix sum12m[jj,8] = r(mean)
	sum `var' if ldmz==1
	matrix sum12m[jj,9] = r(mean)
	sum `var' if sfz==1
	matrix sum12m[jj,10] = r(mean)
	sum `var' if bar==1
	matrix sum12m[jj,11] = r(mean)
	sum `var' if fta==1
	matrix sum12m[jj,12] = r(mean)
	sum `var' if bea==1
	matrix sum12m[jj,13] = r(mean)
	replace jj=jj+1
}
matrix list  sum12m  //最近一年各变量均值
matrix d=dcoeff'*sum12m
matrix list d
matrix v_rho=[rho,rho,rho,rho,rho,rho,rho,rho,rho,rho,rho,rho,rho]
matrix d_rho=d-v_rho
matrix colnames  d_rho=总样本 esa maeu ea sa wana wu dyz ldmz sfz bar fta bea
mat list d_rho
mat list rho

************************************************************
**绘制图3:不同地区（政策）人民币货币锚份额的动态变化过程
twoway (function y=0.5*(tanh(2*rho[1,1]*x+d_rho[1,1])+1),range(0 1) legend(label(1 `"{fontface "宋体":总样本}"') size(small) region(lwidth(vvthin)))) (function y=0.5*(tanh(2*rho[1,1]*x+d_rho[1,4])+1),range(0 1) legend(label(2 `"{fontface "宋体":东亚}"') size(small)))   (function y=0.5*(tanh(2*rho[1,1]*x+d_rho[1,8])+1),range(0 1) legend(label(3 `"{fontface "宋体":大洋洲}"') size(small))) (function y=0.5*(tanh(2*rho[1,1]*x+d_rho[1,3])+1),range(0 1) legend(label(4 `"{fontface "宋体":中亚东欧}"') size(small))) (function y=0.5*(tanh(2*rho[1,1]*x+d_rho[1,11])+1),range(0 1) legend(label(5 `"{fontface "宋体":"一带一路"倡议}"') size(small))) (function y=0.5*(tanh(2*rho[1,1]*x+d_rho[1,12])+1),range(0 1) legend(label(6 `"{fontface "宋体":自由贸易协定}"') size(small)))   (function y=0.5*(tanh(2*rho[1,1]*x+d_rho[1,13])+1),range(0 1) legend(label(7 `"{fontface "宋体":双边货币互换}"') size(small)))  (function y=x,range(0 1) legend(label(8 `"{it:y{subscript:t}=y{subscript:t-1}}"') size(small)) color(black) lpattern(dash)) , xtitle(`"{fontface "宋体":滞后一期人民币隐性锚指数}"',height(5)) ytitle(`"{fontface "宋体":当期人民币隐性锚指数}"' ,height(8)) xsize(2.5) ysize(2) graphregion(fcolor(white)) ylabel(,nogrid) ylabel(,angle(0)) xlabel(0 "0%" 0.2 "20%" 0.4 "40%" 0.6 "60%" 0.8 "80%" 1.0 "100%", angle(0)  ) ylabel(0 "0%" 0.2 "20%" 0.4 "40%" 0.6 "60%" 0.8 "80%" 1.0 "100%", angle(0) )   legend(region(lcolor(none)) lpattern(blank)) legend(size(medsmall) col(2)) legend(order( 1 2 3 4 5 6 7 8  ) region(fcolor(none) lpattern(blank))) scheme(s2mono)
graph export "D:\2024-00108-复现代码及数据\主要回归部分\图3.png", as(png) name("Graph") replace
************************************************************
**绘制图2：贸易、投资、周期相似度、语言相似性都提高10%的
clear
mat assum=sum12m[1..13,1]
mat assum[2,1]=sum12m[2,1]*1.1
mat assum[3,1]=sum12m[3,1]*1.1
mat assum[9,1]=sum12m[9,1]*1.1
mat assum[10,1]=sum12m[10,1]*1.1
matrix d_a=dcoeff'*assum
matrix rownames  d =d_k
mat da_rho=d_a-rho
clear 
input x y
0.00 0.00
0.4035 0.4035
1 1
0.0322 0.0322
0.3585 0.3585
0.1439 0.1439
end
generate str name = "A " in 1
replace  name = "B (40.35%,40.35%)" in 2
replace  name = "C (100%,100%)" in 3
replace  name = "P (3.22%,3.22%)" in 4
replace  name = "D (35.85%,35.85%)" in 5
replace  name = "N (14.39%,14.39%)" in 6
gen pos=3
replace pos=5 in 3
replace pos=5 in 5
twoway (function y=0.5*(tanh(2*rho[1,1]*x+d_rho[1,1])+1),range(0 1) legend(label(1 `"{fontface "宋体":当前模拟结果}"') size(small) region(lwidth(vvthin)))) (function y=0.5*(tanh(2*rho[1,1]*x+da_rho[1,1])+1),range(0 1) legend(label(2 `"{fontface "宋体":条件优化}{fontface "Times New Roman":10%}"') size(small) region(lwidth(vvthin))) lpattern(shortdash))  (function y=0.5*(tanh(2*rho[1,1]*x-3.198855)+1),range(0 1) legend(label(3 `"{fontface "宋体":恰好形成网络外部性}"') size(small) region(lwidth(vvthin)) lpattern(dot)) ) (function y=0.5*(tanh(2*rho[1,1]*x-2.21613652)+1),range(0 1) legend(label(4 `"{fontface "宋体":突变条件}"') size(small) region(lwidth(vvthin))) ) (function y=x,range(0 1) legend(label(5 `"{it:y{subscript:t}=y{subscript:t-1}}"') size(small)) color(black) lpattern(dash)) (scatter y x, msymbol(circle) mlabel(name) msize(vsmall) mlabsize(2.6) mc(gs0) mlabgap(0.05cm) mlabvposition(pos)), xscale(range(0 1.3)) xtitle(`"{fontface "宋体":滞后一期人民币隐性锚指数}"',height(5)) ytitle(`"{fontface "宋体":当期人民币隐性锚指数}"' ,height(8)) xsize(2.5) ysize(2) graphregion(fcolor(white)) ylabel(,nogrid)  ylabel(,angle(0)) xlabel(0 "0%" 0.2 "20%" 0.4 "40%" 0.6 "60%" 0.8 "80%" 1.0 "100%", angle(0)  ) ylabel(0 "0%" 0.2 "20%" 0.4 "40%" 0.6 "60%" 0.8 "80%" 1.0 "100%", angle(0) )  legend(region(lcolor(none)) lpattern(blank)) legend(size(medsmall) col(2)) legend(order(1 2 3 4 5) region(fcolor(none) lpattern(blank))) scheme(s2mono)
graph export "D:\2024-00108-复现代码及数据\主要回归部分\图2.png", as(png) name("Graph") replace
 
*********************************************************
***********经济体层面的预测**********************************
clear
use run_12m.dta,replace
matrix gjsum=J(14,63,.)
matrix rownames gjsum = b0 trade ofdic cnyr1 fin lgdpspread dgdpg dinf corr_gdpg lp2 gpr VIX t cny
//matrix colnames gjsum= 总样本 ea ldmz bar fta  
rename cnty guojia
gen jj=1
foreach var of varlist b0 trade ofdic  cnyr1 fin lgdpspread dgdpg dinf corr_gdpg lp2 gpr VIX t cny{
	forvalues ii=1/63{
		sum `var' if guojia==`ii'
		matrix gjsum[jj,`ii'] = r(mean)
	}
	replace jj=jj+1
}
matrix colnames gjsum=不丹 乌干达 乌拉圭 亚美尼亚 佛得角 克罗地亚 冈比亚 几内亚 利比里亚 加纳 博茨瓦纳 印度尼西亚 吉尔吉斯斯坦 哈萨克斯坦 坦桑尼亚 埃及 埃塞俄比亚 基里巴斯 塔吉克斯坦 塞尔维亚 塞拉利昂 塞浦路斯 塞舌尔 尼日利亚 尼泊尔 巴拉圭 巴西 拉脱维亚 摩尔多瓦 斯威士兰 斯洛伐克 智利 柬埔寨 格鲁吉亚 毛里塔尼亚 毛里求斯 汤加 波兰 泰国 海地 牙买加 瑙鲁 瓦努阿图 科威特 秘鲁 突尼斯 立陶宛 纳米比亚 罗马尼亚 老挝 莫桑比克 菲律宾 萨摩亚 蒙古 赞比亚 越南 阿塞拜疆 阿尔及利亚 阿尔巴尼亚 马拉维 马来西亚 马耳他 马达加斯加
matlist gjsum
mat gjsum1=gjsum[14,1...]
mat gjsum2=gjsum[1..13,1...]
matrix gjd=dcoeff'*gjsum2
mat gjd=gjd'
mat cny=gjsum1'
mat gjd_cny=[gjd,cny]
matrix colnames gjd_cny= d_k cny
putexcel set xfgj,replace sheet(gjd_cny,replace)  //保存到xfgj.xlsx中（这一步是为了保存变量的标签，也就是国家名称
putexcel A1=matrix(gjd_cny)
clear
import excel D:\2024-00108-复现代码及数据\主要回归部分\xfgj.xlsx,sheet(gjd_cny)
gen guojia=_n
save gjd.dta,replace
clear
use guojia.dta
merge 1:1 guojia using gjd.dta
drop _merge
save gjd.dta,replace

************************************************************
**绘制附图A1-a：按照地区分类下不同经济体的phi·d计算结果
clear
use run_12m.dta
keep if (year==2021)&(month==12)
keep 国家 group ea ea esa sa maeu wana wu dyz ldmz sfz bar fta bea
rename 国家 name
merge 1:1 name using gjd.dta
drop _merge
gen label=name
encode name,gen(gj)
save gjdt.dta,replace
clear
use gjdt.dta
sort group
by group:sum phi·d
*****下面这些国家把label变为空的原因是：点在图中会重合到一起，为了整洁不显示这些点的名称(这些点仍然显示，名称不显示)
replace label="" if (name=="老挝")|(name=="柬埔寨")|(name=="哈萨克斯坦")|(name=="塔吉克斯坦")|(name=="波兰")|(name=="阿尔巴尼亚")|(name=="阿尔及利亚")|(name=="瑙鲁")|(name=="埃塞俄比亚")|(name=="马拉维")|(name=="佛得角")|(name=="毛里求斯")|(name=="马达加斯加")|(name=="塞拉利昂")|(name=="尼日利亚")|(name=="塞舌尔")|(name=="斯威士兰")|(name=="秘鲁")|(name=="几内亚")|(name=="纳米比亚")|(name=="冈比亚")
twoway (scatter phi·d group,  xlabel(1 `"{fontface "宋体":东南亚}"' 2 `"{fontface "宋体":东亚}"' 3 `"{fontface "宋体":南亚}"' 4 `"{fontface "宋体":中亚东欧}"' 5 `"{fontface "宋体":西亚北非}"'  6 `"{fontface "宋体":西欧}"' 7 `"{fontface "宋体":大洋洲}"'  8 `"{fontface "宋体":拉丁美洲}"' 9 `"{fontface "宋体":撒哈拉以南非洲}"',labsize(*0.7))  msize(0.5) mcolor(black) mlabel(label)  mlabposition(9) mlabsize(2) legend(label(1 `"{fontface "宋体":各经济体}{it:{fontface "Times New Roman":{&phi}d}}{fontface "宋体":的计算值}"') size(small)) color(black)) (function y=d[1,1],range(0 10) lpattern(dash)legend(label(2 `"{fontface "宋体":样本内平均水平}"') size(small)) color(black)),xtitle(`"{fontface "宋体":地区分类}"',size(small)) ytitle(`"{it:{fontface "Times New Roman":{&phi}d}}"') xsize(2) ysize(1.5) graphregion(fcolor(white)) ylabel(,nogrid)  ylabel(,format(%002.1f) labsize(*0.8)) legend(region(lcolor(none)) lpattern(blank)) legend(size(small) col(2) region(fcolor(none) lpattern(blank))) xlabel(,angle(20)) ylabel(,angle(0)) scheme(s2mono)
graph export "D:\2024-00108-复现代码及数据\主要回归部分\附图A1-a.png", as(png) name("Graph") replace

************************************************************
**绘制附图A1-b:各国当期和下一期人民币货币锚份额
clear
use gjdt.dta
gen y=0.5*(tanh(2*rho[1,1]*cny-rho[1,1]+phi·d)+1)
gen equi=0
replace equi=1 if (cny>0.36)|(y>0.08)
save equi.dta,replace
replace label="" if (cny<0.36)&(y<0.08) //为了不让点叠在一起，只显示部分点名称
**pos表示标签位置：钟表格式
gen pos=3
replace pos=1 if label=="纳米比亚"
replace pos=9 if label=="海地"
replace pos=1 if label=="泰国"
replace pos=3 if label=="不丹"
replace pos=9 if label=="尼泊尔"
replace pos=9 if label=="基里巴斯"
replace pos=10 if label=="印度尼西亚"
twoway (scatter y cny, msize(0.5) mcolor(black) mlabel(label) mlabvposition(pos) mlabsize(2) legend(label(1 `"{fontface "宋体":样本内各经济体}"') )) (function y=x, legend(label(2 `"{it:{fontface "Times New Roman":y{subscript:t}=y{subscript:t+1}}}"') ) color(black) lpattern(dash)),xtitle(`"{fontface "宋体":各经济体当前人民币隐性锚指数}"', size(small) height(5)) ytitle(`"{fontface "宋体":预测各经济体下一阶段人民币隐性锚指数}"',height(5) size(small)) xsize(1.6) ysize(1.5)  xlabel(0 "0%" 0.2 "20%" 0.4 "40%" 0.6 "60%" 0.8 "80%" 1.0 "100%", angle(0)  labsize(*0.8)) ylabel(0 "0%" 0.2 "20%" 0.4 "40%" 0.6 "60%" 0.8 "80%" 1.0 "100%", angle(0)  labsize(*0.8)) graphregion(fcolor(white)) legend(region(lcolor(none) fcolor(none) lpattern(blank)) lpattern(blank)) legend( size(small) col(2))  ylabel(,angle(0)) ylabel(,nogrid) scheme(s2mono) 
graph export "D:\2024-00108-复现代码及数据\主要回归部分\附图A1-b.png", as(png) name("Graph") replace

*************************************************************************************
****linjie_yk和com_lj_drho是matlab计算的临界值（matlab实现
matrix linjie_yk=[0.40352\0.3173\0.43705\0.31013\0.40382\0.42846\0.40251\0.29462\0.43067\0.428\0.38686\0.35122\0.42386]
matrix com_lj_drho=[-3.198855\-4.251139 \-2.239132 \-3.080147 \-5.919790\-2.231891 \-2.223048 \-3.432925 \-3.923477 \-3.688593 \-2.899919 \-3.553417 \-2.668155 ]
matrix com_lj_d=com_lj_drho+v_rho'
************************************************************************
*****正文表4和附录II表A5
clear
use run_12m.dta,replace
matrix compute=J(13,9,.)
matrix colnames  compute = yk d  linjie_yk trade linjie_trade tubian-trade  ofdic linjie_ofdic tubian-ofdic
matrix rownames  compute =总样本 esa maeu ea sa wana wu dyz ldmz sfz bar fta bea 
gen jj=1
foreach var of varlist cny trade ofdic{
	sum `var'
	matrix compute[1,jj] = r(mean)
	sum `var' if esa==1
	matrix compute[2,jj] = r(mean)
	sum `var' if maeu==1
	matrix compute[3,jj] = r(mean)
	sum `var' if ea==1
	matrix compute[4,jj] = r(mean)
	sum `var' if sa==1
	matrix compute[5,jj] = r(mean)
	sum `var' if wana==1
	matrix compute[6,jj] = r(mean)
	sum `var' if wu==1
	matrix compute[7,jj] = r(mean)
	sum `var' if dyz==1
	matrix compute[8,jj] = r(mean)
	sum `var' if ldmz==1
	matrix compute[9,jj] = r(mean)
	sum `var' if sfz==1
	matrix compute[10,jj] = r(mean)
	sum `var' if bar==1
	matrix compute[11,jj] = r(mean)
	sum `var' if fta==1
	matrix compute[12,jj] = r(mean)
	sum `var' if bea==1
	matrix compute[13,jj] = r(mean)
	replace jj=jj+3
}
**compute矩阵是现状
matrix list  compute

****//表4：phi·d和yk临界值
matrix table4=J(13,4,.)
matrix colnames  table4 =phi·d linjie_yk  yk chaju
matrix rownames  table4 =总样本 esa maeu ea sa wana wu dyz ldmz sfz bar fta bea 
forvalues jj=1/13{
matrix table4[`jj',1]=d[1,`jj']
matrix table4[`jj',2]= linjie_yk[`jj',1]
matrix table4[`jj',3]= compute[`jj',1]
matrix table4[`jj',4]=table4[`jj',2]-table4[`jj',3]
}
mat list table4
putexcel set table4,replace sheet(table4,replace)
putexcel A1=matrix(table4),names
******下面计算附录II表A5:临界条件和突变条件
**dcoef_temp_trade用于计算临界trade和突变trade，是将trade系数设为0的系数列矩阵
mat dcoef_temp_trade=dcoeff
mat dcoef_temp_trade[2,1]=0
mat temp_trade=dcoef_temp_trade'*sum12m
**dcoef_temp_ofdic用于计算临界ofdic和突变ofdic，是将ofdic系数设为0的系数列矩阵
mat dcoef_temp_ofdic=dcoeff
mat dcoef_temp_ofdic[3,1]=0
mat temp_ofdic=dcoef_temp_ofdic'*sum12m
**rho=8.0156885，可计算出d-rho的突变值是-2.701694436,所以d突变值是5.313994064（matlab计算得到）
forvalues jj=1/13{
	matrix compute[`jj',2]=d[1,`jj']
	matrix compute[`jj',3]=linjie_yk[`jj',1]
	matrix compute[`jj',5]=(com_lj_d[`jj',1]-temp_trade[1,`jj'])/dcoeff[2,1]
    matrix compute[`jj',6]=(5.313994064-temp_trade[1,`jj'])/dcoeff[2,1]
	matrix compute[`jj',8]=(com_lj_d[`jj',1]-temp_ofdic[1,`jj'])/dcoeff[3,1]
    matrix compute[`jj',9]=(5.313994064-temp_ofdic[1,`jj'])/dcoeff[3,1]
}
matrix list  compute
***compute的后6列是表A5
putexcel set appendix_II&III,modify sheet(II_A5,replace)
putexcel A1=matrix(compute),names
*************正文结束

**************************************************************************
*****地区层面异质性：附录IV-表IV1
clear
use workdata.dta
****分地区，分别加哑变量
xtivreg y esa trade ofdic lp2 corr_gdpg fin cnyr1 lgdpspread dgdpg dinf gpr VIX t1  (lcny = l2cny l3cny), re   //东南亚esa
outreg2 using appendix_IV1.doc,tstat  dec(3) replace 
foreach area of varlist ea maeu sa wana wu dyz ldmz sfz {
xtivreg y `area' trade ofdic lp2 corr_gdpg fin cnyr1 lgdpspread dgdpg dinf gpr VIX  t1   (lcny = l2cny l3cny), re
outreg2 using appendix_IV1.doc,tstat sortvar(lcny esa ea maeu sa wana wu dyz ldmz sfz trade ofdic lp2 corr_gdpg fin cnyr1 lgdpspread dgdpg dinf gpr VIX t1) dec(3) append  
}
** 东南亚esa;东亚ea;中亚东欧:maeu;南亚:sa;西亚北非 wana;西欧:wu;大洋洲:dyz;拉丁美洲:ldmz;撒哈拉以南非洲:sfz
 
**************稳健性检验***************************************************
*****稳健性检验的第一个表：附录V：表V1
**********方法1：改变货币锚指标
clear 
use robust1.dta
xtivreg y trade ofdic lp2 corr_gdpg fin cnyr1 lgdpspread dgdpg dinf gpr VIX i.cnty i.year (lcny = l2cny l3cny), re
outreg2 using appendix_V1.doc,tstat dec(3) replace
**********方法2：区分进出口贸易，将双边贸易替换为出口、进口以及出口和进口进行回归；
clear 
use robust2.dta
xtivreg y trade_ex ofdic lp2 corr_gdpg fin cnyr1 lgdpspread dgdpg dinf gpr VIX i.cnty t (lcny = l2cny l3cny), re
outreg2 using appendix_V1.doc,tstat dec(3) append
xtivreg y trade_im ofdic lp2 corr_gdpg fin cnyr1 lgdpspread dgdpg dinf gpr VIX i.cnty t (lcny = l2cny l3cny), re
outreg2 using appendix_V1.doc,tstat dec(3) append
xtivreg y trade_ex trade_im ofdic lp2 corr_gdpg fin cnyr1 lgdpspread dgdpg dinf gpr VIX i.cnty t (lcny = l2cny l3cny), re
outreg2 using appendix_V1.doc,tstat dec(3) append
***********方法3:更换贸易指标为与中国双边贸易占该国GDP比重
xtivreg y trader1 ofdic lp2 corr_gdpg fin cnyr1 lgdpspread dgdpg dinf gpr VIX i.cnty t (lcny = l2cny l3cny), re
outreg2 using appendix_V1.doc,tstat dec(3) append
***********方法4:替换金融发展指标
clear
use workdata.dta
xtivreg y trade ofdic lp2 corr_gdpg finchina cnyr1 lgdpspread dgdpg dinf gpr VIX i.cnty t (lcny = l2cny l3cny), re 
outreg2 using appendix_V1.doc,tstat dec(3) append

**************************************************************************
*****稳健性检验的第二个表：附录IV：表4-2
*****方法5-1：换y-换成5年窗口期
clear
use robust5_1.dta
xtset cnty t
xtivreg y trade ofdic lp2 corr_gdpg fin cnyr1 lgdpspread dgdpg dinf gpr VIX i.cnty t (lcny = l2cny l3cny), re
outreg2 using appendix_V2.doc,tstat dec(3) replace

*****方法5-2：换y-换成3年窗口期
clear
use robust5_2.dta
xtset cnty t
xtivreg y trade ofdic lp2 corr_gdpg fin cnyr1 lgdpspread dgdpg dinf gpr VIX i.cnty t (lcny = l2cny l3cny), re
outreg2 using appendix_V2.doc,tstat  dec(3) append

*****方法6:加入年度固定效应
clear
use workdata.dta
xtivreg y trade ofdic lp2 corr_gdpg finchina cnyr1 lgdpspread dgdpg dinf gpr VIX i.cnty i.year (lcny = l2cny l3cny), re 
outreg2 using appendix_V2.doc,tstat dec(3) append

*****方法7:时间从2010年6月
clear
use robust7.dta
xtivreg y trade ofdic lp2 corr_gdpg fin cnyr1 dgdpg dinf gpr VIX i.cnty t (lcny = l2cny l3cny), re
outreg2 using appendix_V2.doc,tstat  dec(3) append

*****方法8：换成年度数据
clear
use robust8.dta
xtset cnty year
xtabond2 y lcny trade ofdic cnyr fin lgdpspread dgdpg dinf corr_gdpg lp2 gpr VIX year1,gmmstyle(lcny ,lag(1 1)) iv( dinf trade dgdpg corr_gdpg) twostep robust
outreg2 using appendix_V2.doc,tstat  dec(3) append