

/*******************************************************************************
*
*	2024-00250_表格导出程序代码
*
*******************************************************************************/	

	

	clear all                 //Remove everything from the memory, refresh.
    cap log close             //Close any open log file.
	log using "C:\Users\49030\Desktop\2024-00250_数据\2024-00250_补充文件（运行日志+图表截图）\2024-00250_表格程序代码log.smcl" ,replace
    set more off              //Show the result all at once.
    set rmsg on

	gl root="C:\Users\49030\Desktop\2024-00250_数据"         //设定工作路径
	cd $root
	
	
	gl dofiles="$root\2024-00250_程序代码"
	gl working_data="$root\2024-00250_使用数据"
	gl tables="$root\2024-00250_日志文件"
    gl xlist1="人口规模 城镇化水平 交通便利性 第二产业规模 第三产业规模 财政状况 福利保障"
	
	
	
	*----------------- data1 指标含义 -----------------*
	
/*  工业企业密集度：新增工业企业注册数（个/平方公里）；
    劳动力密集度：第二产业从业人员数（人/平方公里）；
	规上工业企业数：规模以上工业企业数（个/平方公里）；
	第三产业劳动力密集度：第三产业从业人员数（人/平方公里）；
	制造业密集度：新增制造业企业注册数（个/平方公里）；
	采矿业密集度：新增采矿业企业注册数（个/平方公里）；
	水电煤业密集度：新增水电煤业企业注册数（个/平方公里）；
	高污染企业密集度：新增高污染企业注册数（个/平方公里）；
	低污染企业密集度：新增低污染企业注册数（个/平方公里）；
	监测网设立：地市层面设立监测网=1，否则=0；
	dummy_0_5：各区县到最近监测站的距离小于等于5km=1，否则=0；
	dummy_0_10：各区县到最近监测站的距离小于等于10km=1，否则=0；
	邻近地市的区县：监测网设立地市的邻近地市的区县=1，否则=0
	监管强度：各区县的监测站数量（个）；
	监管强度区位落差：城区和县域监测站的数量差值（个）；
	监测网设立_去对照点：去掉属于对照点的监测站后，地市层面设立监测网=1，否则=0；
	监管强度_去对照点：去掉属于对照点的监测站后，各区县的监测站数量（个）；
	监管强度区位落差_去对照点：去掉属于对照点的监测站后，城区和县域监测站的数量差值（个）；
	人口规模：户籍人口数（万人）；
	城镇化水平：城镇用地占区县总面积的比；
	交通便利性：工交建设用地占区县总面积的比；
	第二产业规模：第二产业产值占区县总产值的比；
	第三产业规模：第三产业产值占区县总产值的比；
	财政状况：（财政支出-财政收入）/财政收入；
	福利保障：各种社会福利收养性单位（个）；
	省直管县：属于省直管县=1，否则=0；
	环境规制强度：环保处罚案件数（件）；
	出让面积：当年工业用地出让面积占县域面积的比；
	出让价格：工业用地的出让均价（万元/公顷）；
	出让方式：总出让宗数中招拍挂出让宗数的占比；
	区域经济：人均GDP（元）；
	空气质量：PM2.5浓度（微克/立方米）。                        */
	
	
	*----------------- data2 指标含义 -----------------*

/*  城区：城区=1；县域=0。
*/
	
	
	
	*----------------- data4 指标含义 -----------------*
	
/*  Q101N1：流动原因是什么？"务工/工作"=1；
    Q206：现在工作的行业？“制造业”=3；
	Q205：现在的主要职业？；
	Q207：现在的就业单位性质？；
	choice：为劳动力选择流入区县的哑变量，其所在就业区县=1，其他区县=0。备选集为劳动力流入城市的所有区县；
	监管强度：各区县的监测站数量（个）；
	预期收入：各区县的人均可支配收入（元）；
	人口规模：户籍人口数（万人）；
	城镇化水平：城镇用地占区县总面积的比；
	交通便利性：工交建设用地占区县总面积的比；
	第二产业规模：第二产业产值占区县总产值的比；
	第三产业规模：第三产业产值占区县总产值的比；
	财政状况：（财政支出-财政收入）/财政收入；
	福利保障：各种社会福利收养性单位（个）。     */
	
	
	
	*----------------- 正文的表 -----------------*

	
***********************# 表1 监测站数量变化趋势 #***********************	
   use $working_data\data2.dta ,clear
   
    drop if 年份>=2020
	
	asdoc tab 年份 , save($tables\table1.doc) title(全样本) dec(4) replace 
    asdoc tab 年份 if 城区==1 , save($tables\table1.doc) title(城区) dec(4)
	asdoc tab 年份 if 城区==0 , save($tables\table1.doc) title(县域) dec(4)
	
	
***********************# 表2 监测网设立与要素集聚 #***********************
    use $working_data\data1.dta ,clear

    drop if 年份<=2002
    drop if 年份==2020
	
***城区样本
    preserve
    keep if 类型=="市辖区"
    xtreg 工业企业密集度 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码) 
    est store m1
    xtreg 劳动力密集度 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码)
    est store m2
	
	outreg2 [m1 m2 ] using $tables\table2.xls,            ///
			stat(coef se) bdec(4) sdec(4) rdec(4)  title("Model") replace       ///
            keep(监测网设立 监管强度 $xlist1)   ///
			addtext(County FE, YES, Year FE, YES)

    restore

***县域样本
	preserve
    keep if 类型!="市辖区"
    xtreg 工业企业密集度 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码) 
    est store m3
    xtreg 劳动力密集度 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码)
    est store m4
	
	outreg2 [m3 m4 ] using $tables\table2.xls,            ///
			stat(coef se) bdec(4) sdec(4) rdec(4)  title("Model")       ///
            keep(监测网设立 监管强度 $xlist1)   ///
			addtext(County FE, YES, Year FE, YES)

    restore


***********************# 表3 监测网设立、监管强度区位落差与要素集聚 #***********************
    use $working_data\data1.dta,clear

    drop if 年份<=2002
    drop if 年份==2020
	
***城区样本
    preserve
    keep if 类型=="市辖区"
    xtreg 工业企业密集度 c.监测网设立#c.监管强度区位落差 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码) 
    est store m1
    xtreg 劳动力密集度 c.监测网设立#c.监管强度区位落差 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码)
    est store m2
	
	outreg2 [m1 m2 ] using $tables\table3.xls,            ///
			stat(coef se) bdec(4) sdec(4) rdec(4)  title("Model") replace       ///
            keep(c.监测网设立#c.监管强度区位落差 监测网设立)   ///
			addtext(County FE, YES, Year FE, YES)

    restore

***县域样本
	preserve
    keep if 类型!="市辖区"
    xtreg 工业企业密集度 c.监测网设立#c.监管强度区位落差 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码) 
    est store m3
    xtreg 劳动力密集度 c.监测网设立#c.监管强度区位落差 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码)
    est store m4
	
	outreg2 [m3 m4 ] using $tables\table3.xls,            ///
			stat(coef se) bdec(4) sdec(4) rdec(4)  title("Model")       ///
            keep(c.监测网设立#c.监管强度区位落差 监测网设立)    ///
			addtext(County FE, YES, Year FE, YES)

    restore

	
*****************# 表4 监测网设立对其监测范围内区县的直接效应检验 #*************
    use $working_data\data1.dta,clear

    drop if 年份<=2002
    drop if 年份==2020
	
	xtreg 工业企业密集度 dummy_0_5 $xlist1 i.年份 ,fe vce(cluster 市代码) 
	est store m1
	xtreg 工业企业密集度 dummy_0_10 $xlist1 i.年份 ,fe vce(cluster 市代码) 
	est store m2
	xtreg 劳动力密集度 dummy_0_5  $xlist1 i.年份 ,fe vce(cluster 市代码) 
	est store m3
	xtreg 劳动力密集度 dummy_0_10  $xlist1 i.年份 ,fe vce(cluster 市代码) 
	est store m4
	
	outreg2 [m1 m2 m3 m4 ] using $tables\table4.xls,            ///
			stat(coef se) bdec(4) sdec(4) rdec(4)  title("Model") replace       ///
            keep(dummy_0_5 dummy_0_10)    ///
			addtext(County FE, YES, Year FE, YES)
			
	
	
***********************# 表5 监测网设立的跨地市空间影响检验 #***********************	
    use $working_data\data1.dta,clear

    drop if 年份<=2002
    drop if 年份==2020
	
***城区样本
    preserve
    keep if 类型=="市辖区"
    drop if 年份>=2015      //仅保留2003-2014年的数据
    bys _ID :egen num=sum(监测网设立)
    keep if num==0        //去掉已经设立监测网的样本
    xtreg 工业企业密集度 邻近地市的区县 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码) 
    est store m1
    xtreg 劳动力密集度 邻近地市的区县 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码)
    est store m2
	
	outreg2 [m1 m2 ] using $tables\table5.xls,            ///
			stat(coef se) bdec(4) sdec(4) rdec(4)  title("Model") replace       ///
            keep(邻近地市的区县)   ///
			addtext(County FE, YES, Year FE, YES)

    restore

***县域样本
	preserve
    keep if 类型!="市辖区"
    drop if 年份>=2015      //仅保留2003-2014年的数据
    bys _ID :egen num6=sum(监测网设立)
    keep if num6==0    //去掉已经设立监测网的样本
    xtreg 工业企业密集度 邻近地市的区县 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码) 
    est store m3
    xtreg 劳动力密集度 邻近地市的区县 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码)
    est store m4
	
	outreg2 [m3 m4 ] using $tables\table5.xls,            ///
			stat(coef se) bdec(4) sdec(4) rdec(4)  title("Model")       ///
            keep(邻近地市的区县)   ///
			addtext(County FE, YES, Year FE, YES)

    restore	


***********************# 表6 机制检验：监测网设立与环保执法强度 #***********************
    use $working_data\data1.dta,clear

    drop if 年份<=2002
    drop if 年份==2020
	
***城区样本
    preserve
    keep if 类型=="市辖区"
    keep if 年份>=2006       //2006年之前没有样本，因此仅保留2006-2019年的数据
    xtreg 环境规制强度 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码)
    est store m1
	
	outreg2 [m1 ] using $tables\table6.xls,            ///
			stat(coef se) bdec(4) sdec(4) rdec(4)  title("Model") replace       ///
            keep(监测网设立)   ///
			addtext(County FE, YES, Year FE, YES)

    restore

***县域样本
	preserve
    keep if 类型!="市辖区"
    keep if 年份>=2006       //2006年之前没有样本，因此仅保留2006-2019年的数据
    xtreg 环境规制强度 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码)
    est store m2
	
	outreg2 [m2 ] using $tables\table6.xls,            ///
			stat(coef se) bdec(4) sdec(4) rdec(4)  title("Model")       ///
            keep(监测网设立)   ///
			addtext(County FE, YES, Year FE, YES)

    restore	


	*----------------- 附录的表 -----------------*

	
***********************# 表III1 变量定义与描述性统计 #***********************	
    use $working_data\data1.dta,clear

    drop if 年份<=2002
    drop if 年份==2020

    asdoc sum 工业企业密集度 劳动力密集度 监测网设立 监管强度 监管强度区位落差 人口规模 城镇化水平 交通便利性 第二产业规模 第三产业规模 财政状况 福利保障 , save($tables\tableIII1.doc) dec(4) replace
	

	
***********************# 表IV1劳动力流动的微观证据——基于条件Logit模型 #***********************	
	use $working_data\data4.dta,clear

    keep if Q101N1==1   //保留因“务工/工作”而流动的样本
    keep if Q206==3     //保留在“制造业”企业工作的样本

***全样本
	clogit choice 监管强度 预期收入 $xlist1 i.年份,group(id) nolog r 
	est store m1
	
	outreg2 [m1 ] using $tables\tableIV1.xls,            ///
			stat(coef se) bdec(4) sdec(4) rdec(4)  title("Model") replace       ///
            keep(监管强度 预期收入)   ///
			addtext(Year FE, YES)

***技术型工人
	preserve
	keep if Q205==20|Q205==10|Q205==30 //专业技术人员=10；国家机关、党群组织、企事业单位负责人=20；公务员、办事人员和有关人员=30
	clogit choice 监管强度 预期收入 $xlist1 i.年份,group(id) nolog r 
	est store m2
	
	outreg2 [m2 ] using $tables\tableIV1.xls,            ///
			stat(coef se) bdec(4) sdec(4) rdec(4)  title("Model")       ///
            keep(监管强度 预期收入)   ///
			addtext(Year FE, YES)
			
	restore
	
***非技术型工人
	preserve
    drop if Q205==20|Q205==10|Q205==30
	clogit choice 监管强度 预期收入 $xlist1 i.年份,group(id) nolog r 
	est store m3
	
	outreg2 [m3 ] using $tables\tableIV1.xls,            ///
			stat(coef se) bdec(4) sdec(4) rdec(4)  title("Model")       ///
            keep(监管强度 预期收入)   ///
			addtext(Year FE, YES)
			
	restore	
	
	
***********************# 表IV2劳动力流动的微观证据——不同企业类型的异质性 #***********************		
	use $working_data\data4.dta,clear

    keep if Q101N1==1   //保留因“务工/工作”而流动的样本
    keep if Q206==3     //保留在“制造业”企业工作的样本

***国有企业
	preserve
	keep if Q207==1|Q207==2|Q207==3   //机关、事业单位=1；国有及国有控股企业=2；集体企业=3
	clogit choice 监管强度 预期收入 $xlist1 i.年份,group(id) nolog r 
	est store m1
	
	outreg2 [m1 ] using $tables\tableIV2.xls,            ///
			stat(coef se) bdec(4) sdec(4) rdec(4)  title("Model") replace     ///
            keep(监管强度 预期收入)   ///
			addtext(Year FE, YES)
			
	restore	
	
	
***私营企业
	preserve
	keep if Q207==6   //私营企业=6
	clogit choice 监管强度 预期收入 $xlist1 i.年份,group(id) nolog r 
	est store m2
	
	outreg2 [m2 ] using $tables\tableIV2.xls,            ///
			stat(coef se) bdec(4) sdec(4) rdec(4)  title("Model")     ///
            keep(监管强度 预期收入)   ///
			addtext(Year FE, YES)
			
	restore	
		
	
***外资企业
	preserve
	keep if Q207==7|Q207==8|Q207==9   //港澳台独资企业=7；外商独资企业=8；中外合资企业=9
	clogit choice 监管强度 预期收入 $xlist1 i.年份,group(id) nolog r 
	est store m3
	
	outreg2 [m3 ] using $tables\tableIV2.xls,            ///
			stat(coef se) bdec(4) sdec(4) rdec(4)  title("Model")     ///
            keep(监管强度 预期收入)   ///
			addtext(Year FE, YES)
			
	restore	
		



***********************# 表VII1 稳健性检验 #***********************	
    use $working_data\data1.dta,clear

    drop if 年份<=2002
    drop if 年份==2020

*****剔除“对照点”干扰
***城区样本
    preserve
    keep if 类型=="市辖区"
    xtreg 工业企业密集度 监测网设立_去对照点 监管强度_去对照点 $xlist1 i.年份 ,fe vce(cluster 市代码) 
    est store m1
    xtreg 劳动力密集度 监测网设立_去对照点 监管强度_去对照点 $xlist1 i.年份 ,fe vce(cluster 市代码)
    est store m2
	
	outreg2 [m1 m2 ] using $tables\tableVII1a.xls,            ///
			stat(coef se) bdec(4) sdec(4) rdec(4)  title("Model") replace       ///
            keep(监测网设立_去对照点)   ///
			addtext(County FE, YES, Year FE, YES)

    restore

***县域样本
	preserve
    keep if 类型!="市辖区"
    xtreg 工业企业密集度 监测网设立_去对照点 监管强度_去对照点 $xlist1 i.年份 ,fe vce(cluster 市代码) 
    est store m3
    xtreg 劳动力密集度 监测网设立_去对照点 监管强度_去对照点 $xlist1 i.年份 ,fe vce(cluster 市代码)
    est store m4
	
	outreg2 [m3 m4 ] using $tables\tableVII1a.xls,            ///
			stat(coef se) bdec(4) sdec(4) rdec(4)  title("Model")       ///
            keep(监测网设立_去对照点)   ///
			addtext(County FE, YES, Year FE, YES)

    restore


*****更换被解释变量   
***城区样本
    preserve
    keep if 类型=="市辖区"
    xtreg 规上工业企业数 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码) 
    est store m1
    xtreg 第三产业劳动力密集度 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码)
    est store m2
	
	outreg2 [m1 m2 ] using $tables\tableVII1b.xls,            ///
			stat(coef se) bdec(4) sdec(4) rdec(4)  title("Model") replace       ///
            keep(监测网设立)   ///
			addtext(County FE, YES, Year FE, YES)

    restore

***县域样本
	preserve
    keep if 类型!="市辖区"
    xtreg 规上工业企业数 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码) 
    est store m3
    xtreg 第三产业劳动力密集度 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码)
    est store m4
	
	outreg2 [m3 m4 ] using $tables\tableVII1b.xls,            ///
			stat(coef se) bdec(4) sdec(4) rdec(4)  title("Model")       ///
            keep(监测网设立)   ///
			addtext(County FE, YES, Year FE, YES)

    restore
	

*****改变窗口期：缩减实验结束前期数
***城区样本
    preserve
    keep if 类型=="市辖区"
	drop if 年份>2017
    xtreg 工业企业密集度 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码) 
    est store m1
    xtreg 劳动力密集度 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码)
    est store m2
	
	outreg2 [m1 m2 ] using $tables\tableVII1c.xls,            ///
			stat(coef se) bdec(4) sdec(4) rdec(4)  title("Model") replace       ///
            keep(监测网设立)   ///
			addtext(County FE, YES, Year FE, YES)

    restore

***县域样本
	preserve
    keep if 类型!="市辖区"
	drop if 年份>2017
    xtreg 工业企业密集度 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码) 
    est store m3
    xtreg 劳动力密集度 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码)
    est store m4
	
	outreg2 [m3 m4 ] using $tables\tableVII1c.xls,            ///
			stat(coef se) bdec(4) sdec(4) rdec(4)  title("Model")       ///
            keep(监测网设立)   ///
			addtext(County FE, YES, Year FE, YES)

    restore


*****改变窗口期：缩减实验开始前期数
***城区样本
    preserve
    keep if 类型=="市辖区"
	drop if 年份<2005
    xtreg 工业企业密集度 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码) 
    est store m1
    xtreg 劳动力密集度 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码)
    est store m2
	
	outreg2 [m1 m2 ] using $tables\tableVII1d.xls,            ///
			stat(coef se) bdec(4) sdec(4) rdec(4)  title("Model") replace       ///
            keep(监测网设立)   ///
			addtext(County FE, YES, Year FE, YES)

    restore

***县域样本
	preserve
    keep if 类型!="市辖区"
	drop if 年份<2005
    xtreg 工业企业密集度 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码) 
    est store m3
    xtreg 劳动力密集度 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码)
    est store m4
	
	outreg2 [m3 m4 ] using $tables\tableVII1d.xls,            ///
			stat(coef se) bdec(4) sdec(4) rdec(4)  title("Model")       ///
            keep(监测网设立)   ///
			addtext(County FE, YES, Year FE, YES)

    restore



***********************# 表VIII1 排除其他政策效应：省直管县 #***********************	
    use $working_data\data1.dta,clear

    drop if 年份<=2002
    drop if 年份==2020

***县域样本
	preserve
    keep if 类型!="市辖区"
	xtreg 工业企业密集度 监测网设立 监管强度 $xlist1 省直管县 i.年份 ,fe vce(cluster 市代码) 
	est store m1
	xtreg 工业企业密集度 c.监测网设立#c.监管强度区位落差 监测网设立 监管强度 $xlist1 省直管县 i.年份 ,fe vce(cluster 市代码) 
	est store m2
	xtreg 劳动力密集度 监测网设立 监管强度 $xlist1 省直管县 i.年份 ,fe vce(cluster 市代码)
	est store m3
	xtreg 劳动力密集度 c.监测网设立#c.监管强度区位落差 监测网设立 监管强度 $xlist1 省直管县 i.年份 ,fe vce(cluster 市代码)
	est store m4
	
	outreg2 [m1 m2 m3 m4 ] using $tables\tableVIII1.xls,            ///
			stat(coef se) bdec(4) sdec(4) rdec(4)  title("Model")  replace      ///
            keep(c.监测网设立#c.监管强度区位落差 监测网设立 省直管县)   ///
			addtext(County FE, YES, Year FE, YES)

    restore


***********************# 表IX1 机制检验：县域集聚效应的行业异质性 #***********************	
    use $working_data\data1.dta,clear

    drop if 年份<=2002
    drop if 年份==2020
	
***县域样本
	preserve
    keep if 类型!="市辖区"
    xtreg 制造业密集度 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码)
    est store m1
    xtreg 采矿业密集度 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码)
    est store m2
    xtreg 水电煤业密集度 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码)
    est store m3
    xtreg 高污染企业密集度 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码)
    est store m4
    xtreg 低污染企业密集度 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码)
    est store m5
	
	outreg2 [m1 m2 m3 m4 m5 ] using $tables\tableIX1.xls,           ///
			stat(coef se) bdec(4) sdec(4) rdec(4)  title("Model") replace       ///
            keep(监测网设立)   ///
			addtext(County FE, YES, Year FE, YES)

    restore

	

***********************# 表X1 进一步讨论：监测网设立对县域工业用地出让的影响 #***********************	
    use $working_data\data1.dta,clear

    drop if 年份<=2002
    drop if 年份==2020
	
***县域样本
	preserve
    keep if 类型!="市辖区"
    xtreg 出让面积 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码)
    est store m1
    xtreg 出让面积 c.监测网设立#c.监管强度区位落差 监测网设立  监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码)
    est store m2
    xtreg 出让价格 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码)
    est store m3
    xtreg 出让价格 c.监测网设立#c.监管强度区位落差 监测网设立  监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码)
    est store m4
    xtreg 出让方式 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码)
    est store m5
    xtreg 出让方式 c.监测网设立#c.监管强度区位落差 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码)
    est store m6
	
	outreg2 [m1 m2 m3 m4 m5 m6 ] using $tables\tableX1.xls,           ///
			stat(coef se) bdec(4) sdec(4) rdec(4)  title("Model") replace       ///
            keep(c.监测网设立#c.监管强度区位落差 监测网设立 )   ///
			addtext(County FE, YES, Year FE, YES)

    restore


***********************# 表XI1 进一步讨论：监测网设立对城区和县域的经济发展及环境质量影响 #***********************	
    use $working_data\data1.dta,clear

    drop if 年份<=2002
    drop if 年份==2020
	
***城区样本
    preserve
    keep if 类型=="市辖区"
    xtreg 区域经济 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码)
    est store m1
    xtreg 空气质量 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码)
    est store m2
	
	outreg2 [m1 m2 ] using $tables\tableXI1.xls,            ///
			stat(coef se) bdec(4) sdec(4) rdec(4)  title("Model") replace       ///
            keep(监测网设立)   ///
			addtext(County FE, YES, Year FE, YES)

    restore

***县域样本
	preserve
    keep if 类型!="市辖区"
    xtreg 区域经济 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码)
    est store m3
    xtreg 空气质量 监测网设立 监管强度 $xlist1 i.年份 ,fe vce(cluster 市代码)
    est store m4
	
	outreg2 [m3 m4 ] using $tables\tableXI1.xls,            ///
			stat(coef se) bdec(4) sdec(4) rdec(4)  title("Model")       ///
            keep(监测网设立)   ///
			addtext(County FE, YES, Year FE, YES)

    restore
	
	
	log close





















	
	
	