

	*----------------- 指标含义 -----------------*	
/*	
LnInnovation：本土企业创新，使用企业发明专利申请量的对数衡量（取对数前加1处理）。
Innovation：企业发明专利申请量。
AInnovation：对企业发明专利申请量进行反双曲正弦变换。
S：标准开放度，使用外资持股企业参与制定的处于有效期（标准发布日至废止日）的我国国家标准总频次与行业内企业数量的比值衡量。
Lnage：企业年龄，使用样本年份与企业成立年份差值的对数衡量。
Lnemploy：企业规模，使用企业职工人数的对数衡量。
TFP：劳动生产率，使用企业工业总产值与职工人数的比值衡量。
LA：资产负债率，使用企业总负债与总资产的比值衡量。
Lnpergdp：经济发展水平，使用各省人均GDP的对数衡量。
Secondgdp_weight：第二产业占比，使用各省第二产业GDP占比衡量。
Thirdgdp_weight：第三产业占比，使用各省第三产业GDP占比衡量。
Foreignweight：外资进入强度，使用各省外资企业数量与GDP比值衡量。
LSN：本土企业参与标准制定，使用本土企业参与制定且处于有效期的国家标准数量衡量。
year：样本年份，本文使用的样本年份跨度为2000——2013年。
SD：双重差分项，当企业的样本年份处于标准专项试点年份及之后年份时，SD取值为1，否则为0。
FolseSD：前置一期的双重差分项，当企业的样本年份处于虚设的标准专项试点年份及之后年份时，FolseSD取值为1，否则为0。其中，虚设的标准专项试点年份是指标准专项试点年份的前一年。
USAposition：美国国际投资头寸，使用各行业的美国国际投资头寸规模衡量。
Exp_Imp_firm：是否进出口企业，是则取值为1，否则为0。
Lnxiezuo：共同参标规模，使用本土企业与外资持股企业共同参与制定国家标准数量的对数衡量。
Coop：共同参与标准制定（虚拟变量），当样本所处年份大于本土企业与外资持股企业共同参与国家标准制定的年份时，该变量取值为1，否则为0。
BZLJ：本土企业是否参与过我国国家标准制定，是则取值为1，否则为0。
Marketshare：市场占有率，使用企业国内销售产值占所在行业国内销售总产值的比重衡量。
Imppagerank：中间品进口贸易网络中心度，基于pagerank算法和中间品贸易数据测算。
Exppagerank：最终品出口贸易网络中心度，基于pagerank算法和最终品贸易数据测算。
exp_sdprice：出口环节信息摩擦度，使用出口产品价格的方差衡量。
imp_sdprice：进口环节信息摩擦度，使用进口产品价格的方差衡量。
S_shifei：调整有效期后的标准开放度，使用外资持股企业参与制定的处于有效期（标准实施日至废止日）的我国国家标准总频次与行业内企业数量的比值衡量。
S_gb2：二分位行业的标准开放度，使用外资持股企业参与制定的处于有效期（标准发布日至废止日）的我国国家标准总频次与行业内企业数量的比值衡量。
S_chanpin：使用产品标准测算的标准开放度，使用外资持股企业参与制定的处于有效期（标准发布日至废止日）的我国产品国家标准总频次与行业内企业数量的比值衡量。
S_gbmean：考虑行业外资市场准入差异的标准开放度，使用外资持股企业参与制定的处于有效期（标准发布日至废止日）的我国国家标准总频次与行业内外资持股企业数量的比值衡量。
S_value：考虑企业规模的标准开放度，使用参与制定我国国家标准的外资持股企业的总规模与该行业所有企业总规模的比值衡量，
S_qiangzhi：强制性标准领域的标准开放度，使用外资持股企业参与制定的处于有效期（标准发布日至废止日）的我国强制性国家标准总频次与行业内企业数量的比值衡量。
S_tuijian：推荐性标准领域的标准开放度，使用外资持股企业参与制定的处于有效期（标准发布日至废止日）的我国推荐性国家标准总频次与行业内企业数量的比值衡量。
S_standard：归一化处理后的标准开放度，对外资持股企业参与制定的处于有效期（标准发布日至废止日）的我国国家标准总频次进行归一化处理，得到归一化处理后的标准开放度。
l3.S：标准开放度的滞后3期。
l2.S：标准开放度的滞后2期。
l.S：标准开放度的滞后1期。
Lnfmshouquan：本土企业发明专利授权量，使用企业发明专利授权量的对数衡量（取对数前加1处理）。
Lnbzfmzls：本土企业标准相关的发明专利申请量，使用企业与标准相关的发明专利申请量的对数衡量（取对数前加1处理）。
Lnvalue：企业的工业总产出，使用企业工业总产值的对数衡量。
Lnnew：企业的新产品产出，使用企业新产品产值的对数衡量。
Newweight：新产品占比，使用新产品产值与工业总产值的比重衡量。
Lnhomesale：国内销售额，使用企业工业销售产值与出口交货值之差的对数衡量。
Homeweight：内销份额，使用国内销售额与工业销售产值之比衡量。
cls2002：四分位行业代码。
cls2002_gb2：二分位行业代码。
area_code4：城市代码。
Wage:职工平均工资，使用各省份职工平均工资衡量。
SY：上游标准开放度，利用某行业使用的上游行业中间投入品占其使用的中间投入品总额的比重，对行业的标准开放度进行加权，得到上游行业的标准开放度。
SX：下游标准开放度，利用某行业出售给下游行业中间投入品占其出售的中间投入品总额的比重，对行业的标准开放度进行加权，得到下游行业的标准开放度。
zwfirm：在位企业，参考高凌云和易先忠（2019）识别在位企业，属于在位企业取值为1，否则为0。
newfirm：初创企业，参考高凌云和易先忠（2019）识别初创企业，属于初创企业取值为1，否则为0。
tcfirm：即将退市企业，参考高凌云和易先忠（2019）识别即将退市企业，属于即将退市企业取值为1，否则为0。
SU：国内外标准统一度，使用企业贸易结构加权对标国际标准的国家标准（商品层面），得到企业面临的国内外标准统一度。
Lnre：外资参与标准制定，使用外资持股企业参与制定且处于有效期的国家标准数量的对数衡量。
Addrate：外商追加投资率，使用当期外商追加投资额与上一期外商投资额之比衡量。

*/

        *----------------- 数据文件说明 -----------------*	
 *本文件中的workdata.dta数据文件，是本文回归的基础数据，即2000—2013年本土企业样本数据。
 *本文件中的Foreignworkdata.dta数据文件，是拓展分析部分检验标准开放对外商追加投资的影响时所用数据，即2000—2013年外商投资企业样本数据。
 
 
***********************# 表1 基准回归结果 #***********************
use $working_data\workdata.dta ,clear
	
asdoc xtreg LnInnovation S ,fe cluster(cls2002) nest dec(4) replace 
asdoc xtreg LnInnovation S i.year ,fe cluster(cls2002) nest dec(4) append
asdoc xtreg LnInnovation S Lnage LA Lnemploy  TFP i.year ,fe cluster(cls2002) nest dec(4) append
asdoc xtreg LnInnovation S Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight  i.year ,fe cluster(cls2002) nest dec(4) append



***********************# 表2 准自然实验 #***********************
use $working_data\workdata.dta ,clear
	
asdoc reghdfe LnInnovation SD LSN ,absorb(year firm_code year#industry2_code) vce(cluster area_code4) nest dec(4) replace
asdoc reghdfe LnInnovation SD LSN Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight,absorb(year firm_code year#industry2_code) vce(cluster area_code4) nest dec(4) append
asdoc reghdfe LnInnovation SD Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight,absorb(year firm_code year#industry2_code) vce(cluster area_code4) nest dec(4) append
asdoc reghdfe LnInnovation SD FolseSD LSN Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight ,absorb(year firm_code year#industry2_code) vce(cluster area_code4) nest dec(4) append



***********************# 表3 工具变量估计 #***********************
use $working_data\workdata.dta ,clear
	
tab year , gen(d)
asdoc xtivreg2 LnInnovation Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight  (S =  USAposition) d1 d2 d3 d4 d5 d6 d7 d8 d9 d10 d11 d12 d13 ,fe r first  nest dec(4) replace
asdoc xtivreg2 LnInnovation Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight  (S =  USAposition) d1 d2 d3 d4 d5 d6 d7 d8 d9 d10 d11 d12 d13 if Exp_Imp_firm == 1,fe r first  nest dec(4) append



***********************# 表4 机制检验：中外企业协作与市场竞争 #***********************	
use $working_data\workdata.dta ,clear

**1.中外企业协作机制
asdoc xtreg Lnxiezuo S Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight  i.year if BZLJ > 0 ,fe cluster(cls2002)  nest dec(4) replace
gen S_Coop = S * Coop
asdoc xtreg LnInnovation S_Coop  S  Coop Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight  i.year  if BZLJ > 0 ,fe cluster(cls2002) nest dec(4) append
**2.市场竞争机制
gen S_zwfirm = S * zwfirm
gen S_newfirm = S * newfirm
asdoc xtreg Marketshare  S_newfirm S_zwfirm S  newfirm zwfirm Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight  i.year ,fe cluster(cls2002) nest dec(4) append



***********************# 表5 机制检验：信息传递 #***********************	
use $working_data\workdata.dta ,clear

*1.标准开放对出口环节信息摩擦的影响
asdoc xtreg exp_sdprice S Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight  i.year ,fe cluster(cls2002) nest dec(4) replace 
*2.标准开放对进口环节信息摩擦的影响
asdoc xtreg imp_sdprice S Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight  i.year ,fe cluster(cls2002) nest dec(4) append 
*3.标准开放对中间品进口贸易网络中心度的影响
asdoc xtreg Imppagerank S Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight  i.year ,fe cluster(cls2002) nest dec(4) append 
*4.标准开放对商品出口贸易网络中心度的影响
asdoc xtreg Exppagerank S Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight  i.year ,fe cluster(cls2002) nest dec(4)  append



***********************# 表6 影响路径 #***********************	
use $working_data\workdata.dta ,clear

asdoc xtreg LnInnovation  SY  Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight  i.year ,fe cluster(cls2002) nest dec(4) replace 
asdoc xtreg LnInnovation  SX Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight  i.year ,fe cluster(cls2002) nest dec(4) append 
asdoc xtreg LnInnovation  SY SX S Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight  i.year ,fe cluster(cls2002) nest dec(4) append 




***********************# 附录II 表II1 主要变量的描述性统计 #***********************	

use $working_data\workdata.dta ,clear
asdoc sum S LnInnovation Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight Imppagerank Exppagerank Marketshare  zwfirm newfirm tcfirm SY SX exp_sdprice imp_sdprice Lnxiezuo Coop




***********************# 附录III 表III1 稳健性检验（I） #***********************	
use $working_data\workdata.dta ,clear

**1.调整标准有效期的起始时点
asdoc xtreg LnInnovation S_shifei Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight  i.year ,fe cluster(cls2002) nest dec(4) replace
**2.考虑标准的跨行业适用性问题
*2-1.泛化行业类别
asdoc xtreg LnInnovation  S_gb2 Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight  i.year ,fe cluster(cls2002_gb2) nest dec(4) append
*2-2.将国家标准限定在产品标准范畴
asdoc xtreg LnInnovation  S_chanpin Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight  i.year ,fe cluster(cls2002) nest dec(4) append
**3.使用考虑了行业外资市场准入或企业规模的稳健指标
*3-1.使用考虑了行业外资市场准入的稳健指标
asdoc xtreg LnInnovation  S_gbmean Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight  i.year ,fe cluster(cls2002) nest dec(4) append
*3-2.使用考虑了企业规模的稳健指标
asdoc xtreg LnInnovation S_value Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight  i.year ,fe cluster(cls2002) nest dec(4) append
**4.考虑同一行业不同种类标准的可加性
asdoc xtreg LnInnovation S_qiangzhi  Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight  i.year ,fe cluster(cls2002) nest dec(4) append
asdoc xtreg LnInnovation S_tuijian  Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight  i.year ,fe cluster(cls2002) nest dec(4) append
**5.标准开放指标的归一化处理
asdoc xtreg LnInnovation S_standard Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight  i.year ,fe cluster(cls2002) nest dec(4) append




***********************# 附录III 表III2 稳健性检验（II） #***********************	
use $working_data\workdata.dta ,clear

**1.考虑专利研发周期
xtset firm_code year
asdoc xtreg LnInnovation l2.S l.S S Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight  i.year ,fe cluster(cls2002) nest dec(4) replace
**2.考虑创新指标的多样性
*2-1.使用发明专利授权量代替发明专利申请量
asdoc xtreg Lnfmshouquan S Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight  i.year ,fe cluster(cls2002) nest dec(4) append
*2-2.使用与标准相关的发明专利申请量
asdoc xtreg Lnbzfmzls S Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight  i.year ,fe cluster(cls2002) nest dec(4) append
**3.变换数据处理方式
*3-1.利用反双曲正弦变换对发明专利申请量进行处理
asdoc xtreg AInnovation S Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight  i.year ,fe cluster(cls2002) nest dec(4) append
*3-2.使用发明专利申请量的原值
asdoc xtreg Innovation S Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight  i.year ,fe cluster(cls2002) nest dec(4) append
**4.考虑企业动态
xtbalance,range(2000 2013)
asdoc xtreg LnInnovation S Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight  i.year ,fe cluster(cls2002) nest dec(4) append




***********************# 附录IV 表IV1 进一步分析 #***********************	
use $working_data\workdata.dta ,clear

**1.标准开放与企业转型。考察标准开放对工业总产值、新产品产值、新产品产值占比、内销额、内销额占比的影响
asdoc xtreg Lnvalue S Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight i.year ,fe cluster(cls2002) nest dec(4) replace
asdoc xtreg Lnnew l3.S l2.S  l.S S  Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight i.year ,fe cluster(cls2002) nest dec(4) append
asdoc xtreg Newweight l3.S l2.S  l.S S Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight i.year ,fe cluster(cls2002) nest dec(4) append
asdoc xtreg Lnhomesale S Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight  i.year ,fe cluster(cls2002) nest dec(4) append
asdoc xtreg Homeweight S Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight  i.year ,fe cluster(cls2002) nest dec(4) append

**2.标准开放与国内外标准统一。考察标准开放对我国企业面临的国内外标准统一度的影响，以及国内外标准统一对我国企业创新的影响。
asdoc xtreg SU S  i.year ,fe cluster(cls2002)  nest dec(4) replace 
asdoc xtreg SU S Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight i.year ,fe cluster(cls2002)  nest dec(4) append 
asdoc xtreg LnInnovation SU Lnage LA Lnemploy  TFP  Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight  i.year ,fe cluster(cls2002)  nest dec(4) append 

use $working_data\Foreignworkdata.dta ,clear
**3.外商参与标准制定与“稳外资”目标。考察外商参与标准制定对外商追加投资的影响。
asdoc xtreg Addrate Lnre  i.year, fe r dec(4) nest replace
asdoc xtreg Addrate Lnre Lnemploy LA TFP Wage Lnpergdp i.year, fe r dec(4) nest append


