


	*----------------- 指标含义 -----------------*	
/*	
LnInnovation：本土企业创新，使用企业发明专利申请量的对数衡量（取对数前加1处理）。
S：标准开放度，使用外资持股企业参与制定的处于有效期（标准发布日至废止日）的我国国家标准总频次与行业内企业数量的比值衡量。
pre3:当样本年份等于(试点年份-3)时，取值为1，否则为0。
pre2:当样本年份等于(试点年份-2)时，取值为1，否则为0。
pre1:当样本年份等于(试点年份-1)时，取值为1，否则为0。
current:当样本年份等于试点年份时，取值为1，否则为0。
post1:当样本年份等于(试点年份+1)时，取值为1，否则为0。
post2:当样本年份等于(试点年份+2)时，取值为1，否则为0。
post3:当样本年份等于(试点年份+3)时，取值为1，否则为0。
post4:当样本年份等于(试点年份+4)时，取值为1，否则为0。
post5:当样本年份等于(试点年份+5)时，取值为1，否则为0。
post6:当样本年份等于(试点年份+6)时，取值为1，否则为0。
post7:当样本年份等于(试点年份+7)时，取值为1，否则为0。
post8:当样本年份等于(试点年份+8)时，取值为1，否则为0。
post9:当样本年份等于(试点年份+9)时，取值为1，否则为0。
post10:当样本年份等于(试点年份+10)时，取值为1，否则为0。
post11:当样本年份等于(试点年份+11)时，取值为1，否则为0。
industry2_code：二分位行业代码。
area_code4：城市代码。
Lnage：企业年龄，使用样本年份与企业成立年份差值的对数衡量。
Lnemploy：企业规模，使用企业职工人数的对数衡量。
TFP：劳动生产率，使用企业工业总产值与职工人数的比值衡量。
LA：资产负债率，使用企业总负债与总资产的比值衡量。
Lnpergdp：经济发展水平，使用各省人均GDP的对数衡量。
Secondgdp_weight：第二产业占比，使用各省第二产业GDP占比衡量。
Thirdgdp_weight：第三产业占比，使用各省第三产业GDP占比衡量。
Foreignweight：外资进入强度，使用各省外资企业数量与GDP比值衡量。
LSN：本土企业参与标准制定，使用本土企业参与制定且处于有效期的国家标准数量衡量。
state_weight：行业内国有企业数量占比，使用行业内国有企业数量占行业内企业总数量的比重衡量。
 */

 
***********************# 数据文件说明 #***********************
*本文件中的workdata.dta数据文件，是本文回归的基础数据，即2000—2013年本土企业样本数据。
*本文件中的Figuredata.dta数据文件，是本文绘制行业国有企业数量占比与标准开放度的相关性图示时所用数据，即2000—2013年我国四分位行业层面的标准开放度与国有企业数量占比数据。本土企业样本数据。

  
***********************# 图1 事前同趋势检验 #***********************

use $working_data\workdata.dta ,clear

reghdfe LnInnovation pre3 pre2 current post1 post2 post3 post4 post5 post6 post7 post8 post9 post10 post11 LSN Lnage LA Lnemploy  TFP Lnpergdp  Secondgdp_weight Thirdgdp_weight Foreignweight  ,absorb(year firm_code year#industry2_code) vce(cluster area_code4)
coefplot , level(95 95) keep( pre3 pre2  current post1 post2 post3 post4 post5 post6 post7 post8 post9 post10 post11 ) ///
coeflabels( pre3 = "-3" pre2 = "-2" ///
current = "0"  post1 = "1"  post2 = "2" post3 = "3" post4 = "4"  post5 = "5"  post6 = "6"  post7 = "7" post8 = "8" post9 = "9"  post10 = "10"  post11 = "11"  ) /// 
ylabel(, tposition(inside) nogrid) ///
xlabel(, tposition(inside)) ///
yline(0, lc(black*0.5) lp(dash)) xline(3, lc(black*0.5) lp(dash)) ///
text( -0.5 10 "") ms(o)  ///
ytitle("" , height(6)) vertical  addplot(line @b @at) ///
ciopts(recast(rcap)) scheme(s1mono)



***********************# 附录III 图III1 行业国有企业数量占比与标准开放度的相关性 #***********************

use $working_data\Figuredata.dta ,clear

binscatter S state_weight


*注：附录I的图I1、图I2和图I3，使用Excel界面进行手动绘制，因此无绘制程序。





