

/*******************************************************************************
*
*	Statistical Management System and Statistical Data Quality
*
*******************************************************************************/	

	
	clear all                 //Remove everything from the memory, refresh.
    cap log close             //Close any open log file.
    set more off              //Show the result all at once.
    set rmsg on
	
	
	gl  root = "C:\Users\lfore\Desktop\代码整理\2024-01107_数据"   //设定工作路径
	cd $root
	

	gl dofiles="$root\2024-01107_程序代码"
	gl working_data="$root\2024-01107_使用数据"
	gl tables="$root\2024-01107_日志文件"
	
	*------------------------------- 指标含义 -------------------------------*	
/*	
	
	judge_year_appeal：法官每年审理的案件中，被提起上诉的数量
	judge_year_all：法官每年审理的全部案件数量
	appeal_year_r：法官每年审理的案件中，被提起上诉占比

	judge_year_change：法官每年审理的案件中，被改判的案件数量
	chang_year_r：法官每年审理的案件中，被改判的数量占上诉数量的比例
	
	judge_id：案件对应的法官id
	judge_year：案件判决年份
	
	
*/

**********# 附录III 图Ⅲ1 法官案件审理能力与过去一年审案数量关系 #***************
	
	use "$working_data\法官人力资本研究数据.dta" ,clear
	
	*计算法官每年审理的案件中上诉案件的占比
	gen appeal_year_r=judge_year_appeal/judge_year_all
	
	*法官每年审理的案件中，被改判的数量与上诉案件数量的占比'
	gen chang_year_r=judge_year_change/judge_year_appeal
	
	*按照审理年份与法官id去重，得到法官层级的面板数据
	duplicates drop judge_id judge_year,force
	
	*设置画图字体格式
	set scheme s2color
	graph set window fontface "宋体"
	
	*最终结果
	xtile group = judge_year_all, nq(4)
	
	label define quartiles 1 "25%以下" 2 "25%-50%" 3 "50%-75%" 4 "75%以上", replace
	label values group quartiles

	graph bar (mean) appeal_year_r  chang_year_r    , over(group) ///
    legend(label(1 "进入二审案件比例") label(2 "二审被改判比例") region(lstyle(none))) ///
    graphregion(color(white)) ///
    bar(2, color(orange))
	
	graph save "Graph" $tables\附图III1.gph,replace 


	
	
	
	
	