clear all
set more off


u 2024-00551+使用数据\census15_data.dta,replace 
***********************************************
* 表3
***********************************************

* 读高中
reghdfe high treat dist_bd inter    if distance<=25,absorb(NEAR_FID age_cohort) vce(cluster area_code)
estadd local Polynomial   "Y"  
estadd local Boundary "Y"
estadd local cohort "Y"
est store m1

reghdfe high treat dist_bd inter    if distance<=30,absorb(NEAR_FID age_cohort) vce(cluster area_code)
estadd local Polynomial   "Y"  
estadd local Boundary "Y"
estadd local cohort "Y"
est store m2

reghdfe high treat dist_bd inter    if distance<=35,absorb(NEAR_FID age_cohort) vce(cluster area_code)
estadd local Polynomial   "Y"  
estadd local Boundary "Y"
estadd local cohort "Y"
est store m3

reghdfe high treat dist_bd inter    if distance<=40,absorb(NEAR_FID age_cohort) vce(cluster area_code)
estadd local Polynomial   "Y"  
estadd local Boundary "Y"
estadd local cohort "Y"
est store m4

reghdfe high treat dist_bd inter    if distance<=45,absorb(NEAR_FID age_cohort) vce(cluster area_code)
estadd local Polynomial   "Y"  
estadd local Boundary "Y"
estadd local cohort "Y"
est store m5

local s  "using 2024-00551+日志文件\table3.rtf"   
local m  " m1 m2 m3 m4 m5 "  
local mt " <=25km <=30km <=35km <=40km <=45km "  
esttab `m'`s', ///
replace mtitle(`mt') b(%6.3f) nogap compress label ///
star(* 0.1 ** 0.05 *** 0.01)  ///
keep(treat ) se  ///
scalar(Polynomial Boundary cohort  N) sfmt(fmt %12.0f) ///
title( "Table 3A " )

* 受教育年限
reghdfe edu_year treat dist_bd inter    if distance<=25,absorb(NEAR_FID age_cohort) vce(cluster area_code)
estadd local Polynomial   "Y"  
estadd local Boundary "Y"
estadd local cohort "Y"
est store m1

reghdfe edu_year treat dist_bd inter    if distance<=30,absorb(NEAR_FID age_cohort) vce(cluster area_code)
estadd local Polynomial   "Y"  
estadd local Boundary "Y"
estadd local cohort "Y"
est store m2

reghdfe edu_year treat dist_bd inter    if distance<=35,absorb(NEAR_FID age_cohort) vce(cluster area_code)
estadd local Polynomial   "Y"  
estadd local Boundary "Y"
estadd local cohort "Y"
est store m3

reghdfe edu_year treat dist_bd inter    if distance<=40,absorb(NEAR_FID age_cohort) vce(cluster area_code)
estadd local Polynomial   "Y"  
estadd local Boundary "Y"
estadd local cohort "Y"
est store m4

reghdfe edu_year treat dist_bd inter    if distance<=45,absorb(NEAR_FID age_cohort) vce(cluster area_code)
estadd local Polynomial   "Y"  
estadd local Boundary "Y"
estadd local cohort "Y"
est store m5

local s  "using 2024-00551+日志文件\table3.rtf"   
local m  " m1 m2 m3 m4 m5 "  
local mt " <=25km <=30km <=35km <=40km <=45km "  
esttab `m'`s', ///
append mtitle(`mt') b(%6.3f) nogap compress label ///
star(* 0.1 ** 0.05 *** 0.01)  ///
keep(treat ) se  ///
scalar(Polynomial Boundary cohort  N) sfmt(fmt %12.0f) ///
title( "Table 3B " )


* 分组检验
reghdfe edu_year treat dist_bd inter    if distance<=45&group==1,absorb(NEAR_FID age_cohort) vce(cluster area_code)
estadd local Polynomial   "Y"  
estadd local Boundary "Y"
estadd local cohort "Y"
est store m1

reghdfe edu_year treat dist_bd inter    if distance<=45&group==2,absorb(NEAR_FID age_cohort) vce(cluster area_code)
estadd local Polynomial   "Y"  
estadd local Boundary "Y"
estadd local cohort "Y"
est store m2

reghdfe edu_year treat dist_bd inter    if distance<=45&group==3,absorb(NEAR_FID age_cohort) vce(cluster area_code)
estadd local Polynomial   "Y"  
estadd local Boundary "Y"
estadd local cohort "Y"
est store m3

reghdfe edu_year treat dist_bd inter    if distance<=45&group==4,absorb(NEAR_FID age_cohort) vce(cluster area_code)
estadd local Polynomial   "Y"  
estadd local Boundary "Y"
estadd local cohort "Y"
est store m4

reghdfe edu_year treat dist_bd inter    if distance<=45&group==5,absorb(NEAR_FID age_cohort) vce(cluster area_code)
estadd local Polynomial   "Y"  
estadd local Boundary "Y"
estadd local cohort "Y"
est store m5

local s  "using 2024-00551+日志文件\table3.rtf"   
local m  " m1 m2 m3 m4 m5 "  
local mt " group1 group2 group3 group4 group5 "  
esttab `m'`s', ///
append mtitle(`mt') b(%6.3f) nogap compress label ///
star(* 0.1 ** 0.05 *** 0.01)  ///
keep(treat ) se  ///
scalar(Polynomial Boundary cohort  N) sfmt(fmt %12.0f) ///
title( "Table 3C " )

