clear all
set more off 
*********************************
u 2024-00551+使用数据\hh_data,clear

global hx "age male edu scale"

*************************************************************************
* 表2B---1/2/3列
*************************************************************************

reg lnincome treat dist_bd inter $hx  if distance<=25 ,cluster(area_code)
estadd local Polynomial   "Y"  
estadd local control "Y"
est store m1

reg lnincome treat dist_bd inter $hx  if distance<=35 ,cluster(area_code)
estadd local Polynomial   "Y"  
estadd local control "Y"
est store m2

reg lnincome treat dist_bd inter $hx  if distance<=45 ,cluster(area_code)
estadd local Polynomial   "Y"  
estadd local control "Y"
est store m3

local s  "using 2024-00551+日志文件\table2B.rtf"   
local m  " m1 m2 m3 "  
local mt " <=25km <=35km <=45km "  
esttab `m'`s', ///
replace mtitle(`mt') b(%6.3f) nogap compress label ///
star(* 0.1 ** 0.05 *** 0.01)  ///
keep(treat  ) se  ///
scalar(Polynomial control N) sfmt(fmt %12.0f) ///
title( "Table 2B---1/2/3 " )

*************************************************************************
* 表2B---4/5/6列
*************************************************************************

reg lnincome treat dist_bd inter $hx [pweight=swgt] if distance<=25 ,cluster(area_code)
estadd local Polynomial   "Y"  
estadd local control "Y"
estadd local weight "Y"
est store m1

reg lnincome treat dist_bd inter $hx [pweight=swgt] if distance<=35 ,cluster(area_code)
estadd local Polynomial   "Y"  
estadd local control "Y"
estadd local weight "Y"
est store m2

reg lnincome treat dist_bd inter $hx [pweight=swgt] if distance<=45 ,cluster(area_code)
estadd local Polynomial   "Y"  
estadd local control "Y"
estadd local weight "Y"
est store m3

local s  "using 2024-00551+日志文件\table2B.rtf"   
local m  " m1 m2 m3 "  
local mt " <=25km <=35km <=45km "  
esttab `m'`s', ///
append mtitle(`mt') b(%6.3f) nogap compress label ///
star(* 0.1 ** 0.05 *** 0.01)  ///
keep(treat  ) se  ///
scalar(Polynomial control weight N) sfmt(fmt %12.0f) ///
title( "Table 2B---4/5/6" )

*************************************************************************
* 图1 D E F
*************************************************************************

rdplot lnincome dist_bd  ,c(0) p(1) nbins(5) ///  
graph_options( ///
title("(D)",color(black) size(*1) position(6)) ///
xtitle("",size(*1) )  ///
ytitle("ln 收入",size(*1)) ///
ylabel(,labsize(*1) angle(90) grid) ///
xlabel(,labsize(*1) ) ///
graphregion(fcolor(white)) legend(off))
graph save 2024-00551+日志文件\fig_hh1.gph,replace 

rdplot lnincome dist_bd ,c(0) p(2) nbins(5) ///  
graph_options( ///
title("(E)",color(black) size(*1) position(6)) ///
xtitle("",size(*1) )  ///
ytitle("ln 收入",size(*1)) ///
ylabel(,labsize(*1) angle(90) grid) ///
xlabel(,labsize(*1) ) ///
graphregion(fcolor(white)) legend(off))
graph save 2024-00551+日志文件\fig_hh2.gph,replace 

rdplot lnincome dist_bd ,c(0) p(3) nbins(5) ///  
graph_options( ///
title("(F)",color(black) size(*1) position(6)) ///
xtitle("",size(*1) )  ///
ytitle("ln 收入",size(*1)) ///
ylabel(,labsize(*1) angle(90) grid) ///
xlabel(,labsize(*1) ) ///
graphregion(fcolor(white)) legend(off))
graph save 2024-00551+日志文件\fig_hh3.gph,replace 

*************************************************************************
* 图1 A B C D E F 
*************************************************************************
graph combine 2024-00551+日志文件\fig_house1.gph 2024-00551+日志文件\fig_house2.gph 2024-00551+日志文件\fig_house3.gph  ///
2024-00551+日志文件\fig_hh1.gph 2024-00551+日志文件\fig_hh2.gph 2024-00551+日志文件\fig_hh3.gph ,  ///
row(2) graphregion(fcolor(white) margin(0) )
graph export 2024-00551+日志文件\fig_1.png,replace 

// erase 2024-00551+日志文件\fig_house1.gph    
// erase 2024-00551+日志文件\fig_house2.gph
// erase 2024-00551+日志文件\fig_house3.gph
// erase 2024-00551+日志文件\fig_hh1.gph
// erase 2024-00551+日志文件\fig_hh2.gph
// erase 2024-00551+日志文件\fig_hh3.gph

*********************************
* 稳健性检验 2次项 
* 表A1(C)
*********************************
reg lnincome treat dist_bd inter dist_bd2 dist_bd2d  $hx  if distance<=25 ,cluster(area_code)
estadd local Polynomial   "Y"  
estadd local control "Y"
est store m1

reg lnincome treat dist_bd inter dist_bd2 dist_bd2d  $hx  if distance<=35 ,cluster(area_code)
estadd local Polynomial   "Y"  
estadd local control "Y"
est store m2

reg lnincome treat dist_bd inter dist_bd2 dist_bd2d  $hx  if distance<=45 ,cluster(area_code)
estadd local Polynomial   "Y"  
estadd local control "Y"
est store m3

reg lnincome treat dist_bd inter dist_bd2 dist_bd2d  $hx [pweight=swgt] if distance<=25 ,cluster(area_code)
estadd local Polynomial   "Y"  
estadd local control "Y"
estadd local weight "Y"
est store m4

reg lnincome treat dist_bd inter dist_bd2 dist_bd2d  $hx [pweight=swgt] if distance<=35 ,cluster(area_code)
estadd local Polynomial   "Y"  
estadd local control "Y"
estadd local weight "Y"
est store m5

reg lnincome treat dist_bd inter dist_bd2 dist_bd2d  $hx [pweight=swgt] if distance<=45 ,cluster(area_code)
estadd local Polynomial   "Y"  
estadd local control "Y"
estadd local weight "Y"
est store m6

local s  "using 2024-00551+日志文件\tableA1_C.rtf"   
local m  " m1 m2 m3 m4 m5 m6 "  
local mt " <=25km <=35km <=45km <=25km <=35km <=45km "  
esttab `m'`s', ///
replace mtitle(`mt') b(%6.3f) nogap compress label ///
star(* 0.1 ** 0.05 *** 0.01)  ///
keep(treat  ) se  ///
scalar(Polynomial control weight N) sfmt(fmt %12.0f) ///
title( "Table A1---C" )

*********************************
* 稳健性检验 3次项 
* 表A1(D)
*********************************
reg lnincome treat dist_bd inter dist_bd2 dist_bd2d dist_bd3 dist_bd3d $hx  if distance<=25 ,cluster(area_code)
estadd local Polynomial   "Y"  
estadd local control "Y"
est store m1

reg lnincome treat dist_bd inter dist_bd2 dist_bd2d dist_bd3 dist_bd3d $hx  if distance<=35 ,cluster(area_code)
estadd local Polynomial   "Y"  
estadd local control "Y"
est store m2

reg lnincome treat dist_bd inter dist_bd2 dist_bd2d dist_bd3 dist_bd3d $hx  if distance<=45 ,cluster(area_code)
estadd local Polynomial   "Y"  
estadd local control "Y"
est store m3

reg lnincome treat dist_bd inter dist_bd2 dist_bd2d dist_bd3 dist_bd3d $hx [pweight=swgt] if distance<=25 ,cluster(area_code)
estadd local Polynomial   "Y"  
estadd local control "Y"
estadd local weight "Y"
est store m4

reg lnincome treat dist_bd inter dist_bd2 dist_bd2d dist_bd3 dist_bd3d $hx [pweight=swgt] if distance<=35 ,cluster(area_code)
estadd local Polynomial   "Y"  
estadd local control "Y"
estadd local weight "Y"
est store m5

reg lnincome treat dist_bd inter dist_bd2 dist_bd2d dist_bd3 dist_bd3d $hx [pweight=swgt] if distance<=45 ,cluster(area_code)
estadd local Polynomial   "Y"  
estadd local control "Y"
estadd local weight "Y"
est store m6

local s  "using 2024-00551+日志文件\tableA1_D.rtf"   
local m  " m1 m2 m3 m4 m5 m6 "  
local mt " <=25km <=35km <=45km <=25km <=35km <=45km "  
esttab `m'`s', ///
replace mtitle(`mt') b(%6.3f) nogap compress label ///
star(* 0.1 ** 0.05 *** 0.01)  ///
keep(treat  ) se  ///
scalar(Polynomial control weight N) sfmt(fmt %12.0f) ///
title( "Table A1---D" )

**************************************************************
* 表1第18列的回归结果  
* rdrobust
*************************************************************
rdrobust lnincome dist_bd ,c(0) p(1) covs($hx) kernel(tri) bwselect(mserd)
estadd local Polynomial   "Y"  
estadd local control "Y"
est store m1

esttab m1 using "2024-00551+日志文件\table2C---18column.rtf", ///
replace mtitle(rdrobust) b(%6.3f) nogap compress label ///
star(* 0.1 ** 0.05 *** 0.01)  ///
se scalar(Polynomial control N) sfmt(fmt %12.0f) ///
title( "Table 1C---18column" )

