clear all
set more off


u 2024-00551+使用数据\data1,clear 
   
**********************************
* 平滑性检验
* 图A4
* 图A5
**********************************
twoway (histogram dist_bd,bin(90) lcolor(gs5) lw(*.5) fcolor(none) fintensity(5)), ///
        title("",position(6))  xtitle("辖区质点到边界的距离(Km)",margin(t+2))  ///
		xline(0, lcolor(stone) lp(dash))  ylabel(,labsize(*.8) angle(90))  //
graph export 2024-00551+日志文件\fig_A4.png,replace	

DCdensity dist_bd  if  distance<=45, breakpoint(0) generate(Xj Yj r0 fhat se_fhat) b(4) 
graph export 2024-00551+日志文件\fig_A5.png,replace	
graph close

cap drop Yj Xj r0 fhat se_fhat

**********************************
* 平衡性检验
* 表1 
**********************************

reghdfe ln_haiba treat dist_bd inter  if distance<=45,absorb( NEAR_FID) vce(cluster area_code)
estadd local Polynomial   "Y"  
estadd local Boundary "Y"
est store m1

reghdfe podu treat dist_bd inter      if distance<=45,absorb( NEAR_FID) vce(cluster area_code)
estadd local Polynomial   "Y"  
estadd local Boundary "Y"
est store m2

reghdfe ln_dis treat dist_bd inter    if distance<=45,absorb( NEAR_FID) vce(cluster area_code)
estadd local Polynomial   "Y"  
estadd local Boundary "Y"
est store m3
 
reghdfe qiwen_mean treat dist_bd inter if distance<=45,absorb(NEAR_FID) vce(cluster area_code)
estadd local Polynomial   "Y"  
estadd local Boundary "Y"
est store m4

reghdfe ad_area treat dist_bd inter   if distance<=45,absorb( NEAR_FID) vce(cluster area_code)
estadd local Polynomial   "Y"  
estadd local Boundary "Y"
est store m5

local s  "using 2024-00551+日志文件\table1.rtf"   
local m  " m1 m2 m3 m4 m5 "  
local mt " haiba podu distance2river qiwen_mean area"  
esttab `m'`s', ///
replace mtitle(`mt') b(%6.3f) nogap compress label ///
star(* 0.1 ** 0.05 *** 0.01)  ///
keep(treat ) se r2 ///
scalar(Polynomial Boundary N) sfmt(fmt %12.0f) ///
title( "Table 1 " )

**********************************
* 图A6
**********************************
* 海拔
cmogram ln_haiba dist_bd if distance<=45 ,cut(0) histopts(bin(5))    ///
scatter  lfitci lfitopt(alp(dash) alw(*.6) clp(solid) clc(gs5))  ///
graphopts(m(oh) mc(gs5) xline(0,lcolor(gs8) lp(dash))   ///
title(ln海拔,color(black) size(*.8)) ///
xtitle("(A)",size(*1) )  ///
ytitle("",size(*.8)) ///
ylabel(,labsize(*.8) angle(90) nogrid) ///
xlabel(-45 0 45,labsize(*.8) ) ) 
graph save 2024-00551+日志文件\rdp1.gph, replace

* 坡度
cmogram podu dist_bd if distance<=45 ,cut(0) histopts(bin(5))    ///
scatter  lfitci lfitopt(alp(dash) alw(*.6) clp(solid) clc(gs5))  ///
graphopts(m(oh) mc(gs5)  xline(0,lcolor(gs8) lp(dash))  ///
title(坡度,color(black) size(*.8)) ///
xtitle("(B)",size(*1) )  ///
ytitle("",size(*.8)) ///
ylabel(,labsize(*.8) angle(90) nogrid) ///
xlabel(-45 0 45,labsize(*.8) ) ) 
graph save 2024-00551+日志文件\rdp2.gph, replace

* 与河流的距离
cmogram ln_dis dist_bd if distance<=45 ,cut(0) histopts(bin(5))    ///
scatter  lfitci lfitopt(alp(dash) alw(*.6) clp(solid) clc(gs5))  ///
graphopts(m(oh) mc(gs5) xline(0,lcolor(gs8) lp(dash))   ///
title(ln与河流的距离,color(black) size(*.8)) ///
xtitle("(C)",size(*1) )  ///
ytitle("",size(*.8)) ///
ylabel(,labsize(*.8) angle(90) nogrid) ///
xlabel(-45 0 45,labsize(*.8) ) ) 
graph save 2024-00551+日志文件\rdp3.gph, replace

* 平均气温
cmogram qiwen_mean dist_bd if distance<=45 ,cut(0) histopts(bin(5))    ///
scatter  lfitci lfitopt(alp(dash) alw(*.6) clp(solid) clc(gs5))  ///
graphopts(m(oh) mc(gs5) xline(0,lcolor(gs8) lp(dash))   ///
title(平均气温,color(black) size(*.8)) ///
xtitle("(D)",size(*1) )  ///
ytitle("",size(*.8)) ///
ylabel(,labsize(*.8) angle(90) nogrid) ///
xlabel(-45 0 45,labsize(*.8) ) ) 
graph save 2024-00551+日志文件\rdp4.gph, replace

cmogram ad_area dist_bd if distance<=45 ,cut(0) histopts(bin(5))    ///
scatter  lfitci lfitopt(alp(dash) alw(*.6) clp(solid) clc(gs5))  ///
graphopts(m(oh) mc(gs5)  xline(0,lcolor(gs8) lp(dash))  ///
title(面积,color(black) size(*.8)) ///
xtitle("(E)",size(*1) )  ///
ytitle("",size(*.8)) ///
ylabel(0(40)120,labsize(*.8) angle(90) nogrid) ///
xlabel(-45 0 45,labsize(*.8) ) ) 
graph save 2024-00551+日志文件\rdp5.gph, replace

graph combine 2024-00551+日志文件\rdp1.gph 2024-00551+日志文件\rdp2.gph 2024-00551+日志文件\rdp3.gph 2024-00551+日志文件\rdp4.gph 2024-00551+日志文件\rdp5.gph,  ///
row(2) scheme(s1mono) hole(6) plotregion(fcolor(white) lcolor(white)) ///
graphregion(margin(zero) fcolor(white)) 
graph export 2024-00551+日志文件\fig_A6.png, replace

// erase 2024-00551+日志文件\rdp1.gph 
// erase 2024-00551+日志文件\rdp2.gph 
// erase 2024-00551+日志文件\rdp3.gph 
// erase 2024-00551+日志文件\rdp4.gph 
// erase 2024-00551+日志文件\rdp5.gph