//季刊附录
//生成多项式
//use data.dta ,clear  //调用数据
gen t=year-2017     
gen GF1=diquGreen*t
gen GF2=diquGreen*t*t
gen GF3=diquGreen*t*t*t
gen GF4=diquGreen*time

//平行趋势检验
gen policy = year - 2018
tab policy
replace policy = -4 if policy <- 4
replace policy = 2 if policy > 2
forvalues i =4(-1)1{
  gen pre_`i' = (policy == -`i' & treat == 1) 
}

gen current = (policy == 0 & treat == 1)

forvalues j = 1(1)2{
  gen  post_`j' = (policy == `j' & treat == 1)
}
drop pre_1
//图II1：平行趋势检验
reghdfe bio  pre* current post* lnrgdp lnforeign Structure lninfrastructure Density  Gov   slop high night temp  GF1 GF2 GF3 ,absorb(year id  ) vce(cluster id)

coefplot, baselevels keep(pre* current post*) vertical ///
coeflabels( pre_4="-4" pre_3 3="-3" pre_2="-2" pre_1="-1"  current="0" post_1="1" post_2="2" ) ///
         yline(0, lwidth(vthin) lpattern(solid) lcolor(teal)) ///
         xline(4, lwidth(vthin) lpattern(solid) lcolor(teal)) ///
         xlabel(, labsize(*0.85)) ///
		 ylabel(-1(0.5)2.5, axis(1)) ///
         ytitle("政策动态效应") msymbol(O) msize(small) mcolor(gs1) ///
		 ytitle("{fontface 仿宋:政策动态效应}", axis(1)) ///
		 xtitle("{fontface 仿宋:相对年份}", axis(1)) ///
         addplot(line @b @at, lcolor(gs1) lwidth(medthick)) ///
         ciopts(recast(rline) lwidth(thin) lpattern(dash) lcolor(gs2)) ///
         graphregion(color(white)) level(95)

		 
///安慰剂检验
//*******************************************图II2 安慰剂检验****************************************
******5、安慰剂检验******  //此处路径与文件名需要修改
cd "E:\刘钊数据\新建文件夹\新建文件夹"
clear
set seed 91768367
set matsize 500
mat b=J(500,1,0)
mat se=J(500,1,0)
mat p=J(500,1,0)

quietly forvalues i=1/500{
  use 数据.dta, clear
  gsample 8,cluster(id) wor
  keep id
  save 2.dta,replace
  duplicates drop id ,force
  merge 1:m id using 数据.dta
  gen treat3=(_merge==3)
  gen post3= (year >=2018)
  gen did5= treat3*post3
  gen t=year-2017     
gen GF1=diquGreen*t
gen GF2=diquGreen*t*t
gen GF3=diquGreen*t*t*t
gen GF4=diquGreen*time
  reghdfe  bio did5 lnrgdp lnforeign Structure lninfrastructure Density Gov   slop high night temp GF1 GF2 GF3 ,absorb(year id ) vce(cluster id)
  mat b[`i',1] = _b[did5]
  mat se[`i',1] = _se[did5]
  mat p[`i',1] = 2*ttail(e(df_r),abs(_b[did5]/_se[did5]))
 }
  svmat b,names(coef)
  svmat se,names(se)
  svmat p,names(pvalue)
  
  label var pvalue1 p值
  label var coef1 估计系数
  save placebo1dta,replace
  
twoway scatter pvalue1 coef1, mcolor(black) msize(small) || ///
kdensity coef1, yaxis(2) lcolor(black) ///
yline(0.005, axis(1) lwidth(medium) lpattern(dash) lcolor(black)) ///
xline(0.499, axis(1) lwidth(medium) lpattern(dash) lcolor(black))  ///
xlabel(-1(0.2)1, axis(1)) ///
xtitle("{fontface 仿宋:估计系数}") ///
ytitle("{fontface 仿宋:P值}", axis(1)) ///
ytitle("{fontface 仿宋:分布密度}", axis(2)) ///
legend(off) scheme(qleanmono)
		 
		 
//倾向得分匹配
//************************************************表II1：倾向得分匹配***********************************************
set seed 0001
gen randomorder1=runiform()
sort randomorder1
psmatch2  treat lnrgdp lnforeign Structure lninfrastructure Density Gov  night temp if year==2017, kernel out(bio)  logit ate neighbor(4) common caliper(.05) ties
bys id:egen psm=mean(_weight)
*******稳健性检验*******
reghdfe   bio did  lnrgdp lnforeign Structure lninfrastructure Density Gov   slop high night temp GF1 GF2 GF3 if psm!=.,absorb(year id ) vce(cluster id)   //列1
reghdfe   bio did  lnrgdp lnforeign Structure lninfrastructure Density Gov   slop high night temp GF4 if psm!=.,absorb(year id ) vce(cluster id)   // 列2
reghdfe   bio did  lnrgdp lnforeign Structure lninfrastructure Density Gov   slop high night temp  c.diquGreen#i.year if psm!=.,absorb(year id ) vce(cluster id)   //列3


set seed 0001
gen randomorder=runiform()
sort randomorder
psmatch2  treat lnrgdp lnforeign Structure lninfrastructure Density Gov    slop high night temp , kernel out(bio)  logit ate neighbor(2) common caliper(.05) ties
*******稳健性检验*******
reghdfe   bio did  lnrgdp lnforeign Structure lninfrastructure Density Gov   slop high night temp GF1 GF2 GF3 if _weight!=.,absorb(year id ) vce(cluster id)  //列4
reghdfe   bio did  lnrgdp lnforeign Structure lninfrastructure Density Gov   slop high night temp GF4 if _weight!=.,absorb(year id ) vce(cluster id)  //列5
reghdfe   bio did  lnrgdp lnforeign Structure lninfrastructure Density Gov   slop high night temp  c.diquGreen#i.year if _weight!=.,absorb(year id ) vce(cluster id) //列6





**********************************************************表II2 ：更换被解释变量**************************************
reghdfe  lnavgm did  lnrgdp lnforeign Structure lninfrastructure Density Gov   slop high night temp GF1 GF2 GF3   ,absorb(year id ) vce(cluster id )   //第1列


reghdfe  lasso did lnrgdp lnforeign Structure lninfrastructure Density Gov   slop high night temp GF1 GF2 GF3 , absorb(year id) vce(cluster id)   //第2列

reghdfe z_F did  lnrgdp lnforeign Structure lninfrastructure Density Gov   slop high night temp GF1 GF2 GF3 , absorb(year id) vce(cluster id)   //第3列


*******************************************************表II3：排除新冠疫情的影响******************************
reghdfe bio did lnrgdp lnforeign Structure lninfrastructure Density Gov   slop high night temp lnCOVID GF1 GF2 GF3 , absorb(year id) vce(cluster id)  //列1
reghdfe bio did lnrgdp lnforeign Structure lninfrastructure Density Gov    slop high night temp  lnCOVID  GF4, absorb(year id) vce(cluster id)  //列2
reghdfe bio did lnrgdp lnforeign Structure lninfrastructure Density Gov    slop high night temp  lnCOVID  c.diquGreen#i.year , absorb(year id) vce(cluster id )  //列3


********************************************************表II4：控制当地的社会经济发展情况******************************
reghdfe bio did  lnrgdp lnforeign Structure lninfrastructure Density Gov   slop high night temp GF1 GF2 GF3 lnhumcap2 lnculture2 rjinter lntours old, absorb(year id) vce(cluster id)   //列1


reghdfe bio did  lnrgdp lnforeign Structure lninfrastructure Density Gov    slop high night temp GF4 lnhumcap2 lnculture2  rjinter lntours old, absorb(year id) vce(cluster id)   //列2

reghdfe bio did  lnrgdp lnforeign Structure lninfrastructure Density Gov    slop high night temp c.diquGreen#i.year lnhumcap2 lnculture2  rjinter lntours old, absorb(year id) vce(cluster id )  //列3


**********************************************************表II5：改变控制城市***************************************
***********改变控制组：保留试验区省内其他城市作为控制组
reghdfe bio did  lnrgdp lnforeign Structure lninfrastructure Density Gov    slop high night temp c.diquGreen#i.year if tongsheng==1, absorb(year id) vce(cluster id) //列1
***********改变控制组：保留试验区周边其他城市作为控制组
reghdfe bio did  lnrgdp lnforeign Structure lninfrastructure Density Gov  slop high night temp c.diquGreen#i.year if treat==1|treat1==1, absorb(year id) vce(cluster id) //列2
***********改变控制组：保留试验区省内和周边其他城市作为控制组
reghdfe bio did  lnrgdp lnforeign Structure lninfrastructure Density Gov  slop high night temp c.diquGreen#i.year if tongsheng==1|treat1==1, absorb(year id) vce(cluster id) //列3
**************改变控制组，使用其他省作为控制组
reghdfe bio did  lnrgdp lnforeign Structure lninfrastructure Density Gov    slop high night temp c.diquGreen#i.year  if waisheng==0, absorb(year id) vce(cluster id)  //列4



*********************************************************表II6：剔除观测记录较少的城市*********************************************
*******************剔除观鸟报告少的******
reghdfe bio did  lnrgdp lnforeign Structure lninfrastructure Density Gov    slop high night temp c.diquGreen#i.year if 城市_年份观鸟报告>10, absorb(year id) vce(cluster id )     //列1
*******************剔除观鸟报告少的******
reghdfe bio did  lnrgdp lnforeign Structure lninfrastructure Density Gov    slop high night temp c.diquGreen#i.year if 城市_年份观鸟报告>30, absorb(year id) vce(cluster id )  //列2
*******************剔除观鸟报告少的******
reghdfe bio did  lnrgdp lnforeign Structure lninfrastructure Density Gov    slop high night temp c.diquGreen#i.year if 城市_年份观鸟报告>50, absorb(year id) vce(cluster id )  //列3
*******************剔除观鸟报告少的******
reghdfe bio did  lnrgdp lnforeign Structure lninfrastructure Density Gov    slop high night temp c.diquGreen#i.year if 城市_年份观鸟报告>100, absorb(year id) vce(cluster id )  //列4

********************************************************表III1 ：试验区辐射效应检验*****************************************************
reghdfe bio did8  lnrgdp lnforeign Structure lninfrastructure Density Gov   slop high night temp  if treat==0,absorb(id) vce(cluster id) //列1
reghdfe bio did8 lnrgdp lnforeign Structure lninfrastructure Density Gov   slop high night temp if treat==0,absorb(year id ) vce(cluster id) //列2


**********************************************************表III2 ：剔除试验区周边城市**********************************************
*****************实验组剔除周边地区
reghdfe bio did  lnrgdp lnforeign Structure lninfrastructure Density Gov   slop high night temp GF1 GF2 GF3 if treat1==0, absorb(year id) vce(cluster id)  //列1
reghdfe bio did  lnrgdp lnforeign Structure lninfrastructure Density Gov    slop high night temp GF4 if treat1==0, absorb(year id) vce(cluster id)  //列2
reghdfe bio did  lnrgdp lnforeign Structure lninfrastructure Density Gov    slop high night temp c.diquGreen#i.year if treat1==0, absorb(year id) vce(cluster id)   //列3





