** urban unemployment rates and labor force participation rates based on mini-census 2015

* latest update: line all

capture log close
set more off
clear all

global testmode 1
* 1: office computer
* 2: laptop
* 3: remote platform

if $testmode==1{
local workdir   "H:\stata 13\work_files\labor_market"
local datadir   "H:\stata 13\raw_data\labor_market"
local outdir    "H:\stata 13\output\labor_market"
local dofiledir "H:\stata 13\do_files\labor_market"
}

if $testmode==2{
local workdir   "E:\stata 13\work_files\labor_market"
local datadir   "E:\stata 13\raw_data\labor_market"
local outdir    "E:\stata 13\output\labor_market"
local dofiledir "E:\stata 13\do_files\labor_market"
}

if $testmode==3{
local workdir   "D:\stata 13\work_files\labor_market"
local datadir   "D:\stata 13\raw_data\labor_market"
local outdir    "D:\stata 13\output\labor_market"
local dofiledir "D:\stata 13\do_files\labor_market"
}

cd "`datadir'"

log using "`outdir'\program_fig1&2",replace smcl

log off

use census2015, clear

drop if r7_1==2                // people not living in the present address

gen city_fla=.                 // 1=city, 2=town, 3=rural area

replace city_fla=1 if inlist(cx,111,112)
replace city_fla=2 if inlist(cx,121,122,123)
replace city_fla=3 if inlist(cx,210,220)

recode city_fla (1 2=1) (3=0), gen(urban)

label define urban_type 1"urban" 0"rural"
label value urban urban_type

gen sex=.
replace sex=1 if r3==1
replace sex=2 if r3==2

label define sex_type 1"male" 2"female"
label value sex sex_type

gen lfs=. if age>=15 & age<=.  // define labor force status, 1=employment, 2=unemployment, 3=not in labor force

replace lfs=1 if inlist(r17,1,2)
replace lfs=2 if r17==3 & inlist(r22,3,4,5,6,7,8,9) & inlist(r23,1,2,3,4,5,6) & r24==1
replace lfs=3 if r17==3 & inlist(r22,3,4,5,6,7,8,9) & inlist(r23,1,2,3,4,5,6) & r24==2
replace lfs=3 if r17==3 & inlist(r22,3,4,5,6,7,8,9) & inlist(r23,7)
replace lfs=3 if r17==3 & inlist(r22,1,2)

label define lfs_type 1"employed" 2"unemployed" 3"NILF"
label value lfs lfs_type

gen emp=.
replace emp=1 if lfs==1
replace emp=0 if lfs==2|lfs==3

label define emp_type 1"employed" 0"non-employed"
label value emp emp_type

gen unemp=.
replace unemp=1 if lfs==2
replace unemp=0 if lfs==1

label define unemp_type 1"unemployed" 0"employed"
label value unemp unemp_type

gen lfp=.
replace lfp=1 if lfs==1|lfs==2
replace lfp=0 if lfs==3

label define lfp_type 1"labor fore" 0"NILF"
label value lfp lfp_type

save "`workdir'\census_ind_2015.dta", replace

log on 

** urban and rural unemployment rates

table urban if (age>=16 & age<=60 & sex==1) | (age>=16 & age<=55 & sex==2) [aw=qs_ren], stat(mean unemp)

** urban and rural labor force participation rates by age groups

table urban if age>=16 & age<=59 [aw=qs_ren], stat(mean lfp) 

table urban if age>=16 & age<=24 [aw=qs_ren], stat(mean lfp) 

table urban if age>=25 & age<=59 [aw=qs_ren], stat(mean lfp) 

log close

clear


