** migrants' nonfarm employment shares based on census 2000 2005 2010 2015

* latest update: line all

capture log close
set more off
clear all

global testmode 1
* 1: office computer
* 2: laptop
* 3: remote platform

if $testmode==1{
local workdir   "H:\stata 13\work_files\labor_market"
local datadir   "H:\stata 13\raw_data\labor_market"
local outdir    "H:\stata 13\output\labor_market"
local dofiledir "H:\stata 13\do_files\labor_market"
}

if $testmode==2{
local workdir   "E:\stata 13\work_files\labor_market"
local datadir   "E:\stata 13\raw_data\labor_market"
local outdir    "E:\stata 13\output\labor_market"
local dofiledir "E:\stata 13\do_files\labor_market"
}

if $testmode==3{
local workdir   "D:\stata 13\work_files\labor_market"
local datadir   "D:\stata 13\raw_data\labor_market"
local outdir    "D:\stata 13\output\labor_market"
local dofiledir "D:\stata 13\do_files\labor_market"
}

cd "`datadir'"

log using "`outdir'\program_table2",replace smcl

log off

**********************************************************  census 2000

use census2000, clear

drop if r061==5 | r061==4                  // living abroad & undefined hukou status

gen city_fla=ra0

label define city_fla_type 1"city" 2"town" 3"county"
label value city_fla city_fla_type

recode city_fla (1 2=1) (3=0), gen(urban)  // 1=urban area, 0=rural area

gen hk_loc=.                               // define local residence and migrants

replace hk_loc=1 if r061==1 
replace hk_loc=1 if inlist(r061,2,3) & inlist(r062,4,5,6)
replace hk_loc=0 if inlist(r061,2,3) & inlist(r062,1,2,3,7,8)

label define local_type 1"resident" 0"non_resident"
label value hk_loc local_type

gen hk_urban=.                             // define Hukou type
replace hk_urban=1 if r07==2
replace hk_urban=0 if r07==1

label define urban_type 1"urban hukou" 0"rural hukou"
label value hk_urban urban_type

gen hkloc_type=.
replace hkloc_type=1 if hk_loc==1 & hk_urban==1
replace hkloc_type=2 if hk_loc==1 & hk_urban==0
replace hkloc_type=3 if hk_loc==0 & hk_urban==1
replace hkloc_type=4 if hk_loc==0 & hk_urban==0

label define hkloc_type_type 1"urban local" 2"rural local" 3"urban migrant" 4"rural migrant"
label value hkloc_type hkloc_type_type

recode hkloc_type (1=1) (2=2) (3 4=3), gen(hk_type)

label define type_type 1"urban local" 2"rural local" 3"migrant"
label value hk_type type_type

gen lfs=.
replace lfs=1 if inlist(r17,1,2)
replace lfs=2 if r17==3 & inlist(r211,5,6)
replace lfs=3 if r17==3 & inlist(r211,1,2,3,4,7)

label define lfs_type 1"employed" 2"unemployed" 3"NILF"
label value lfs lfs_type

gen emp=.
replace emp=1 if lfs==1
replace emp=0 if lfs==2|lfs==3

label define emp_type 1"employed" 0"non-employed"
label value emp emp_type

ren r19 ind

gen sec=.  
replace sec=1 if  ind>0 & ind<61
replace sec=2 if  ind>=61 & ind<501
replace sec=3 if  ind>=501 & ind<.

label define sec_type 1"agricultural" 2"secondary" 3"service"
label value sec sec_type

gen year=2000

keep city city_fla urban hk_urban hkloc_type sec emp year 

save "`workdir'\census_ind_2000.dta", replace

**********************************************************  census 2005

use census2005_county, clear

drop if inlist(where_hk,1,2,3) & inlist(where_res,3,4,5)  // not living in the local town
drop if inlist(where_hk,4)                                // undefined hukou status

drop if city_flag=="A"
destring city_flag, replace

gen city_fla=city_flag

label define city_fla_type 1"city" 2"town" 3"county"
label value city_fla city_fla_type

recode city_flag (1 2=1) (3=0), gen(urban)

tostring region, replace
gen city=substr(region,1,4)
gen county_code=substr(region,5,2)
destring county_code, replace

tostring prov_hk, replace
tostring city_hk, replace

replace city_hk="0"+city_hk if strlen(city_hk)==1 & where_hk==3

gen mig_city=prov_hk+city_hk

gen hk_loc=.     // define local residence and migrants

replace hk_loc=1 if inlist(where_hk,1)
replace hk_loc=1 if inlist(where_hk,2) & (county_code>=0 & county_code<=20)
replace hk_loc=1 if inlist(where_hk,3) & city==mig_city & (county_code>=0 & county_code<=20) & (county_hk>=0 & county_hk<=20)

replace hk_loc=0 if hk_loc==.

label define local_type 1"resident" 0"non_resident"
label value hk_loc local_type

gen hk_urban=.
replace hk_urban=1 if hktype==2
replace hk_urban=0 if hktype==1

label define urban_type 1"urban hukou" 0"rural hukou"
label value hk_urban urban_type

gen hkloc_type=.
replace hkloc_type=1 if hk_loc==1 & hk_urban==1
replace hkloc_type=2 if hk_loc==1 & hk_urban==0
replace hkloc_type=3 if hk_loc==0 & hk_urban==1
replace hkloc_type=4 if hk_loc==0 & hk_urban==0

label define hkloc_type_type 1"urban local" 2"rural local" 3"urban migrant" 4"rural migrant"
label value hkloc_type hkloc_type_type

gen lfs=. 
replace lfs=1 if inlist(ifwork,1,2)
replace lfs=2 if ifwork==3 & inlist(cause_nw,3,4,5,6,7,8,9) & inlist(how_sjob,1,2,3,4,5,6) & ifready_job==1
replace lfs=3 if ifwork==3 & inlist(cause_nw,3,4,5,6,7,8,9) & inlist(how_sjob,1,2,3,4,5,6) & ifready_job==2
replace lfs=3 if ifwork==3 & inlist(cause_nw,3,4,5,6,7,8,9) & inlist(how_sjob,7)
replace lfs=3 if ifwork==3 & inlist(cause_nw,1,2)

label define lfs_type 1"employed" 2"unemployed" 3"NILF"
label value lfs lfs_type

gen emp=.
replace emp=1 if lfs==1
replace emp=0 if lfs==2|lfs==3

label define emp_type 1"employed" 0"non-employed"
label value emp emp_type

gen sec=.
replace sec=1 if  ind>0 & ind<6
replace sec=2 if  ind>=6 & ind<51
replace sec=3 if  ind>=51 & ind<.

label define sec_type 1"agricultural" 2"secondary" 3"service"
label value sec sec_type

gen year=2005

destring city, replace

keep city city_fla urban hk_urban hkloc_type sec emp year

save "`workdir'\census_ind_2005.dta", replace

**********************************************************  census 2010

use census2010_1m, clear

keep if inlist(r6_1,1,2,3)  // living in the local town

drop if inlist(r7_1,5)      // undefined hukou status

gen city_fla=.
replace city_fla=1 if inlist(cx,111,112)
replace city_fla=2 if inlist(cx,121,122,123)
replace city_fla=3 if inlist(cx,210,220)

label define city_fla_type 1"city" 2"town" 3"county"
label value city_fla city_fla_type

recode city_fla (1 2=1) (3=0), gen(urban)

tostring address, replace
gen city=substr(address,1,4)
gen county_code=substr(address,5,2)
destring county_code, replace

tostring r7_2, replace
gen mig_city=substr(r7_2,1,4)
gen county_hk=substr(r7_2,5,2)
destring county_hk, replace

gen hk_loc=.   // define local residence and migrants

replace hk_loc=1 if inlist(r7_1,1,2)  
replace hk_loc=1 if inlist(r7_1,3) & (county_code>=0 & county_code<=20)
replace hk_loc=1 if inlist(r7_1,4) & city==mig_city & (county_code>=0 & county_code<=20) & (county_hk>=0 & county_hk<=20)

replace hk_loc=0 if hk_loc==.

label define local_type 1"resident" 0"non_resident"
label value hk_loc local_type

gen hk_urban=.
replace hk_urban=1 if r11==2
replace hk_urban=0 if r11==1

label define urban_type 1"urban hukou" 0"rural hukou"
label value hk_urban urban_type

gen hkloc_type=.
replace hkloc_type=1 if hk_loc==1 & hk_urban==1
replace hkloc_type=2 if hk_loc==1 & hk_urban==0
replace hkloc_type=3 if hk_loc==0 & hk_urban==1
replace hkloc_type=4 if hk_loc==0 & hk_urban==0

label define hkloc_type_type 1"urban local" 2"rural local" 3"urban migrant" 4"rural migrant"
label value hkloc_type hkloc_type_type

gen lfs=. 
replace lfs=1 if inlist(r17_1,1,2)
replace lfs=2 if r17_1==3 & inlist(r20,3,4,5,6,7,8,9) & inlist(r21,1,2,3,4,5,6) & r22_1==1
replace lfs=3 if r17_1==3 & inlist(r20,3,4,5,6,7,8,9) & inlist(r21,1,2,3,4,5,6) & r22_1==2
replace lfs=3 if r17_1==3 & inlist(r20,3,4,5,6,7,8,9) & inlist(r21,7)
replace lfs=3 if r17_1==3 & inlist(r20,1,2)

label define lfs_type 1"employed" 2"unemployed" 3"NILF"
label value lfs lfs_type

gen emp=.
replace emp=1 if lfs==1
replace emp=0 if lfs==2|lfs==3

label define emp_type 1"employed" 0"non-employed"
label value emp emp_type

ren r18 ind

gen sec=.
replace sec=1 if  ind>0 & ind<61
replace sec=2 if  ind>=61 & ind<511
replace sec=3 if  ind>=511 & ind<.

label define sec_type 1"agricultural" 2"secondary" 3"service"
label value sec sec_type

gen year=2010

destring city, replace

keep city city_fla urban hk_urban hkloc_type sec emp year

save "`workdir'\census_ind_2010.dta", replace

**********************************************************  census 2015

use census2015, clear

drop if r7_1==2 // people not living in the present address

drop if r6_1==3 // undefined hukou status

gen city_fla=.
replace city_fla=1 if inlist(cx,111,112)
replace city_fla=2 if inlist(cx,121,122,123)
replace city_fla=3 if inlist(cx,210,220)

label define city_fla_type 1"city" 2"town" 3"county"
label value city_fla city_fla_type

recode city_fla (1 2=1) (3=0), gen(urban)

tostring address, replace
gen city=substr(address,1,4)
gen county_code=substr(address,5,2)
destring county_code, replace

tostring r6_2, replace
gen mig_city=substr(r6_2,1,4)
gen county_hk=substr(r6_2,5,2)
destring county_hk, replace

gen hk_loc=.   // define local residence and migrants

replace hk_loc=1 if inlist(r6_1,1)  
replace hk_loc=1 if inlist(r6_1,2) & city==mig_city & (county_code>=0 & county_code<=20) & (county_hk>=0 & county_hk<=20)

replace hk_loc=1 if inlist(r6_1,2) & city=="5001" & mig_city=="5001" & (county_code>=0 & county_code<=20) & county_hk==51
replace hk_loc=1 if inlist(r6_1,2) & city=="5001" & mig_city=="5001" & county_code==51 & county_hk==51
replace hk_loc=1 if inlist(r6_1,2) & city=="5001" & mig_city=="5001" & county_code==51 & (county_hk>=0 & county_hk<=20)

replace hk_loc=0 if hk_loc==.

label define local_type 1"resident" 0"non_resident"
label value hk_loc local_type

gen hk_urban=.
replace hk_urban=1 if r11==2
replace hk_urban=0 if r11==1

label define urban_type 1"urban hukou" 0"rural hukou"
label value hk_urban urban_type

gen hkloc_type=.
replace hkloc_type=1 if hk_loc==1 & hk_urban==1
replace hkloc_type=2 if hk_loc==1 & hk_urban==0
replace hkloc_type=3 if hk_loc==0 & hk_urban==1
replace hkloc_type=4 if hk_loc==0 & hk_urban==0

label define hkloc_type_type 1"urban local" 2"rural local" 3"urban migrant" 4"rural migrant"
label value hkloc_type hkloc_type_type

gen lfs=. 
replace lfs=1 if inlist(r17,1,2)
replace lfs=2 if r17==3 & inlist(r22,3,4,5,6,7,8,9) & inlist(r23,1,2,3,4,5,6) & r24==1
replace lfs=3 if r17==3 & inlist(r22,3,4,5,6,7,8,9) & inlist(r23,1,2,3,4,5,6) & r24==2
replace lfs=3 if r17==3 & inlist(r22,3,4,5,6,7,8,9) & inlist(r23,7)
replace lfs=3 if r17==3 & inlist(r22,1,2)

label define lfs_type 1"employed" 2"unemployed" 3"NILF"
label value lfs lfs_type

gen emp=.
replace emp=1 if lfs==1
replace emp=0 if lfs==2|lfs==3

label define emp_type 1"employed" 0"non-employed"
label value emp emp_type

ren r18 ind

gen sec=.

replace sec=1 if  ind>0 & ind<51

replace sec=3 if  ind>=51 & ind<61

replace sec=2 if  ind>=61 & ind<111

replace sec=3 if  ind>=111 & ind<120

replace sec=2 if  ind>=120 & ind<431

replace sec=3 if  ind>=431 & ind<441

replace sec=2 if  ind>=441 & ind<511

replace sec=3 if  ind>=511 & ind<.

label define sec_type 1"agricultural" 2"secondary" 3"service"
label value sec sec_type

gen year=2015

destring city, replace

keep city city_fla urban hk_urban hkloc_type sec emp year qs_ren

save "`workdir'\census_ind_2015.dta", replace

**********************************************************  four waves data

cd "`workdir'"

use census_ind_2000, clear

append using census_ind_2005
append using census_ind_2010
append using census_ind_2015

save census_ind_all, replace

log on 

** migrants' share in nonfarm employment in urban area, 2000, 2005, 2010

tab hkloc_type year if urban==1 & emp==1 & inlist(sec, 2, 3) & year!=2015, col nofreq

** migrants' share in nonfarm employment in urban area, 2015

tab hkloc_type year if urban==1 & emp==1 & inlist(sec, 2, 3) & year==2015 [aw=qs_ren], col nofreq

log off

log close

clear


