
/**********************************************************************/
/*  SECTION number: title  			
    Notes: */
/**********************************************************************/
	

capture program drop AppFigureI
	program AppFigureI
	
		set graphics on


		use CSC&Visa.dta, clear
		keep if Year<=2018

		twoway scatter 资助总数 Year , connect(l) mcolor(dknavy) lcolor(dknavy) || scatter J1_China Year , xtitle("年份") ///
			connect(l) mcolor() lcolor() m(S) legend(row(2) label(1 "国家留学基金委资助人员数量") label(2 "中国赴美访学学者J1签证数量") ) ///
			graphregion(fcolor(white)) scheme(s2color)

		 gr export "$tables/AppFigureI1.png", replace 


		////////////////////////////////////
		
		use Teacher_C+E_985visit_v5.3.dta, clear
		
			bys Year: egen EngTotal_sum=sum(EngTotal)
			
			gen Teachercounter=1
			bys Year: egen Teachernum=sum(Teachercounter)
			
			gen Visitcounter=0
				replace Visitcounter=1 if VisitPostA==1
			bys Year: egen Visitnum=sum(Visitcounter)


			gen Visit_America=0
				replace Visit_America=VisitPostA*(Visit1_State==1)
			bys Year: egen Visit_America_num=sum(Visit_America)
			gen Visit_Europe=0
				replace Visit_Europe=1 if VisitPostA*(Visit1_State==3 | Visit1_State==4)
			bys Year: egen Visit_Europe_num=sum(Visit_Europe)
			gen Visit_Asia=0
				replace Visit_Asia=VisitPostA*((Visit1_State==2) | (Visit1_State==5))
			bys Year: egen Visit_Asia_num=sum(Visit_Asia)

			
		duplicates drop Year, force
		
		drop if Year<1990
			
		twoway (scatter EngTotal_sum Year, yaxis(1) msymbol(D) connect(l) msize()) (line Visitnum Year, yaxis(2)) ,legend(label(1 "英文期刊发表总量") label(2 "访问学者累计数量"))  
		graph export $tables/RA0_EngTotal&Visitnum.png ,replace

		gen g1=Visit_America_num
		gen g2=Visit_America_num+Visit_Europe_num
		gen g3=Visit_America_num+Visit_Europe_num+Visit_Asia_num

		label var g3 "亚洲"
		label var g2 "欧洲澳洲"
		label var g1 "北美洲"
			
		//twoway area g3 g2 g1 Year, legend(row(1))  scheme(s1mono) 
		twoway (area g3 g2 g1 Year, yaxis(1) color(maroon dkgreen navy) ytitle("访学人员累计规模"))   (scatter EngTotal_sum Year, yaxis(2) msymbol(D) connect(l) lcolor(black) msize() mcolor(black)  ytitle("各年英文发表量", axis(2))) , ///
			legend(label(4 "英文期刊发表量") )  graphregion(fcolor(white))
 	
		 gr export "$tables/AppFigureI2.png", replace 


	end

/*------------------------------------ End of program  ------------------------------------*/

capture program drop AppFigureIV
	program AppFigureIV


	set scheme s1color

	use Teacher_C+E_985visit_v5.3.dta, clear    	

		egen exact_group = group(FirstYear ID_Faculty)
		bys exact_group: egen tmp_visited=max(EverVisit_A)
		keep if tmp_visited==1

		gen rel_workyr=Year-FirstYear
		keep if rel_workyr>=0 & rel_workyr<=13
		//replace rel_workyr=rel_workyr+1

	 	reg EngTotal ib0.rel_workyr if EverVisit_A == 1 ,  cluster(ID)
	 	est store EverVisit_A1
	 	reg EngTotal ib0.rel_workyr if EverVisit_A == 0 ,  cluster(ID)
	 	est store EverVisit_A0

		coefplot (EverVisit_A1,m(O)) (EverVisit_A0,m(T)), vertical drop(_cons) base  ciopts(color(%10) lcolor(dkgreen) recast(rarea)) ylabel(-0.1(0.05)0.2) ytit("英文期刊发表量") ///
		 	recast(con)  ylabel(, grid) yline(0, lc(dkgreen)) levels(90) xtit("入职年份")  xline(7.5, lp(dash))  legend(label(2 "有访学经历") label(4 "无访学经历") ring(0) pos(11) col(1)) ///
		 	rename(0.rel_workyr = 0 1.rel_workyr = 1 2.rel_workyr = 2 3.rel_workyr = 3 4.rel_workyr = 4 5.rel_workyr = 5 ///
		 	6.rel_workyr = 6 7.rel_workyr = 7 8.rel_workyr = 8 9.rel_workyr = 9 10.rel_workyr = 10 11.rel_workyr = 11 12.rel_workyr = 12 13.rel_workyr = 13 14.rel_workyr = 14)
		 	gr export "$tables/AppFigureIV1a.png", replace 


	use Teacher_C+E_985visit_v5.3.dta, clear    	

		egen exact_group = group(FirstYear ID_Faculty)
		bys exact_group: egen tmp_visited=max(EverVisit_A)
		keep if tmp_visited==1

		gen rel_visit_workyr=Visit1_StartYear-FirstYear
		bys exact_group: egen avg_rel_visit_workyr=mean(rel_visit_workyr)
		replace avg_rel_visit_workyr=round(avg_rel_visit_workyr)

		replace EverVisit_A=!mi(Visit1_StartYear)
		replace Visit1_StartYear=FirstYear+avg_rel_visit_workyr

		gen rel_visityr=Year-Visit1_StartYear

		replace rel_visityr=10 if rel_visityr>=10
		keep if rel_visityr>=-6 & rel_visityr<=10
		replace rel_visityr=rel_visityr+6


	 	reghdfe EngTotal ib5.rel_visityr if EverVisit_A == 1 , a(ID) cluster(ID_Faculty)
	 	est store EverVisit_A1
	 	reghdfe EngTotal ib5.rel_visityr if EverVisit_A == 0 , a(ID)  cluster(ID_Faculty)
	 	est store EverVisit_A0

	 	set scheme s1color
		coefplot (EverVisit_A1,m(O)) (EverVisit_A0,m(T)), vertical drop(_cons) base  ciopts(color(%10) lcolor(dkgreen) recast(rarea)) ylabel(-0.1(0.05)0.2) ytit("英文期刊发表量") ///
		 	recast(con)  ylabel(, grid) yline(0, lc(dkgreen)) levels(90) xtit("相对访学年份")  xline(6.5, lp(dash))  legend(label(2 "有访学经历") label(4 "无访学经历") ring(0) pos(11) col(1)) ///
		 	rename(0.rel_visityr = -6 1.rel_visityr = -5 2.rel_visityr = -4 3.rel_visityr = -3 4.rel_visityr = -2 5.rel_visityr = -1 ///
		 	6.rel_visityr = 0 7.rel_visityr = 1 8.rel_visityr = 2 9.rel_visityr = 3 10.rel_visityr = 4 11.rel_visityr = 5 12.rel_visityr = 6 ///
		 	13.rel_visityr = 7 14.rel_visityr = 8 15.rel_visityr = 9 16.rel_visityr = 10 )
			gr export "$tables/AppFigureIV1b.png", replace 

	end

/*------------------------------------ End of program  ------------------------------------*/

capture program drop AppTableV1	
	program AppTableV1
		
	use Teacher_C+E_985visit_v5.3.dta, clear 

		merge 1:1 ID Year using tomerge-Citation.dta, gen(m_cit)
			//source:/Users/lqf/Desktop/Project_Tenure/Working_data/tomerge-Citation.dta
		drop if m_cit==2
		foreach var of varlist eng_citation eng_quantile eng_percitation eng_perquantile {
		replace `var'=0 if m_cit==1
		replace `var'=0 if EngTotal==0
		}
		foreach var of varlist  eng_quantile  eng_perquantile {
		replace `var'=`var'*100
		}

		merge 1:1 ID Year using Pub_ABS2021.dta, gen(m_abs)
		drop if m_abs==2

		foreach w in abs4 abs3 abs2 abs1 {

			replace `w'=0 if mi(`w')
		}

		gen abs0=EngTotal-abs4-abs3-abs2-abs1

		gen abs_all=abs4+abs3+abs2+abs1

		est clear

		foreach var of varlist SSCI IF eng_citation eng_quantile eng_percitation eng_perquantile abs_all {
		
			reghdfe `var' VisitPostA , absorb(i.ID i.ID_Faculty#i.Year i.t ) $vce	
				estadd local ID_FE "Yes",replace
				estadd local Year_FE "Yes",replace
				estadd local SchoolYear_FE "Yes",replace
				estadd local Cluster "ID",replace
				estadd local WorkYear_FE "Yes",replace
				est store m1_`var'
		}



		reghdfe EngTotal VisitPostA  , absorb(i.ID i.ID_Faculty#i.Year i.t ) cluster(ID_Faculty)
				estadd local ID_FE "Yes",replace
				estadd local Year_FE "Yes",replace
				estadd local SchoolYear_FE "Yes",replace
				estadd local Cluster "School",replace
				estadd local WorkYear_FE "Yes",replace
				est store m2_1


		capture drop EngTotal_asinh
		gen EngTotal_asinh=asinh(EngTotal)

		reghdfe EngTotal_asinh VisitPostA   , absorb(i.ID i.ID_Faculty#i.Year i.t ) $vce
				estadd local ID_FE "Yes",replace
				estadd local Year_FE "Yes",replace
				estadd local SchoolYear_FE "Yes",replace
				estadd local Cluster "ID",replace
				estadd local WorkYear_FE "Yes",replace
			est store m2_2


		preserve
		
		//drop if inlist(ID_Faculty,1,2,3,4) //清北
		keep if FirstYear>2000

		reghdfe EngTotal VisitPostA  , absorb(i.ID i.ID_Faculty#i.Year i.t ) $vce
				estadd local ID_FE "Yes",replace
				estadd local Year_FE "Yes",replace
				estadd local SchoolYear_FE "Yes",replace
				estadd local Cluster "ID",replace
				estadd local WorkYear_FE "Yes",replace
			est store m2_3
		restore



		preserve
		
		drop if inlist(ID_Faculty,1,2,3,4) //清北
		//keep if t<=15
		//drop if !mi(Visit2_StartYear)

		reghdfe EngTotal VisitPostA  , absorb(i.ID i.ID_Faculty#i.Year i.t ) $vce
				estadd local ID_FE "Yes",replace
				estadd local Year_FE "Yes",replace
				estadd local SchoolYear_FE "Yes",replace
				estadd local Cluster "ID",replace
				estadd local WorkYear_FE "Yes",replace
			est store m2_4
		restore


		merge m:1 ID using PSM_weight1.dta, nogen
		merge m:1 ID using CEM_weight1.dta, nogen


		foreach var of varlist EngTotal{
					
			reghdfe `var' VisitPostA   [pw=psmw], absorb(i.ID i.ID_Faculty#i.Year i.t ) $vce
				estadd local ID_FE "Yes",replace
				estadd local Year_FE "Yes",replace
				estadd local SchoolYear_FE "Yes",replace
				estadd local Cluster "ID",replace
				estadd local WorkYear_FE "Yes",replace
	 			est store m2_5
				
			reghdfe `var' VisitPostA   [pw=cem_weights], absorb(i.ID i.ID_Faculty#i.Year i.t ) $vce
				estadd local ID_FE "Yes",replace
				estadd local Year_FE "Yes",replace
				estadd local SchoolYear_FE "Yes",replace
				estadd local Cluster "ID",replace
				estadd local WorkYear_FE "Yes",replace
	 			est store m2_6

		}

		gen D_EngTotal=EngTotal>0

		reghdfe D_EngTotal VisitPostA , absorb(i.ID i.ID_Faculty#i.Year i.t) $vce
			estadd local ID_FE "Yes",replace
			estadd local Year_FE "Yes",replace
			estadd local SchoolYear_FE "Yes",replace
			estadd local Cluster "ID",replace
			estadd local WorkYear_FE "Yes",replace
		est store m2_7


		local s  "using $tables/AppTableV1_PanelA.rtf"  // 输出到word文档
		local m  "m1_*"        // 模型名称
		
		esttab `m' `s', b(%7.3f) t(%7.3f) compress nogap se  ///
			star(* 0.1 ** 0.05 *** 0.01) ///
			stats(ID_FE Year_FE  WorkYear_FE SchoolYear_FE Cluster N r2_a r2_p, fmt(%3s %3s %3s %3s %6s %12.0f %9.3f %9.3f)) ///
			order(VisitPostA ) ///
			mtitles() ///
			title("Table1 Impact on `var'") replace


		local s  "using $tables/AppTableV1_PanelB.rtf"  // 输出到word文档
		local m  "m2_*"        // 模型名称
		
		esttab `m' `s', b(%7.3f) t(%7.3f) compress nogap se  ///
			star(* 0.1 ** 0.05 *** 0.01) ///
			stats(ID_FE Year_FE  WorkYear_FE SchoolYear_FE Cluster N r2_a r2_p, fmt(%3s %3s %3s %3s %6s %12.0f %9.3f %9.3f)) ///
			order(VisitPostA ) ///
			mtitles() ///
			title("Table1 Impact on `var'") replace

	end

/*------------------------------------ End of program  ------------------------------------*/

capture program drop AppTableV2
	program AppTableV2

	use Teacher_C+E_985visit_v5.3.dta, clear  

		*排除晋升前影响：
			//Restricted Sample:  
				//距离职称评定较远的群体
				//同学院、同一年入职的群体
			//加入 i.FirstYear#i.Year FE 


		egen exact_group = group(FirstYear ID_Faculty)
		bys exact_group: egen tmp_visited=max(EverVisit_A)
		*keep if tmp_visited==1
		*drop tmp_visited //47,102->23,847


 			foreach var of varlist 系主任 院长助理 院党委副书记 院党委书记 副院长 院长 {
				capture gen `var'_Year=substr(`var', 1,4)
				tab `var'_Year
				capture destring `var'_Year,replace
				capture gen `var'_Year_Post=0
				replace `var'_Year_Post=(Year>`var'_Year) if `var'_Year!=1
			}
			
			rename 系主任_Year_Post DeptDirector_Post 

			local Title "VP_Year_Post Prof_Year_Post DeptDirector_Post 院长助理_Year_Post 院党委副书记_Year_Post 院党委书记_Year_Post 副院长_Year_Post 院长_Year_Post"
			sum `Title'

		est clear
		foreach var of varlist EngTotal { //NonSSCI EngTotal



				******************************
				preserve
					gen YearToVP=Year-VP_Year
		 			gen YearToProf=Year-Prof_Year

		 			drop if inlist(YearToVP,0,-1,-2)
		 			drop if inlist(YearToProf,0,-1,-2)

					reghdfe `var' VisitPostA , absorb(i.ID i.ID_Faculty#i.Year i.t) $vce
						estadd local ID_FE "Yes",replace
						estadd local Year_FE "Yes",replace
						estadd local WorkYear_FE "Yes",replace
						estadd local SchoolYear_FE "Yes",replace
						estadd local CohortYear_FE "No",replace
		 				est store m_`var'1

				restore

				******************************
				*- 基于入职时间，大致定义临近晋升的年份（例如入职后五年或者基于样本中实际观察的晋升时间），
				*- 并基于此排除靠近待晋升考核年份的样本

		 		preserve

		 			cap drop VisitYearsToVP
		 			cap drop VisitYearsToProf

		 			gen VisitYearsToVP=Visit1_StartYear-VP_Year
		 			gen VisitYearsToProf=Visit1_StartYear-Prof_Year
		 			gen VisitYearsToEnt=Visit1_StartYear-FirstYear


		 			drop if inlist(VisitYearsToVP,0,-1,-2)
		 			drop if inlist(VisitYearsToProf,0,-1,-2)
		 			drop if inlist(VisitYearsToEnt,4,5,6)

					reghdfe `var' VisitPostA , absorb(i.ID i.ID_Faculty#i.Year i.t) $vce
						estadd local ID_FE "Yes",replace
						estadd local Year_FE "Yes",replace
						estadd local WorkYear_FE "Yes",replace
						estadd local SchoolYear_FE "Yes",replace
						estadd local CohortYear_FE "No",replace
		 				est store m_`var'2
		 		restore


		 		******************************

					reghdfe `var' VisitPostA if tmp_visited==1, absorb(i.ID i.ID_Faculty#i.Year i.t i.exact_group#i.Year) $vce
						estadd local ID_FE "Yes",replace
						estadd local Year_FE "Yes",replace
						estadd local WorkYear_FE "Yes",replace
						estadd local SchoolYear_FE "Yes",replace
						estadd local CohortYear_FE "Yes",replace
		 				est store m_`var'3


		 		******************************

					reghdfe `var' VisitPostA VP_Year_Post Prof_Year_Post, absorb(i.ID i.ID_Faculty#i.Year i.t ) $vce
						estadd local ID_FE "Yes",replace
						estadd local Year_FE "Yes",replace
						estadd local WorkYear_FE "Yes",replace
						estadd local SchoolYear_FE "Yes",replace
						estadd local CohortYear_FE "No",replace
		 				est store m_`var'4

		 		******************************

		 			reghdfe `var' VisitPostA `Title', absorb(i.ID i.ID_Faculty#i.Year i.t ) $vce
						estadd local ID_FE "Yes",replace
						estadd local Year_FE "Yes",replace
						estadd local WorkYear_FE "Yes",replace
						estadd local SchoolYear_FE "Yes",replace
						estadd local CohortYear_FE "No",replace
		 				est store m_`var'5

		 
		 		}

				local s  "using $tables/AppTableV2.rtf"  // 输出到word文档
				local m  "*"        // 模型名称
				
				esttab `m' `s', b(%7.3f) t(%7.3f) compress nogap se  ///
					star(* 0.1 ** 0.05 *** 0.01) ///
					stats(ID_FE Year_FE WorkYear_FE SchoolYear_FE CohortYear_FE N r2_a, fmt(%3s %3s %3s %3s %3s %12.0f %9.3f)) ///
					title("Table1 Impact on `var'") replace

				//mtitles("去掉晋升前三年内的发表" "去掉晋升前三年内访学的群体" "与同学院同年入职教师比较" "控制职称变量" "综合") ///


	end

/*------------------------------------ End of program  ------------------------------------*/

capture program drop AppFigureV1		
	program AppFigureV1
	
	/*
	
	use Teacher_C+E_985visit_v5.3.dta, clear 
			duplicates drop ID, force
			g id= _n
			keep id ID YearsBeforeVisit
		save $working_data/placebo/real_YearsBeforeVisit, replace
		
		
		local reps=1000
		set seed 10101
		forvalue i=1/`reps'{
		
			use Teacher_C+E_985visit_v5.3.dta, clear 
				duplicates drop ID, force
				gen random_digit= runiform() 
				sort random_digit 
				g random_id= _n  
				keep YearsBeforeVisit random_id
				rename YearsBeforeVisit random_YearsBeforeVisit
				rename random_id id
			save $working_data/placebo/random_YearsBeforeVisit, replace
		
			*- 合并，回归，提取系数
			use Teacher_C+E_985visit_v5.3.dta, clear
				merge m:1 ID using $working_data/placebo/real_YearsBeforeVisit,nogen		
				merge m:1 id using $working_data/placebo/random_YearsBeforeVisit,nogen		
				
				bys ID: egen MaxWorkYear=max(t)
				gen random_VisitPostA=0
					replace random_VisitPostA=1 if Year>random_YearsBeforeVisit+FirstYear-1
				//  gen random_YearsBeforeVisit2 = floor((MaxWorkYear-1+1)*runiform()+1)
				// 	gen random_VisitPostA2=0
				// 	replace random_VisitPostA2=1 if Year>random_YearsBeforeVisit2+FirstYear-1 & !mi(random_YearsBeforeVisit)
					
				keep EngTotal random_VisitPostA ID ID_Faculty Year t VisitPostA  FirstYear VP_Year_Post Prof_Year_Post
			
				foreach var of varlist EngTotal {	
					foreach x of var VisitPostA  {
					
						qui reghdfe `var' random_`x' , absorb(i.ID i.ID_Faculty#i.Year i.t i.FirstYear) $vce //VP_Year_Post Prof_Year_Post
						g `var'_b_random_`x'= _b[random_`x']  
						*提取x的回归系数
						g `var'_se_random_`x'= _se[random_`x'] 
						
					}
					
					qui reghdfe `var' VisitPostA , absorb(i.ID i.ID_Faculty#i.Year i.t i.FirstYear) $vce //VP_Year_Post Prof_Year_Post
					g `var'_b_VisitPostA= _b[VisitPostA]  
					*提取x的回归系数
					g `var'_se_VisitPostA= _se[VisitPostA] 	
						
				}
				*提取x的标准误
				keep *_b_random_VisitPostA  *_se_random_VisitPostA *_b_VisitPostA *_se_VisitPostA
				keep if _n==1 
				save $working_data/placebo/placebo`i', replace  
				*把第i次placebo检验的系数和标准误存起来
			}

		*- 纵向合并1000次的系数和标准误 
		
		use $working_data/placebo/placebo1, clear
			forvalue i=2/500{
				append using $working_data/placebo/placebo`i'
				*纵向合并1000次回归的系数及标准误
			}  
		save $working_data/placebo/placebo0 , replace

		*/
		use $working_data/placebo/placebo0 , clear
		local reps=500
		//keep if sortid<=`reps'
		foreach var of newlist  EngTotal {
		disp 1
  		gen `var'_random_tvalue1= `var'_b_random_VisitPostA / `var'_se_random_VisitPostA
     			local `var'_tvalue1= `var'_b_VisitPostA[1]/ `var'_se_VisitPostA[1]
     			gen `var'_pcount1=(`var'_b_VisitPostA[1]<`var'_b_random_VisitPostA) 
     			egen `var'_ptotal1=sum(`var'_pcount1)
     			local `var'_pvalue1=`var'_ptotal1[1]/`reps'
    			sum `var'_b_random_VisitPostA
			
     			dpplot `var'_b_random_VisitPostA , plot(histogram `var'_b_random_VisitPostA, bcolor(none) width(0.005) fcolor(none))  ms(oh) color(none) ///
     			xlabel (0 "0" 0.037 "0.037")  xline(0,lpattern(dash)) xline(0.037)  param(`r(mean)' `r(sd)') gen(density1 density2) ms(oh) sub("") ///
     			xtitle("回归系数") ytitle("概率密度") graphregion(fcolor(white)) 	plotregion(lcolor(black)) //scheme(burd)
			
     			graph export $tables/AppFigureV1.png, replace
     			//twoway scatter T3_Up_random_tvalue pdf, msize(vsmall) xline(4.011) graphregion(fcolor(white)) ytitle("PDF") 
		}

		cd $working_data

	
	end
	
/*------------------------------------ End of program  ------------------------------------*/

capture program drop AppTableVI1
	program AppTableVI1


	use Teacher_C+E_985visit_v5.3.dta, clear

		merge 1:1 ID Year using Pub_ABS2021.dta, gen(m_abs)
			drop if m_abs==2
			foreach w in abs4 abs3 abs2 abs1 {
				replace `w'=0 if mi(`w')
			}
			gen abs0=EngTotal-abs4-abs3-abs2-abs1
			gen abs_all=abs4+abs3+abs2+abs1
			replace abs4=abs3+abs4


		drop if  mi(Visit1_Rank) & !mi(Visit1_StartYear)

		gen TA1_EngTotal=TA1_SSCI+TA1_NonSSCI
		gen TA2_EngTotal=TA2_SSCI+TA2_NonSSCI
		gen TA3_EngTotal=TA3_SSCI+TA3_NonSSCI
		gen FN_EngTotal=FN_SSCI+FN_NonSSCI
		gen NoFN_EngTotal = TA2_EngTotal- FN_EngTotal
		gen EngTotal_ColleageCoop=SSCI_ColleageCoop+NonSSCI_ColleageCoop

		capture drop m1
		merge 1:1 ID Year using Visit_DirectCoop.dta, gen(m1)
		drop if m1==2
		drop m1
		gen EngTotal_DirectCoop=DirectCoop_num
			replace EngTotal_DirectCoop=0 if mi(EngTotal_DirectCoop)
		gen EngTotal_NoDirectCoop=EngTotal-EngTotal_DirectCoop

		merge m:1 UniverName using THE_econ_ChinaPart.dta, gen(m1)
		drop if m1==2
		drop m1
		rename Rank HomeRank
		replace HomeRank=600 if mi(HomeRank)

		gen LevelGap=Visit1_Rank-HomeRank if !mi(Visit1_StartYear)

		tab LevelGap if t==1 & !mi(Visit1_StartYear) ,mi
		sum LevelGap ,detail // if t==1 & !mi(Visit1_StartYear),detail
			
		gen LevelGap_abs=abs(LevelGap)
		sum LevelGap_abs, detail

			//1:1:1

			
			local rank1 -600
			local rank2 -374.5
			local rank3 -41 
			local rank4 600 
			local range1 "差距小"
			local range2 "差距大"
			local range3 [66,100]
			local rank_mid 260.5 //-162.5 //-149.5

			/* 
			local rank1 -600
			local rank2 -50
			local rank3 50
			local rank4 600   */


			capture drop VisitPostA_LevelGap_bin* 
			gen VisitPostA_LevelGap_bin1=0
				replace VisitPostA_LevelGap_bin1=1 if VisitPostA==1 & LevelGap_abs>0 & LevelGap_abs<=`rank_mid'
			gen VisitPostA_LevelGap_bin2=0
				replace VisitPostA_LevelGap_bin2=1 if VisitPostA==1 & LevelGap_abs>`rank_mid' & LevelGap_abs<`rank4'

			est clear
			foreach var of varlist abs4 abs2 abs1 abs0 { 
				reghdfe `var' VisitPostA_LevelGap_bin*   , absorb(i.ID i.ID_Faculty#i.Year i.t) 
					est store m_`var'
			
			}		

				local s  "using $tables/AppTableVI1.rtf"  // 输出到word文档
				local m  "*"        // 模型名称
				
				esttab `m' `s', b(%7.3f) t(%7.3f) compress nogap se  ///
					star(* 0.1 ** 0.05 *** 0.01) ///
					stats(ID_FE Year_FE WorkYear_FE SchoolYear_FE N r2_a widstat, fmt(%3s %3s %3s %3s %12.0f %9.3f %9.3f)) ///
					title("Table1 Impact on `var'") replace
	end

/*------------------------------------ End of program  ------------------------------------*/

capture program drop AppFigureVI1
	program AppFigureVI1



	use Teacher_C+E_985visit_v5.3.dta, clear



		gen TA1_EngTotal=TA1_SSCI+TA1_NonSSCI
		gen TA2_EngTotal=TA2_SSCI+TA2_NonSSCI
		gen TA3_EngTotal=TA3_SSCI+TA3_NonSSCI
		gen FN_EngTotal=FN_SSCI+FN_NonSSCI
		gen NoFN_EngTotal = TA2_EngTotal- FN_EngTotal
		gen EngTotal_ColleageCoop=SSCI_ColleageCoop+NonSSCI_ColleageCoop

		gen temp3_EngTotal=EngTotal
			replace temp3_EngTotal=0 if VisitPostA==1 | Year-Visit1_StartYear<-3
		bys ID : egen pre3mean_EngTotal=total(temp3_EngTotal)
		gen VisitPostA_pre3_EngTotal=VisitPostA*pre3mean_EngTotal

		capture drop m1
		merge 1:1 ID Year using Visit_DirectCoop.dta, gen(m1)
		drop if m1==2
		drop m1
		gen EngTotal_DirectCoop=DirectCoop_num
			replace EngTotal_DirectCoop=0 if mi(EngTotal_DirectCoop)
		gen EngTotal_NoDirectCoop=EngTotal-EngTotal_DirectCoop

		gen VisitPostAs=VisitPostA*pre3mean_EngTotal

		preserve

				keep if t==1
				keep if !mi(Visit1_StartYear)
				gen rank_t1=(Visit1_Rank>0 & Visit1_Rank<=50)
				reg Visit1_Rank pre3mean_EngTotal, robust
				reg rank_t1 pre3mean_EngTotal, robust

		restore

		gen Visit_NonUniv=0
			replace Visit_NonUniv=1 if inlist(Visit1_Univ, "FAU政府采购研究中心", "世界银行经济发展学院", "芬兰央行", "金融管理局")
			replace Visit_NonUniv=1 if inlist(Visit1_Univ, "林肯金融集团(Lincoln Financial Group)", "世界银行经济发展学院", "美国国家大气研究中心","Federal Reserve Bank of Atlanta ")
			replace Visit_NonUniv=1 if inlist(Visit1_Univ, "瑞士联邦理工学院（EPFL）伯努利研究中心","联合国大学-世界经济发展研究院","中央研究院")
		
		capture drop VisitPostA_Rank_bin* 
		capture drop university1
		// 		gen university1 = ustrregexs(0) if ustrregexm(Visit1_Univ,"[\u4e00-\u9fa5]+")	
			

			gen VisitPostA_Rank_bin1=0
				replace VisitPostA_Rank_bin1=1 if VisitPostA==1 & Visit1_Rank>0 & Visit1_Rank<=50
			gen VisitPostA_Rank_bin2=0
				replace VisitPostA_Rank_bin2=1 if VisitPostA==1 & Visit1_Rank>50 & Visit1_Rank<=300
			gen VisitPostA_Rank_bin3=0
				replace VisitPostA_Rank_bin3=1 if VisitPostA==1 & Visit1_Rank>300 & !mi(Visit1_Rank) & !mi(Visit1_StartYear)
							
		//	gen VisitPostA_Rank_bin4=0 
		//		replace VisitPostA_Rank_bin4=1 if VisitPostA==1 & Visit_NonUniv==1
			
			
		// 		& Visit1_Rank<700
		//  		gen VisitPostA_Rank_bin6=0
		//  			replace VisitPostA_Rank_bin6=1 if VisitPostA==1 & Visit1_Rank>700 & !mi(Visit1_Rank)
		//  		gen VisitPostA_Rank_bin7=0
		// 			replace VisitPostA_Rank_bin7=1 if VisitPostA==1 & mi(Visit1_Rank)	

			est clear
			foreach var of varlist EngTotal { 
				reghdfe `var' VisitPostA_Rank_bin*  VisitPostA_pre3_EngTotal , absorb(i.ID i.ID_Faculty#i.Year i.t) $vce
					est store m_1
			
				coefplot, keep(VisitPostA_Rank_bin*) ///
					  coeflabels( ///
								VisitPostA_Rank_bin1 = "[1,50]" ///
								VisitPostA_Rank_bin2 = "(50,300]" ///
								VisitPostA_Rank_bin3 = ">300" ///
								 )                       ///
					  lev(90) vertical                                                                          ///
					  yline(0)                                                                          ///
					  ytitle("英文总发表",size(large))                                                               ///
					  xtitle("")                                                               ///
					  addplot(line @b @at)                                                              ///
					  ciopts(recast(rcap))                                                              ///
					  rescale()                                                                      ///
					  scheme(s1mono) 
				qui	  graph save $tables/RE5_`var'.gph, replace 
				*qui graph export $tables/RC3_Coop_Spill2_`var'.png, replace
			}		

			est clear
			foreach var of varlist EngTotal_NoDirectCoop  { 
				reghdfe `var' VisitPostA_Rank_bin*  VisitPostA_pre3_EngTotal , absorb(i.ID i.ID_Faculty#i.Year i.t) $vce
					est store m_1
			
				coefplot, keep(VisitPostA_Rank_bin*) ///
					  coeflabels( ///
								VisitPostA_Rank_bin1 = "[1,50]" ///
								VisitPostA_Rank_bin2 = "(50,300]" ///
								VisitPostA_Rank_bin3 = ">300" ///
								 )                       ///
					  lev(90) vertical                                                                          ///
					  yline(0)                                                                          ///
					  ytitle("非直接合作",size(large))                                                               ///
					  xtitle("")                                                               ///
					  addplot(line @b @at)                                                              ///
					  ciopts(recast(rcap))                                                              ///
					  rescale()                                                                      ///
					  scheme(s1mono) 
				qui	  graph save $tables/RE5_`var'.gph, replace 
				*qui graph export $tables/RC3_Coop_Spill2_`var'.png, replace
			}

			est clear
			foreach var of varlist EngTotal_DirectCoop  { 
				reghdfe `var' VisitPostA_Rank_bin*  VisitPostA_pre3_EngTotal , absorb(i.ID i.ID_Faculty#i.Year i.t) $vce
					est store m_1
			
				coefplot, keep(VisitPostA_Rank_bin*) ///
					  coeflabels( ///
								VisitPostA_Rank_bin1 = "[1,50]" ///
								VisitPostA_Rank_bin2 = "(50,300]" ///
								VisitPostA_Rank_bin3 = ">300" ///
								 )                       ///
					  lev(90) vertical                                                                          ///
					  yline(0)                                                                          ///
					  ytitle("同访学学校直接合作",size(large))                                                               ///
					  xtitle("")                                                               ///
					  addplot(line @b @at)                                                              ///
					  ciopts(recast(rcap))                                                              ///
					  rescale()                                                                      ///
					  scheme(s1mono) 
				qui	  graph save $tables/RE5_`var'.gph, replace 
				*qui graph export $tables/RC3_Coop_Spill2_`var'.png, replace
			}
			
		gr combine $tables/RE5_EngTotal.gph $tables/RE5_EngTotal_NoDirectCoop.gph $tables/RE5_EngTotal_DirectCoop.gph, ///
		ycommon rows(1) b1title("访学学校排名",size(large)) graphregion(fcolor(white))
		gr export "$tables/AppFigureVI1a.png", width(3000) replace


	/*----------------------------------------------------*/
	   /* [>   3.  Effect by LevelGap   <] */ 
	/*----------------------------------------------------*/

	use Teacher_C+E_985visit_v5.3.dta, clear

		drop if  mi(Visit1_Rank) & !mi(Visit1_StartYear)

		gen TA1_EngTotal=TA1_SSCI+TA1_NonSSCI
		gen TA2_EngTotal=TA2_SSCI+TA2_NonSSCI
		gen TA3_EngTotal=TA3_SSCI+TA3_NonSSCI
		gen FN_EngTotal=FN_SSCI+FN_NonSSCI
		gen NoFN_EngTotal = TA2_EngTotal- FN_EngTotal
		gen EngTotal_ColleageCoop=SSCI_ColleageCoop+NonSSCI_ColleageCoop


		gen temp3_EngTotal=EngTotal
			replace temp3_EngTotal=0 if VisitPostA==1 | Year-Visit1_StartYear<-3
		bys ID : egen pre3mean_EngTotal=total(temp3_EngTotal)
		gen VisitPostA_pre3_EngTotal=VisitPostA*pre3mean_EngTotal

		capture drop m1
		merge 1:1 ID Year using Visit_DirectCoop.dta, gen(m1)
		drop if m1==2
		drop m1
		gen EngTotal_DirectCoop=DirectCoop_num
			replace EngTotal_DirectCoop=0 if mi(EngTotal_DirectCoop)
		gen EngTotal_NoDirectCoop=EngTotal-EngTotal_DirectCoop

		merge m:1 UniverName using THE_econ_ChinaPart.dta, gen(m1)
		drop if m1==2
		drop m1
		rename Rank HomeRank
		replace HomeRank=600 if mi(HomeRank)

		gen LevelGap=Visit1_Rank-HomeRank if !mi(Visit1_StartYear)

		tab LevelGap if t==1 & !mi(Visit1_StartYear) ,mi
		sum LevelGap ,detail // if t==1 & !mi(Visit1_StartYear),detail
			
			/* 		                LevelGap
			-------------------------------------------------------------
			      Percentiles      Smallest
			 1%         -599           -599
			 5%         -592           -599
			10%         -585           -599       Obs               9,897
			25%         -513           -599       Sum of wgt.       9,897

			50%       -149.5                      Mean          -189.6989
			                        Largest       Std. dev.      308.1001
			75%            0            577
			90%        249.5            577       Variance       94925.68
			95%          462            577       Skewness       .4269711
			99%          577            577       Kurtosis       2.557237 */
			
		gen LevelGap_abs=abs(LevelGap)
		sum LevelGap_abs, detail
			
		 



			//1:1:1

			
			local rank1 -600
			local rank2 -374.5
			local rank3 -41 
			local rank4 600 
			local range1 "[0,50]"
			local range2 "(50,100]"
			local range3 [66,100]
			local rank_mid 260.5 //-162.5 //-149.5

			/* 
			local rank1 -600
			local rank2 -50
			local rank3 50
			local rank4 600   */


			capture drop VisitPostA_LevelGap_bin* 
			gen VisitPostA_LevelGap_bin1=0
				replace VisitPostA_LevelGap_bin1=1 if VisitPostA==1 & LevelGap_abs>0 & LevelGap_abs<=`rank_mid'
			gen VisitPostA_LevelGap_bin2=0
				replace VisitPostA_LevelGap_bin2=1 if VisitPostA==1 & LevelGap_abs>`rank_mid' & LevelGap_abs<`rank4'

			est clear
			foreach var of varlist EngTotal { 
				reghdfe `var' VisitPostA_LevelGap_bin*  VisitPostA_pre3_EngTotal , absorb(i.ID i.ID_Faculty#i.Year i.t) $vce
					est store m_1
			
				coefplot, keep(VisitPostA_LevelGap_bin*) ///
					  coeflabels( ///
								VisitPostA_LevelGap_bin1 = "差距小" ///
								VisitPostA_LevelGap_bin2 = "差距大" ///
								 )                       ///
					  lev(90) vertical                                                                          ///
					  yline(0)                                                                          ///
					  ytitle("英文总发表",size(large))                                                               ///
					  xtitle("")                                                               ///
					  addplot(line @b @at)                                                              ///
					  ciopts(recast(rcap))                                                              ///
					  rescale()                                                                      ///
					  scheme(s1mono) 
				qui	  graph save $tables/RE5_`var'.gph, replace 
				*qui graph export $tables/RC3_Coop_Spill3_`var'.png, replace
			}		

			est clear
			foreach var of varlist EngTotal_NoDirectCoop  { 
				reghdfe `var' VisitPostA_LevelGap_bin*  VisitPostA_pre3_EngTotal , absorb(i.ID i.ID_Faculty#i.Year i.t) $vce
					est store m_1
			
				coefplot, keep(VisitPostA_LevelGap_bin*) ///
					  coeflabels( ///
								VisitPostA_LevelGap_bin1 = "差距小" ///
								VisitPostA_LevelGap_bin2 = "差距大" ///
								 )                       ///
					  lev(90) vertical                                                                          ///
					  yline(0)                                                                          ///
					  ytitle("非直接合作",size(large))                                                               ///
					  xtitle("")                                                               ///
					  addplot(line @b @at)                                                              ///
					  ciopts(recast(rcap))                                                              ///
					  rescale()                                                                      ///
					  scheme(s1mono) 
				qui	  graph save $tables/RE5_`var'.gph, replace 
				*qui graph export $tables/RC3_Coop_Spill3_`var'.png, replace
			}

			est clear
			foreach var of varlist EngTotal_DirectCoop  { 
				reghdfe `var' VisitPostA_LevelGap_bin*  VisitPostA_pre3_EngTotal , absorb(i.ID i.ID_Faculty#i.Year i.t) $vce
					est store m_1
			
				coefplot, keep(VisitPostA_LevelGap_bin*) ///
					  coeflabels( ///
								VisitPostA_LevelGap_bin1 = "差距小" ///
								VisitPostA_LevelGap_bin2 = "差距大" ///
								 )                       ///
					  lev(90) vertical                                                                          ///
					  yline(0)                                                                          ///
					  ytitle("同访学学校直接合作",size(large))                                                               ///
					  xtitle("")                                                               ///
					  addplot(line @b @at)                                                              ///
					  ciopts(recast(rcap))                                                              ///
					  rescale()                                                                      ///
					  scheme(s1mono) 
				qui	  graph save $tables/RE5_`var'.gph, replace 
				*qui graph export $tables/RC3_Coop_Spill3_`var'.png, replace
			}
			
		gr combine $tables/RE5_EngTotal.gph $tables/RE5_EngTotal_NoDirectCoop.gph $tables/RE5_EngTotal_DirectCoop.gph, ///
		ycommon rows(1) b1title("访学学校排名与本校排名差",size(large)) graphregion(fcolor(white))
		gr export "$tables/AppFigureVI1b.png", width(3000) replace
		


	end
/*------------------------------------ End of program  ------------------------------------*/

capture program drop AppFigureVI2
	program AppFigureVI2

	use Teacher_C+E_985visit_v5.3.dta, clear
	 
		gen TA1_EngTotal=TA1_SSCI+TA1_NonSSCI
		gen TA2_EngTotal=TA2_SSCI+TA2_NonSSCI
		gen TA3_EngTotal=TA3_SSCI+TA3_NonSSCI
		gen FN_EngTotal=FN_SSCI+FN_NonSSCI
		gen NoFN_EngTotal = TA2_EngTotal- FN_EngTotal
		gen EngTotal_ColleageCoop=SSCI_ColleageCoop+NonSSCI_ColleageCoop

		capture drop m1
		merge 1:1 ID Year using Visit_DirectCoop.dta, gen(m1)
		drop if m1==2
		drop m1
		gen EngTotal_DirectCoop=DirectCoop_num
			replace EngTotal_DirectCoop=0 if mi(EngTotal_DirectCoop)
		gen EngTotal_NoDirectCoop=EngTotal-EngTotal_DirectCoop

		merge 1:1 ID Year using 合作者Pub, gen(visit_co)
		drop if visit_co==2

		gen temp_EngTotal=co_EngTotal
			replace temp_EngTotal=. if VisitPostA==1
		bys ID : egen premean_EngTotal=mean(temp_EngTotal)


		gen temp3_EngTotal=co_EngTotal
			replace temp3_EngTotal=0 if VisitPostA==1 | Year-Visit1_StartYear<-3
			replace temp3_EngTotal=0 if mi(temp3_EngTotal)
		bys ID : egen pre3mean_EngTotal=total(temp3_EngTotal)


		gen VisitPostA_pre=VisitPostA*premean_EngTotal
		gen VisitPostA_pre3=VisitPostA*pre3mean_EngTotal			

		capture drop VisitPostA_Rank_bin* 
			local a 11
			local b 23

			cap drop VisitPostA_Rank_bin*
			gen VisitPostA_Rank_bin1=0
				replace VisitPostA_Rank_bin1=1 if VisitPostA==1 & pre3mean_EngTotal<=`a'
			gen VisitPostA_Rank_bin2=0
				replace VisitPostA_Rank_bin2=1 if VisitPostA==1 & pre3mean_EngTotal>`a' & pre3mean_EngTotal<=`b'
			gen VisitPostA_Rank_bin3=0
				replace VisitPostA_Rank_bin3=1 if VisitPostA==1 & pre3mean_EngTotal>`b'


			est clear
			foreach var of varlist  EngTotal_DirectCoop   { 
				reghdfe `var' VisitPostA_Rank_bin*  , absorb(i.ID i.ID_Faculty#i.Year i.t) $vce
					est store m_1
			
				coefplot, keep(VisitPostA_Rank_bin*) ///
					  coeflabels( ///
								VisitPostA_Rank_bin1 = "低" ///
								VisitPostA_Rank_bin2 = "中" ///
								VisitPostA_Rank_bin3 = "高" ///
								 )                       ///
					  lev(90) vertical                                                                          ///
					  yline(0)                                                                          ///
					  ytitle("",size(large))                                                               ///
					  xtitle("")                                                               ///
					  addplot(line @b @at)                                                              ///
					  ciopts(recast(rcap))                                                              ///
					  rescale()                                                                      ///
					  scheme(s1mono) 
				graph export $tables/AppFigureVI2.png, replace
			}
	end

/*------------------------------------ End of program  ------------------------------------*/

capture program drop AppTableVII1
	program AppTableVII1

 
	/*----------------------------------------------------*/
	   /* [>   2.1.  中文发表   <] */ 
	/*----------------------------------------------------*/

	use Teacher_C+E_985visit_v5.3.dta, clear


		est clear
		foreach var of varlist Top9_Up CSSCI ChiCore ChiTotal { //CSSCI SSCI NonSSCI A_plus A B C D E Others_Eng Top3 Top9 ChiCore Top3 Top9 CSSCI_Down ChiTotal 
			reghdfe `var' VisitPostA  , absorb(i.ID i.ID_Faculty#i.Year i.t ) $vce
				estadd local ID_FE "Yes",replace
				estadd local Year_FE "Yes",replace
				estadd local SchoolYear_FE "Yes",replace
				estadd local Cluster "ID",replace
				estadd local WorkYear_FE "Yes",replace
				est store m_`var'
		}
			
		*local s  "using $tables/RE3_Chinese.rtf"  // 输出到word文档
		local s  "using $tables/AppTableVII1_PanelA.csv"  // 输出到word文档
		local m  "*"        // 模型名称
		esttab `m' `s', b(%7.3f) t(%7.3f) compress nogap se  ///
			star(* 0.1 ** 0.05 *** 0.01) ///
			stats(ID_FE Year_FE SchoolYear_FE WorkYear_FE Cluster N r2_a , fmt(%3s %3s %3s %3s %6s %12.0f %9.3f)) ///
			title("Table1 Impact on `var'") replace 	

		

	/*----------------------------------------------------*/
	   /* [>   2.2.  基金   <] */ 

	   	/* 
	   	import excel using 自科基金_管理类_zaiwen.xlsx, firstrow clear

		gen Year=substr(批准年份,1,4)
		keep 负责人 Year 资助金额 依托单位 资助类别
		destring Year,replace

		save NSFS_lists.dta, replace  


		import excel using 社科基金项目数据1991-2022.xlsx, firstrow clear

		gen Year=substr(立项时间,1,4)
		destring Year,replace
		rename 项目负责人 负责人

		gen 依托单位 = regexs(1) if regexm(工作单位, "(.*大学)")


		keep 负责人 Year 依托单位

		save NSSFC_lists.dta, replace 

		*/

	/*----------------------------------------------------*/


	use Teacher_C+E_985visit_v5.3.dta, clear


			gen 负责人=Name
				replace 负责人=subinstr(Name, " ", "", .)
				replace 负责人=subinstr(负责人, char(10), "", .)

			replace 负责人="何平" if 负责人=="何一平（何平）"
			gen 依托单位=UniverName
			duplicates report 负责人 Year 依托单位

			joinby 负责人 Year 依托单位 using NSFS_lists, unmatched(master) _merge(m_NSFC)

			gen counter1=资助类别!=""
			bys ID Year: egen NSFC_new=sum(counter)

			duplicates drop ID Year, force


			joinby 负责人 Year 依托单位 using NSSFC_lists, unmatched(master) _merge(m_NSSFC)

			gen counter2=m_NSSFC==3
			bys ID Year: egen NSSFC_new=sum(counter2)

			duplicates drop ID Year, force


		merge 1:1 ID Year using FundData_v2.2.dta, gen(m_fund)
			
		drop if m_fund==2
		
		foreach var of varlist FundMoney TotalFund TotalFund2 TotalFund_Zike TotalFund_Sheke TotalFund_Bu fund_total fund_total2 fund_zike fund_sheke fund_bu {
			
			replace `var' = 0 if m_fund==1
			
		}	
		gen fund_other=fund_total-fund_zike-fund_sheke-fund_bu

		est clear
		foreach var of varlist NSFC_new NSSFC_new fund_bu fund_other{ 
			reghdfe `var' VisitPostA  , absorb(i.ID i.ID_Faculty#i.Year i.t i.FirstYear) $vce
				estadd local ID_FE "Yes",replace
				estadd local Year_FE "Yes",replace
				estadd local SchoolYear_FE "Yes",replace
				estadd local Cluster "ID",replace
				estadd local WorkYear_FE "Yes",replace
				est store m_`var'
		}
		
		*local s  "using $tables/RC4_Fund.rtf"  // 输出到word文档
		local s  "using $tables/AppTableVII1_PanelB.csv"  // 输出到word文档
		local m  "*"        // 模型名称
		
		esttab `m' `s', b(%7.3f) t(%7.3f) compress nogap se  ///
			star(* 0.1 ** 0.05 *** 0.01) ///
			stats(ID_FE Year_FE SchoolYear_FE WorkYear_FE Cluster N r2_a , fmt(%3s %3s %3s %3s %6s %12.0f %9.3f)) ///
			title("Table1 Impact on `var'") append
		

	/*----------------------------------------------------*/
	   /* [>   2.3.  研究话题   <] */ 
	/*----------------------------------------------------*/

	use Teacher_C+E_985visit_v5.3.dta, clear

		gen EngTotal_China=SSCI_China+NonSSCI_China
		gen EngTotal_US=SSCI_US+NonSSCI_US
		gen EngTotal_foriegn=SSCI_foriegn+NonSSCI_foriegn
		gen EngTotal_TheoryJournal=SSCI_TheoryJournal+NonSSCI_TheoryJournal
		gen EngTotal_Empirical=SSCI_Empirical+NonSSCI_Empirical
		gen EngTotal_NonEmpirical=EngTotal-EngTotal_Empirical
		gen EngTotal_NonTJournal=EngTotal-EngTotal_TheoryJournal

		est clear
		foreach var of varlist EngTotal_China  EngTotal_foriegn  {  //EngTotal_Empirical EngTotal_TheoryJournal
			reghdfe `var' VisitPostA , absorb(i.ID i.ID_Faculty#i.Year i.t i.FirstYear) $vce
				estadd local ID_FE "Yes",replace
				estadd local Year_FE "Yes",replace
				estadd local SchoolYear_FE "Yes",replace
				estadd local Cluster "ID",replace
				estadd local WorkYear_FE "Yes",replace
				est store m_`var'
		}
		

		bys ID: egen Study_theory=max(EngTotal_TheoryJournal)
		bys ID: egen EverPubS_EngTotal=max(EngTotal)
		bys ID: egen max_EngTotal_NonEmpirical=max(EngTotal_NonEmpirical)


		foreach var of varlist  EngTotal { 
			
			reghdfe `var' VisitPostA if !(Study_theory>0), absorb(i.ID i.ID_Faculty#i.Year i.t i.FirstYear) $vce
				estadd local ID_FE "Yes",replace
				estadd local Year_FE "Yes",replace
				estadd local SchoolYear_FE "Yes",replace
				estadd local Cluster "ID",replace
				estadd local WorkYear_FE "Yes",replace
				est store m1_`var'

			reghdfe `var' VisitPostA if (Study_theory>0 | EverPubS_EngTotal==0 ), absorb(i.ID i.ID_Faculty#i.Year i.t i.FirstYear) $vce
				estadd local ID_FE "Yes",replace
				estadd local Year_FE "Yes",replace
				estadd local SchoolYear_FE "Yes",replace
				estadd local Cluster "ID",replace
				estadd local WorkYear_FE "Yes",replace
				est store m2_`var'

		}
		
		*local s  "using $tables/RC4_Topic.rtf"  // 输出到word文档
		local s  "using $tables/AppTableVII1_PanelC.csv"  // 输出到word文档
		local m  "*"        // 模型名称
		
		esttab `m' `s', b(%7.3f) t(%7.3f) compress nogap se  ///
			star(* 0.1 ** 0.05 *** 0.01) ///
			stats(ID_FE Year_FE SchoolYear_FE WorkYear_FE Cluster N r2_a , fmt(%3s %3s %3s %3s %6s %12.0f %9.3f)) ///
			title("Table1 Impact on `var'") append
	

	/*----------------------------------------------------*/
	   /* [>   2.3.  英文期刊质量   <] */ 
	/*----------------------------------------------------*/

	use Teacher_C+E_985visit_v5.3.dta, clear 
		merge 1:1 ID Year using Pub_ABS2021.dta, gen(m_abs)
		drop if m_abs==2


		foreach w in abs4 abs3 abs2 abs1 {

			replace `w'=0 if mi(`w')
		}

		gen abs0=EngTotal-abs4-abs3-abs2-abs1

		gen abs_all=abs4+abs3+abs2+abs1

		replace abs4=abs3+abs4

		est clear

		foreach w in abs4 abs2 abs1 abs0 abs_all {

			replace `w'=0 if mi(`w')

			reghdfe `w' VisitPostA, absorb(i.ID i.ID_Faculty#i.Year i.t) $vce
				estadd local ID_FE "Yes",replace
				estadd local Year_FE "Yes",replace
				estadd local SchoolYear_FE "Yes",replace
				estadd local Cluster "ID",replace
				estadd local WorkYear_FE "Yes",replace
			est store m2_`w'

		}  // end of foreach w in varlist

			local s  "using $tables/AppTableVII1_PanelD.csv"  // 输出到word文档
			local m  "*"        // 模型名称

			esttab `m' `s', b(%7.3f) t(%7.3f) compress nogap se  ///
				star(* 0.1 ** 0.05 *** 0.01) ///
				stats(ID_FE Year_FE WorkYear_FE SchoolYear_FE N r2_a , fmt(%3s %3s %3s %3s %12.0f %9.3f )) ///
				title("Table1 Impact on `var'") replace


	end

/*------------------------------------ End of program  ------------------------------------*/

capture program drop AppTableVII2
	program AppTableVII2


	use Teacher_C+E_985visit_v5.3.dta, clear 

		est clear
		foreach var of varlist Top9_Up CSSCI ChiCore ChiTotal { //CSSCI SSCI NonSSCI A_plus A B C D E Others_Eng Top3 Top9 ChiCore Top3 Top9 CSSCI_Down ChiTotal 
			reghdfe `var' VisitPostA  if IsNative==1 , absorb(i.ID i.ID_Faculty#i.Year i.t ) $vce
				estadd local ID_FE "Yes",replace
				estadd local Year_FE "Yes",replace
				estadd local SchoolYear_FE "Yes",replace
				estadd local Cluster "ID",replace
				estadd local WorkYear_FE "Yes",replace
				est store m1_`var'
		}

		foreach var of varlist Top9_Up CSSCI ChiCore ChiTotal { //CSSCI SSCI NonSSCI A_plus A B C D E Others_Eng Top3 Top9 ChiCore Top3 Top9 CSSCI_Down ChiTotal 
			reghdfe `var' VisitPostA  if IsNative==0 , absorb(i.ID i.ID_Faculty#i.Year i.t ) $vce
				estadd local ID_FE "Yes",replace
				estadd local Year_FE "Yes",replace
				estadd local SchoolYear_FE "Yes",replace
				estadd local Cluster "ID",replace
				estadd local WorkYear_FE "Yes",replace
				est store m2_`var'
		}


			local s  "using $tables/AppTableVII2.csv"  // 输出到word文档
			local m  "*"        // 模型名称

			esttab `m' `s', b(%7.3f) t(%7.3f) compress nogap se  ///
				star(* 0.1 ** 0.05 *** 0.01) ///
				stats(ID_FE Year_FE WorkYear_FE SchoolYear_FE N r2_a , fmt(%3s %3s %3s %3s %12.0f %9.3f )) ///
				title("Table1 Impact on `var'") replace	
	end

/*------------------------------------ End of program  ------------------------------------*/

capture program drop AppFigureVIII
	program AppFigureVIII

	use Teacher_C+E_985visit_v5.3.dta, clear

		keep if !mi(Visit1_StartYear)
		*drop if FirstYear>2016

		gen visited = VisitPostA==1  //&  Year-Visit1_StartYear>=0 & Year-Visit1_StartYear<=10

		gen EngTotal_novisit= EngTotal
		replace EngTotal_novisit = EngTotal - visited*0.037 


		collapse EngTotal EngTotal_novisit, by(Year)
		replace EngTotal_novisit=0 if EngTotal_novisit<0

		tostring EngTotal_novisit , generate(EngTotal_novisit_label) format( %6.3f) force
		replace EngTotal_novisit_label="" if EngTotal_novisit==0

		//tw con t3_up_econ t3_up_notenure tenure_sys year if year >= 2004  & isnative ==0
		format EngTotal EngTotal_novisit  %6.3f
		tw con EngTotal EngTotal_novisit  Year if Year >= 2000 , mlabel() msymbol(O D) ///
		 xlabel(2000(2)2018.2) lp(solid dash ) mlabpos(12 6) ylabel(, grid) ytit("人均英文发表量") xtitle("年份") ///
		 legend(ring(0) col(1) pos(11) label(1 "实际发表") label(2 "反事实模拟") ) ///
		 graphregion(fcolor(white))

		gr export "$tables/AppFigureVIII1a.png",replace 


	////////////////////////////////////////////////////////



	use Teacher_C+E_985visit_v5.3.dta, clear

	gen rel_workyr=Year-FirstYear

	reg EngTotal i.rel_workyr i.FirstYear,coeflegend

	local EnterNum 150
	local VisitNum 100
	set seed 10101
	local VisitEffect 1.389
	local grate1 1.1
	local grate2 1.2

	forvalues j = 1990 (1) 2018 {

		disp "now we are step1: `j'"

		forvalues m = 1 (1) 12 {

			disp "now we are step1: j: `j', m: `m'"

			sum EngTotal if FirstYear==`j' & rel_workyr==0
			set obs `=_N+r(N)'
			replace Year=2018+`m' if Year==.
			replace FirstYear=`j' if FirstYear==.
			local k =2019-`j' 

			if `k'<=29 {

				qui: reg EngTotal i.rel_workyr i.FirstYear if Year<2019,coeflegend
				replace EngTotal=_b[`k'.rel_workyr]+_b[_cons]+_b[`j'.FirstYear]+rnormal()*0.1 if mi(EngTotal)
			}

			else {
				qui: reg EngTotal i.rel_workyr i.FirstYear if Year<2019,coeflegend
				replace EngTotal=0.2-0.02*`m'+_b[_cons]+_b[`j'.FirstYear]+rnormal()*0.1 if mi(EngTotal)
			}

		}  // end of forvalues m = 1 (1) n
	}  // end of forvalues j = 1 (1) n


	forvalues j = 2019 (1) 2030 {

		disp "now we are step2: `j'"

		forvalues m = 1 (1) 12 {

			disp "now we are step2: j: `j', m: `m'"

			//sum EngTotal if FirstYear==`j'  & rel_workyr==0
			set obs `=_N+`EnterNum'+10*`m''
			replace Year=2018+`m' if Year==.
			replace FirstYear=`j' if FirstYear==.
			local k =2019-`j' 
			//local l=`j'-1989		
			if `k'==0 {
				qui: reg EngTotal i.rel_workyr i.FirstYear if Year<2019,coeflegend
				replace EngTotal=_b[_cons]+_b[2018.FirstYear]*`grate1'^`m'+rnormal()*0.1+rnormal()*0.1 if mi(EngTotal)
			}

			if `k'>0 {
				qui: reg EngTotal i.rel_workyr i.FirstYear if Year<2019,coeflegend
				replace EngTotal=_b[`k'.rel_workyr]*`grate1'^`m'+_b[_cons]+_b[2018.FirstYear]*`grate1'^`m'+rnormal()*0.1 if mi(EngTotal)
			}

		}  // end of forvalues m = 1 (1) n
	}  // end of forvalues j = 1 (1) n

	gen EngTotal2=EngTotal
	gen EngTotal3=EngTotal	

	forvalues j = 1 (1) 12 {

		disp "now we are step3: `j'"

		preserve
			drop if mi(ID)
			duplicates drop ID,force
			gen random_digit= runiform() 
			sort random_digit 
			g random_id= _n  	
		restore

			gen random_digit= runiform() 
			sort random_digit 
			g random_id= _n  	

		replace EngTotal=EngTotal * `VisitEffect' if random_id<=`VisitNum'*`grate2'^`j'*(13-`j') & Year>=2018+`j'
		
		cap drop random_digit
		cap drop random_id
	}  // end of forvalues j = 1 (1) n



	forvalues j = 1 (1) 12 {

		disp "now we are step4: `j'"
		gen random_digit2= runiform() 
		sort random_digit2
		g random_id2= _n  
		replace EngTotal2=EngTotal2 * `VisitEffect' if random_id2<=`VisitNum'*`grate2'^`j'*0.25*(13-`j') & Year>=2018+`j'

		cap drop random_digit2
		cap drop random_id2
	}  // end of forvalues j = 1 (1) n


	forvalues j = 1 (1) 12 {

		disp "now we are step4: `j'"
		gen random_digit2= runiform() 
		sort random_digit2
		g random_id2= _n  
		replace EngTotal3=EngTotal3 * `VisitEffect' if random_id2<=`VisitNum'*`grate2'^`j'*(0.75/2+0.25)*(13-`j') & Year>=2018+`j'

		cap drop random_digit2
		cap drop random_id2
	}  // end of forvalues j = 1 (1) n


		collapse EngTotal EngTotal2 EngTotal3, by(Year)

		drop if Year<=2018

		tostring EngTotal2 , generate(EngTotal2_label) format( %6.3f) force
		replace EngTotal2_label="" if Year<=2018
		//replace EngTotal2_label="" if mod(Year,2) & Year>2018

		tostring EngTotal , generate(EngTotal_label) format( %6.3f) force
		//replace EngTotal_label="" if mod(Year,2) & Year>2018

		tostring EngTotal3 , generate(EngTotal3_label) format( %6.3f) force
		//replace EngTotal_label="" if mod(Year,2) & Year>2018


		format EngTotal EngTotal2 EngTotal3 %6.3f
		tw con  EngTotal2 EngTotal3 EngTotal Year if Year >= 2000 , mlabel() msymbol(O D) ///
		 xlabel(2019(1)2030.2) lp( dash dash solid) mlabpos(6 9 12) ylabel(, grid) ytit("人均英文发表量") xtitle("年份") /// 
		 legend(ring(0) col(1) pos(11) label(1 "限制情景") label(2 "应对情景") label(3 "基准情景") ) ///
		 graphregion(fcolor(white))

		 //xline(2018,lpattern(dash)) 

		gr export "$tables/AppFigureVIII1b.png",replace 
	end



