

capture program drop DefGlobal
	program DefGlobal

		global vce="cluster(ID)"

	end

/*------------------------------------ End of program  ------------------------------------*/

capture program drop Table1
	program Table1

	
	use Teacher_C+E_985visit_v5.3.dta, clear  
		merge 1:1 ID Year using tomerge-Citation.dta, gen(m_cit)
			//source:/Users/lqf/Desktop/Project_Tenure/Working_data/tomerge-Citation.dta
		drop if m_cit==2
		foreach var of varlist eng_citation eng_quantile eng_percitation eng_perquantile {
		replace `var'=0 if m_cit==1
		replace `var'=0 if EngTotal==0
		}
		foreach var of varlist  eng_quantile  eng_perquantile {
		replace `var'=`var'*100
		}

		local xlist1 "FirstYear IsNative Gender EverPostDoc EverWorked UGRD_Rank PhDRank_econ_tubo_hg Visit1_StartYear Visit1_length"
		local xlist2 "EngTotal SSCI eng_citation CSSCI"


		preserve
			keep if t==1
			keep EverVisit_A `xlist1' 
			order  EverVisit_A `xlist1'
			bysort EverVisit_A: outreg2 using $tables/Table1.rtf, replace sum(log) title(Decriptive statistics) eqkeep(N mean sd) 
		restore


		preserve
			keep EverVisit_A `xlist2'
			order  EverVisit_A `xlist2'
			bysort EverVisit_A: outreg2 using $tables/Table1.rtf, append sum(log) title(Decriptive statistics) eqkeep(N mean sd) 
		restore
	
	
	end

/*------------------------------------ End of program  ------------------------------------*/


capture program drop Table2
	program Table2
	
	use Teacher_C+E_985visit_v5.3.dta, clear    	
		

		capture drop t2
		capture gen t2 = t^2

		est clear
		foreach var of varlist EngTotal { //NonSSCI EngTotal
			
			reghdfe EngTotal VisitPostA, absorb(i.ID i.Year) $vce
				estadd local ID_FE "Yes",replace
				estadd local Year_FE "Yes",replace
				estadd local WorkYear_FE "No",replace
				estadd local SchoolYear_FE "No",replace
 				est store m_`var'1

 			reghdfe EngTotal VisitPostA , absorb(i.ID i.Year i.t) $vce
				estadd local ID_FE "Yes",replace
				estadd local Year_FE "Yes",replace
				estadd local WorkYear_FE "Yes",replace
				estadd local SchoolYear_FE "No",replace
 				est store m_`var'2

 			reghdfe EngTotal VisitPostA , absorb(i.ID i.Year i.ID_Faculty#i.Year) $vce
				estadd local ID_FE "Yes",replace
				estadd local Year_FE "Yes",replace
				estadd local WorkYear_FE "No",replace
				estadd local SchoolYear_FE "Yes",replace
 				est store m_`var'3

  			reghdfe EngTotal VisitPostA , absorb(i.ID i.Year i.t i.ID_Faculty#i.Year) $vce
				estadd local ID_FE "Yes",replace
				estadd local Year_FE "Yes",replace
				estadd local WorkYear_FE "Yes",replace
				estadd local SchoolYear_FE "Yes",replace
 				est store m_`var'4

		}

		local s  "using $tables/Table2.rtf"  // 输出到word文档
		local m  "*"        // 模型名称

		esttab `m' `s', b(%7.3f) t(%7.3f) compress nogap se  ///
			star(* 0.1 ** 0.05 *** 0.01) ///
			stats(ID_FE Year_FE WorkYear_FE SchoolYear_FE N r2_a , fmt(%3s %3s %3s %3s %12.0f %9.3f )) ///
			title("Table1 Impact on `var'") replace
	
	end
	
/*------------------------------------ RB1_DynamicDD  ------------------------------------*/

capture program drop Figure1a
	program Figure1a

	use Teacher_C+E_985visit_v5.3.dta, clear  

		gen rel_time=Year - Visit1_StartYear
		summ rel_time if !mi(rel_time)
		local relmin = abs(r(min))
		local relmax = abs(r(max))

		// leads
		cap drop F_*
		forval x = 1/`relmin' {  // drop the first lead
			gen     F_`x' = rel_time == -`x'
			replace F_`x' = 0 if mi(Visit1_StartYear)
		}

		//lags
		cap drop L_*
		forval x = 0/`relmax' {
			gen     L_`x' = rel_time ==  `x'
			replace L_`x' = 0 if mi(Visit1_StartYear)
		}
		replace  F_1=0 // reference year

		est clear
		foreach var of varlist EngTotal  { //SSCI T3_Up //T_other T2_Down T2 T3 T_other T2_Down EngTotal SSCI NonSSCI CSSCI Top3 Top9 ChiCore

		reghdfe `var' L_* F_* , a(i.ID i.Year#i.ID_Faculty i.FirstYear i.t) cluster(ID) //VP_Year_Post Prof_Year_Post
			est store dd_`var'
		event_plot 	dd_`var' , 	///
		stub_lag( L_#	) 		///
		stub_lead(F_#	)		///
			together trimlead(6) trimlag(10) noautolegend 									///
			plottype(scatter) ciplottype(rspike)  alpha(0.1)													///
				lag_opt1(msymbol(Oh) msize(1.2) mlwidth(0.3) color("`r(p1)'")) 	lag_ci_opt2(color("`r(p1)'") lw(0.1)) 	///
						graph_opt(	                                   ///
								title("")                   ///
								xtitle("相对访学年份")                               ///
								ytitle("估计系数") xlabel(-6(1)10) ///
								xline(-0.5, lc(gs8) lp(dash)) ///
								yline(   0, lc(gs8) lp(dash)) ///
								legend(off)	graphregion(fcolor(white)) ///
								plotregion(lcolor(black))  ///
								) 
			gr export "$tables/Figure1a.png", width(3000)  replace 

		}

	end


capture program drop Figure1b
	program Figure1b

	use Teacher_C+E_985visit_v5.3.dta, clear 

		gen visit_post=(Year)>=Visit1_StartYear

		**********1.
		did_multiplegt EngTotal ID Year visit_post, robust_dynamic dynamic(10) placebo(10) breps(20) cluster(ID) longdiff_placebo average_effect //controls(VP_Year_Post Prof_Year_Post ) 
		matrix didmgt_b = e(estimates) 
		matrix didmgt_v = e(variances)

		**********2.
		did_imputation EngTotal ID Year Visit1_StartYear, horizons(0/10) pretrend(10) autosample cluster(ID)
		estimates store didimp

		**********3.
		gen rel_time=Year - Visit1_StartYear
		summ rel_time
		local relmin = abs(r(min))
		local relmax = abs(r(max))

		// leads
		cap drop F_*
		forval x = 1/`relmin' {  // drop the first lead
			gen     F_`x' = rel_time == -`x'
			replace F_`x' = 0 if mi(Visit1_StartYear)
		}

		//lags
		cap drop L_*
		forval x = 0/`relmax' {
			gen     L_`x' = rel_time ==  `x'
			replace L_`x' = 0 if mi(Visit1_StartYear)
		}
		replace  F_1=0 // reference year

		gen never_treat = mi(Visit1_StartYear)
		eventstudyinteract EngTotal L_* F_*, vce(cluster ID) absorb(ID Year) cohort(Visit1_StartYear) control_cohort(never_treat)

		matrix evtstint_b = e(b_iw) 
		matrix evtstint_v = e(V_iw)

		**********Plot
		colorpalette //tableau, nograph	
		event_plot 	didmgt_b#didmgt_v  didimp evtstint_b#evtstint_v , 	///
		stub_lag( Effect_#    tau#  L_#	) 		///
		stub_lead(Placebo_#   pre#  F_#	)		///
			together perturb(-0.2(0.20)0.20) trimlead(6) trimlag(10) noautolegend 									///
			plottype(scatter) ciplottype(rspike)  alpha(0.1)													///
				lag_opt1(msymbol(lgx) msize(1.2) mlwidth(0.3) color("`r(p1)'")) 	lag_ci_opt1(color("`r(p1)'") lw(0.2)) 	///
				lag_opt2(msymbol(Dh)  msize(1.2) mlwidth(0.3) color("`r(p6)'")) 	lag_ci_opt2(color("`r(p6)'") lw(0.2)) 	///
				lag_opt3(msymbol(Th)  msize(1.2) mlwidth(0.3) color("`r(p11)'")) 	lag_ci_opt3(color("`r(p11)'") lw(0.2)) 	///
						graph_opt(	                                   ///
								title("")                   ///
								xtitle("相对访学年份")                               ///
								ytitle("估计系数") xlabel(-6(1)10) ///
								legend(order(1 "CD(2020)" 3 "BJS(2021)" 5 "SA(2020)" ) ring(0) pos(11) row(3) region(style(none))) 	///
								xline(-0.5, lc(gs8) lp(dash)) ///
								yline(   0, lc(gs8) lp(dash)) ///
								graphregion(fcolor(white)) ///
								plotregion(lcolor(black))  ///
								) 
		gr export "$tables/Figure1b.png", width(3000) replace

	end
	
/*------------------------------------ End of program  ------------------------------------*/

capture program drop Figure2
	program Figure2

	use Teacher_C+E_985visit_v5.3.dta, clear  

		gen rel_time=Year - Visit1_StartYear
		summ rel_time if !mi(rel_time)
		local relmin = abs(r(min))
		local relmax = abs(r(max))

		// leads
		cap drop F_*
		forval x = 1/`relmin' {  // drop the first lead
			gen     F_`x' = rel_time == -`x'
			replace F_`x' = 0 if mi(Visit1_StartYear)
		}

		//lags
		cap drop L_*
		forval x = 0/`relmax' {
			gen     L_`x' = rel_time ==  `x'
			replace L_`x' = 0 if mi(Visit1_StartYear)
		}
		replace  F_1=0 // reference year

		est clear
		foreach var of varlist EngTotal  { 

		reghdfe `var' L_* F_* if EverVisit_A==1, a(i.ID i.Year#i.ID_Faculty i.FirstYear i.t) cluster(ID) //VP_Year_Post Prof_Year_Post
			est store es_`var'
		event_plot 	es_`var' , 	///
		stub_lag( L_#	) 		///
		stub_lead(F_#	)		///
			together trimlead(6) trimlag(10) noautolegend 								///
			plottype(scatter) ciplottype(rspike)  alpha(0.1)													///
				lag_opt1(msymbol(Oh) msize(1.2) mlwidth(0.3) color("`r(p1)'")) 	lag_ci_opt2(color("`r(p1)'") lw(0.1)) 	///
						graph_opt(	                                   ///
								title("")                   ///
								xtitle("相对访学年份")                               ///
								ytitle("估计系数") xlabel(-6(1)10) ///
								xline(-0.5, lc(gs8) lp(dash)) ///
								yline(   0, lc(gs8) lp(dash)) ///
								legend(off)	graphregion(fcolor(white)) ///
								plotregion(lcolor(black))  ///
								) 
			gr export "$tables/Figure2.png", width(3000) replace

		}

	end

/*------------------------------------ End of program  ------------------------------------*/


capture program drop Table3
	program Table3

	*- Column 1,2,3,4
		use Teacher_C+E_985visit_v5.3.dta, clear		
			
			//keep if Visit1_State==1 | mi(Visit1_StartYear)

			cap drop m1
			merge m:1 Year using CSC&Visa.dta, gen(m1)
			drop if m1==2

				tset ID Year

		 		gen Shock1=资助总数
				gen Shock2=访问学者
				gen Shock3=J1_China/1000
				gen Shock4=J1_Share  
		
				cap drop m1
				merge m:1 ID_Faculty Year using Share_1.dta, gen(m1)

				est clear
				foreach var1 of varlist  Shock4  { 

					foreach var2 of varlist Share5 {

						gen `var1'_`var2'=`var1'*`var2'*(t>average_t)

						reghdfe VisitPostA `var1'_`var2', absorb(i.ID i.Year i.t i.ID_Faculty#i.Year) cluster(ID) //vce(robust)
							estadd local ID_FE "Yes",replace
							estadd local Year_FE "Yes",replace
							estadd local WorkYear_FE "Yes",replace
							estadd local SchoolYear_FE "Yes",replace
							est store m_`var1'`var2'_1
						ivreghdfe EngTotal (VisitPostA=`var1'_`var2'), absorb(i.ID i.Year i.t i.ID_Faculty#i.Year) robust //cluster(ID)
							estadd local ID_FE "Yes",replace
							estadd local Year_FE "Yes",replace
							estadd local WorkYear_FE "Yes",replace
							estadd local SchoolYear_FE "Yes",replace
							est store m_`var1'`var2'_2

					drop if Visit1_State!=1 & !mi(Visit1_StartYear) 

					reghdfe VisitPostA `var1'_`var2', absorb(i.ID i.Year i.t i.ID_Faculty#i.Year) cluster(ID) //vce(robust)
							estadd local ID_FE "Yes",replace
							estadd local Year_FE "Yes",replace
							estadd local WorkYear_FE "Yes",replace
							estadd local SchoolYear_FE "Yes",replace
							est store m_`var1'`var2'_3
						ivreghdfe EngTotal (VisitPostA=`var1'_`var2'), absorb(i.ID i.Year i.t i.ID_Faculty#i.Year) robust //cluster(ID)
							estadd local ID_FE "Yes",replace
							estadd local Year_FE "Yes",replace
							estadd local WorkYear_FE "Yes",replace
							estadd local SchoolYear_FE "Yes",replace
							est store m_`var1'`var2'_4

					}
				}

				local s  "using $tables/Table3_part1.rtf"  // 输出到word文档
				local m  "*"        // 模型名称
				
				esttab `m' `s', b(%7.3f) t(%7.3f) compress nogap se  ///
					star(* 0.1 ** 0.05 *** 0.01) ///
					stats(ID_FE Year_FE WorkYear_FE SchoolYear_FE N r2_a widstat, fmt(%3s %3s %3s %3s %12.0f %9.3f %9.3f)) ///
					title("Table1 Impact on `var'") replace


	/////////////////////////////////////////////////////////////////////////////////////////////////////////////
	*- Column 5,6

		use Teacher_C+E_985visit_v5.3.dta, clear

			xtset ID Year

			gen iv_year=.

			merge m:1 ID using 1992.dta,  nogen keep(master match )	
			replace iv_year=sort_n if sort_n!=.
			drop sort_n
			merge m:1 ID using 1993.dta,  nogen keep(master match )	
			replace iv_year=sort_n if sort_n!=.
			drop sort_n
			merge m:1 ID using 1995.dta,  nogen keep(master match )	
			replace iv_year=sort_n if sort_n!=.
			drop sort_n
			merge m:1 ID using 1996.dta,  nogen keep(master match )	
			replace iv_year=sort_n if sort_n!=.
			drop sort_n
			merge m:1 ID using 1997.dta,  nogen keep(master match )	
			replace iv_year=sort_n if sort_n!=.
			drop sort_n
			merge m:1 ID using 1998.dta,  nogen keep(master match )	
			replace iv_year=sort_n if sort_n!=.
			drop sort_n
			merge m:1 ID using 1999.dta,  nogen keep(master match )	
			replace iv_year=sort_n if sort_n!=.
			drop sort_n
			merge m:1 ID using 2000.dta,  nogen keep(master match )	
			replace iv_year=sort_n if sort_n!=.
			drop sort_n
			merge m:1 ID using 2001.dta,  nogen keep(master match )	
			replace iv_year=sort_n if sort_n!=.
			drop sort_n
			merge m:1 ID using 2002.dta,  nogen keep(master match )	
			replace iv_year=sort_n if sort_n!=.
			drop sort_n
			merge m:1 ID using 2003.dta,  nogen keep(master match )	
			replace iv_year=sort_n if sort_n!=.
			drop sort_n
			merge m:1 ID using 2004.dta,  nogen keep(master match )	
			replace iv_year=sort_n if sort_n!=.
			drop sort_n
			merge m:1 ID using 2005.dta,  nogen keep(master match )	
			replace iv_year=sort_n if sort_n!=.
			drop sort_n
			merge m:1 ID using 2006.dta,  nogen keep(master match )	
			replace iv_year=sort_n if sort_n!=.
			drop sort_n
			merge m:1 ID using 2007.dta,  nogen keep(master match )	
			replace iv_year=sort_n if sort_n!=.
			drop sort_n
			merge m:1 ID using 2008.dta,  nogen keep(master match )	
			replace iv_year=sort_n if sort_n!=.
			drop sort_n
			merge m:1 ID using 2009.dta,  nogen keep(master match )	
			replace iv_year=sort_n if sort_n!=.
			drop sort_n
			merge m:1 ID using 2010.dta,  nogen keep(master match )	
			replace iv_year=sort_n if sort_n!=.
			drop sort_n
			merge m:1 ID using 2011.dta,  nogen keep(master match )	
			replace iv_year=sort_n if sort_n!=.
			drop sort_n
			merge m:1 ID using 2012.dta,  nogen keep(master match )	
			replace iv_year=sort_n if sort_n!=.
			drop sort_n
			merge m:1 ID using 2013.dta,  nogen keep(master match )	
			replace iv_year=sort_n if sort_n!=.
			drop sort_n
			merge m:1 ID using 2014.dta,  nogen keep(master match )	
			replace iv_year=sort_n if sort_n!=.
			drop sort_n
			merge m:1 ID using 2015.dta,  nogen keep(master match )	
			replace iv_year=sort_n if sort_n!=.
			drop sort_n
			merge m:1 ID using 2016.dta,  nogen keep(master match )	
			replace iv_year=sort_n if sort_n!=.
			drop sort_n
			merge m:1 ID using 2017.dta,  nogen keep(master match )	
			replace iv_year=sort_n if sort_n!=.
			drop sort_n
			merge m:1 ID using 2018.dta,  nogen keep(master match )	
			replace iv_year=sort_n if sort_n!=.
			drop sort_n

			tset ID Year
			gen predict_iv=Year-iv_year>=0

			est clear

			reghdfe VisitPostA predict_iv, absorb(i.ID i.Year i.t i.ID_Faculty#i.Year) cluster(ID)
					est store m_predict_iv_1
				ivreghdfe EngTotal (VisitPostA=predict_iv), absorb(i.ID i.Year i.t i.ID_Faculty#i.Year) cluster(ID)
					est store m_predict_iv_2


		local s  "using $tables/Table3_part2.rtf"  // 输出到word文档
		local m  "*"        // 模型名称
				

		esttab `m' `s', b(%7.3f) t(%7.3f) compress nogap se  ///
			star(* 0.1 ** 0.05 *** 0.01) ///
			stats(ID_FE Year_FE WorkYear_FE SchoolYear_FE N r2_a, fmt(%3s %3s %3s %3s %12.0f %9.3f)) ///
			title("Table1 Impact on `var'") replace


	end

/*------------------------------------ End of program  ------------------------------------*/


capture program drop Table4
	program Table4
	

	/*----------------------------------------------------*/
	   /* [>   1.  Direct Coop and Indirect Spillover   <] */ 
	/*----------------------------------------------------*/
		 
	use Teacher_C+E_985visit_v5.3.dta, clear
		 
		gen TA1_EngTotal=TA1_SSCI+TA1_NonSSCI
		gen TA2_EngTotal=TA2_SSCI+TA2_NonSSCI
		gen TA3_EngTotal=TA3_SSCI+TA3_NonSSCI
		gen FN_EngTotal=FN_SSCI+FN_NonSSCI
		gen NoFN_EngTotal = TA2_EngTotal- FN_EngTotal
		gen EngTotal_ColleageCoop=SSCI_ColleageCoop+NonSSCI_ColleageCoop

		capture drop m1
		merge 1:1 ID Year using Visit_DirectCoop.dta, gen(m1)
		drop if m1==2
		drop m1
		gen EngTotal_DirectCoop=DirectCoop_num
			replace EngTotal_DirectCoop=0 if mi(EngTotal_DirectCoop)
		
		est clear
		foreach var of varlist FN_EngTotal  EngTotal_DirectCoop NoFN_EngTotal { 
			reghdfe `var' VisitPostA  , absorb(i.ID i.ID_Faculty#i.Year i.t) $vce
				estadd local ID_FE "Yes",replace
				estadd local Year_FE "Yes",replace
				estadd local SchoolYear_FE "Yes",replace
				estadd local Cluster "ID",replace
				estadd local WorkYear_FE "Yes",replace
				est store m1_`var'
		}
		
	*- Panel B

		gen rel_time=Year - Visit1_StartYear
		gen VisitPostA_s1=VisitPostA* (rel_time>=0 & rel_time<=2)
		gen VisitPostA_s2=VisitPostA* (rel_time>=3 & rel_time<=6)
		gen VisitPostA_s3=VisitPostA* (rel_time>=7 & rel_time<=100)

		est clear
		foreach var of varlist FN_EngTotal  EngTotal_DirectCoop NoFN_EngTotal { 
			reghdfe `var' VisitPostA_s* , absorb(i.ID i.ID_Faculty#i.Year i.t) $vce
				estadd local ID_FE "Yes",replace
				estadd local Year_FE "Yes",replace
				estadd local SchoolYear_FE "Yes",replace
				estadd local Cluster "ID",replace
				estadd local WorkYear_FE "Yes",replace
				est store m2_`var'
		}
		
		local s  "using $tables/Table4.rtf"  // 输出到word文档
		local m  "*"        // 模型名称
		
		esttab `m' `s', b(%7.3f) t(%7.3f) compress nogap se  ///
			star(* 0.1 ** 0.05 *** 0.01) ///
			stats(ID_FE Year_FE SchoolYear_FE WorkYear_FE Cluster N r2_a , fmt(%3s %3s %3s %3s %6s %12.0f %9.3f)) ///
			title("Table1 Impact on `var'") replace


	end

/*------------------------------------ End of program  ------------------------------------*/


capture program drop Figure3
	program Figure3
	

	/*----------------------------------------------------*/
	   /* [>   2.  Effect by VisitRank   <] */ 
	/*----------------------------------------------------*/

	use Teacher_C+E_985visit_v5.3.dta, clear

		gen TA1_EngTotal=TA1_SSCI+TA1_NonSSCI
		gen TA2_EngTotal=TA2_SSCI+TA2_NonSSCI
		gen TA3_EngTotal=TA3_SSCI+TA3_NonSSCI
		gen FN_EngTotal=FN_SSCI+FN_NonSSCI
		gen NoFN_EngTotal = TA2_EngTotal- FN_EngTotal
		gen EngTotal_ColleageCoop=SSCI_ColleageCoop+NonSSCI_ColleageCoop

		capture drop m1
		merge 1:1 ID Year using Visit_DirectCoop.dta, gen(m1)
		drop if m1==2
		drop m1
		gen EngTotal_DirectCoop=DirectCoop_num
			replace EngTotal_DirectCoop=0 if mi(EngTotal_DirectCoop)
		gen EngTotal_NoDirectCoop=EngTotal-EngTotal_DirectCoop

		gen Visit_NonUniv=0
			replace Visit_NonUniv=1 if inlist(Visit1_Univ, "FAU政府采购研究中心", "世界银行经济发展学院", "芬兰央行", "金融管理局")
			replace Visit_NonUniv=1 if inlist(Visit1_Univ, "林肯金融集团(Lincoln Financial Group)", "世界银行经济发展学院", "美国国家大气研究中心","Federal Reserve Bank of Atlanta ")
			replace Visit_NonUniv=1 if inlist(Visit1_Univ, "瑞士联邦理工学院（EPFL）伯努利研究中心","联合国大学-世界经济发展研究院","中央研究院")
		
		capture drop VisitPostA_Rank_bin* 
		capture drop university1
		// 		gen university1 = ustrregexs(0) if ustrregexm(Visit1_Univ,"[\u4e00-\u9fa5]+")	
			
			gen VisitPostA_Rank_bin1=0
				replace VisitPostA_Rank_bin1=1 if VisitPostA==1 & Visit1_Rank>0 & Visit1_Rank<=50
			gen VisitPostA_Rank_bin2=0
				replace VisitPostA_Rank_bin2=1 if VisitPostA==1 & Visit1_Rank>50 & Visit1_Rank<=300
			gen VisitPostA_Rank_bin3=0
				replace VisitPostA_Rank_bin3=1 if VisitPostA==1 & Visit1_Rank>300 & !mi(Visit1_Rank) & !mi(Visit1_StartYear)
		//	gen VisitPostA_Rank_bin4=0 
		//		replace VisitPostA_Rank_bin4=1 if VisitPostA==1 & Visit_NonUniv==1
			
			
		// 		& Visit1_Rank<700
		//  		gen VisitPostA_Rank_bin6=0
		//  			replace VisitPostA_Rank_bin6=1 if VisitPostA==1 & Visit1_Rank>700 & !mi(Visit1_Rank)
		//  		gen VisitPostA_Rank_bin7=0
		// 			replace VisitPostA_Rank_bin7=1 if VisitPostA==1 & mi(Visit1_Rank)	

			est clear
			foreach var of varlist EngTotal { 
				reghdfe `var' VisitPostA_Rank_bin*   , absorb(i.ID i.ID_Faculty#i.Year i.t) $vce
					est store m_1

				test VisitPostA_Rank_bin1=VisitPostA_Rank_bin2=VisitPostA_Rank_bin3
				test VisitPostA_Rank_bin1=VisitPostA_Rank_bin2
				test VisitPostA_Rank_bin1=VisitPostA_Rank_bin3
				test VisitPostA_Rank_bin2=VisitPostA_Rank_bin3

				coefplot, keep(VisitPostA_Rank_bin*) ///
					  coeflabels( ///
								VisitPostA_Rank_bin1 = "[1,50]" ///
								VisitPostA_Rank_bin2 = "(50,300]" ///
								VisitPostA_Rank_bin3 = ">300" ///
								 )                       ///
					  lev(90) vertical                                                                          ///
					  yline(0)                                                                          ///
					  ytitle("英文总发表",size(large))                                                               ///
					  xtitle("")                                                               ///
					  addplot(line @b @at)                                                              ///
					  ciopts(recast(rcap))                                                              ///
					  rescale()                                                                      ///
					  scheme(s1mono) 
				qui	  graph save $tables/RE5_`var'.gph, replace 
				*qui graph export $tables/RC3_Coop_Spill2_`var'.png, replace
			}		

			est clear
			foreach var of varlist EngTotal_NoDirectCoop  { 
				reghdfe `var' VisitPostA_Rank_bin*   , absorb(i.ID i.ID_Faculty#i.Year i.t) $vce
					est store m_1
				test VisitPostA_Rank_bin1=VisitPostA_Rank_bin2=VisitPostA_Rank_bin3
				test VisitPostA_Rank_bin1=VisitPostA_Rank_bin2
				test VisitPostA_Rank_bin1=VisitPostA_Rank_bin3
				test VisitPostA_Rank_bin2=VisitPostA_Rank_bin3

				coefplot, keep(VisitPostA_Rank_bin*) ///
					  coeflabels( ///
								VisitPostA_Rank_bin1 = "[1,50]" ///
								VisitPostA_Rank_bin2 = "(50,300]" ///
								VisitPostA_Rank_bin3 = ">300" ///
								 )                       ///
					  lev(90) vertical                                                                          ///
					  yline(0)                                                                          ///
					  ytitle("非直接合作",size(large))                                                               ///
					  xtitle("")                                                               ///
					  addplot(line @b @at)                                                              ///
					  ciopts(recast(rcap))                                                              ///
					  rescale()                                                                      ///
					  scheme(s1mono) 
				qui	  graph save $tables/RE5_`var'.gph, replace 
				*qui graph export $tables/RC3_Coop_Spill2_`var'.png, replace
			}

			est clear
			foreach var of varlist EngTotal_DirectCoop  { 
				reghdfe `var' VisitPostA_Rank_bin*   , absorb(i.ID i.ID_Faculty#i.Year i.t) $vce
					est store m_1
			
				test VisitPostA_Rank_bin1=VisitPostA_Rank_bin2=VisitPostA_Rank_bin3
				test VisitPostA_Rank_bin1=VisitPostA_Rank_bin2
				test VisitPostA_Rank_bin1=VisitPostA_Rank_bin3
				test VisitPostA_Rank_bin2=VisitPostA_Rank_bin3
				
				coefplot, keep(VisitPostA_Rank_bin*) ///
					  coeflabels( ///
								VisitPostA_Rank_bin1 = "[1,50]" ///
								VisitPostA_Rank_bin2 = "(50,300]" ///
								VisitPostA_Rank_bin3 = ">300" ///
								 )                       ///
					  lev(90) vertical                                                                          ///
					  yline(0)                                                                          ///
					  ytitle("同访学学校直接合作",size(large))                                                               ///
					  xtitle("")                                                               ///
					  addplot(line @b @at)                                                              ///
					  ciopts(recast(rcap))                                                              ///
					  rescale()                                                                      ///
					  scheme(s1mono) 
				qui	  graph save $tables/RE5_`var'.gph, replace 
				*qui graph export $tables/RC3_Coop_Spill2_`var'.png, replace
			}
			
		gr combine $tables/RE5_EngTotal.gph $tables/RE5_EngTotal_NoDirectCoop.gph $tables/RE5_EngTotal_DirectCoop.gph, ///
		ycommon rows(1) b1title("访学学校排名",size(large)) graphregion(fcolor(white))
		gr export "$tables/Figure3a.png", width(3000) replace

	/*----------------------------------------------------*/
	   /* [>   3.  Effect by LevelGap   <] */ 
	/*----------------------------------------------------*/

	use Teacher_C+E_985visit_v5.3.dta, clear

		drop if  mi(Visit1_Rank) & !mi(Visit1_StartYear)

		gen TA1_EngTotal=TA1_SSCI+TA1_NonSSCI
		gen TA2_EngTotal=TA2_SSCI+TA2_NonSSCI
		gen TA3_EngTotal=TA3_SSCI+TA3_NonSSCI
		gen FN_EngTotal=FN_SSCI+FN_NonSSCI
		gen NoFN_EngTotal = TA2_EngTotal- FN_EngTotal
		gen EngTotal_ColleageCoop=SSCI_ColleageCoop+NonSSCI_ColleageCoop

		capture drop m1
		merge 1:1 ID Year using Visit_DirectCoop.dta, gen(m1)
		drop if m1==2
		drop m1
		gen EngTotal_DirectCoop=DirectCoop_num
			replace EngTotal_DirectCoop=0 if mi(EngTotal_DirectCoop)
		gen EngTotal_NoDirectCoop=EngTotal-EngTotal_DirectCoop

		merge m:1 UniverName using THE_econ_ChinaPart.dta, gen(m1)
		drop if m1==2
		drop m1
		rename Rank HomeRank
		replace HomeRank=600 if mi(HomeRank)

		gen LevelGap=Visit1_Rank-HomeRank if !mi(Visit1_StartYear)

		tab LevelGap if t==1 & !mi(Visit1_StartYear) ,mi
		sum LevelGap ,detail // if t==1 & !mi(Visit1_StartYear),detail
			
			/* 		                LevelGap
			-------------------------------------------------------------
			      Percentiles      Smallest
			 1%         -599           -599
			 5%         -592           -599
			10%         -585           -599       Obs               9,897
			25%         -513           -599       Sum of wgt.       9,897

			50%       -149.5                      Mean          -189.6989
			                        Largest       Std. dev.      308.1001
			75%            0            577
			90%        249.5            577       Variance       94925.68
			95%          462            577       Skewness       .4269711
			99%          577            577       Kurtosis       2.557237 */
			
		gen LevelGap_abs=abs(LevelGap)
		sum LevelGap_abs, detail
			
		 



			//1:1:1

			
			local rank1 -600
			local rank2 -374.5
			local rank3 -41 
			local rank4 600 
			local range1 "[0,50]"
			local range2 "(50,100]"
			local range3 [66,100]
			local rank_mid 260.5 //-162.5 //-149.5

			/* 
			local rank1 -600
			local rank2 -50
			local rank3 50
			local rank4 600   */


			capture drop VisitPostA_LevelGap_bin* 
			gen VisitPostA_LevelGap_bin1=0
				replace VisitPostA_LevelGap_bin1=1 if VisitPostA==1 & LevelGap_abs>0 & LevelGap_abs<=`rank_mid'
			gen VisitPostA_LevelGap_bin2=0
				replace VisitPostA_LevelGap_bin2=1 if VisitPostA==1 & LevelGap_abs>`rank_mid' & LevelGap_abs<`rank4'

			est clear
			foreach var of varlist EngTotal { 
				reghdfe `var' VisitPostA_LevelGap_bin*   , absorb(i.ID i.ID_Faculty#i.Year i.t) $vce
					est store m_1
			
				coefplot, keep(VisitPostA_LevelGap_bin*) ///
					  coeflabels( ///
								VisitPostA_LevelGap_bin1 = "`range1'" ///
								VisitPostA_LevelGap_bin2 = "`range2'" ///
								 )                       ///
					  lev(90) vertical                                                                          ///
					  yline(0)                                                                          ///
					  ytitle("英文总发表",size(large))                                                               ///
					  xtitle("")                                                               ///
					  addplot(line @b @at)                                                              ///
					  ciopts(recast(rcap))                                                              ///
					  rescale()                                                                      ///
					  scheme(s1mono) 
				qui	  graph save $tables/RE5_`var'.gph, replace 
				*qui graph export $tables/RC3_Coop_Spill3_`var'.png, replace
			}		

			est clear
			foreach var of varlist EngTotal_NoDirectCoop  { 
				reghdfe `var' VisitPostA_LevelGap_bin*   , absorb(i.ID i.ID_Faculty#i.Year i.t) $vce
					est store m_1
			
				coefplot, keep(VisitPostA_LevelGap_bin*) ///
					  coeflabels( ///
								VisitPostA_LevelGap_bin1 = "`range1'" ///
								VisitPostA_LevelGap_bin2 = "`range2'" ///
								 )                       ///
					  lev(90) vertical                                                                          ///
					  yline(0)                                                                          ///
					  ytitle("非直接合作",size(large))                                                               ///
					  xtitle("")                                                               ///
					  addplot(line @b @at)                                                              ///
					  ciopts(recast(rcap))                                                              ///
					  rescale()                                                                      ///
					  scheme(s1mono) 
				qui	  graph save $tables/RE5_`var'.gph, replace 
				*qui graph export $tables/RC3_Coop_Spill3_`var'.png, replace
			}

			est clear
			foreach var of varlist EngTotal_DirectCoop  { 
				reghdfe `var' VisitPostA_LevelGap_bin*   , absorb(i.ID i.ID_Faculty#i.Year i.t) $vce
					est store m_1
			
				coefplot, keep(VisitPostA_LevelGap_bin*) ///
					  coeflabels( ///
								VisitPostA_LevelGap_bin1 = "`range1'" ///
								VisitPostA_LevelGap_bin2 = "`range2'" ///
								 )                       ///
					  lev(90) vertical                                                                          ///
					  yline(0)                                                                          ///
					  ytitle("同访学学校直接合作",size(large))                                                               ///
					  xtitle("")                                                               ///
					  addplot(line @b @at)                                                              ///
					  ciopts(recast(rcap))                                                              ///
					  rescale()                                                                      ///
					  scheme(s1mono) 
				qui	  graph save $tables/RE5_`var'.gph, replace 
				*qui graph export $tables/RC3_Coop_Spill3_`var'.png, replace
			}
			
		gr combine $tables/RE5_EngTotal.gph $tables/RE5_EngTotal_NoDirectCoop.gph $tables/RE5_EngTotal_DirectCoop.gph, ///
		ycommon rows(1) b1title("访学学校排名与本校排名差别分位数",size(large)) graphregion(fcolor(white))
		gr export "$tables/Figure3b.png", width(3000) replace
		
	end

/*------------------------------------ End of program  ------------------------------------*/



capture program drop Figure4
	program Figure4
	

	use Teacher_C+E_985visit_v5.3.dta, clear 
		
		capture drop VisitStatus
		gen VisitStatus=0
		//bys ID VisitPostA: egen min_VP=min()
		replace VisitStatus=1 if EverVisit_A==1 & (Visit1_StartYear<VP_Year | mi(VP_Year) )
		replace VisitStatus=2 if EverVisit_A==1 & VP_Year<Visit1_StartYear & !mi(VP_Year)
		replace VisitStatus=3 if EverVisit_A==1 & Prof_Year<Visit1_StartYear & !mi(Prof_Year)
		replace VisitStatus=3 if EverVisit_A==1 & mi(Prof_Year) & Visit1_StartYear-FirstYear>12 

		capture gen VisitPostA_AP=VisitPostA*(VisitStatus==1)
		capture gen VisitPostA_VP=VisitPostA*(VisitStatus==2)
		capture gen VisitPostA_Prof=VisitPostA*(VisitStatus==3)
		
		est clear
		
		gen VisitPostA_Male=VisitPostA*(Gender==1)
		gen VisitPostA_FeMale=VisitPostA*(Gender==0)

		gen VisitPostA_Tubo=VisitPostA*(IsNative==1)
		gen VisitPostA_Haigui=VisitPostA*(IsNative==0)


		reghdfe EngTotal VisitPostA_Male VisitPostA_FeMale, absorb(i.ID i.ID_Faculty#i.Year i.t ) $vce
 			est store m1
			test VisitPostA_Male=VisitPostA_FeMale
			coefplot, keep(VisitPostA_Male VisitPostA_FeMale) ///
					  coeflabels( ///
								VisitPostA_Male = "男性" ///
								VisitPostA_FeMale = "女性" ///
								,labsize(small) ///
								 )                       ///
					  lev(90) vertical                                                                          ///
					  yline(0)                                                                          ///
					  ytitle("")                                                               ///
					  xtitle("性别")                                                               ///
					  addplot(line @b @at)                                                              ///
					  ciopts(recast(rcap))                                                              ///
					  rescale()                                                                      ///
					  scheme(s1mono) 
				qui	  graph save $tables/RD_gender.gph, replace 
				*qui graph export $tables/RD_gender.png, replace

		sum EngTotal if (Gender==1)
		sum EngTotal if (Gender==0)

	//////////////////////////////////////////////////////////////////////
		reghdfe EngTotal VisitPostA_Tubo VisitPostA_Haigui, absorb(i.ID i.ID_Faculty#i.Year i.t ) $vce
 			est store m2
			test VisitPostA_Tubo=VisitPostA_Haigui

 			coefplot, keep(VisitPostA_Tubo VisitPostA_Haigui) ///
					  coeflabels( ///
								VisitPostA_Tubo = "本土" ///
								VisitPostA_Haigui = "海归" ///
								,labsize(small) ///
								 )                       ///
					  lev(90) vertical                                                                          ///
					  yline(0)                                                                          ///
					  ytitle("")                                                               ///
					  xtitle("博士类别")                                                               ///
					  addplot(line @b @at)                                                              ///
					  ciopts(recast(rcap))                                                              ///
					  rescale()                                                                      ///
					  scheme(s1mono) 
				qui	  graph save $tables/RD_PhD.gph, replace 
				*qui graph export $tables/RD_PhD.png, replace
		sum EngTotal if (IsNative==1)
		sum EngTotal if (IsNative==0)

	//////////////////////////////////////////////////////////////////////


	gen tenure_visit=Visit1_StartYear-FirstYear
		replace tenure_visit=0 if mi(tenure_visit)

		cap drop VisitPostA_tenure*
		gen VisitPostA_tenure1=VisitPostA*(tenure_visit>=0 & tenure_visit<=4)
		gen VisitPostA_tenure2=VisitPostA*(tenure_visit>=5 & tenure_visit<12)
		gen VisitPostA_tenure3=VisitPostA*(tenure_visit>=12)


 		reghdfe EngTotal VisitPostA_tenure1 VisitPostA_tenure2 VisitPostA_tenure3, absorb(i.ID i.ID_Faculty#i.Year i.t ) $vce
 			est store m1

 		test VisitPostA_tenure1=VisitPostA_tenure2=VisitPostA_tenure3
 		test VisitPostA_tenure1=VisitPostA_tenure2
 		test VisitPostA_tenure2=VisitPostA_tenure3

			coefplot, keep(VisitPostA_tenure1 VisitPostA_tenure2 VisitPostA_tenure3) ///
					  coeflabels( ///
								VisitPostA_tenure1 = "<5" ///
								VisitPostA_tenure2 = "[5,12]" ///
								VisitPostA_tenure3 = " >12" ///
								,labsize(small) ///
								 )                       ///
					  lev(90) vertical                                                                          ///
					  yline(0)                                                                          ///
					  ytitle("")                                                               ///
					  xtitle("出访时工作年限")                                                               ///
					  addplot(line @b @at)                                                              ///
					  ciopts(recast(rcap))                                                              ///
					  rescale()                                                                      ///
					  scheme(s1mono) 
				qui	  graph save $tables/RD_worktenure.gph, replace 
				

	//////////////////////////////////////////////////////////////////////


 		gen VisitPostA_less6=VisitPostA*(VisitLength<=6 & VisitLength>0)
 		gen VisitPostA_6to12=VisitPostA*(VisitLength>6 & VisitLength<=12)
 		gen VisitPostA_more12=VisitPostA*(VisitLength>12)

		reghdfe EngTotal VisitPostA_less6 VisitPostA_6to12 VisitPostA_more12 VisitPostA, absorb(i.ID i.ID_Faculty#i.Year i.t ) $vce
 			est store m5

  			coefplot, keep(VisitPostA_less6 VisitPostA_6to12 VisitPostA_more12) ///
					  coeflabels( ///
								VisitPostA_less6 = "(0,6]" ///
								VisitPostA_6to12 = "(6,12]" ///
								VisitPostA_more12 = ">12" ///
								,labsize(small) ///
								 )                       ///
					  lev(90) vertical                                                                          ///
					  yline(0)                                                                          ///
					  ytitle("")                                                               ///
					  xtitle("访学时长(月)")                                                               ///
					  addplot(line @b @at)                                                              ///
					  ciopts(recast(rcap))                                                              ///
					  rescale()                                                                      ///
					  scheme(s1mono) 
				qui	  graph save $tables/RD_legnth.gph, replace 
				*qui graph export $tables/RD_legnth.png, replace

	//////////////////////////////////////////////////////////////////////



		replace Visit2_StartYear=. if Visit2_StartYear>2018 
		replace Visit3_StartYear=. if Visit3_StartYear>2018 
		replace Visit4_StartYear=. if Visit4_StartYear>2018 
		gen Visit_1times=mi(Visit2_StartYear) & VisitPostA
		gen Visit_2times=!mi(Visit2_StartYear) & VisitPostA //& mi(Visit3_StartYear) & VisitPostA

		reghdfe EngTotal Visit_1times Visit_2times  , absorb(i.ID i.ID_Faculty#i.Year i.t ) $vce
 			est store m1

 		test Visit_1times=Visit_2times

			coefplot, keep(Visit_1times Visit_2times Visit_3times Visit_4times Visit_5times) ///
					  coeflabels( ///
								Visit_1times = "单次" ///
								Visit_2times = "多次" ///
								,labsize(small) ///
								 )                       ///
					  lev(90) vertical                                                                          ///
					  yline(0)                                                                          ///
					  ytitle("")                                                               ///
					  xtitle("访学次数")                                                               ///
					  addplot(line @b @at)                                                              ///
					  ciopts(recast(rcap))                                                              ///
					  rescale()                                                                      ///
					  scheme(s1mono) 
				qui	  graph save $tables/RD_times.gph, replace 
				*qui graph export $tables/RD_gender.png, replace




		/*
		import excel using Is211.xlsx, firstrow clear
			keep ID_Faculty Is211 SchoolRank
			save SchoolInfo.dta,replace 
		*/

		 merge m:1 ID_Faculty using SchoolInfo.dta,gen(m_SchoolInfo)

		gen VisitPostA_Is985=VisitPostA*(1-(Is211==1))

		cap drop VisitPostA_Top*
		gen VisitPostA_Top2=VisitPostA*(SchoolRank<=15)
		gen VisitPostA_Top50=VisitPostA*(SchoolRank<=32 & SchoolRank>15)
		gen VisitPostA_Top100=VisitPostA*(SchoolRank<=. & SchoolRank>32)
		*gen VisitPostA_Top100=VisitPostA*(SchoolRank<=. & SchoolRank>50)


		reghdfe EngTotal VisitPostA_Top* , absorb(i.ID i.ID_Faculty#i.Year i.t ) $vce
 			est store m6

 			test VisitPostA_Top2=VisitPostA_Top10=VisitPostA_Top50
 			test VisitPostA_Top2=VisitPostA_Top10
 			test VisitPostA_Top10=VisitPostA_Top50

  			coefplot, keep(VisitPostA_Top2 VisitPostA_Top10 VisitPostA_Top50 VisitPostA_Top100)  ///
					  coeflabels(  ///
								VisitPostA_Top2 = "前1/3"    ///
								VisitPostA_Top50 = "中1/3"  ///
								VisitPostA_Top100= "后1/3"  ///
								,labsize(small)           ///
								 )                       ///
					  lev(90) vertical                   ///
					  yline(0)                           ///
					  ytitle("")                         ///
					  xtitle("学者所在学校排名")           ///
					  addplot(line @b @at)               ///
					  ciopts(recast(rcap))               ///
					  rescale()                          ///
					  scheme(s1mono) 
				qui	  graph save $tables/RD_DomRank.gph, replace 
				*qui graph export $tables/RD_legnth.png, replace


	gr combine $tables/RD_gender.gph $tables/RD_PhD.gph $tables/RD_worktenure.gph  $tables/RD_legnth.gph $tables/RD_times.gph $tables/RD_DomRank.gph, ///
	ycommon rows(2) b1title("") graphregion(fcolor(white))
	//RD_continent.gph
	gr export "$tables/Figure4.png", width(3000) replace


	end

/*------------------------------------ End of program  ------------------------------------*/










