
log using "Logfile.smcl", replace name("中国劳动收入份额变化：微观视角剖析_程序运行日志")
********************************************************************************
                    /* 中国劳动收入份额变化：微观视角剖析 */
                            /* 张俊森 余 琪 周 康 */
********************************************************************************
* 生成文章图表完整代码
* 版本：2024年11月2日
* 导入数据：Analysis_ASIF.dta
*           Analysis_ASIF_Balance.dta
*           Analysis_ASIF_SOE_Balance.dta
*           Analysis_ASIF_PE_Balance.dta
*           Analysis_NTSD.dta
*           Analysis_NTSD_Balance.dta
*           ls_summary.xlsx      
* 导出图表：正文图1-7
*           附录表I1
*           附录图I1; 图A1-A4; 图III1-III2; 图IV1; 图V1
********************************************************************************
clear all
set more off
graph set window fontface "宋体"
global dir "D:\程序代码"

********************************************************************************
********************************************************************************
                         ***************************                            
						 *                         *                            
						 *        正文图表         *                            
						 *                         *                            
						 ***************************                            
********************************************************************************
********************************************************************************
// 图1  中国制造业部门加总和个体劳动收入份额变化（1998-2007年） 
********************************************************************************
use "$dir\Data\Analysis_ASIF.dta", clear

preserve
bys year: cumul ls, gen(ls_cumul_t)
keep if ls_cumul_t >= 0.49 & ls_cumul_t <= 0.51
collapse (mean) ls, by(year)
rename ls med_ls_t
save "$dir\Temp\temp.dta", replace
restore

preserve
collapse (mean) ls_t, by(year)
merge 1:1 year using "$dir\Temp\temp.dta", nogenerate
	   
twoway (connect ls_t year, lpattern(solid) msymbol(circle) msize(small) yaxis(1)) (connect med_ls_t year, lpattern(dash) msymbol(triangle) msize(small) yaxis(2)), graphregion(color(white)) ytitle("加总劳动收入份额") ytitle("个体劳动收入份额", axis(2)) xtitle("年份") yscale(range(0.24 0.34)) ylabel(0.24(0.02)0.34, angle(0) format(%10.2f) grid) ylabel(0.2(0.05)0.45, axis(2) angle(0) format(%10.2f)) xscale(range(1998 2007)) xlabel(1998(1)2007) xline(2001 2003, lp(dash) lc(navy)) legend(label(1 "加总（左坐标轴）") label(2 "中间值（右坐标轴）"))
	   
graph save "$dir\Output\Figure 1", replace
restore

********************************************************************************
// 图2  劳动收入份额与市场份额变化（1998年、2007年）
********************************************************************************
foreach n of numlist 1998 2007{
preserve
keep if year == `n'

gen num = 1 
bys ind_dig2: egen total_num = sum(num)
gen share_num = num / total_num

bys ind_dig2: egen total_va = sum(value_add_inc)
gen share_va = value_add_inc / total_va

collapse (sum) share_num share_va, by(ind_dig2 sort_ls)
save "$dir\Temp\temp.dta", replace
restore

preserve
keep if year == `n'
collapse (sum) value_add_inc, by(ind_dig2)

egen sum_va = sum(value_add_inc)
gen weight = value_add_inc / sum_va
keep ind_dig2 weight

merge 1:n ind_dig2 using "$dir\Temp\temp.dta"

gen share_num_weight = share_num * weight
gen share_va_weight = share_va * weight
collapse (sum) share_num_weight share_va_weight, by(sort_ls)

twoway (bar share_num_weight sort_ls, barwidth(0.1)) (line share_va_weight sort_ls, lcolor(black)), graphregion(color(white)) title("年份： `n'") ytitle("分布") xtitle("劳动收入份额") yscale(range(0 0.3)) ylabel(0(0.05)0.3, angle(0) format(%10.2f)) xscale(range(0 1.4)) xlabel(0(0.2)1.4, format(%10.1f)) legend(label(1 "企业数量") label(2 "增加值"))

graph save "$dir\Output\Figure 2_`n'", replace	
restore
}

********************************************************************************
// 图3  加总劳动收入份额变化分解（1998-2007年）
********************************************************************************
use "$dir\Data\Analysis_ASIF_Balance.dta", clear

preserve
drop ls_t total_wage_t total_va_t
bys year: egen total_wage_t = sum(total_wage)
bys year: egen total_va_t = sum(value_add_inc)
gen ls_t = total_wage_t / total_va_t
gen omega = value_add_inc / total_va_t
bys year: egen mean_omega = mean(omega)
bys year: egen mean_ls = mean(ls)

sort id year

bys id: gen L_omega = L.omega
bys id: gen L_mean_omega = L.mean_omega
bys id: gen L_ls = L.ls
bys id: gen L_mean_ls = L.mean_ls

gen composition_1 = (omega - mean_omega) * (ls - mean_ls)
gen composition_2 = (L_omega - L_mean_omega) * (L_ls - L_mean_ls)

gen big_player = (L_omega - L_mean_omega) * (ls - L_ls - mean_ls + L_mean_ls)
gen superstar = (omega - L_omega - mean_omega + L_mean_omega) * (L_ls - L_mean_ls)
gen rising_star = (omega - L_omega - mean_omega + L_mean_omega) * (ls - L_ls - mean_ls + L_mean_ls)

gen cumul_composition_1 = (omega - mean_omega) * (ls - mean_ls)
bys id: gen omega_1998 = omega[1]
bys id: gen mean_omega_1998 = mean_omega[1]
bys id: gen ls_1998 = ls[1]
bys id: gen mean_ls_1998 = mean_ls[1]
gen cumul_composition_2 = (omega_1998 - mean_omega_1998) * (ls_1998 - mean_ls_1998)

gen cumul_big_player = (omega_1998 - mean_omega_1998) * (ls - ls_1998 - mean_ls + mean_ls_1998)
gen cumul_superstar = (omega - omega_1998 - mean_omega + mean_omega_1998) * (ls_1998 - mean_ls_1998)
gen cumul_rising_star = (omega - omega_1998 - mean_omega + mean_omega_1998) * (ls - ls_1998 - mean_ls + mean_ls_1998)
	
collapse (mean) ls_t ls (sum) composition_1 composition_2 big_player superstar rising_star cumul*, by(year)

gen composition = composition_1 - composition_2
gen test1 = big_player + superstar + rising_star
tsset year
gen test2 = D.ls_t - D.ls
gen D_ls_t = D.ls_t
gen D_ls = D.ls
drop test1 test2

gen cumul_composition = cumul_composition_1 - cumul_composition_2
gen ls_t_1998 = ls_t[1]
gen ls_1998 = ls[1]
gen cumul_D_ls_t = ls_t - ls_t_1998
gen cumul_D_ls = ls - ls_1998
gen test1 = cumul_D_ls_t - cumul_D_ls
gen test2 = cumul_big_player + cumul_superstar + cumul_rising_star
drop test1 test2

*********************************
*         年度变动分解          *
*********************************
graph bar D_ls_t D_ls big_player superstar rising_star if year >= 1999, graphregion(color(white)) title("年度变动分解") over(year) bargap(0.6) ytitle("劳动收入份额年度变动") bar(1, color(navy) fintensity(inten100)) bar(2, color(navy) fintensity(inten80)) bar(3, color(navy) fintensity(inten50)) bar(4, color(navy) fintensity(inten20)) bar(5, color(navy) fintensity(inten0)) yscale(range(-0.02 0.02)) ylabel(-0.02(0.01)0.02, angle(0) format(%10.2f)) legend(label(1 "加总") label(2 "个体") label(3 "大玩家") label(4 "超级明星") label(5 "明日之星") rows(2))

graph save "$dir\Output\Figure 3_A", replace 

*********************************
*         累计变动分解          *
*********************************
graph bar cumul_D_ls_t cumul_D_ls cumul_big_player cumul_superstar cumul_rising_star if year >= 1999, graphregion(color(white)) title("累计变动分解") over(year) bargap(0.6) ytitle("劳动收入份额累计变动") bar(1, color(navy) fintensity(inten100)) bar(2, color(navy) fintensity(inten80)) bar(3, color(navy) fintensity(inten50)) bar(4, color(navy) fintensity(inten20)) bar(5, color(navy) fintensity(inten0)) yscale(range(-0.12 0.04)) ylabel(-0.12(0.02)0.04, angle(0) format(%10.2f)) legend(label(1 "加总") label(2 "个体") label(3 "大玩家") label(4 "超级明星") label(5 "明日之星") rows(2))

graph save "$dir\Output\Figure 3_B", replace
restore

********************************************************************************
// 图4  中国制造业部门加总和个体劳动收入份额变化（2008-2016年）
********************************************************************************
use "$dir\Data\Analysis_NTSD.dta", clear

preserve
bys year: cumul ls, gen(ls_cumul_t)
keep if ls_cumul_t >= 0.49 & ls_cumul_t <= 0.51
collapse (mean) ls, by(year)
rename ls med_ls_t
save "$dir\Temp\temp.dta", replace
restore

preserve
collapse (mean) ls_t, by(year)
merge 1:1 year using "$dir\Temp\temp.dta", nogenerate
	   
twoway (connect ls_t year, lpattern(solid) msymbol(circle) msize(small) yaxis(1)) (connect med_ls_t year, lpattern(dash) msymbol(triangle) msize(small) yaxis(2)), graphregion(color(white)) ytitle("加总劳动收入份额") ytitle("个体劳动收入份额", axis(2)) xtitle("年份") yscale(range(0.28 0.38)) ylabel(0.28(0.02)0.38, angle(0) format(%10.2f) grid) ylabel(0.5(0.02)0.6, axis(2) angle(0) format(%10.2f)) xscale(range(2008 2016)) xlabel(2008(1)2016) legend(label(1 "加总（左坐标轴）") label(2 "中间值（右坐标轴）"))
	   
graph save "$dir\Output\Figure 4", replace
restore

********************************************************************************
// 图5  企业数量、劳动投入及增加值分布（2008年、2016年）
********************************************************************************
*********************************
*            2008年             *
*********************************
preserve
keep if year == 2008

gen num = 1 
bys ind_dig2: egen total_num = sum(num)
gen share_num = num / total_num

bys ind_dig2: egen total_worker = sum(worker)
gen share_worker = worker / total_worker 

bys ind_dig2: egen total_va = sum(value_add_inc)
gen share_va = value_add_inc / total_va

collapse (sum) share_num share_worker share_va, by(ind_dig2 sort_ls)
save "$dir\Temp\temp.dta", replace
restore

preserve
keep if year == 2008
collapse (sum) value_add_inc, by(ind_dig2)

egen sum_va = sum(value_add_inc)
gen weight = value_add_inc / sum_va
keep ind_dig2 weight

merge 1:n ind_dig2 using "$dir\Temp\temp.dta"

gen share_num_weight = share_num * weight
gen share_worker_weight = share_worker * weight
gen share_va_weight = share_va * weight
collapse (sum) share_num_weight share_worker_weight share_va_weight, by(sort_ls)

drop if sort_ls > 1

twoway (bar share_num_weight sort_ls, bcolor(gray) barwidth(0.1)), graphregion(color(white)) title("2008") subtitle("企业数量占比", pos(11)) ytitle("占比") xtitle("劳动收入份额") yscale(range(0 0.16)) ylabel(0(0.02)0.16, angle(0) format(%10.2f)) xscale(range(0 1)) xlabel(0(0.2)1, format(%10.1f))

graph save "$dir\Output\Figure 5_A1", replace	

twoway (bar share_worker_weight sort_ls, bcolor(gray) barwidth(0.1)), graphregion(color(white)) title("2008") subtitle("劳动投入占比", pos(11)) ytitle("占比") xtitle("劳动收入份额") yscale(range(0 0.16)) ylabel(0(0.02)0.16, angle(0) format(%10.2f)) xscale(range(0 1)) xlabel(0(0.2)1, format(%10.1f))

graph save "$dir\Output\Figure 5_A2", replace	

twoway (bar share_va_weight sort_ls, bcolor(gray) barwidth(0.1)), graphregion(color(white)) title("2008") subtitle("增加值占比", pos(11)) ytitle("占比") xtitle("劳动收入份额") yscale(range(0 0.3)) ylabel(0(0.05)0.3, angle(0) format(%10.2f)) xscale(range(0 1)) xlabel(0(0.2)1, format(%10.1f))

graph save "$dir\Output\Figure 5_A3", replace	
restore

*********************************
*            2016年             *
*********************************
preserve
keep if year == 2016

gen num = 1 
bys ind_dig2: egen total_num = sum(num)
gen share_num = num / total_num

bys ind_dig2: egen total_worker = sum(worker)
gen share_worker = worker / total_worker 

bys ind_dig2: egen total_va = sum(value_add_inc)
gen share_va = value_add_inc / total_va

collapse (sum) share_num share_worker share_va, by(ind_dig2 sort_ls)
save "$dir\Temp\temp.dta", replace
restore

preserve
keep if year == 2016
collapse (sum) value_add_inc, by(ind_dig2)

egen sum_va = sum(value_add_inc)
gen weight = value_add_inc / sum_va
keep ind_dig2 weight

merge 1:n ind_dig2 using "$dir\Temp\temp.dta"

gen share_num_weight = share_num * weight
gen share_worker_weight = share_worker * weight
gen share_va_weight = share_va * weight
collapse (sum) share_num_weight share_worker_weight share_va_weight, by(sort_ls)

drop if sort_ls > 1

twoway (bar share_num_weight sort_ls, bcolor(black) barwidth(0.1)), graphregion(color(white)) title("2016") subtitle("企业数量占比", pos(11)) ytitle("占比") xtitle("劳动收入份额") yscale(range(0 0.16)) ylabel(0(0.02)0.16, angle(0) format(%10.2f)) xscale(range(0 1)) xlabel(0(0.2)1, format(%10.1f))

graph save "$dir\Output\Figure 5_B1", replace	

twoway (bar share_worker_weight sort_ls, bcolor(black) barwidth(0.1)), graphregion(color(white)) title("2016") subtitle("劳动投入占比", pos(11)) ytitle("占比")  xtitle("劳动收入份额") yscale(range(0 0.16)) ylabel(0(0.02)0.16, angle(0) format(%10.2f)) xscale(range(0 1)) xlabel(0(0.2)1, format(%10.1f))

graph save "$dir\Output\Figure 5_B2", replace	

twoway (bar share_va_weight sort_ls, bcolor(black) barwidth(0.1)), graphregion(color(white)) title("2016") subtitle("增加值占比", pos(11)) ytitle("占比") xtitle("劳动收入份额") yscale(range(0 0.3)) ylabel(0(0.05)0.3, angle(0) format(%10.2f)) xscale(range(0 1)) xlabel(0(0.2)1, format(%10.1f))

graph save "$dir\Output\Figure 5_B3", replace		
restore

********************************************************************************
// 图6  国有、私营和外资企业加总与个体劳动收入份额变化（1998-2007年）
********************************************************************************
use "$dir\Data\Analysis_ASIF", clear

preserve
bys year firm_type: cumul ls, gen(ls_cumul_t)
keep if ls_cumul_t >= 0.49 & ls_cumul_t <= 0.51
collapse (mean) ls, by(year firm_type)
rename ls med_ls_t
save "$dir\Temp\temp.dta", replace
restore

preserve
bys year firm_type: egen total_wage_t_type = sum(total_wage)
bys year firm_type: egen total_va_t_type = sum(value_add_inc)
gen ls_t_type = total_wage_t_type / total_va_t_type
collapse (mean) ls_t_type ls, by(year firm_type)
merge 1:1 year firm_type using "$dir\Temp\temp.dta", nogenerate

*********************************
*           国有企业            *
*********************************
twoway (connect ls_t_type year if firm_type == 1, lpattern(solid) msymbol(circle) msize(small)) (connect med_ls_t year if firm_type == 1, lpattern(dash) msymbol(triangle) msize(small)) (connect ls year if firm_type == 1, lpattern(longdash) msymbol(diamond) msize(small)),  graphregion(color(white)) title("国有企业") ytitle("劳动收入份额") xtitle("年份") yscale(range(0.2 0.55)) ylabel(0.2(0.05)0.55, angle(0) format(%10.2f)) xscale(range(1998 2007)) xlabel(1998(1)2007) legend(label(1 "加总") label(2 "中间值") label(3 "均值") rows(1)) 

graph save "$dir\Output\Figure 6_A", replace

*********************************
*           私营企业            *
*********************************
twoway (connect ls_t_type year if firm_type == 2, lpattern(solid) msymbol(circle) msize(small)) (connect med_ls_t year if firm_type == 2, lpattern(dash) msymbol(triangle) msize(small)) (connect ls year if firm_type == 2, lpattern(longdash) msymbol(diamond) msize(small)), graphregion(color(white)) title("私营企业") ytitle("劳动收入份额") xtitle("年份") yscale(range(0.25 0.45)) ylabel(0.25(0.05)0.45, angle(0) format(%10.2f)) xscale(range(1998 2007)) xlabel(1998(1)2007) legend(label(1 "加总") label(2 "中间值") label(3 "均值") rows(1))   

graph save "$dir\Output\Figure 6_B", replace

*********************************
*           外资企业            *
*********************************
twoway (connect ls_t_type year if firm_type == 3, lpattern(solid) msymbol(circle) msize(small)) (connect med_ls_t year if firm_type == 3, lpattern(dash) msymbol(triangle) msize(small)) (connect ls year if firm_type == 3, lpattern(longdash) msymbol(diamond) msize(small)), graphregion(color(white)) title("外资企业") ytitle("劳动收入份额") xtitle("年份") yscale(range(0.2 0.45)) ylabel(0.2(0.05)0.45, angle(0) format(%10.2f)) xscale(range(1998 2007)) xlabel(1998(1)2007) legend(label(1 "加总") label(2 "中间值") label(3 "均值") rows(1))
   
graph save "$dir\Output\Figure 6_C", replace
restore

********************************************************************************
// 图7  国有、私营与整体制造业企业加总劳动收入份额变化分解（1998-2007年）
********************************************************************************
*********************************
*           国有企业            *
*********************************
preserve
use "$dir\Data\Analysis_ASIF_SOE_Balance.dta", clear

drop ls_t total_wage_t total_va_t
bys year: egen total_wage_t = sum(total_wage)
bys year: egen total_va_t = sum(value_add_inc)
gen ls_t = total_wage_t / total_va_t
gen omega = value_add_inc / total_va_t
bys year: egen mean_omega = mean(omega)
bys year: egen mean_ls = mean(ls)

sort id year

bys id: gen L_omega = L.omega
bys id: gen L_mean_omega = L.mean_omega
bys id: gen L_ls = L.ls
bys id: gen L_mean_ls = L.mean_ls

gen composition_1 = (omega - mean_omega) * (ls - mean_ls)
gen composition_2 = (L_omega - L_mean_omega) * (L_ls - L_mean_ls)

gen big_player = (L_omega - L_mean_omega) * (ls - L_ls - mean_ls + L_mean_ls)
gen superstar = (omega - L_omega - mean_omega + L_mean_omega) * (L_ls - L_mean_ls)
gen rising_star = (omega - L_omega - mean_omega + L_mean_omega) * (ls - L_ls - mean_ls + L_mean_ls)

gen cumul_composition_1 = (omega - mean_omega) * (ls - mean_ls)
bys id: gen omega_1998 = omega[1]
bys id: gen mean_omega_1998 = mean_omega[1]
bys id: gen ls_1998 = ls[1]
bys id: gen mean_ls_1998 = mean_ls[1]
gen cumul_composition_2 = (omega_1998 - mean_omega_1998) * (ls_1998 - mean_ls_1998)

gen cumul_big_player = (omega_1998 - mean_omega_1998) * (ls - ls_1998 - mean_ls + mean_ls_1998)
gen cumul_superstar = (omega - omega_1998 - mean_omega + mean_omega_1998) * (ls_1998 - mean_ls_1998)
gen cumul_rising_star = (omega - omega_1998 - mean_omega + mean_omega_1998) * (ls - ls_1998 - mean_ls + mean_ls_1998)
	
collapse (mean) ls_t ls (sum) composition_1 composition_2 big_player superstar rising_star cumul*, by(year)

gen composition = composition_1 - composition_2
gen test1 = big_player + superstar + rising_star
tsset year
gen test2 = D.ls_t - D.ls
gen D_ls_t = D.ls_t
gen D_ls = D.ls
drop test1 test2

gen cumul_composition = cumul_composition_1 - cumul_composition_2
gen ls_t_1998 = ls_t[1]
gen ls_1998 = ls[1]
gen cumul_D_ls_t = ls_t - ls_t_1998
gen cumul_D_ls = ls - ls_1998
gen test1 = cumul_D_ls_t - cumul_D_ls
gen test2 = cumul_big_player + cumul_superstar + cumul_rising_star
drop test1 test2

graph bar cumul_D_ls_t cumul_D_ls cumul_big_player cumul_superstar cumul_rising_star if year >= 1999, graphregion(color(white)) title("累计变动分解（国有企业）")  over(year) bargap(0.6) ytitle("劳动收入份额累计变动") bar(1, color(navy) fintensity(inten100)) bar(2, color(navy) fintensity(inten80)) bar(3, color(navy) fintensity(inten50)) bar(4, color(navy) fintensity(inten20)) bar(5, color(navy) fintensity(inten0)) yscale(range(-0.14 0.02)) ylabel(-0.14(0.02)0.02, angle(0) format(%10.2f)) legend(label(1 "加总") label(2 "个体") label(3 "大玩家") label(4 "超级明星") label(5 "明日之星") rows(2))

graph save "$dir\Output\Figure 7_A", replace
restore

*********************************
*           私营企业            *
*********************************
preserve
use "$dir\Data\Analysis_ASIF_PE_Balance.dta", clear

drop ls_t total_wage_t total_va_t
bys year: egen total_wage_t = sum(total_wage)
bys year: egen total_va_t = sum(value_add_inc)
gen ls_t = total_wage_t / total_va_t
gen omega = value_add_inc / total_va_t
bys year: egen mean_omega = mean(omega)
bys year: egen mean_ls = mean(ls)

sort id year

bys id: gen L_omega = L.omega
bys id: gen L_mean_omega = L.mean_omega
bys id: gen L_ls = L.ls
bys id: gen L_mean_ls = L.mean_ls

gen composition_1 = (omega - mean_omega) * (ls - mean_ls)
gen composition_2 = (L_omega - L_mean_omega) * (L_ls - L_mean_ls)

gen big_player = (L_omega - L_mean_omega) * (ls - L_ls - mean_ls + L_mean_ls)
gen superstar = (omega - L_omega - mean_omega + L_mean_omega) * (L_ls - L_mean_ls)
gen rising_star = (omega - L_omega - mean_omega + L_mean_omega) * (ls - L_ls - mean_ls + L_mean_ls)

gen cumul_composition_1 = (omega - mean_omega) * (ls - mean_ls)
bys id: gen omega_1998 = omega[1]
bys id: gen mean_omega_1998 = mean_omega[1]
bys id: gen ls_1998 = ls[1]
bys id: gen mean_ls_1998 = mean_ls[1]
gen cumul_composition_2 = (omega_1998 - mean_omega_1998) * (ls_1998 - mean_ls_1998)

gen cumul_big_player = (omega_1998 - mean_omega_1998) * (ls - ls_1998 - mean_ls + mean_ls_1998)
gen cumul_superstar = (omega - omega_1998 - mean_omega + mean_omega_1998) * (ls_1998 - mean_ls_1998)
gen cumul_rising_star = (omega - omega_1998 - mean_omega + mean_omega_1998) * (ls - ls_1998 - mean_ls + mean_ls_1998)
	
collapse (mean) ls_t ls (sum) composition_1 composition_2 big_player superstar rising_star cumul*, by(year)

gen composition = composition_1 - composition_2
gen test1 = big_player + superstar + rising_star
tsset year
gen test2 = D.ls_t - D.ls
gen D_ls_t = D.ls_t
gen D_ls = D.ls
drop test1 test2

gen cumul_composition = cumul_composition_1 - cumul_composition_2
gen ls_t_1998 = ls_t[1]
gen ls_1998 = ls[1]
gen cumul_D_ls_t = ls_t - ls_t_1998
gen cumul_D_ls = ls - ls_1998
gen test1 = cumul_D_ls_t - cumul_D_ls
gen test2 = cumul_big_player + cumul_superstar + cumul_rising_star
drop test1 test2

graph bar cumul_D_ls_t cumul_D_ls cumul_big_player cumul_superstar cumul_rising_star if year >= 1999, graphregion(color(white)) title("累计变动分解（私营企业）")  over(year) bargap(0.6) ytitle("劳动收入份额累计变动") bar(1, color(navy) fintensity(inten100)) bar(2, color(navy) fintensity(inten80)) bar(3, color(navy) fintensity(inten50)) bar(4, color(navy) fintensity(inten20)) bar(5, color(navy) fintensity(inten0)) yscale(range(-0.12 0.08)) ylabel(-0.12(0.02)0.08, angle(0) format(%10.2f)) legend(label(1 "加总") label(2 "个体") label(3 "大玩家") label(4 "超级明星") label(5 "明日之星") rows(2))

graph save "$dir\Output\Figure 7_B", replace
restore

*********************************
*           全制造业            *
*********************************
preserve
use "$dir\Data\Analysis_ASIF_Balance.dta", clear
collapse (sum) total_wage value_add_inc, by(year firm_type)
gen ls = total_wage / value_add_inc
bys year: egen value_add_inc_t = sum(value_add_inc)
bys year: egen total_wage_t = sum(total_wage)
gen ls_t = total_wage_t / value_add_inc_t
gen omega = value_add_inc / value_add_inc_t

keep year firm_type ls_t omega
reshape wide ls_t omega, i(year) j(firm_type)
tsset year
gen cumul_D_ls_t = ls_t1 - ls_t1[1]
keep year omega* cumul_D_ls_t

save "$dir\Temp\temp.dta",replace
restore

preserve
use "$dir\Data\Analysis_ASIF_SOE_Balance.dta", clear

drop ls_t total_wage_t total_va_t
bys year: egen total_wage_t = sum(total_wage)
bys year: egen total_va_t = sum(value_add_inc)
gen ls_t = total_wage_t / total_va_t
gen omega = value_add_inc / total_va_t
bys year: egen mean_omega = mean(omega)
bys year: egen mean_ls = mean(ls)

sort id year

bys id: gen L_omega = L.omega
bys id: gen L_mean_omega = L.mean_omega
bys id: gen L_ls = L.ls
bys id: gen L_mean_ls = L.mean_ls

gen composition_1 = (omega - mean_omega) * (ls - mean_ls)
gen composition_2 = (L_omega - L_mean_omega) * (L_ls - L_mean_ls)

gen big_player = (L_omega - L_mean_omega) * (ls - L_ls - mean_ls + L_mean_ls)
gen superstar = (omega - L_omega - mean_omega + L_mean_omega) * (L_ls - L_mean_ls)
gen rising_star = (omega - L_omega - mean_omega + L_mean_omega) * (ls - L_ls - mean_ls + L_mean_ls)

gen cumul_composition_1 = (omega - mean_omega) * (ls - mean_ls)
bys id: gen omega_1998 = omega[1]
bys id: gen mean_omega_1998 = mean_omega[1]
bys id: gen ls_1998 = ls[1]
bys id: gen mean_ls_1998 = mean_ls[1]
gen cumul_composition_2 = (omega_1998 - mean_omega_1998) * (ls_1998 - mean_ls_1998)

gen cumul_big_player = (omega_1998 - mean_omega_1998) * (ls - ls_1998 - mean_ls + mean_ls_1998)
gen cumul_superstar = (omega - omega_1998 - mean_omega + mean_omega_1998) * (ls_1998 - mean_ls_1998)
gen cumul_rising_star = (omega - omega_1998 - mean_omega + mean_omega_1998) * (ls - ls_1998 - mean_ls + mean_ls_1998)
	
collapse (mean) ls_t ls (sum) composition_1 composition_2 big_player superstar rising_star cumul*, by(year)

gen composition = composition_1 - composition_2
gen test1 = big_player + superstar + rising_star
tsset year
gen test2 = D.ls_t - D.ls
gen D_ls_t = D.ls_t
gen D_ls = D.ls
drop test1 test2

gen cumul_composition = cumul_composition_1 - cumul_composition_2
gen ls_t_1998 = ls_t[1]
gen ls_1998 = ls[1]
gen cumul_D_ls_t = ls_t - ls_t_1998
gen cumul_D_ls = ls - ls_1998

keep year cumul_D_ls_t cumul_D_ls cumul_big_player cumul_superstar cumul_rising_star
renvars _all, suffix(_soe)
rename year_soe year

merge 1:1 year using "$dir\Temp\temp.dta"
drop _merge

save "$dir\Temp\temp.dta",replace
restore

preserve
use "$dir\Data\Analysis_ASIF_PE_Balance.dta", clear

drop ls_t total_wage_t total_va_t
bys year: egen total_wage_t = sum(total_wage)
bys year: egen total_va_t = sum(value_add_inc)
gen ls_t = total_wage_t / total_va_t
gen omega = value_add_inc / total_va_t
bys year: egen mean_omega = mean(omega)
bys year: egen mean_ls = mean(ls)

sort id year

bys id: gen L_omega = L.omega
bys id: gen L_mean_omega = L.mean_omega
bys id: gen L_ls = L.ls
bys id: gen L_mean_ls = L.mean_ls

gen composition_1 = (omega - mean_omega) * (ls - mean_ls)
gen composition_2 = (L_omega - L_mean_omega) * (L_ls - L_mean_ls)

gen big_player = (L_omega - L_mean_omega) * (ls - L_ls - mean_ls + L_mean_ls)
gen superstar = (omega - L_omega - mean_omega + L_mean_omega) * (L_ls - L_mean_ls)
gen rising_star = (omega - L_omega - mean_omega + L_mean_omega) * (ls - L_ls - mean_ls + L_mean_ls)

gen cumul_composition_1 = (omega - mean_omega) * (ls - mean_ls)
bys id: gen omega_1998 = omega[1]
bys id: gen mean_omega_1998 = mean_omega[1]
bys id: gen ls_1998 = ls[1]
bys id: gen mean_ls_1998 = mean_ls[1]
gen cumul_composition_2 = (omega_1998 - mean_omega_1998) * (ls_1998 - mean_ls_1998)

gen cumul_big_player = (omega_1998 - mean_omega_1998) * (ls - ls_1998 - mean_ls + mean_ls_1998)
gen cumul_superstar = (omega - omega_1998 - mean_omega + mean_omega_1998) * (ls_1998 - mean_ls_1998)
gen cumul_rising_star = (omega - omega_1998 - mean_omega + mean_omega_1998) * (ls - ls_1998 - mean_ls + mean_ls_1998)
	
collapse (mean) ls_t ls (sum) composition_1 composition_2 big_player superstar rising_star cumul*, by(year)

gen composition = composition_1 - composition_2
gen test1 = big_player + superstar + rising_star
tsset year
gen test2 = D.ls_t - D.ls
gen D_ls_t = D.ls_t
gen D_ls = D.ls
drop test1 test2

gen cumul_composition = cumul_composition_1 - cumul_composition_2
gen ls_t_1998 = ls_t[1]
gen ls_1998 = ls[1]
gen cumul_D_ls_t = ls_t - ls_t_1998
gen cumul_D_ls = ls - ls_1998

keep year cumul_D_ls_t cumul_D_ls cumul_big_player cumul_superstar cumul_rising_star
renvars _all, suffix(_fe)
rename year_fe year

merge 1:1 year using "$dir\Temp\temp.dta"
drop _merge

foreach var of varlist *soe{
	replace `var' = `var' * omega1
}

foreach var of varlist *fe{
	replace `var' = `var' * omega2
}

graph bar cumul_D_ls_t cumul_D_ls_soe cumul_big_player_soe cumul_superstar_soe cumul_rising_star_soe cumul_D_ls_fe cumul_big_player_fe cumul_superstar_fe cumul_rising_star_fe if year >= 1999, graphregion(color(white)) title("累计变动分解（全制造业）") over(year) bargap(0.6) ytitle("劳动收入份额累计变动") yscale(range(-0.08 0.04)) ylabel(-0.08(0.02)0.04, angle(0) format(%10.2f)) legend(label(1 "加总") label(2 "国企-个体") label(3 "国企-大玩家") label(4 "国企-超级明星") label(5 "国企-明日之星") label(6 "私企-个体") label(7 "私企-大玩家") label(8 "私企-超级明星") label(9 "私企-明日之星") rows(3))

graph save "$dir\Output\Figure 7_C", replace
restore


********************************************************************************
********************************************************************************
                         ***************************                            
						 *                         *                            
						 *        附录图表         *                            
						 *                         *                            
						 ***************************                            
********************************************************************************
********************************************************************************
//                       附录 I  样本筛选及描述性统计                         //
********************************************************************************
********************************************************************************
// 表I1  描述性统计
********************************************************************************
use "$dir\Data\Analysis_ASIF.dta", clear
cd "$dir\Output" 

logout, save (Table I1) text replace: tabstat total_wage worker value_add_inc ls, stat(mean sd min max count) col(stat) format(%20.2f)

********************************************************************************
// 图I1  中国劳动收入份额变化（1998-2007年）
********************************************************************************
preserve
import excel "$dir\Data\ls_summary.xlsx", sheet("Sheet1") firstrow clear

twoway (connect lv year, lp(longdash) ms(circle) msize(small)) (connect bai year, lp(longdash_dot) ms(diamond) msize(small)) (connect jia year, lp(solid) ms(triangle) msize(small)) (connect qian year, lp(dash_dot) ms(plus) msize(small)) (connect yu year, lp(dash) ms(square) msize(small)), graphregion(color(white)) ytitle(劳动收入份额（%）) xtitle(年份) ylabel(30(5)55) xlabel(1998(1)2007) legend(label(1 吕冰洋和郭庆旺（2012）) label(2 白重恩等（2008）) label(3 贾珅和申广军（2016）) label(4 钱震杰和朱晓冬（2013）) label(5 本文结果) rows(3))

graph save "$dir\Output\Figure I1", replace
restore

********************************************************************************
//                                附录 II  附图                               //
********************************************************************************
********************************************************************************
// 图A1  劳动收入份额与市场份额变化（1998-2007年）
********************************************************************************
foreach n of numlist 1998/2007{
preserve
keep if year == `n'

gen num = 1 
bys ind_dig2: egen total_num = sum(num)
gen share_num = num / total_num

bys ind_dig2: egen total_va = sum(value_add_inc)
gen share_va = value_add_inc / total_va

collapse (sum) share_num share_va, by(ind_dig2 sort_ls)
save "$dir\Temp\temp.dta", replace
restore

preserve
keep if year == `n'
collapse (sum) value_add_inc, by(ind_dig2)

egen sum_va = sum(value_add_inc)
gen weight = value_add_inc / sum_va
keep ind_dig2 weight

merge 1:n ind_dig2 using "$dir\Temp\temp.dta"

gen share_num_weight = share_num * weight
gen share_va_weight = share_va * weight
collapse (sum) share_num_weight share_va_weight, by(sort_ls)

twoway (bar share_num_weight sort_ls, barwidth(0.1)) (line share_va_weight sort_ls, lcolor(black)), graphregion(color(white)) title("年份： `n'") ytitle("分布") xtitle("劳动收入份额") yscale(range(0 0.3)) ylabel(0(0.05)0.3, angle(0) format(%10.2f)) xscale(range(0 1.4)) xlabel(0(0.2)1.4, format(%10.1f)) legend(label(1 "企业数量") label(2 "增加值"))

graph save "$dir\Output\Figure A1_`n'", replace	   
restore
}

********************************************************************************
// 图A2  国有、私营和外资企业的数量及增加值占比
********************************************************************************
preserve
gen num = 1
collapse (sum) num value_add_inc, by(year firm_type)
bys year: egen value_add_inc_t = sum(value_add_inc)
bys year: egen num_t = sum(num)
gen share_va = value_add_inc / value_add_inc_t
gen share_num = num / num_t
keep year firm_type share_va share_num
reshape wide share_num share_va, i(year) j(firm_type)

*********************************
*         企业数量占比          *
*********************************
graph bar (mean) share_num1 (mean) share_num2 (mean) share_num3, graphregion(color(white)) over(year) stack title("企业数量占比") bar(1, fcolor("80 80 80") lcolor(black) lwidth(thin)) bar(2, fcolor(white) lcolor(black) lwidth(thin)) bar(3, fcolor("150 150 150") lcolor(black) lwidth(thin)) ytitle("占比") ylabel(, angle(0) format(%10.1f)) legend(order(1 "国有企业" 2 "私营企业" 3 "外资企业") rows(1))

graph save "$dir\Output\Figure A2_A", replace

*********************************
*           增加值占比          *
*********************************
graph bar (mean) share_va1 (mean) share_va2 (mean) share_va3, graphregion(color(white)) over(year) stack title("增加值占比") bar(1, fcolor("80 80 80") lcolor(black) lwidth(thin)) bar(2, fcolor(white) lcolor(black) lwidth(thin)) bar(3, fcolor("150 150 150") lcolor(black) lwidth(thin)) ytitle("占比") ylabel(, angle(0) format(%10.1f)) legend(order(1 "国有企业" 2 "私营企业" 3 "外资企业") rows(1))

graph save "$dir\Output\Figure A2_B", replace
restore

********************************************************************************
// 图A3  中国制造业部门加总和个体劳动收入份额变化（国有、私营和外资企业视角）
********************************************************************************
preserve
collapse (sum) total_wage value_add_inc, by(year firm_type)
gen ls = total_wage / value_add_inc
bys year: egen value_add_inc_t = sum(value_add_inc)
bys year: egen total_wage_t = sum(total_wage)
gen ls_t = total_wage_t / value_add_inc_t

collapse (mean) ls ls_t, by(year)

twoway (connect ls_t year, lpattern(solid) msymbol(circle) msize(small)) (connect ls year, lpattern(dash) msymbol(triangle) msize(small)), graphregion(color(white)) ytitle("劳动收入份额") xtitle("年份") yscale(range(0.24, 0.34)) ylabel(0.24(0.02)0.34, angle(0) format(%20.2f)) xlabel(1998(1)2007) legend(label(1 "加总劳动收入份额") label(2 "个体劳动收入份额"))

graph save "$dir\Output\Figure A3", replace
restore

********************************************************************************
// 图A4  加总劳动收入份额变化分解（国有、私营和外资企业视角）
********************************************************************************
preserve
collapse (sum) total_wage value_add_inc, by(year firm_type)

gen ls = total_wage / value_add_inc
bys year: egen value_add_inc_t = sum(value_add_inc)
bys year: egen total_wage_t = sum(total_wage)
gen ls_t = total_wage_t / value_add_inc_t
gen omega = value_add_inc / value_add_inc_t
bys year: egen mean_omega = mean(omega)
bys year: egen mean_ls = mean(ls)

rename firm_type id
sort id year

bys id: gen L_omega = L.omega
bys id: gen L_mean_omega = L.mean_omega
bys id: gen L_ls = L.ls
bys id: gen L_mean_ls = L.mean_ls

gen composition_1 = (omega - mean_omega) * (ls - mean_ls)
gen composition_2 = (L_omega - L_mean_omega) * (L_ls - L_mean_ls)

gen big_player = (L_omega - L_mean_omega) * (ls - L_ls - mean_ls + L_mean_ls)
gen superstar = (omega - L_omega - mean_omega + L_mean_omega) * (L_ls - L_mean_ls)
gen rising_star = (omega - L_omega - mean_omega + L_mean_omega) * (ls - L_ls - mean_ls + L_mean_ls)

gen cumul_composition_1 = (omega - mean_omega) * (ls - mean_ls)
bys id: gen omega_1998 = omega[1]
bys id: gen mean_omega_1998 = mean_omega[1]
bys id: gen ls_1998 = ls[1]
bys id: gen mean_ls_1998 = mean_ls[1]
gen cumul_composition_2 = (omega_1998 - mean_omega_1998) * (ls_1998 - mean_ls_1998)

gen cumul_big_player = (omega_1998 - mean_omega_1998) * (ls - ls_1998 - mean_ls + mean_ls_1998)
gen cumul_superstar = (omega - omega_1998 - mean_omega + mean_omega_1998) * (ls_1998 - mean_ls_1998)
gen cumul_rising_star = (omega - omega_1998 - mean_omega + mean_omega_1998) * (ls - ls_1998 - mean_ls + mean_ls_1998)
	
collapse (mean) ls_t ls (sum) composition_1 composition_2 big_player superstar rising_star cumul*, by(year)

gen composition = composition_1 - composition_2
gen test1 = big_player + superstar + rising_star
tsset year
gen test2 = D.ls_t - D.ls
gen D_ls_t = D.ls_t
gen D_ls = D.ls
drop test1 test2

gen cumul_composition = cumul_composition_1 - cumul_composition_2
gen ls_t_1998 = ls_t[1]
gen ls_1998 = ls[1]
gen cumul_D_ls_t = ls_t - ls_t_1998
gen cumul_D_ls = ls - ls_1998
gen test1 = cumul_D_ls_t - cumul_D_ls
gen test2 = cumul_big_player + cumul_superstar + cumul_rising_star
drop test1 test2

*********************************
*         年度变动分解          *
*********************************
graph bar D_ls_t D_ls big_player superstar rising_star if year >= 1999, graphregion(color(white)) title("年度变动分解") over(year) bargap(0.6) ytitle("劳动收入份额年度变动") bar(1, color(navy) fintensity(inten100)) bar(2, color(navy) fintensity(inten80)) bar(3, color(navy) fintensity(inten50)) bar(4, color(navy) fintensity(inten20)) bar(5, color(navy) fintensity(inten0)) yscale(range(-0.02 0.01)) ylabel(-0.02(0.01)0.01, angle(0) format(%10.2f)) legend(label(1 "加总") label(2 "个体") label(3 "大玩家") label(4 "超级明星") label(5 "明日之星") rows(2))

graph save "$dir\Output\Figure A4_A", replace 

*********************************
*         累计变动分解          *
*********************************
graph bar cumul_D_ls_t cumul_D_ls cumul_big_player cumul_superstar cumul_rising_star if year >= 1999, graphregion(color(white)) title("累计变动分解") over(year) bargap(0.6) ytitle("劳动收入份额累计变动") bar(1, color(navy) fintensity(inten100)) bar(2, color(navy) fintensity(inten80)) bar(3, color(navy) fintensity(inten50)) bar(4, color(navy) fintensity(inten20)) bar(5, color(navy) fintensity(inten0)) yscale(range(-0.08 0.02)) ylabel(-0.08(0.02)0.02, angle(0) format(%10.2f)) legend(label(1 "加总") label(2 "个体") label(3 "大玩家") label(4 "超级明星") label(5 "明日之星") rows(2))

graph save "$dir\Output\Figure A4_B", replace
restore

********************************************************************************
//                            附录 III  反事实分析                            //
********************************************************************************
********************************************************************************
// 图III1  中国制造业部门加总和个体劳动收入份额变化（平衡面板），1998-2007年
********************************************************************************
use "$dir\Data\Analysis_ASIF_Balance.dta", clear

preserve
bys year: cumul ls, gen(ls_cumul_t)
keep if ls_cumul_t >= 0.49 & ls_cumul_t <= 0.51
collapse (mean) ls, by(year)
rename ls med_ls_t
save "$dir\Temp\temp.dta", replace
restore

preserve
bys year: egen sum_wage = sum(total_wage)
bys year: egen sum_va = sum(value_add_inc)
gen ls_t_balance = sum_wage / sum_va
collapse (mean) ls_t_balance ls, by(year)

merge 1:1 year using "$dir\Temp\temp.dta",nogenerate
	   
twoway (connect ls_t_balance year, lpattern(solid) msymbol(circle) msize(small) yaxis(1)) (connect med_ls_t year, lpattern(dash) msymbol(triangle) msize(small) yaxis(2)), graphregion(color(white)) title("1998-2007年（平衡面板）") ytitle("加总劳动收入份额") ytitle(" 个体劳动收入份额", axis(2)) xtitle("年份") yscale(range(0.22 0.32)) ylabel(0.22(0.02)0.32, angle(0) format(%10.2f) grid) ylabel(0.2(0.05)0.45, axis(2) angle(0) format(%10.2f)) xscale(range(1998 2007)) xlabel(1998(1)2007) legend(label(1 "加总（左坐标轴）") label(2 "中间值（右坐标轴）"))

graph save "$dir\Output\Figure III1", replace 
restore

********************************************************************************
// 图III2  反事实分析："大玩家"和"超级明星"情境
********************************************************************************
*********************************
*          大玩家情境           *
*********************************
preserve
keep if year == 1998
egen total_va_1998_balance = sum(value_add_inc)
gen weight_1998 = value_add_inc / total_va_1998_balance
keep id weight_1998
save "$dir\Temp\temp.dta", replace
restore

preserve
merge n:1 id using "$dir\Temp\temp.dta"
gen ls_weight_1998 = ls * weight_1998

bys year: egen total_va_t_balance = sum(value_add_inc)
gen weight_act = value_add_inc / total_va_t_balance
gen ls_weight_act = ls * weight_act

collapse (sum) ls_weight_act ls_weight_1998, by(year)

twoway (connect ls_weight_act year, lpattern(solid) msymbol(circle) msize(small)) (connect ls_weight_1998 year, lpattern(dash) msymbol(triangle) msize(small)), graphregion(color(white)) title("“大玩家”情境") ytitle("加总劳动收入份额") xtitle("年份") yscale(range(0.22 0.32)) ylabel(0.22(0.02)0.32, angle(0) format(%10.2f)) xscale(range(1998 2007)) xlabel(1998(1)2007) legend(label(1 "劳动收入份额（真实）") label(2 "劳动收入份额（反事实）"))

graph save "$dir\Output\Figure III2_A", replace
restore

*********************************
*         超级明星情境          *
*********************************
preserve
keep if year == 1998
clonevar ls_1998 = ls
keep id ls_1998
save "$dir\Temp\temp.dta", replace
restore

preserve
merge n:1 id using "$dir\Temp\temp.dta"

bys year: egen total_va_t_balance = sum(value_add_inc)
gen weight_act = value_add_inc / total_va_t_balance
gen ls_weight_act = ls * weight_act
gen ls_1998_weight_act = ls_1998 * weight_act

collapse (sum) ls_weight_act ls_1998_weight_act, by(year)

twoway (connect ls_weight_act year, lpattern(solid) msymbol(circle) msize(small)) (connect ls_1998_weight_act year, lpattern(dash) msymbol(triangle) msize(small)), graphregion(color(white)) title("“超级明星”情境") ytitle("加总劳动收入份额") xtitle("年份") yscale(range(0.22 0.34)) ylabel(0.22(0.02)0.34, angle(0) format(%10.2f)) xscale(range(1998 2007)) xlabel(1998(1)2007) legend(label(1 "劳动收入份额（真实）") label(2 "劳动收入份额（反事实）"))

graph save "$dir\Output\Figure III2_B", replace
restore

********************************************************************************
//                附录 IV  劳动收入份额变化分解：2008-2015年                  //
********************************************************************************
********************************************************************************
// 图IV1  加总劳动收入份额变化分解（2008-2015年）
********************************************************************************
use "$dir\Data\Analysis_NTSD_Balance.dta", clear

preserve
drop ls_t total_wage_t total_va_t
bys year: egen total_wage_t = sum(total_wage)
bys year: egen total_va_t = sum(value_add_inc)
gen ls_t = total_wage_t / total_va_t
gen omega = value_add_inc / total_va_t
bys year: egen mean_omega = mean(omega)
bys year: egen mean_ls = mean(ls)

sort id year
bys id: gen L_omega = L.omega
bys id: gen L_mean_omega = L.mean_omega
bys id: gen L_ls = L.ls
bys id: gen L_mean_ls = L.mean_ls

gen composition_1 = (omega - mean_omega) * (ls - mean_ls)
gen composition_2 = (L_omega - L_mean_omega) * (L_ls - L_mean_ls)

gen big_player = (L_omega - L_mean_omega) * (ls - L_ls - mean_ls + L_mean_ls)
gen superstar = (omega - L_omega - mean_omega + L_mean_omega) * (L_ls - L_mean_ls)
gen rising_star = (omega - L_omega - mean_omega + L_mean_omega) * (ls - L_ls - mean_ls + L_mean_ls)

gen cumul_composition_1 = (omega - mean_omega) * (ls - mean_ls)
bys id: gen omega_2008 = omega[1]
bys id: gen mean_omega_2008 = mean_omega[1]
bys id: gen ls_2008 = ls[1]
bys id: gen mean_ls_2008 = mean_ls[1]
gen cumul_composition_2 = (omega_2008 - mean_omega_2008) * (ls_2008 - mean_ls_2008)

gen cumul_big_player = (omega_2008 - mean_omega_2008) * (ls - ls_2008 - mean_ls + mean_ls_2008)
gen cumul_superstar = (omega - omega_2008 - mean_omega + mean_omega_2008) * (ls_2008 - mean_ls_2008)
gen cumul_rising_star = (omega - omega_2008 - mean_omega + mean_omega_2008) * (ls - ls_2008 - mean_ls + mean_ls_2008)
	
collapse (mean) ls_t ls (sum) composition_1 composition_2 big_player superstar rising_star cumul*, by(year)

gen composition = composition_1 - composition_2
gen test1 = big_player + superstar + rising_star
tsset year
gen test2 = D.ls_t - D.ls
gen D_ls_t = D.ls_t
gen D_ls = D.ls
drop test1 test2

gen cumul_composition = cumul_composition_1 - cumul_composition_2
gen ls_t_2008 = ls_t[1]
gen ls_2008 = ls[1]
gen cumul_D_ls_t = ls_t - ls_t_2008
gen cumul_D_ls = ls - ls_2008
gen test1 = cumul_D_ls_t - cumul_D_ls
gen test2 = cumul_big_player + cumul_superstar + cumul_rising_star
drop test1 test2

*********************************
*         年度变动分解          *
*********************************
graph bar D_ls_t D_ls big_player superstar rising_star if year >= 2009, graphregion(color(white)) title("年度变动分解") over(year) bargap(0.6) ytitle("劳动收入份额年度变动") bar(1, color(navy) fintensity(inten100)) bar(2, color(navy) fintensity(inten80)) bar(3, color(navy) fintensity(inten50)) bar(4, color(navy) fintensity(inten20)) bar(5, color(navy) fintensity(inten0)) yscale(range(-0.08 0.04)) ylabel(-0.08(0.02)0.04, angle(0) format(%10.2f)) legend(label(1 "加总") label(2 "个体") label(3 "大玩家") label(4 "超级明星") label(5 "明日之星") rows(2))

graph save "$dir\Output\Figure IV1_A", replace 

*********************************
*         累计变动分解          *
*********************************
graph bar cumul_D_ls_t cumul_D_ls cumul_big_player cumul_superstar cumul_rising_star if year >= 2009, graphregion(color(white)) title("累计变动分解") over(year) bargap(0.6) ytitle("劳动收入份额累计变动") bar(1, color(navy) fintensity(inten100)) bar(2, color(navy) fintensity(inten80)) bar(3, color(navy) fintensity(inten50)) bar(4, color(navy) fintensity(inten20)) bar(5, color(navy) fintensity(inten0)) yscale(range(-0.2 0.1)) ylabel(-0.2(0.05)0.1, angle(0) format(%10.2f)) legend(label(1 "加总") label(2 "个体") label(3 "大玩家") label(4 "超级明星") label(5 "明日之星") rows(2))

graph save "$dir\Output\Figure IV1_B", replace
restore

********************************************************************************
//                            附录 V  国有企业改革                            //
********************************************************************************
********************************************************************************
// 图V1  存续、转型和新进入国企的市场份额与劳动收入份额变化（1998-2007年）
********************************************************************************
use "$dir\Data\Analysis_ASIF.dta", clear

preserve
keep if firm_type == 1
collapse (sum) total_wage value_add_inc, by(year soe)
gen ls = total_wage / value_add_inc
bys year: egen value_add_inc_t = sum(value_add_inc)
bys year: egen total_wage_t = sum(total_wage)
gen ls_t = total_wage_t / value_add_inc_t
gen omega = value_add_inc / value_add_inc_t

*********************************
*           存续国企            *
*********************************
twoway (bar omega year if soe == 1, barwidth(0.7) color(gray) yaxis(1)) (connect ls year if soe == 1, lpattern(dash) lcolor(black) mcolor(black) msymbol(triangle) msize(small) yaxis(2)), graphregion(color(white)) subtitle("存续国企") xtitle("年份") ytitle("市场份额") ytitle("劳动收入份额", axis(2)) yscale(range(0.47 0.57)) ylabel(0.47(0.02)0.57, angle(0) format(%10.2f)) ylabel(0.15(0.05)0.4, angle(0) format(%10.2f) axis(2)) xscale(range(1998 2007)) xlabel(1998(1)2007) legend(label(1 "市场份额（左坐标轴）") label(2 "劳动收入份额（右坐标轴）") rows(2))

graph save "$dir\Output\Figure V1_A", replace

*********************************
*           转型国企            *
*********************************
twoway (bar omega year if soe == 2, barwidth(0.7) color(gray) yaxis(1)) (connect ls year if soe == 2, lpattern(dash) lcolor(black) mcolor(black) msymbol(triangle) msize(small) yaxis(2)), graphregion(color(white)) subtitle("转型国企") xtitle("年份") ytitle("市场份额") ytitle("劳动收入份额", axis(2)) yscale(range(0.36 0.43)) ylabel(0.36(0.01)0.43, angle(0) format(%10.2f)) ylabel(0.15(0.05)0.4, angle(0) format(%10.2f) axis(2)) xscale(range(1998 2007)) xlabel(1998(1)2007) legend(label(1 "市场份额（左坐标轴）") label(2 "劳动收入份额（右坐标轴）") rows(2))

graph save "$dir\Output\Figure V1_B", replace

*********************************
*          新进入国企           *
*********************************
twoway (bar omega year if soe == 3, barwidth(0.7) color(gray) yaxis(1)) (connect ls year if soe == 3, lpattern(dash) lcolor(black) mcolor(black) msymbol(triangle) msize(small) yaxis(2)), graphregion(color(white)) subtitle("新进入国企") xtitle("年份") ytitle("市场份额") ytitle("劳动收入份额", axis(2)) yscale(range(0.05 0.11)) ylabel(0.05(0.01)0.11, angle(0) format(%10.2f)) ylabel(0.1(0.05)0.4, angle(0) format(%10.2f) axis(2)) xscale(range(1998 2007)) xlabel(1998(1)2007) legend(label(1 "市场份额（左坐标轴）") label(2 "劳动收入份额（右坐标轴）") rows(2))

graph save "$dir\Output\Figure V1_C", replace
restore

















