
***********************************************************************
* 第四章 正文表5 “年龄歧视导致 35 岁失业”：年龄刻板印象与年轻劳动者偏好
*        附录IV表A3  “年龄歧视导致35岁失业”：年龄刻板印象与年轻劳动者偏好（加入控制变量）
***********************************************************************

*  检验分两步进行
*  第一步：根据利用城市层面的招聘数据，将35岁限制（是=1，否=0）同时与健康、形象、适应能力、创造力、可靠、抱怨、学习能力、沟通能力、经验、新技术、年轻共11个虚拟变量进行回归，汇总城市层面各个变量的估计系数和标准误
*  第二步：匹配城市招聘数据与2015年人口普查数据，检验负面、正面年龄刻板印象或年轻劳动者偏好能否解释"年龄歧视导致的35岁失业"现象


** 第一步
cd "D:\2024-00330+数据\2024-00330+论文数据"

use 招聘数据_年龄要求_刻板印象_年轻偏好.dta,clear   //基于5969万条企业招聘数据, 从岗位要求文本信息中提取关键词，分别设定为虚拟变量，具体步骤请见正文

*  分城市进行回归
statsby _b _se , by(city_adjust): reg _35岁要求 健康 形象 适应能力 创造力 抱怨 学习能力 新技术 可靠 沟通能力 经验 年轻,r

** 根据城市名称，匹配城市ID，以便与人口普查数据进行匹配
merge m:1 city_adjust using 城市行政区划2022_不含省直辖县和部分省份.dta,force
drop if _merge==2 
drop _merge

** 对于没有匹配上的样本，手动调整6位数地区代码
replace ctnm_id = 469006   if city_adjust == "万宁市"
replace ctnm_id = 460300   if city_adjust == "三沙市"
replace ctnm_id = 469007   if city_adjust == "东方市"
replace ctnm_id = 469024   if city_adjust == "临高县"
replace ctnm_id = 650100   if city_adjust == "乌鲁木齐市"
replace ctnm_id = 469027   if city_adjust == "乐东黎族自治县"
replace ctnm_id = 659004   if city_adjust == "五家渠市"
replace ctnm_id = 469001   if city_adjust == "五指山市"
replace ctnm_id = 429004   if city_adjust == "仙桃市"
replace ctnm_id = 654000   if city_adjust == "伊犁哈萨克自治州"
replace ctnm_id = 469029   if city_adjust == "保亭黎族苗族自治县"
replace ctnm_id = 653000   if city_adjust == "克孜勒苏柯尔克孜自治州"
replace ctnm_id = 650200   if city_adjust == "克拉玛依市"
replace ctnm_id = 659005   if city_adjust == "北屯市"
replace ctnm_id = 652700   if city_adjust == "博尔塔拉蒙古自治州"
replace ctnm_id = 659007   if city_adjust == "双河市"
replace ctnm_id = 659008   if city_adjust == "可克达拉市"
replace ctnm_id = 650400   if city_adjust == "吐鲁番市"
replace ctnm_id = 653200   if city_adjust == "和田地区"
replace ctnm_id = 650500   if city_adjust == "哈密市"
replace ctnm_id = 653100   if city_adjust == "喀什地区"
replace ctnm_id = 659003   if city_adjust == "图木舒克市"
replace ctnm_id = 654200   if city_adjust == "塔城地区"
replace ctnm_id = 429006   if city_adjust == "天门市"
replace ctnm_id = 469021   if city_adjust == "定安县"
replace ctnm_id = 469022   if city_adjust == "屯昌县"
replace ctnm_id = 540500   if city_adjust == "山南市"
replace ctnm_id = 652800   if city_adjust == "巴音郭楞蒙古自治州"
replace ctnm_id = 540100   if city_adjust == "拉萨市"
replace ctnm_id = 469005   if city_adjust == "文昌市"
replace ctnm_id = 540200   if city_adjust == "日喀则市"
replace ctnm_id = 659009   if city_adjust == "昆玉市"
replace ctnm_id = 652300   if city_adjust == "昌吉回族自治州"
replace ctnm_id = 469026   if city_adjust == "昌江黎族自治县"
replace ctnm_id = 540300   if city_adjust == "昌都市"
replace ctnm_id = 540400   if city_adjust == "林芝市"
replace ctnm_id = 632600   if city_adjust == "果洛藏族自治州"
replace ctnm_id = 419001   if city_adjust == "济源市"
replace ctnm_id = 630200   if city_adjust == "海东市"
replace ctnm_id = 632200   if city_adjust == "海北藏族自治州"
replace ctnm_id = 632500   if city_adjust == "海南藏族自治州"
replace ctnm_id = 632800   if city_adjust == "海西蒙古族藏族自治州"
replace ctnm_id = 429005   if city_adjust == "潜江市"
replace ctnm_id = 469025   if city_adjust == "澄迈县"
replace ctnm_id = 632700   if city_adjust == "玉树藏族自治州"
replace ctnm_id = 469030   if city_adjust == "琼中黎族苗族自治县"
replace ctnm_id = 469002   if city_adjust == "琼海市"
replace ctnm_id = 469025   if city_adjust == "白沙黎族自治县"
replace ctnm_id = 659001   if city_adjust == "石河子市"
replace ctnm_id = 429021   if city_adjust == "神农架林区"
replace ctnm_id = 630100   if city_adjust == "西宁市"
replace ctnm_id = 540600   if city_adjust == "那曲市"
replace ctnm_id = 659006   if city_adjust == "铁门关市"
replace ctnm_id = 652900   if city_adjust == "阿克苏地区"
replace ctnm_id = 654300   if city_adjust == "阿勒泰地区"
replace ctnm_id = 659002   if city_adjust == "阿拉尔市"
replace ctnm_id = 542500   if city_adjust == "阿里地区"
replace ctnm_id = 469028   if city_adjust == "陵水黎族自治县"
replace ctnm_id = 632300   if city_adjust == "黄南藏族自治州"

drop if city_adjust == ""   
gen city_code = string(ctnm_id)
replace city_code = substr(city_code,1,4)
destring city_code,replace
duplicates drop city_code,force

*  保存各城市、各个变量的估计系数和标准误
save 招聘数据_回归系数_年龄刻板印象_年轻劳动者偏好.dta,replace


** 第二步

use 实证分析数据_2015人口普查数据.dta,clear

gen city_code=substr(地区代码,1,4)
destring city_code,replace
*  调整city_code，匹配利用城市层面招聘数据判断的年龄刻板印象与年轻劳动者偏好 
replace city_code = 1100 if city_code ==1101
replace city_code = 1100 if city_code ==1102
replace city_code = 1200 if city_code ==1201
replace city_code = 1200 if city_code ==1202
replace city_code = 1306 if city_code ==1390
replace city_code = 3100 if city_code ==3101
replace city_code = 3100 if city_code ==3102
replace city_code = 3701 if city_code ==3712
replace city_code = 5000 if city_code ==5001
replace city_code = 5000 if city_code ==5002
replace city_code = 5403 if city_code ==5421
replace city_code = 5405 if city_code ==5422
replace city_code = 5406 if city_code ==5424
replace city_code = 5404 if city_code ==5426
replace city_code = 6504 if city_code ==6521
replace city_code = 6505 if city_code ==6522

merge m:1 city_code using 招聘数据_回归系数_年龄刻板印象_年轻劳动者偏好.dta,force
keep if  _merge==3  //（city_code=2202 无招聘数据）
drop _merge

*  根据35岁限制与以下关键词是否存在显著正相关（系数对应的T值>1.96），则判断该城市存在基于形象的负面年龄刻板印象
gen 健康=0
replace 健康=1 if _b_健康>0 & _b_健康/_se_健康>1.96
gen 形象=0
replace 形象=1 if _b_形象>0 & _b_形象/_se_形象>1.96
gen 适应能力=0
replace 适应能力=1 if _b_适应能力>0 & _b_适应能力/_se_适应能力>1.96
gen 创造力=0
replace 创造力=1 if _b_创造力>0 & _b_创造力/_se_创造力>1.96
gen 抱怨=0
replace 抱怨=1 if _b_抱怨>0 & _b_抱怨/_se_抱怨>1.96
gen 学习能力=0
replace 学习能力=1 if _b_学习能力>0 & _b_学习能力/_se_学习能力>1.96
gen 新技术=0
replace 新技术=1 if _b_新技术>0 & _b_新技术/_se_新技术>1.96

*  根据35岁限制与以下关键词是否存在显著负相关（系数对应的T值<-1.96），则判断该城市存在基于形象的正面年龄刻板印象
gen 可靠=0
replace 可靠=1 if _b_可靠<0 & _b_可靠/_se_可靠<-1.96
gen 沟通能力=0
replace 沟通能力=1 if _b_沟通能力<0 & _b_沟通能力/_se_沟通能力<-1.96
gen 经验=0
replace 经验=1 if _b_经验<0 & _b_经验/_se_经验<-1.96

*  根据35岁限制与年轻是否存在显著正相关（系数对应的T值>1.96），则判断该城市存在年轻劳动者偏好
gen 年轻 =0
replace 年轻 =1 if _b_年轻/_se_年轻>1.96

** 正文表5
*  局部线性回归
foreach v in "健康" "形象" "适应能力" "创造力" "抱怨" "学习能力" "新技术" "可靠" "沟通能力" "经验" "年轻" {
areg 是否因为单位原因失业 Over35 DistanceFrom35 Over35_DistanceFrom35 if abs(DistanceFrom35)<=45 & `v'==1 , abs(区县代码) cluster(区县代码)
eststo
areg 是否因为单位原因失业 Over35 DistanceFrom35 Over35_DistanceFrom35 if abs(DistanceFrom35)<=45 & `v'==0 , abs(区县代码) cluster(区县代码)
eststo
}
cd "D:\2024-00330+数据\2024-00330+日志文件"
esttab, ar2 se b(%9.4f) t(%9.4f) star(* 0.10 ** 0.05 *** 0.01) nogap, using 第四章_代码16结果_正文表5_局部线性回归.csv, replace
estimate drop est*

** 局部二次项回归
foreach v in "健康" "形象" "适应能力" "创造力" "抱怨" "学习能力" "新技术" "可靠" "沟通能力" "经验" "年轻" {
areg 是否因为单位原因失业 Over35 DistanceFrom35 Over35_DistanceFrom35 DistanceFrom35_sq Over35_DistanceFrom35_sq if abs(DistanceFrom35)<=58 & `v'==1, abs(区县代码) cluster(区县代码)
eststo
areg 是否因为单位原因失业 Over35 DistanceFrom35 Over35_DistanceFrom35 DistanceFrom35_sq Over35_DistanceFrom35_sq if abs(DistanceFrom35)<=58 & `v'==0, abs(区县代码) cluster(区县代码)
eststo
}
esttab, ar2 se b(%9.4f) t(%9.4f) star(* 0.10 ** 0.05 *** 0.01) nogap, using 第四章_代码16结果_正文表5_局部二次项回归.csv, replace
estimate drop est*


** 附录I表A3
*  局部线性回归
foreach v in "健康" "形象" "适应能力" "创造力" "抱怨" "学习能力" "新技术" "可靠" "沟通能力" "经验" "年轻" {
areg 是否因为单位原因失业 Over35 DistanceFrom35 Over35_DistanceFrom35 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 有农村土地承包权 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 有汽车 if abs(DistanceFrom35)<=45 & `v'==1 , abs(区县代码) cluster(区县代码)
eststo
areg 是否因为单位原因失业 Over35 DistanceFrom35 Over35_DistanceFrom35 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 有农村土地承包权 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 有汽车 if abs(DistanceFrom35)<=45 & `v'==0 , abs(区县代码) cluster(区县代码)
eststo
}
esttab, ar2 se b(%9.4f) t(%9.4f) star(* 0.10 ** 0.05 *** 0.01) nogap, using 第四章_代码16结果_附录IV表A3_局部线性回归.csv, replace
estimate drop est*

*  局部二次项回归
foreach v in "健康" "形象" "适应能力" "创造力" "抱怨" "学习能力" "新技术" "可靠" "沟通能力" "经验" "年轻" {
areg 是否因为单位原因失业 Over35 DistanceFrom35 Over35_DistanceFrom35 DistanceFrom35_sq Over35_DistanceFrom35_sq 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 有农村土地承包权 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 有汽车 if abs(DistanceFrom35)<=58 & `v'==1, abs(区县代码) cluster(区县代码)
eststo
areg 是否因为单位原因失业 Over35 DistanceFrom35 Over35_DistanceFrom35 DistanceFrom35_sq Over35_DistanceFrom35_sq 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 有农村土地承包权 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 有汽车 if abs(DistanceFrom35)<=58 & `v'==0, abs(区县代码) cluster(区县代码)
eststo
}

esttab, ar2 se b(%9.4f) t(%9.4f) star(* 0.10 ** 0.05 *** 0.01) nogap, using 第四章_代码16结果_附录IV表A3_局部二次项回归.csv, replace
estimate drop est*




