
***********************************************************************
* 第四章 附录III表III1  安慰剂检验：考察其他年龄节点
***********************************************************************

cd "D:\2024-00330+数据\2024-00330+论文数据"

use 实证分析数据_2015人口普查数据.dta,clear

*  变量构造的思路如下：
*      当以34岁为断点时,DistanceFrom34=0, 35岁对应的DistanceFrom34为12
*      当以36岁为断点时,DistanceFrom36=0, 35岁对应的DistanceFrom36为-12
*      换言之，只需要把DistanceFrom35 +/- 12的倍数,即得到基于年龄X构建的驱动变量DistanceFromX

*  基于上述思路，分别以21—49岁为节点重新利用基准模型进行回归

forvalue i = 21(1)49{
gen DistanceFrom_`i' = DistanceFrom35 + (35 - `i') * 12
}  

*  局部线性回归
*      不含控制变量
forvalue x = 21(1)49{
gen Over_`x' = 0
replace Over_`x' = 1 if DistanceFrom_`x'>=0
gen Over_`x'_DistanceFrom_`x'=Over_`x' * DistanceFrom_`x'
areg 是否因为单位原因失业 Over_`x' DistanceFrom_`x' Over_`x'_DistanceFrom_`x' if abs(DistanceFrom_`x')<=45 , abs(区县代码) cluster(区县代码)
eststo
areg 是否因为单位原因失业 Over_`x' DistanceFrom_`x' Over_`x'_DistanceFrom_`x' 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 有农村土地承包权 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 有汽车 if abs(DistanceFrom_`x')<=45 , abs(区县代码) cluster(区县代码)
eststo

}
cd "D:\2024-00330+数据\2024-00330+日志文件"
esttab, ar2 se b(%9.4f) t(%9.4f) star(* 0.10 ** 0.05 *** 0.01) nogap, using 第四章_代码12结果_附录III表III1_局部线性回归.csv, replace
estimate drop est*

*  局部二次项回归
forvalue x = 21(1)49{
gen DistanceFrom_`x'_sq = (DistanceFrom_`x')^2
gen Over_`x'_DistanceFrom_`x'_sq = Over_`x' * DistanceFrom_`x'_sq
areg 是否因为单位原因失业 Over_`x' DistanceFrom_`x' Over_`x'_DistanceFrom_`x' DistanceFrom_`x'_sq Over_`x'_DistanceFrom_`x'_sq if abs(DistanceFrom_`x')<=58, abs(区县代码) cluster(区县代码)
eststo
areg 是否因为单位原因失业 Over_`x' DistanceFrom_`x' Over_`x'_DistanceFrom_`x' DistanceFrom_`x'_sq Over_`x'_DistanceFrom_`x'_sq 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 有农村土地承包权 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 有汽车 if abs(DistanceFrom_`x')<=58, abs(区县代码) cluster(区县代码)
eststo
}
esttab, ar2 se b(%9.4f) t(%9.4f) star(* 0.10 ** 0.05 *** 0.01) nogap, using 第四章_代码12结果_附录III表III1_局部二次项回归.csv, replace
estimate drop est*

*  说明：当x=35时，得到的是正文表2基准回归不加控制变量的结果
*        附录IV表IV1汇总了虚拟变量Over_Age的系数和标准误
