
***********************************************************************
* 第三章 基于2015年人口普查原始数据，构造变量、生成实证分析数据
***********************************************************************

cd "D:\2024-00330+数据\2024-00330+论文数据"

use 2015年人口普查原始数据.dta,clear

**（一）变量构造
**（1）被解释变量
* 涉及变量M63，对应问题：未工作原因？
* 1、在校学习；
* 2、丧失工作能力；
* 3、毕业后未工作；
* 4、因单位原因失去工作；
* 5、因本人原因失去工作
* 6、承包土地被征用
* 7、离退休
* 8、料理家务
* 9、其他
rename M63 失业原因
gen 是否因为单位原因失业=0                             
replace 是否因为单位原因失业=1 if 失业原因=="4"
replace 是否因为单位原因失业=是否因为单位原因失业*100  //为避免估计系数过小，将被解释变量乘以100

**（2）核心解释变量
* （2.1）构建驱动变量DistanceFrom35:受访者普查时的年龄与35周岁的距离，单位为月
rename M35 出生年份    
rename M36 出生月份   
*  本文只考虑16—59周岁的男性和16-54周岁的女性劳动者，因此只对这部分受访者计算DistanceFrom35
*  第一步：计算16-34周岁受访者对应的DistanceFrom35
gen DistanceFrom35 = 10-出生月份 if 出生年份==1980         //2015年人口普查时间为2015年11月1日，1980年10月出生的受访者在调查时年满35周岁，设置为0，9月出生的设置为1，11月出生的设置为-1，以此类推
forvalue i=1981(1)1999{                                                        //16—34周岁受访者，1981年1月出生设置为-3，2月设置为-4，以此类推
replace DistanceFrom35=-2-(12*(`i'-1981))-出生月份 if 出生年份==`i'      
}
replace DistanceFrom35=.  if 出生年份==1999 & 出生月份 >=11 & 出生月份<=12     //不考虑未满16周岁的受访者
*  第二步：对于男性，计算35-59周岁受访者对应的DistanceFrom35
forvalue i=1979(-1)1955{                                   //35—59岁样本,1979年12月出生设置为10，11月设置为11，以此类推; M34=="1" 为男性
replace DistanceFrom35=10+(12*(1980-出生年份)-出生月份) if 出生年份==`i'  & M34=="1"   
}
replace DistanceFrom35=.  if 出生年份==1955 & 出生月份 >=1 & 出生月份<=10 & M34=="1"   //不考虑年满60周岁的男性受访者
*  第三步：对于女性，计算35-54周岁受访者对应的DistanceFrom35
forvalue i=1979(-1)1960{                                   //35—54岁样本,1979年12月出生设置为10，11月设置为11，以此类推; M34=="2" 为女性
replace DistanceFrom35=10+(12*(1980-出生年份)-出生月份) if 出生年份==`i' & M34=="2"   
}
replace DistanceFrom35=.  if 出生年份==1960 & 出生月份 >=1 & 出生月份<=10 & M34=="2"   //不考虑年满55周岁的女性受访者

* （2.2）基于DistanceFrom35，可以得到局部线性回归和局部二次项回归使用的其他解释变量
gen Over35=0                                           //Over35：受访者在2015年人口普查时是否年满35周岁，是设置为1，否则为0
replace Over35=1 if DistanceFrom35>=0
gen Over35_DistanceFrom35=Over35*DistanceFrom35        //Over35与DistanceFrom35的交叉项 
gen DistanceFrom35_sq=(DistanceFrom35)^2               //DistanceFrom35的2次项
gen Over35_DistanceFrom35_sq=Over35*DistanceFrom35_sq  //Over35与DistanceFrom35_sq的交叉项

**（3）控制变量
* （3.1）个人特征
** 户主（是=1，否=0）
*  涉及变量M33，对应问题：与户主关系？
*  0、户主；
*  1、配偶；
*  2、子女；
*  3、父母；
*  4、岳父母或公婆；
*  5、祖父母；
*  6、媳婿；
*  7、孙子女；
*  8、兄弟姐妹；
*  9、其他；
gen 户主=0 if M33!="0"  
replace 户主=1 if M33=="0"

** 性别（男=1，女=0）
*  涉及变量M34，对应问题：性别？
*  1、男
*  2、女
gen 性别=0 if  M34=="2"
replace 性别=1 if  M34=="1"

** 民族（汉族=1，其他=0）
*  涉及变量M37，对应问题：民族？
*  01、汉族
*  02、03、...56、97、98
gen 民族=0
replace 民族=1 if M37=="01"

** 受教育程度（未上过学=0，小学=6，初中=9，高中或中职=12，大专=15，本科=16，研究生=19）
*  涉及变量M51，对应问题：受教育程度？
*  1、未上过学；
*  2、小学；
*  3、初中；
*  4、普通高中；
*  5、中职；
*  6、大学专科；
*  7、大学本科；
*  8、研究生；
gen 受教育程度=.
replace 受教育程度=0 if M51=="1"
replace 受教育程度=6 if M51=="2"
replace 受教育程度=9 if M51=="3"
replace 受教育程度=12 if (M51=="4" |M51=="5")
replace 受教育程度=15 if M51=="6"
replace 受教育程度=16 if M51=="7"
replace 受教育程度=19 if M51=="8"

** 识字（是=1，否=0）
*  涉及变量M50，对应问题：是否识字？
*  1、是；
*  2、否
gen 识字 = 0 if M50 == "2" 
replace 识字 =1 if M50 == "1" 

** 流动人口（离开户口登记地=1，其他=0）
*  涉及变量M43，对应问题：离开户口登记地的时间？
*  1、没有离开户口登记地；
*  2、不满半年；
*  3、半年至一年；
*  4、一至二年；
*  5、二至三年；
*  6、三至四年；
*  7、四至五年；
*  8、五至十年；
*  9、十年以上
gen 流动人口=0 if M43=="1" 
replace 流动人口=1 if M43!="1" & M43!=" "

** 1年前常住地为本地（是=1，否=0）
*  涉及变量M46，对应问题：一年前常住地？
*  1、现住房；
*  2、其他地区；
gen _1年前常住地为本地 = 0 if M46 == "2"
replace _1年前常住地为本地 = 1 if M46 == "1"

** 5年前常住地为本地（是=1，否=0）
*  涉及变量M48，对应问题：一年前常住地？
*  1、现住房；
*  2、其他地区；
gen _5年前常住地为本地 = 0 if M48 == "2"
replace _5年前常住地为本地 = 1 if M48 == "1"

** 已婚有配偶（是=1，其他=0）
*  涉及变量M68，对应问题：婚姻状况？
*  1、未婚；
*  2、有配偶；
*  3、离婚；
*  4、丧偶；
gen 已婚有配偶=0 if (M68=="1" | M68=="3" |M68=="4")
replace 已婚有配偶=1 if M68=="2"

** 有农村土地承包权（是=1，否=0）
*  涉及变量M68，对应问题：是否有农村土地承包权？
*  1、有；
*  2、无；
gen 有农村土地承包权 = 0 if M45 == "2"
replace 有农村土地承包权 = 1 if M45 == "1"

**（3.2）家庭特征
** 家庭人数
rename M3 家庭人数

** 去年有人出生（有=1，无=0）
*  涉及变量M5，对应问题：出生人口？
gen 去年有人出生=0 if M5==0
replace 去年有人出生=1 if M5>=1 & M5!=.

** 去年有人死亡（有=1，无=0）
*  涉及变量M6，对应问题：死亡人口？
gen 去年有人死亡=0 if M6==0
replace 去年有人死亡=1 if M6>=1 & M6!=.

** 房屋面积
*  涉及变量M9，对应问题：您家住房的建筑面积（平方米）？
rename M9 房屋面积

** 房屋房间数
*  涉及变量M10，对应问题：您的住房间数（间）？
rename M10 房屋房间数

** 10层以上楼房（是=1，否=0）
* 涉及变量M11，对应问题：您家住房所在的建筑物一共有多少层？
* 1、平房；
* 2、2-3层楼房；
* 3、4-6层楼房；
* 4、7-9层楼房；
* 5、10层以上楼房
gen _10层以上楼房=0 if (M11=="1" | M11=="2" | M11=="3" | M11=="4")  
replace _10层以上楼房=1 if M11=="5"

** 2000年后建成住房（是=1，否=0）
* 涉及变量M12，对应问题：您家住房的建成年代？
* 1、1949年以前；
* 2、1949-1959年；
* 3、1960-1969年；
* 4、1970-1979年；
* 5、1980-1989年;
* 6、1990-1999年；
* 7、2000-2009年；
* 8、2010年以后
gen _2000年后建成住房=0 if (M12=="1" | M12=="2" | M12=="3" | M12=="4" | M12=="5" | M12=="6" )
replace _2000年后建成住房=1 if (M12=="7" | M12=="8")

** 有厨房（有=1，无=0）
* 涉及变量M13，对应问题：您家住房内有无厨房？
* 1、独立使用；
* 2、与其他户合用；
* 3、无；
gen 有厨房=0 if (M13=="2" | M13=="3")
replace 有厨房=1 if M13=="1"

** 有厕所（有=1，无=0）
* 涉及变量M14，对应问题：您家住房内有无厕所？
* 1、独立使用抽水/冲水式；
* 2、合用抽水/冲水式；
* 3、独立使用其他样式；
* 4、合用其他样式；
* 5、无
gen 有厕所=0 if (M14=="1" | M14=="3")
replace 有厕所=1 if (M14=="2" | M14=="4" | M14=="5" )

** 购买的住房（是=1，否=0）
* 涉及变量M15，对应问题：您家住房的来源？
* 1、购买新建商品房；
* 2、购买二手房；
* 3、购买原公有住房；
* 4、购买经济适用房、两限房；
* 5、自建住房；
* 6、租赁廉租房、公租房；
* 7、租赁其他住房；
* 8、其他
gen 购买的住房=0 if (M15=="1" | M15=="2")
replace 购买的住房=1 if (M15=="3" | M15=="4"| M15=="5" | M15=="6" | M15=="7" | M15=="8")

** 有汽车（有=1，无=0）
* 涉及变量M16，对应问题：您家拥有家用汽车的情况？ 
* 1、拥有100万元以上的汽车；
* 2、拥有50-100万元的汽车；
* 3、拥有30-50万元的汽车；
* 4、拥有20-30万元的汽车；
* 5、拥有10-20万元的汽车；
* 6、拥有10万元以下的汽车；
* 7、没有汽车
gen 有汽车=0 if M16 =="7"
replace 有汽车=1 if (M16=="1" | M16=="2" |M16=="3" |M16=="4" |M16=="5" |M16=="6")

**（二）样本构建
** 本文使用的2015年人口普查数据有2003563个原始观测值，经过以下四个步骤，获得基准回归样本
* （1）根据人口普查调查年月和受访者出生年月，构造以月份为基本单位的年龄信息
*      关于DistanceFrom35的构造步骤，见上文第31-45行

* （2）保留劳动人口
*      注意：DistanceFrom35是针对16-59岁男性和16-54岁女性构造的，因此只要保留非缺失值即可  
*      此步骤剔除717393个截至普查时未满16周岁或已满60（55）周岁的男性（女性）样本
keep if DistanceFrom35!=.        

* （3）检验连续性条件需要纳入个人和家庭特征，而根据人口普查的调查说明，集体户、家庭住房类型为非普通住宅（包括集体宿舍和工棚、工作地住宿和无住房）的样本并不调查相关信息
*      因此剔除对应42841个样本以及55281个没有提供家庭信息的样本；
*      涉及变量M7，对应问题：您的住户类型？ 
*                            1、家庭户
*                            2、集体户（转至个人项目）   
*      涉及变量M8，对应问题：您家的住房类型？ 
*                            1、普通住宅
*                            2、集体宿舍和工棚 （转至个人项目）
*                            2、工作地住宿 （转至个人项目）
*                            2、无住房（转至个人项目）                                  
keep if (M7=="1" | M8=="1")    //剔除42841个样本 
keep if 房屋房间数!=.          //剔除55281个样本 

* （4）在剩余的1188048个样本中，利用Calonico et al.（2014）的方法，依次对局部线性回归、局部二次项回归选取对应的最优窗宽
*      首先，对被解释变量"是否因为单位原因失业"剔除区县固定效应
rename M2 地区代码
gen 区县代码=substr(地区代码,1,6)  
destring 区县代码,replace  
areg 是否因为单位原因失业 , abs(区县代码) cluster(区县代码)    
predict 是否因为单位原因失业_r,r

*      其次，计算最优窗宽
*      局部线性回归,最优窗宽45.398,取45
rdrobust 是否因为单位原因失业_r DistanceFrom35 , c(0) p(1) kernel(uniform) bwselect(mserd) vce(cluster 区县代码) 

*      局部二次项回归,最优窗宽58.025,取58
rdrobust 是否因为单位原因失业_r DistanceFrom35 , c(0) p(2) kernel(uniform) bwselect(mserd) vce(cluster 区县代码) 

** 生成实证分析数据
*  保留实证分析使用的变量
keep 地区代码 区县代码 出生年份 出生月份 失业原因 是否因为单位原因失业 DistanceFrom35 Over35 Over35_DistanceFrom35 DistanceFrom35_sq Over35_DistanceFrom35_sq 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 有农村土地承包权 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 有汽车

order 地区代码 区县代码 出生年份 出生月份 失业原因 是否因为单位原因失业 DistanceFrom35 Over35 Over35_DistanceFrom35 DistanceFrom35_sq Over35_DistanceFrom35_sq 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 有农村土地承包权 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 有汽车

*  保存
save 实证分析数据_2015人口普查数据.dta,replace	
