
***********************************************************************
* 第四章 附录II表II3  稳健性检验：替换驱动变量计量单位
***********************************************************************

cd "D:\2024-00330+数据\2024-00330+论文数据"

use 实证分析数据_2015人口普查数据.dta,clear

*  基准回归使用的驱动变量DistanceFrom35的单位为月，经过两步获得以季度为单位的驱动变量
*  1、2015年人口普查时劳动者年龄超过35岁，例如，35岁10个月，此时以月度为单位的DistanceFrom35=10，以季度为单位的DistanceFrom35_Quarter=3（注意0代表超过35岁的第1个季度），此时将DistanceFrom35除以3再取整，即可得到DistanceFrom35_Quarter
*  2、2015年人口普查时劳动者年龄小于35岁，例如，34岁11个月，此时以月度为单位的DistanceFrom35=-1，以季度为单位的DistanceFrom35_Quarter=-1（注意0代表超过35岁的第1个季度），此时将DistanceFrom35除以3再取整-1，即可得到DistanceFrom35_Quarter
gen DistanceFrom35_Quarter=int((DistanceFrom35)/3)  if DistanceFrom35>=0
replace DistanceFrom35_Quarter= int((DistanceFrom35+0.05)/3)-1 if DistanceFrom35<0

gen Over35_Quarter = 0
replace Over35_Quarter = 1 if DistanceFrom35_Quarter >=0

gen Over35_DistanceFrom35_Quarter= Over35_Quarter * DistanceFrom35_Quarter

gen DistanceFrom35_Quarter_sq = (DistanceFrom35_Quarter)^2

gen Over35_distanceFrom35_Quarter_sq = Over35_Quarter *  DistanceFrom35_Quarter_sq

*  选取最优窗宽
*      首先，剔除区县固定效应
areg 是否因为单位原因失业 , abs(区县代码) cluster(区县代码)    
predict 是否因为单位原因失业_r,r
*      局部线性回归:最优窗宽14.590，取15个季度
rdrobust 是否因为单位原因失业_r DistanceFrom35_Quarter , c(0) p(1) kernel(uniform) bwselect(mserd) vce(cluster 区县代码)  
*      局部二次项回归:最优窗宽21.725，取22个季度
rdrobust 是否因为单位原因失业_r DistanceFrom35_Quarter , c(0) p(2) kernel(uniform) bwselect(mserd) vce(cluster 区县代码) 

*  稳健性检验
areg 是否因为单位原因失业 Over35_Quarter DistanceFrom35_Quarter Over35_DistanceFrom35_Quarter if abs(DistanceFrom35_Quarter)<=15, abs(区县代码) cluster(区县代码)
eststo
areg 是否因为单位原因失业 Over35_Quarter DistanceFrom35_Quarter Over35_DistanceFrom35_Quarter 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 有农村土地承包权 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 有汽车 if abs(DistanceFrom35_Quarter)<=15, abs(区县代码) cluster(区县代码)
eststo
areg 是否因为单位原因失业 Over35_Quarter DistanceFrom35_Quarter Over35_DistanceFrom35_Quarter DistanceFrom35_Quarter_sq Over35_distanceFrom35_Quarter_sq if abs(DistanceFrom35_Quarter)<=22, abs(区县代码) cluster(区县代码)
eststo
areg 是否因为单位原因失业 Over35_Quarter DistanceFrom35_Quarter Over35_DistanceFrom35_Quarter DistanceFrom35_Quarter_sq Over35_distanceFrom35_Quarter_sq 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 有农村土地承包权 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 有汽车 if abs(DistanceFrom35_Quarter)<=22, abs(区县代码) cluster(区县代码)
eststo

cd "D:\2024-00330+数据\2024-00330+日志文件"

esttab, ar2 se b(%9.4f) t(%9.4f) star(* 0.10 ** 0.05 *** 0.01) nogap, using 第四章_代码6结果_附录II表II3.csv, replace
estimate drop est*
