
***********************************************************************
* 第四章 附录IV表A4 拓展检验：地区、个体和时间异质性（加入控制变量）
***********************************************************************

** Panel A. 地区异质性
cd "D:\2024-00330+数据\2024-00330+论文数据"

use 实证分析数据_2015人口普查数据.dta,clear

gen city_code=substr(地区代码,1,4)
destring city_code,replace
*  调整城市代码，以匹配招聘数据
replace city_code = 1100 if city_code ==1101
replace city_code = 1100 if city_code ==1102
replace city_code = 1200 if city_code ==1201
replace city_code = 1200 if city_code ==1202
replace city_code = 1306 if city_code ==1390
replace city_code = 3100 if city_code ==3101
replace city_code = 3100 if city_code ==3102
replace city_code = 3701 if city_code ==3712
replace city_code = 5000 if city_code ==5001
replace city_code = 5000 if city_code ==5002
replace city_code = 5403 if city_code ==5421
replace city_code = 5405 if city_code ==5422
replace city_code = 5406 if city_code ==5424
replace city_code = 5404 if city_code ==5426
replace city_code = 6504 if city_code ==6521
replace city_code = 6505 if city_code ==6522

** 匹配城市层面招聘数据
merge m:1 city_code using 招聘数据_城市层面_年龄限制.dta,force
keep if _merge==3
drop _merge

** 计算城市层面招聘35岁及以下的比例(包括35岁、30岁、28岁等)，及其对应的中位数
gen 城市_招聘35岁及以下 = ratio_age_35+ratio_age_35down
sum 城市_招聘35岁及以下 if abs(DistanceFrom35)<=45 ,d
sum 城市_招聘35岁及以下 if abs(DistanceFrom35)<=58 ,d

** 招聘年龄限制程度较高的城市 
areg 是否因为单位原因失业 Over35 DistanceFrom35 Over35_DistanceFrom35 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 有农村土地承包权 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 有汽车 if abs(DistanceFrom35)<=45 &  城市_招聘35岁及以下>=.0919424, abs(区县代码) cluster(区县代码)
eststo
areg 是否因为单位原因失业 Over35 DistanceFrom35 Over35_DistanceFrom35 DistanceFrom35_sq Over35_DistanceFrom35_sq 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 有农村土地承包权 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 有汽车 if abs(DistanceFrom35)<=58 &  城市_招聘35岁及以下>=.0921593, abs(区县代码) cluster(区县代码)
eststo
** 招聘年龄限制程度较低的城市 
areg 是否因为单位原因失业 Over35 DistanceFrom35 Over35_DistanceFrom35 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 有农村土地承包权 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 有汽车 if abs(DistanceFrom35)<=45 & 城市_招聘35岁及以下<.0919424, abs(区县代码) cluster(区县代码)
eststo
areg 是否因为单位原因失业 Over35 DistanceFrom35 Over35_DistanceFrom35 DistanceFrom35_sq Over35_DistanceFrom35_sq 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 有农村土地承包权 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 有汽车 if abs(DistanceFrom35)<=58 & 城市_招聘35岁及以下<.0921593 , abs(区县代码) cluster(区县代码)
eststo
cd "D:\2024-00330+数据\2024-00330+日志文件"
esttab, ar2 se b(%9.4f) t(%9.4f) star(* 0.10 ** 0.05 *** 0.01) nogap, using 第四章_代码18结果_附录IV表A4_PanelA.csv, replace
estimate drop est*

**  Panel B. 个体异质性
cd "D:\2024-00330+数据\2024-00330+论文数据"

use 实证分析数据_2015人口普查数据.dta,clear

*   大专及以上
areg 是否因为单位原因失业 Over35 DistanceFrom35 Over35_DistanceFrom35 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 有农村土地承包权 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 有汽车 if abs(DistanceFrom35)<=45 & 受教育程度>12, abs(区县代码) cluster(区县代码)
eststo
areg 是否因为单位原因失业 Over35 DistanceFrom35 Over35_DistanceFrom35 DistanceFrom35_sq Over35_DistanceFrom35_sq 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 有农村土地承包权 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 有汽车 if abs(DistanceFrom35)<=58 & 受教育程度>12, abs(区县代码) cluster(区县代码)
eststo
*   高中及以下
areg 是否因为单位原因失业 Over35 DistanceFrom35 Over35_DistanceFrom35 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 有农村土地承包权 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 有汽车 if abs(DistanceFrom35)<=45 & 受教育程度<=12, abs(区县代码) cluster(区县代码)
eststo
areg 是否因为单位原因失业 Over35 DistanceFrom35 Over35_DistanceFrom35 DistanceFrom35_sq Over35_DistanceFrom35_sq 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 有农村土地承包权 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 有汽车 if abs(DistanceFrom35)<=58 & 受教育程度<=12, abs(区县代码) cluster(区县代码)
eststo
*       其中：女性
areg 是否因为单位原因失业 Over35 DistanceFrom35 Over35_DistanceFrom35 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 有农村土地承包权 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 有汽车 if abs(DistanceFrom35)<=45 & 受教育程度<=12 & 性别==0, abs(区县代码) cluster(区县代码)
eststo
areg 是否因为单位原因失业 Over35 DistanceFrom35 Over35_DistanceFrom35 DistanceFrom35_sq Over35_DistanceFrom35_sq 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 有农村土地承包权 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 有汽车 if abs(DistanceFrom35)<=58 & 受教育程度<=12 & 性别==0, abs(区县代码) cluster(区县代码)
eststo
*       其中：男性
areg 是否因为单位原因失业 Over35 DistanceFrom35 Over35_DistanceFrom35 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 有农村土地承包权 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 有汽车 if abs(DistanceFrom35)<=45 & 受教育程度<=12 & 性别==1, abs(区县代码) cluster(区县代码)
eststo
areg 是否因为单位原因失业 Over35 DistanceFrom35 Over35_DistanceFrom35 DistanceFrom35_sq Over35_DistanceFrom35_sq 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 有农村土地承包权 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 有汽车 if abs(DistanceFrom35)<=58 & 受教育程度<=12 & 性别==1, abs(区县代码) cluster(区县代码)
eststo
*          其中：未婚/离婚/丧偶
areg 是否因为单位原因失业 Over35 DistanceFrom35 Over35_DistanceFrom35 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 有农村土地承包权 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 有汽车 if abs(DistanceFrom35)<=45 & 受教育程度<=12 & 性别==1 & 已婚有配偶==0, abs(区县代码) cluster(区县代码)
eststo
areg 是否因为单位原因失业 Over35 DistanceFrom35 Over35_DistanceFrom35 DistanceFrom35_sq Over35_DistanceFrom35_sq 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 有农村土地承包权 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 有汽车 if abs(DistanceFrom35)<=58 & 受教育程度<=12 & 性别==1 & 已婚有配偶==0, abs(区县代码) cluster(区县代码)
eststo
*          其中：已婚
areg 是否因为单位原因失业 Over35 DistanceFrom35 Over35_DistanceFrom35 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 有农村土地承包权 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 有汽车 if abs(DistanceFrom35)<=45 & 受教育程度<=12 & 性别==1 & 已婚有配偶==1, abs(区县代码) cluster(区县代码)
eststo
areg 是否因为单位原因失业 Over35 DistanceFrom35 Over35_DistanceFrom35 DistanceFrom35_sq Over35_DistanceFrom35_sq 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 有农村土地承包权 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 有汽车 if abs(DistanceFrom35)<=58 & 受教育程度<=12 & 性别==1 & 已婚有配偶==1, abs(区县代码) cluster(区县代码)
eststo
cd "D:\2024-00330+数据\2024-00330+日志文件"
esttab, ar2 se b(%9.4f) t(%9.4f) star(* 0.10 ** 0.05 *** 0.01) nogap, using 第四章_代码18结果_附录IV表A4_PanelB.csv, replace
estimate drop est*


** Panel C. 时间异质性
cd "D:\2024-00330+数据\2024-00330+论文数据"
*      2005年人口普查  
use 实证分析数据_2005人口普查数据.dta,clear

*     （1）本文只考虑16—59周岁的男性和16-54周岁的女性劳动者，因此只对这部分受访者计算DistanceFrom35
*          第一步：计算16-34周岁受访者对应的DistanceFrom35
*                  2005年人口普查时间为2005年11月1日，1970年10月出生的受访者在调查时年满35周岁，设置为0，9月出生的设置为1，11月出生的设置为-1，以此类推
gen DistanceFrom35 = 10-出生月份 if 出生年份==1970  
*                  16—34周岁受访者，1981年1月出生设置为-3，2月设置为-4，以此类推
forvalue i=1971(1)1989{
replace DistanceFrom35=-2-(12*(`i'-1971))-出生月份 if 出生年份==`i'      
}
*                  不考虑未满16周岁的受访者
replace DistanceFrom35=.  if 出生年份==1989 & 出生月份 >=11 & 出生月份<=12  
*          第二步：对于男性，计算35-59周岁受访者对应的DistanceFrom35
*                  35—59岁样本,1969年12月出生设置为10，11月设置为11，以此类推
forvalue i=1969(-1)1945{
replace DistanceFrom35=10+(12*(1970-出生年份)-出生月份) if 出生年份==`i'  & 性别==1   
}
*                  不考虑年满60周岁的男性受访者
replace DistanceFrom35=.  if 出生年份==1945 & 出生月份 >=1 & 出生月份<=10 & 性别==1 
*          第三步：对于女性，计算35-54周岁受访者对应的DistanceFrom35
*                  35—54岁样本,1979年12月出生设置为10，11月设置为11，以此类推
forvalue i=1969(-1)1950{
replace DistanceFrom35=10+(12*(1970-出生年份)-出生月份) if 出生年份==`i' & 性别==0  
}
*                  不考虑年满55周岁的女性受访者
replace DistanceFrom35=.  if 出生年份==1950 & 出生月份 >=1 & 出生月份<=10 & 性别==0 

*     （2）基于DistanceFrom35，可以得到局部线性回归和局部二次项回归使用的其他解释变量：
*          Over35：受访者在2005年人口普查时是否年满35周岁，是设置为1，否则为0
gen Over35=0    
replace Over35=1 if DistanceFrom35>=0
*          Over35_DistanceFrom35：Over35与DistanceFrom35的交叉项 
gen Over35_DistanceFrom35=Over35*DistanceFrom35  
*          DistanceFrom35_sq：DistanceFrom35的2次项
gen DistanceFrom35_sq=(DistanceFrom35)^2    
*          Over35_DistanceFrom35_sq: Over35与DistanceFrom35_sq的交叉项 
gen Over35_DistanceFrom35_sq=Over35*DistanceFrom35_sq

*     （3）构建回归样本
*          第一，根据调查年月和受访者出生年月，构造以月份为基本单位的年龄信息
*                请见DistanceFrom35的构造过程
*          第二，保留基准回归对应出生年月的样本
*                注意：DistanceFrom35是针对基准回归对应出生年月的样本构造的，因此只要保留非缺失值即可  
keep if DistanceFrom35!=.        
*          第三，剔除变量丢失的数据
sum 是否因为单位原因失业 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 农业户口 兄弟姐妹个数 健康水平 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _7层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房
drop if 是否因为单位原因失业==. 
drop if 户主==. 
drop if 识字==. 
drop if 已婚有配偶==. 
drop if 农业户口==. 
drop if 房屋面积==. 
sum 是否因为单位原因失业 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 农业户口 兄弟姐妹个数 健康水平 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _7层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房
*     （4）回归，
areg 是否因为单位原因失业 Over35 DistanceFrom35 Over35_DistanceFrom35 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 农业户口 兄弟姐妹个数 健康水平 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _7层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 if abs(DistanceFrom35)<=37, abs(城市代码) cluster(城市代码)
eststo
areg 是否因为单位原因失业 Over35 DistanceFrom35 Over35_DistanceFrom35 DistanceFrom35_sq Over35_DistanceFrom35_sq 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 农业户口 兄弟姐妹个数 健康水平 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _7层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 if abs(DistanceFrom35)<=53, abs(城市代码) cluster(城市代码)
eststo
cd "D:\2024-00330+数据\2024-00330+日志文件"
esttab, ar2 se b(%9.4f) t(%9.4f) star(* 0.10 ** 0.05 *** 0.01) nogap, using 第四章_代码18结果_附录IV表A4_PanelC_2005普查数据.csv, replace
estimate drop est*

**     2010年人口普查  
cd "D:\2024-00330+数据\2024-00330+论文数据"

use 实证分析数据_2010人口普查数据.dta,clear

*     （1）本文只考虑16—59周岁的男性和16-54周岁的女性劳动者，因此只对这部分受访者计算DistanceFrom35
*          第一步：计算16-34周岁受访者对应的DistanceFrom35
*                  2010年人口普查时间为2010年11月1日，1975年10月出生的受访者在调查时年满35周岁，设置为0，9月出生的设置为1，11月出生的设置为-1，以此类推
gen DistanceFrom35 = 10-出生月份 if 出生年份==1975  
*                  16—34周岁受访者，1981年1月出生设置为-3，2月设置为-4，以此类推
forvalue i=1976(1)1994{
replace DistanceFrom35=-2-(12*(`i'-1976))-出生月份 if 出生年份==`i'      
}
*                  不考虑未满16周岁的受访者
replace DistanceFrom35=.  if 出生年份==1994 & 出生月份 >=11 & 出生月份<=12  
*          第二步：对于男性，计算35-59周岁受访者对应的DistanceFrom35
*                  35—59岁样本,1969年12月出生设置为10，11月设置为11，以此类推
forvalue i=1974(-1)1950{
replace DistanceFrom35=10+(12*(1975-出生年份)-出生月份) if 出生年份==`i'  & 性别==1   
}
*                  不考虑年满60周岁的男性受访者
replace DistanceFrom35=.  if 出生年份==1950 & 出生月份 >=1 & 出生月份<=10 & 性别==1 
*          第三步：对于女性，计算35-54周岁受访者对应的DistanceFrom35
*                  35—54岁样本,1979年12月出生设置为10，11月设置为11，以此类推
forvalue i=1974(-1)1955{
replace DistanceFrom35=10+(12*(1975-出生年份)-出生月份) if 出生年份==`i' & 性别==0  
}
*                  不考虑年满55周岁的女性受访者
replace DistanceFrom35=.  if 出生年份==1955 & 出生月份 >=1 & 出生月份<=10 & 性别==0 

*     （2）基于DistanceFrom35，可以得到局部线性回归和局部二次项回归使用的其他解释变量：
*          Over35：受访者在2010年人口普查时是否年满35周岁，是设置为1，否则为0
gen Over35=0    
replace Over35=1 if DistanceFrom35>=0
*          Over35_DistanceFrom35：Over35与DistanceFrom35的交叉项 
gen Over35_DistanceFrom35=Over35*DistanceFrom35  
*          DistanceFrom35_sq：DistanceFrom35的2次项
gen DistanceFrom35_sq=(DistanceFrom35)^2    
*          Over35_DistanceFrom35_sq: Over35与DistanceFrom35_sq的交叉项 
gen Over35_DistanceFrom35_sq=Over35*DistanceFrom35_sq

*     （3）构建回归样本
*          第一，根据调查年月和受访者出生年月，构造以月份为基本单位的年龄信息
*                请见DistanceFrom35的构造过程
*          第二，保留基准回归对应出生年月的样本
*                注意：DistanceFrom35是针对基准回归对应出生年月的样本构造的，因此只要保留非缺失值即可  
keep if DistanceFrom35!=.        
*          第三，剔除变量丢失的数据
sum 是否因为单位原因失业 户主 性别 民族 受教育程度 识字 流动人口 _5年前常住地为本地 已婚有配偶 农业户口 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房
drop if 已婚有配偶==.
drop if 农业户口==.
drop if 房屋面积==.
sum 是否因为单位原因失业 户主 性别 民族 受教育程度 识字 流动人口 _5年前常住地为本地 已婚有配偶 农业户口 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房
*     （4）回归
areg 是否因为单位原因失业 Over35 DistanceFrom35 Over35_DistanceFrom35 户主 性别 民族 受教育程度 识字 流动人口 _5年前常住地为本地 已婚有配偶 农业户口 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 if abs(DistanceFrom35)<=35, abs(区县代码) cluster(区县代码)
eststo
areg 是否因为单位原因失业 Over35 DistanceFrom35 Over35_DistanceFrom35 DistanceFrom35_sq Over35_DistanceFrom35_sq 户主 性别 民族 受教育程度 识字 流动人口 _5年前常住地为本地 已婚有配偶 农业户口 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 if abs(DistanceFrom35)<=64, abs(区县代码) cluster(区县代码)
eststo

cd "D:\2024-00330+数据\2024-00330+日志文件"
esttab, ar2 se b(%9.4f) t(%9.4f) star(* 0.10 ** 0.05 *** 0.01) nogap, using 第四章_代码18结果_附录IV表A4_PanelC_2010普查数据.csv, replace
estimate drop est*
