
***********************************************************************
* 第四章  附录III表III2  安慰剂检验：使用2005（2010）年人口普查数据
***********************************************************************

cd "D:\2024-00330+数据\2024-00330+论文数据"

* Panel A. 使用2005年人口普查数据
*   基于2005年人口普查原始数据，进行变量构造和样本构建

use 2005年人口普查原始数据.dta,clear

**（一）变量构造
**（1）被解释变量
*  是否因为单位原因失业（是=1，否=0）
*  涉及变量cause_nw，对应问题：上周未工作原因？
*  1、在校学习；
*  2、丧失劳动能力；
*  3、离退休；
*  4、料理家务；
*  5、毕业后未工作
*  6、因单位原因失去原工作
*  7、因本人原因失去原工作
*  8、承包土地被征用
*  9、其他
rename cause_nw 失业原因
gen 是否因为单位原因失业 = 0
replace 是否因为单位原因失业 = 1 if 失业原因==6
replace 是否因为单位原因失业 = 是否因为单位原因失业*100   //为避免估计系数过小，将被解释变量乘以100

**（2）控制变量
* （2.1）个人特征
** 户主（是=1，否=0）
*  涉及变量relation，对应问题：与户主关系？
*  0、户主；
*  1、配偶；
*  2、子女；
*  3、父母；
*  4、岳父母或公婆；
*  5、祖父母；
*  6、媳婿；
*  7、孙子女；
*  8、兄弟姐妹；
*  9、其他；
gen 户主=0 if relation!=0 & relation!=.
replace 户主=1 if relation==0

** 性别（男=1，女=0）
*  涉及变量sex，对应问题：性别？
*  1、男
*  2、女
gen 性别=0 if  sex==2
replace 性别=1 if  sex==1

** 民族（汉族=1，其他=0）
*  涉及变量ethnic，对应问题：民族？
*  01、汉族
*  02、03、...56、97、98
gen 民族=0
replace 民族=1 if ethnic==1

** 受教育程度（未上过学=0，小学=6，初中=9，高中=12，大学专科=15，大学本科=16，研究生及以上=19）
*  涉及变量educ，对应问题：受教育程度？
*  1、未上过学；
*  2、小学；
*  3、初中；
*  4、高中；
*  5、大学专科；
*  6、大学本科；
*  7、研究生及以上；
gen 受教育程度=.
replace 受教育程度=0 if educ==1
replace 受教育程度=6 if educ==2
replace 受教育程度=9 if educ==3
replace 受教育程度=12 if educ==4 
replace 受教育程度=15 if educ==5
replace 受教育程度=16 if educ==6
replace 受教育程度=19 if educ==7

** 识字（是=1，否=0）
*  涉及变量literacy，对应问题：是否识字？
*  1、是；
*  2、否
gen 识字 = 0 if literacy == 2
replace 识字 =1 if literacy == 1

** 流动人口（离开户口登记地=1，其他=0）
*  涉及变量time_out，对应问题：离开户口登记地的时间？
*  1、没有离开户口登记地；
*  2、半年以下；
*  3、半年至一年；
*  4、一至二年；
*  5、二至三年；
*  6、三至四年；
*  7、四至五年；
*  8、五至六年；
*  9、六年以上
gen 流动人口=0 if time_out==1 
replace 流动人口=1 if time_out!=1 & time_out!=.

** 1年前常住地为本地（是=1，否=0）
*  涉及变量where_1y_res，对应问题：一年前常住地？
*  1、省内；
*  2、省外；
gen _1年前常住地为本地 = 0 if where_1y_res == 2
replace _1年前常住地为本地 = 1 if where_1y_res == 1

** 5年前常住地为本地（是=1，否=0）
*  涉及变量where_5y_res，对应问题：五年前常住地？
*  1、省内；
*  2、省外；
gen _5年前常住地为本地 = 0 if where_5y_res == 2
replace _5年前常住地为本地 = 1 if where_5y_res == 1

** 已婚有配偶（是=1，其他=0）
*  涉及变量maritus，对应问题：婚姻状况？
*  1、未婚；
*  2、初婚有配偶；
*  3、再婚有配偶；
*  4、离婚；
*  5、丧偶；
gen 已婚有配偶=0 if (maritus==1 | maritus==4 |maritus==5)
replace 已婚有配偶=1 if (maritus==2 | maritus==3)

** 农村户口（是=1，否=0）
*  涉及变量hktype，对应问题：户口性质？
*  农业
*  非农业
gen 农业户口 = 0 if hktype == 2
replace 农业户口 = 1 if hktype == 1

** 兄弟姐妹个数
*  涉及变量nbroth，对应问题：兄弟__人？
*  涉及变量nsister，对应问题：姐妹__人？
replace nbroth = 0 if nbroth==.
replace nsister = 0 if nsister==.
gen 兄弟姐妹个数 = nbroth + nsister

** 健康水平（身体健康=1，基本能基本能保证正常的生活工作、不能正常工作或生活不能自理、说不准=0）
*  涉及变量health，对应问题：身体健康状况？
*  1、身体健康
*  2、基本能保证正常的生活工作
*  3、不能正常工作或生活不能自理
*  4、说不准
replace health = 0 if (health==2 | health==3 | health==4)
rename health 健康水平

**（2.2）家庭特征
** 家庭人数
*  涉及变量n_hh，对应问题：2005年10月31日晚居住在本户的人数？
*  涉及变量n_hk_hh，对应问题：户口在本户, 2005年10月31日晚未居住在本户的人数？
gen house_size=n_hh+n_hk_hh
rename house_size 家庭人数

** 去年有人出生（有=1，无=0）
*  涉及变量n_mbirth_hh，对应问题：本户2004年11月1日至2005年10月31日出生人口，男__人？
*  涉及变量n_fbirth_hh，对应问题：本户2004年11月1日至2005年10月31日出生人口，女__人？
gen 去年有人出生 = n_mbirth_hh + n_fbirth_hh
replace 去年有人出生 = 1 if 去年有人出生>=1 & 去年有人出生!=.

** 去年有人死亡（有=1，无=0）
*  涉及变量n_mbirth_hh，对应问题：本户2004年11月1日至2005年10月31日死亡人口，男__人？
*  涉及变量n_fbirth_hh，对应问题：本户2004年11月1日至2005年10月31日死亡人口，女__人？
gen 去年有人死亡= n_mdeath_hh + n_fdeath_hh
replace 去年有人死亡=1 if 去年有人死亡>=1 & 去年有人死亡!=.

** 房屋面积
*  涉及变量nsm_h，对应问题：住房建筑面积（平方米）？
rename nsm_h 房屋面积

** 房屋房间数
*  涉及变量nroom_h，对应问题：住房间数（间）？
rename nroom_h 房屋房间数

** 7层以上楼房（是=1，否=0）
*  涉及变量nf_build，对应问题：建筑层数？
*  1、平房；
*  2、六层及以下楼房；
*  3、七层及以上楼房；
gen _7层以上楼房=0 if (nf_build==1 | nf_build==2 )  
replace _7层以上楼房=1 if nf_build==3

** 2000年后建成住房（是=1，否=0）
*  涉及变量t_build，对应问题：本座住宅建成时间:__年？ 
gen _2000年后建成住房=0 if t_build!=.
replace _2000年后建成住房=1 if t_build>=2000 & t_build!=.

** 有厨房（有=1，无=0）
*  涉及变量ifkit_h，对应问题：住房内有无厨房？
*  1、本户独立使用；
*  2、本户与其他户合用；
*  3、无；
gen 有厨房=0 if (ifkit_h==2 | ifkit_h==3)
replace 有厨房=1 if ifkit_h==1

** 有厕所（有=1，无=0）
*  涉及变量iftoil_h，对应问题：住房内有无厕所？
*  1、独立使用抽水式；
*  2、邻居合用抽水式；
*  3、独立使用其他式样；
*  4、邻居合用其他式样；
*  5、无
gen 有厕所=0 if (iftoil_h==1 | iftoil_h==3)
replace 有厕所=1 if (iftoil_h==2 | iftoil_h==4 | iftoil_h==5 )

** 购买的住房（是=1，否=0）
*  涉及变量how_h，对应问题：住房来源？
*  1、自建住房；
*  2、购买商品房；
*  3、购买经济适用房；
*  4、购买原公有住房；
*  5、租赁公有住房；
*  6、租赁商品住房；
*  7、其他
gen 购买的住房=0 if (how_h==1 | how_h==5 | how_h==6 | how_h==7 )
replace 购买的住房=1 if (how_h==2 | how_h==3| how_h==4 )

rename year_birth 出生年份    
rename moth_birth 出生月份   
rename region 城市代码

keep 城市代码 出生年份 出生月份 失业原因 是否因为单位原因失业 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 农业户口 兄弟姐妹个数 健康水平 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _7层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房

order 城市代码 出生年份 出生月份 失业原因 是否因为单位原因失业 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 农业户口 兄弟姐妹个数 健康水平 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _7层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房

*   保存

save 实证分析数据_2005人口普查数据.dta,replace    //拓展分析部分还会用到该数据

*   回归

use 实证分析数据_2005人口普查数据.dta,clear

*  构造核心解释变量
* （1）根据2005年人口普查时间和受访者出生年月信息，构建驱动变量DistanceFrom25:受访者普查时的年龄与25周岁的距离，单位为月
*      说明：由于2005、2015年人口普查时间都是11月1日，因此在构造DistanceFrom25时，执行与DistanceFrom35一样的代码即可
gen DistanceFrom25 = 10-出生月份 if 出生年份==1980  
forvalue i=1981(1)1999{
replace DistanceFrom25=-2-(12*(`i'-1981))-出生月份 if 出生年份==`i'      
}
replace DistanceFrom25=.  if 出生年份==1999 & 出生月份 >=11 & 出生月份<=12  
forvalue i=1979(-1)1955{
replace DistanceFrom25=10+(12*(1980-出生年份)-出生月份) if 出生年份==`i'  & 性别==1   
}
replace DistanceFrom25=.  if 出生年份==1955 & 出生月份 >=1 & 出生月份<=10 & 性别==1
forvalue i=1979(-1)1960{
replace DistanceFrom25=10+(12*(1980-出生年份)-出生月份) if 出生年份==`i' & 性别==0  
}
replace DistanceFrom25=.  if 出生年份==1960 & 出生月份 >=1 & 出生月份<=10 & 性别==0 

* （2）基于DistanceFrom25，可以得到局部线性回归和局部二次项回归使用的其他解释变量：
gen Over25=0                                            //受访者在2005年人口普查时是否年满25周岁，是设置为1，否则为0
replace Over25=1 if DistanceFrom25>=0
gen Over25_DistanceFrom25=Over25*DistanceFrom25         //Over25与DistanceFrom25的交叉项 
gen DistanceFrom25_sq=(DistanceFrom25)^2                //DistanceFrom25的2次项
gen Over25_DistanceFrom25_sq=Over25*DistanceFrom25_sq   //Over25与DistanceFrom25_sq的交叉项

* （3）构建安慰剂检验回归样本
*      第一，根据调查年月和受访者出生年月，构造以月份为基本单位的年龄信息
*            请见DistanceFrom25的构造过程
*      第二，保留基准回归对应出生年月的样本
*            注意：DistanceFrom25是针对基准回归对应出生年月的样本构造的，因此只要保留非缺失值即可  
keep if DistanceFrom25!=.        
**     第三，剔除变量丢失的数据
sum 是否因为单位原因失业 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 农业户口 兄弟姐妹个数 健康水平 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _7层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房
drop if 是否因为单位原因失业==. 
drop if 户主==. 
drop if 识字==. 
drop if 已婚有配偶==. 
drop if 农业户口==. 
drop if 房屋面积==. 
sum 是否因为单位原因失业 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 农业户口 兄弟姐妹个数 健康水平 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _7层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房

* （4）安慰剂检验回归
*      说明：2005年人口普查数据只有提供城市代码，所以只能控制城市固定效应、采用聚类到城市的稳健标准误

areg 是否因为单位原因失业 Over25 DistanceFrom25 Over25_DistanceFrom25 if abs(DistanceFrom25)<=45, abs(城市代码) cluster(城市代码)
eststo
areg 是否因为单位原因失业 Over25 DistanceFrom25 Over25_DistanceFrom25 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 农业户口 兄弟姐妹个数 健康水平 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _7层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 if abs(DistanceFrom25)<=45, abs(城市代码) cluster(城市代码)
eststo
areg 是否因为单位原因失业 Over25 DistanceFrom25 Over25_DistanceFrom25 DistanceFrom25_sq Over25_DistanceFrom25_sq if abs(DistanceFrom25)<=58, abs(城市代码) cluster(城市代码)
eststo
areg 是否因为单位原因失业 Over25 DistanceFrom25 Over25_DistanceFrom25 DistanceFrom25_sq Over25_DistanceFrom25_sq 户主 性别 民族 受教育程度 识字 流动人口 _1年前常住地为本地 _5年前常住地为本地 已婚有配偶 农业户口 兄弟姐妹个数 健康水平 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _7层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 if abs(DistanceFrom25)<=58, abs(城市代码) cluster(城市代码)
eststo

cd "D:\2024-00330+数据\2024-00330+日志文件"

esttab, ar2 se b(%9.4f) t(%9.4f) star(* 0.10 ** 0.05 *** 0.01) nogap, using 第四章_代码13结果_附录III表III2_PanelA.csv, replace
estimate drop est*



* Panel B. 使用2010年人口普查数据
*   基于2010年人口普查原始数据，进行变量构造和样本构建

clear
set max_memory 128g
cd "D:\2024-00330+数据\2024-00330+论文数据"
** 2010年人口普查数据：包括7个子文件
foreach 2010年人口普查原始数据 in "2010年人口普查原始数据_r1" "2010年人口普查原始数据_r1_b" "2010年人口普查原始数据_r2" "2010年人口普查原始数据_r2_b" "2010年人口普查原始数据_r3" "2010年人口普查原始数据_r4" "2010年人口普查原始数据_r5" {
use `2010年人口普查原始数据'.dta,clear
**转换成数值型
destring 户别 - 周岁年龄 , replace

**（一）变量构造
**（1）被解释变量
*  是否因为单位原因失业（是=1，否=0）
*  涉及变量：未工作原因？
*  1、在校学习；
*  2、丧失工作能力；
*  3、毕业后未工作；
*  4、因单位原因失去原工作；
*  5、因本人原因失去原工作
*  6、承包土地被征用
*  7、离退休
*  8、料理家务
*  9、其他
gen 是否因为单位原因失业 = 0
replace 是否因为单位原因失业 = 1 if 未工作原因==4
replace 是否因为单位原因失业 = 是否因为单位原因失业*100   //  为避免估计系数过小，将被解释变量乘以100

**（2）控制变量
* （2.1）个人特征
** 户主（是=1，否=0）
*  涉及变量:与户主关系？
*  0、户主；
*  1、配偶；
*  2、子女；
*  3、父母；
*  4、岳父母或公婆；
*  5、祖父母；
*  6、媳婿；
*  7、孙子女；
*  8、兄弟姐妹；
*  9、其他；
gen 户主=0 if 与户主关系!=0
replace 户主=1 if 与户主关系==0

** 性别（男=1，女=0）
*  涉及变量：性别？
*  1、男
*  2、女
gen 性别2=0 if  性别==2
replace 性别2=1 if  性别==1
drop 性别
rename 性别2 性别

** 民族（汉族=1，其他=0）
*  涉及变量：民族？
*  01、汉族
*  02、03、...56、97、98
gen 民族2=0
replace 民族2=1 if 民族==1
drop 民族 
rename 民族2 民族

** 受教育程度（未上过学=0，小学=6，初中=9，高中=12，大学专科=15，大学本科=16，研究生及以上=19）
*  涉及变量：受教育程度？
*  1、未上过学；
*  2、小学；
*  3、初中；
*  4、高中；
*  5、大学专科；
*  6、大学本科；
*  7、研究生；
gen 受教育程度2=.
replace 受教育程度2=0 if 受教育程度==1
replace 受教育程度2=6 if 受教育程度==2
replace 受教育程度2=9 if 受教育程度==3
replace 受教育程度2=12 if 受教育程度==4
replace 受教育程度2=15 if 受教育程度==5
replace 受教育程度2=16 if 受教育程度==6
replace 受教育程度2=19 if 受教育程度==7
drop 受教育程度 
rename 受教育程度2 受教育程度

** 识字（是=1，否=0）
*  涉及变量：是否识字？
*  1、是；
*  2、否
gen 识字 = 0 if 是否识字 == 2
replace 识字 = 1 if 是否识字 == 1

** 流动人口（离开户口登记地=1，其他=0）
*  涉及变量：离开户口登记地的时间？
*  1、没有离开户口登记地；
*  2、半年以下；
*  3、半年至一年；
*  4、一至两年；
*  5、两至三年；
*  6、三至四年；
*  7、四至五年；
*  8、五至六年；
*  9、六年以上
gen 流动人口=0 if 离开户口登记地时间==1
replace 流动人口=1 if 离开户口登记地时间!=1 & 离开户口登记地时间!=.

** 5年前常住地为本地（是=1，否=0）
*  涉及变量：五年前常住地？
*  1、省内；
*  2、省外；
gen _5年前常住地为本地 = 0 if 五年前常住地 == 2
replace _5年前常住地为本地 = 1 if 五年前常住地 == 1

** 已婚有配偶（是=1，其他=0）
*  涉及变量maritus，对应问题：婚姻状况？
*  1、未婚；
*  2、有配偶；
*  3、离婚；
*  4、丧偶；
gen 已婚有配偶=0 if (婚姻状况==1 | 婚姻状况==3 |婚姻状况==4)
replace 已婚有配偶=1 if 婚姻状况==2

** 农村户口（是=1，否=0）
*  涉及变量：户口性质？
*  农业
*  非农业
gen 农业户口 = 0 if 户口性质 == 2
replace 农业户口 = 1 if 户口性质 == 1

**（2.2）家庭特征
** 家庭人数
*  涉及变量：当晚居住本户的人数？
*  涉及变量：未居住在本户的人数？
gen 家庭人数 = 当晚居住本户的人数+未居住在本户的人数

** 去年有人出生（有=1，无=0）
*  涉及变量：出生人口__男？
*  涉及变量：出生人口__女？
gen 去年有人出生 = 出生人口男 + 出生人口女
replace 去年有人出生 = 1 if 去年有人出生>=1 & 去年有人出生!=.

** 去年有人死亡（有=1，无=0）
*  涉及变量：死亡人口__男？
*  涉及变量：死亡人口__女？
gen 去年有人死亡 = 死亡人口男 + 死亡人口女
replace 去年有人死亡=1 if 去年有人死亡>=1 & 去年有人死亡!=.

** 房屋面积
*  涉及变量：建筑面积（平方米）？
rename 建筑面积 房屋面积

** 房屋房间数
*  涉及变量：本户住房间数（间）？
rename 本户住房间数 房屋房间数

** 10层以上楼房（是=1，否=0）
*  涉及变量nf_build，对应问题：建筑层数？
*  1、平房；
*  2、2-3层楼房；
*  3、4-6层楼房；
*  4、7-9层楼房；
*  5、10层以上楼房；
gen _10层以上楼房=0 if (建筑层数==1 | 建筑层数==2 | 建筑层数==3 | 建筑层数==4)  
replace _10层以上楼房=1 if 建筑层数==5

** 2000年后建成住房（是=1，否=0）
*  涉及变量：住房建成年代？
*  1、1949年以前；
*  2、1949-1959年；
*  3、1960-1969年；
*  4、1970-1979年；
*  5、1980-1989年；
*  6、1990-1999年；
*  7、2000年以后
gen _2000年后建成住房=0 if 住房建成年代!=. & 住房建成年代!=7
replace _2000年后建成住房=1 if 住房建成年代==7

** 有厨房（有=1，无=0）
*  涉及变量：住房内有无厨房？
*  1、独立使用；
*  2、与其他户合用；
*  3、无；
gen 有厨房=0 if (住房内有无厨房==2 | 住房内有无厨房==3)
replace 有厨房=1 if 住房内有无厨房==1

** 有厕所（有=1，无=0）
*  涉及变量：住房内有无厕所？
*  1、独立使用抽水式；
*  2、邻居合用抽水式；
*  3、独立使用其他式样；
*  4、邻居合用其他式样；
*  5、无
gen 有厕所=0 if (住房内有无厕所==1 | 住房内有无厕所==3)
replace 有厕所=1 if (住房内有无厕所==2 | 住房内有无厕所==4 | 住房内有无厕所==5 )

** 购买的住房（是=1，否=0）
*  涉及变量：住房来源？
*  1、租赁廉租住房；
*  2、租赁其他住房；
*  3、自建住房；
*  4、购买商品房；
*  5、购买二手房；
*  6、购买经济适用房；
*  7、购买原公有住房
*  8、其他
gen 购买的住房=0 if (住房来源==1 | 住房来源==2 | 住房来源==3 | 住房来源==8 )
replace 购买的住房=1 if ( 住房来源==4| 住房来源==5 | 住房来源==6 | 住房来源==7)

rename 出生年 出生年份    
rename 出生月 出生月份   
gen 区县代码 = substr(户编码,1,6)
destring 区县代码,replace

keep 区县代码 出生年份 出生月份 是否因为单位原因失业 户主 性别 民族 受教育程度 识字 流动人口  _5年前常住地为本地 已婚有配偶 农业户口  家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房
order 区县代码 出生年份 出生月份 是否因为单位原因失业 户主 性别 民族 受教育程度 识字 流动人口  _5年前常住地为本地 已婚有配偶 农业户口  家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房

save `2010年人口普查原始数据'_处理后.dta,replace 
}

** 合并
use 2010年人口普查原始数据_r1_处理后.dta,clear
append using 2010年人口普查原始数据_r1_b_处理后.dta,force
append using 2010年人口普查原始数据_r2_处理后.dta,force
append using 2010年人口普查原始数据_r2_b_处理后.dta,force
append using 2010年人口普查原始数据_r3_处理后.dta,force
append using 2010年人口普查原始数据_r4_处理后.dta,force
append using 2010年人口普查原始数据_r5_处理后.dta,force

*   保存

save 实证分析数据_2010人口普查数据.dta,replace    //拓展分析部分还会用到该数据

*   回归

use 实证分析数据_2010人口普查数据.dta,clear

**（1）根据2010年人口普查时间和受访者出生年月信息，构建驱动变量DistanceFrom30:受访者普查时的年龄与30周岁的距离，单位为月
*      说明：由于2010、2015年人口普查时间都是11月1日，因此在构造DistanceFrom30时，执行与DistanceFrom35一样的代码即可
gen DistanceFrom30 = 10-出生月份 if 出生年份==1980  
forvalue i=1981(1)1999{
replace DistanceFrom30=-2-(12*(`i'-1981))-出生月份 if 出生年份==`i'      
}
replace DistanceFrom30=.  if 出生年份==1999 & 出生月份 >=11 & 出生月份<=12  
forvalue i=1979(-1)1955{
replace DistanceFrom30=10+(12*(1980-出生年份)-出生月份) if 出生年份==`i'  & 性别==1   
}
replace DistanceFrom30=.  if 出生年份==1955 & 出生月份 >=1 & 出生月份<=10 & 性别==1
forvalue i=1979(-1)1960{
replace DistanceFrom30=10+(12*(1980-出生年份)-出生月份) if 出生年份==`i' & 性别==0  
}
replace DistanceFrom30=.  if 出生年份==1960 & 出生月份 >=1 & 出生月份<=10 & 性别==0 

**（2）基于DistanceFrom30，可以得到局部线性回归和局部二次项回归使用的其他解释变量：
gen Over30=0                                             //受访者在2010年人口普查时是否年满30周岁，是设置为1，否则为0
replace Over30=1 if DistanceFrom30>=0
gen Over30_DistanceFrom30=Over30*DistanceFrom30          //Over30与DistanceFrom30的交叉项 
gen DistanceFrom30_sq=(DistanceFrom30)^2                 //DistanceFrom30的2次项  
gen Over30_DistanceFrom30_sq=Over30*DistanceFrom30_sq    //Over30与DistanceFrom30_sq的交叉项

**（3）构建安慰剂检验回归样本
*      第一，根据调查年月和受访者出生年月，构造以月份为基本单位的年龄信息
*            请见DistanceFrom30的构造过程
*      第二，保留基准回归对应出生年月的样本
*            注意：DistanceFrom30是针对基准回归对应出生年月的样本构造的，因此只要保留非缺失值即可  
keep if DistanceFrom30!=.        

*      第三，剔除变量丢失的数据
sum 是否因为单位原因失业 户主 性别 民族 受教育程度 识字 流动人口 _5年前常住地为本地 已婚有配偶 农业户口 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房
drop if 已婚有配偶==.
drop if 农业户口==.
drop if 房屋面积==.
sum 是否因为单位原因失业 户主 性别 民族 受教育程度 识字 流动人口 _5年前常住地为本地 已婚有配偶 农业户口 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房

**（4）安慰剂检验回归
areg 是否因为单位原因失业 Over30 DistanceFrom30 Over30_DistanceFrom30 if abs(DistanceFrom30)<=45, abs(区县代码) cluster(区县代码)
eststo
areg 是否因为单位原因失业 Over30 DistanceFrom30 Over30_DistanceFrom30 户主 性别 民族 受教育程度 识字 流动人口 _5年前常住地为本地 已婚有配偶 农业户口 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 if abs(DistanceFrom30)<=45, abs(区县代码) cluster(区县代码)
eststo
areg 是否因为单位原因失业 Over30 DistanceFrom30 Over30_DistanceFrom30 DistanceFrom30_sq Over30_DistanceFrom30_sq if abs(DistanceFrom30)<=58, abs(区县代码) cluster(区县代码)
eststo
areg 是否因为单位原因失业 Over30 DistanceFrom30 Over30_DistanceFrom30 DistanceFrom30_sq Over30_DistanceFrom30_sq 户主 性别 民族 受教育程度 识字 流动人口 _5年前常住地为本地 已婚有配偶 农业户口 家庭人数 去年有人出生 去年有人死亡 房屋面积 房屋房间数 _10层以上楼房 _2000年后建成住房 有厨房 有厕所 购买的住房 if abs(DistanceFrom30)<=58, abs(区县代码) cluster(区县代码)
eststo

cd "D:\2024-00330+数据\2024-00330+日志文件"
esttab, ar2 se b(%9.4f) t(%9.4f) star(* 0.10 ** 0.05 *** 0.01) nogap, using 第四章_代码13结果_附录III表III2_PanelB.csv, replace
estimate drop est*

