
***********************************************************************
* 第二章 附录I图I1 我国企业招聘35岁现象的地区差异
***********************************************************************

* 基于5969万条企业招聘数据
* 利用“工作城市”的信息，识别岗位所在省份(变量名为prvcnm) 和城市(若工作城市为县级市，调整为所属地级市，变量名为city_adjust)
* 利用自然语言处理技术，生成两个变量minage、maxage，记录岗位设置的年龄下限或上限数值，若不存在年龄下限或上限信息，则设置为0

cd "D:\2024-00330+数据\2024-00330+论文数据"

use 附录I图I1-数据.dta,clear

* 是否有年龄要求
gen age_requirement = 0
replace age_requirement = 1 if minage>0 
replace age_requirement = 1 if maxage>0 

* 是否有35岁限制
gen age_35=0
replace age_35=1 if maxage==35

***************************附录I图I1(a)和(b)*************************************
* 汇总各省情况，获得附录I图I1(a)和(b)对应的统计数值

preserve
gen obs=1
bys prvcnm: egen sum_obs_prov = sum(obs)
bys prvcnm: egen sum_age_requirement_prov = sum(age_requirement)
bys prvcnm: egen sum_age_35_prov = sum(age_35)   
gen ratio_age_require_prov=sum_age_requirement_prov/sum_obs_prov //对于特定省份的工作岗位，存在年龄限制的岗位占总岗位的比例
gen ratio_age_35_prov=sum_age_35_prov/sum_obs_prov   //对于特定省份的工作岗位，存在35岁上限要求的岗位占总岗位的比例
duplicates drop prvcnm,force
keep prvcnm ratio_age_require_prov ratio_age_35_prov
* 将数据保存至日志文件夹中的“第二章_代码3结果_附录I图I1(a)和(b).xls”，绘图得到附录I图I1(a)和(b)
restore

***************************附录I图I1(c)和(d)*************************************
* 汇总各城市情况，获得附录I图I1(c)和(d)画图所需统计数值

preserve
drop if city_adjust==""
gen obs=1
bys city_adjust: egen sum_obs = sum(obs)
bys city_adjust: egen sum_age_requirement = sum(age_requirement)
bys city_adjust: egen sum_age_35 = sum(age_35)
gen ratio_age_require=sum_age_requirement/sum_obs
gen ratio_age_35=sum_age_35/sum_obs
duplicates drop city_adjust,force
rename sum_obs 样本量
rename ratio_age_require 存在年龄限制的岗位比例
rename ratio_age_35 明确要求35岁以下的岗位比例
rename city_adjust city
keep city 存在年龄限制的岗位比例 明确要求35岁以下的岗位比例
save 附录I图I1_画图数据_城市年龄要求.dta,replace
restore

* 绘制附录I图I1(c)和(d)，画图原始代码来自 He, Xiaoping, Yuxuan Yu, and Shuo Jiang. "City centrality, population density and energy efficiency." Energy Economics 117 (2023): 106436. 对应链接https://www.sciencedirect.com/science/article/pii/S0140988322005655#f0015

use data_fig3.dta, clear     //画图软件包代码
merge 1:1 city using 附录I图I1_画图数据_城市年龄要求.dta,force

replace 存在年龄限制的岗位比例 = 存在年龄限制的岗位比例 * 100
replace 明确要求35岁以下的岗位比例 = 明确要求35岁以下的岗位比例 * 100
replace 存在年龄限制的岗位比例=-1 if _merge==1   //无数据用灰色（对应数值-1）表示
replace 明确要求35岁以下的岗位比例=-1 if _merge==1  //无数据用灰色（对应数值-1）表示


* 附录I图I1(c)：对于特定城市的工作岗位，存在年龄限制的岗位占总岗位的比例
preserve
sum 存在年龄限制的岗位比例 if 存在年龄限制的岗位比例!=-1,d
grmap, activate    //grmap这个代码需要Stata15及以上版本运行
grmap 存在年龄限制的岗位比例 using chinacity2020_coord.dta, ///
	id(ID) osize(vvthin ...) ocolor(white ...) ///
	clmethod(custom) clbreaks(-1  0 15.82 18.49 21.31 46.35 ) ///
	fcolor("gs10" "224 242 241" "178 223 219" "128 203 196" "77 182 172" "38 166 154") ///
	leg(order(2 "无数据" 3 "[最小值,25分位数):7.05%~15.82%" 4 "[25分位数,50分位数):15.82%~18.49%" 5 "[50分位数,75分位数):18.49%~21.31%" 6 "[75分位数,最大值]:21.31%~46.34%" )) ///
	graphr(margin(medium)) ///
	line(data(chinacity2020_line_coord3.dta) by(group) ///
		size(vvthin *1 *0.5 *0.5 *0.5) pattern(solid ...) ///
		select(drop if inlist(group, 4, 7)) ///
		color(white /// 
			  black ///
			  "0 85 170" /// 
			  black /// 
			  black /// sdaf
			  )) ///
	polygon(data(polygon3) fcolor(black) ///
		osize(vvthin)) ///
	label(data(chinacity2020_label3) x(X) y(Y) label(cname) length(20) size(*0.8)) 
	
cd "D:\2024-00330+数据\2024-00330+日志文件"
graph save "Graph" 第二章_代码3结果_附录I图I1(c).gph    
restore


* 附录I图I1(d)：对于特定城市的工作岗位，存在年龄限制的岗位占总岗位的比例
preserve
cd "D:\2024-00330+数据\2024-00330+论文数据"
sum 明确要求35岁以下的岗位比例 if 明确要求35岁以下的岗位比例!=-1,d
grmap, activate
grmap 明确要求35岁以下的岗位比例 using chinacity2020_coord.dta, ///
	id(ID) osize(vvthin ...) ocolor(white ...) ///
	clmethod(custom) clbreaks(-1  0 3.76 4.39 5.04 34.15 ) ///
	fcolor("gs10" "224 242 241" "178 223 219" "128 203 196" "77 182 172" "38 166 154") ///
	leg(order(2 "无数据" 3 "[最小值,25分位数):1.60%~3.76%" 4 "[25分位数,50分位数):3.76%~4.39%" 5 "[50分位数,75分位数):4.39%~5.04%" 6 "[75分位数,最大值]:5.04%~34.15%" )) ///
	graphr(margin(medium)) ///
	line(data(chinacity2020_line_coord3.dta) by(group) ///
		size(vvthin *1 *0.5 *0.5 *0.5) pattern(solid ...) ///
		select(drop if inlist(group, 4, 7)) ///
		color(white /// 
			  black ///
			  "0 85 170" /// 
			  black /// 
			  black /// 
			  )) ///
	polygon(data(polygon3) fcolor(black) ///
		osize(vvthin)) ///
	label(data(chinacity2020_label3) x(X) y(Y) label(cname) length(20) size(*0.8))
	
cd "D:\2024-00330+数据\2024-00330+日志文件"
graph save "Graph" 第二章_代码3结果_附录I图I1(d).gph    
restore

