

***********************************************************************
* 第二章 正文图1：我国企业招聘的35岁现象
***********************************************************************

* 基于5969万条企业招聘数据，考察用人单位是否系统性锚定35岁进行雇佣决策
* 企业通常在任职要求设置年龄限制，文本结构包括：满X岁；X岁以上；X岁（含）以上；X—Y岁；X岁—Y岁；X至Y岁；X到Y岁；X岁以上、Y岁以下；X岁以下；不超过X岁；还有周岁格式（例如，满X周岁）和符号差异（例如，X岁~Y岁）。
* 根据上述文本结构，本文利用自然语言处理技术，生成两个变量minage、maxage，记录岗位设置的年龄下限或上限数值，若不存在年龄下限或上限信息，则设置为0

cd "D:\2024-00330+数据\2024-00330+论文数据"

use 正文图1-数据.dta,clear

* 是否有年龄要求
gen age_requirement = 0
replace age_requirement = 1 if minage>0    
replace age_requirement = 1 if maxage>0    

* 是否有年龄上限
gen maxage_requirement = 0
replace maxage_requirement = 1 if maxage>0

* 是否有年龄下限
gen minage_requirement = 0
replace minage_requirement = 1 if minage>0

* 获得正文图1 (a) 对应统计数值
sum age_requirement maxage_requirement minage_requirement  //全样本
sum age_requirement maxage_requirement minage_requirement if data_sources=="前程无忧"  
sum age_requirement maxage_requirement minage_requirement if data_sources=="猎聘网"    
sum age_requirement maxage_requirement minage_requirement if data_sources=="智联招聘"
sum age_requirement maxage_requirement minage_requirement if (data_sources=="BOSS直聘" | data_sources=="BOSS")
sum age_requirement maxage_requirement minage_requirement if data_sources=="58同城"

* 获得正文图1 (b) 对应统计数值
keep if maxage>0
tab maxage   //全样本
tab maxage if data_sources=="前程无忧"
tab maxage if data_sources=="猎聘网"
tab maxage if data_sources=="智联招聘"
tab maxage if (data_sources=="BOSS直聘" | data_sources=="BOSS")
tab maxage if data_sources=="58同城"

* 整理上述统计数值，保存至日志文件夹中的“第二章_代码1结果_正文图1.xls”，绘图得到正文图1
