

/*******************************************************************************
*
*	Statistical Management System and Statistical Data Quality
*
*******************************************************************************/	

	
	clear all                 //Remove everything from the memory, refresh.
    cap log close             //Close any open log file.
    set more off              //Show the result all at once.
    set rmsg on

	gl root=" C:\Users\lenovo\Desktop\2024-00207_数据"         //设定工作路径
	cd $root
	

	gl dofiles="$root\2024-00207_程序代码"
	gl working_data="$root\2024-00207_使用数据"
	gl tables="$root\2024-00207_日志文件"
    gl control="c.lpopu_ind2000#i.year c.指数2000#i.year   c.urban2000#i.year  c.lhaiba2000#i.year c.labor_ra2000#i.year "

	
	
	*----------------- 指标含义 -----------------*	
	
/*	lgdp：采用97年平减指数计算的实际GDP取对数；
	treat：统计机构垂直管理改革政策虚拟变量，实施取1，没有实施取0；
	post:统计机构垂直管理改革政策实施时间虚拟变量，2006年及之后取1，2006年之前取0；
	treat_post：生成的统计机构垂直化改革变量，是treat与post变量的交乘项；
	llight:DMSP夜间灯光亮度(取对数);
	tpllight：treat_post变量与llight的交乘项；
	tllight：treat变量与llight的交乘项；
	pllight：post变量与llight的交乘项；
	lfisrev:财政收入（取对数）；
	lelec：全年用电总量（取对数)；
	lhuowu：货运总量（取对数）；
	lfinan：年末金融贷款余额（取对数）；
	linform：信息化水平衡量指标，全年电信业务量（取对数）
	pressure：发展压力衡量指标，滞后一期的GDP排名
	lpopu_ind2000：期初人口密度
	urban2000：期初城镇化率
	labor_ra2000：期初单位就业人员占比	
	指数2000：期初市场化指数
	lhaiba2000：期初海拔高度（取对数）
	llight2：DMSP与VIIRS整合后的长时间序列夜间灯光变量（取对数）
	tpllight2：treat_post变量与llight2的交乘项；
	tllight2：treat变量与llight2的交乘项；
	pllight2：post变量与llight2的交乘项；
	全面省直管县_汇总到市：实施过省直管县政策的市赋值为1，否则为0；
	llight_sq：llight变量的平方项；
	l.llight:llight变量的滞后项；
	age_省委书记: 省委书记年龄
	age_省长：省长年龄
	tennu_省委书记：省委书记任期
	tennu_省长：省长任期
	tpllightlinform: tpllight变量与linform变量的交乘项；
	tplinform: treat_post变量与linform变量的交乘项；
	llightlinform：llight变量与linform变量的交乘项；
	tpllightpre：tpllight变量与pressure变量的交乘项；     
	tppre：treat_post变量与pressure变量的交乘项；  
	llightpre：llight变量与pressure变量的交乘项     */
	
	

***********************# 表1 描述性统计 #***********************	
	
	use $working_data\workdata.dta ,clear
		
		keep if  year<=2013 & year>=2000
		drop if lgdp==. |llight==.|treat_post==.
	asdoc sum  treat_post lgdp llight  lfisrev lelec lhuowu lfinan linform pressure 

	
	use $working_data\workdata.dta ,clear
		keep if  year<=2013&year>=2000
	asdoc sum  lpopu_ind2000 lhaiba2000 指数2000 urban2000 labor_ra2000  if year==2000
	
	
	
	
***********************# 表2 基准回归结果 #***********************

	use $working_data\workdata.dta ,clear
		keep if  year<=2013&year>=2000
		drop if  lgdp==. |treat_post==. |llight==.
	

	reghdfe lgdp llight ,a(citycode year) cluster(citycode)
		est store m1

	reghdfe lgdp tpllight llight treat_post  ,a(citycode year) cluster(citycode)
		est store m2

	reghdfe lgdp tpllight llight treat_post tllight pllight ,a(citycode year) cluster(citycode)
		est store m3

	reghdfe lgdp tpllight llight treat_post tllight pllight $control ,a(citycode year) cluster(citycode)
		est store m4
	
	
	outreg2 [m1 m2 m3 m4 ] using  $tables\table2.xls,            ///
			stat(coef se) bdec(4)  title("Model") replace       ///
            keep(llight tpllight treat_post tllight pllight)   ///
			addtext(City FE, YES, Year FE, YES)
	
	
	
	
************# 表3 采用东北地区和东中西部地区样本 #**********
	
	use $working_data\workdata.dta ,clear
		keep if  year<=2013&year>=2000
		drop if  lgdp==. |treat_post==. |llight==.
			
	
	/****** 东北地区对比 ******/	

	reghdfe lgdp tpllight llight treat_post tllight pllight $control  ///
	if pro==22|pro==21|pro==23  ,a(citycode year) cluster(citycode)
		est store m1

	reghdfe lgdp tpllight llight treat_post tllight pllight $control  ///
	if pro==22|pro==21  ,a(citycode year) cluster(citycode)
		est store m2

	reghdfe lgdp tpllight llight treat_post tllight pllight $control  ///
	if pro==22|pro==23  ,a(citycode year) cluster(citycode)
		est store m3

		
	/****** 与东中西部地区对比 ******/

	reghdfe lgdp tpllight llight treat_post tllight pllight  $control  ///
    if east==1|pro==22  ,a(citycode year) cluster(citycode)
		est store m4

	reghdfe lgdp tpllight llight treat_post tllight pllight  $control  ///    
	if middle==1|pro==22  ,a(citycode year) cluster(citycode)
		est store m5

	reghdfe lgdp tpllight llight treat_post tllight pllight   $control  /// 
	if west==1|pro==22  ,a(citycode year) cluster(citycode)
		est store m6

		
		
	outreg2 [m1 m2 m3 m4 m5 m6  ] using $tables\table3.xls, 		///
				stat(coef se) bdec(4)  title("Model") replace 		///
				keep(llight tpllight treat_post  tllight pllight)   ///
				addtext(City FE, YES, Year FE, YES)

	
	
	
***********************# 表4 安慰剂检验 #***********************
					
					
	use $working_data\workdata.dta ,clear
		keep if  year<=2013&year>=2000
		drop if  lgdp==. |treat_post==. |llight==.

		
	* 财政收入	
	reghdfe  lfisrev llight  $control 	,a(citycode year) cluster(citycode)
		est store m1
		
	reghdfe  lfisrev tpllight llight treat_post tllight pllight $control ///
	,a(citycode year) cluster(citycode)
		est store m2

		
	* 全年用电量
	reghdfe lelec llight  $control   ,a(citycode year) cluster(citycode)
		est store m3

	reghdfe lelec tpllight llight treat_post tllight pllight $control ///
	,a(citycode year) cluster(citycode)
		est store m4

	* 货运总量
	reghdfe lhuowu llight  $control  ,a(citycode year) cluster(citycode)
		est store m5

	reghdfe lhuowu tpllight llight treat_post tllight pllight $control ///
	,a(citycode year) cluster(citycode)
		est store m6

	* 人民币贷款余额
	reghdfe lfinan llight  $control ,a(citycode year) cluster(citycode)
		est store m7

	reghdfe lfinan tpllight llight treat_post tllight pllight $control ///
	,a(citycode year) cluster(citycode)
		est store m8

		
	outreg2 [m1 m2 m3 m4 m5 m6 m7 m8 ] using $tables\table4.xls, 	///
				stat(coef se) bdec(4)  title("Model") replace 		///
				keep(llight tpllight treat_post  tllight pllight)   ///
				addtext(City FE, YES, Year FE, YES)

	
	
	
***********************# 表5 异质性分析 #***********************
					
	use $working_data\workdata.dta ,clear
		keep if  year<=2013&year>=2000
   		drop if  lgdp==. |treat_post==. |llight==.           

		
	* 1.信息化水平

	reghdfe lgdp tpllightlinform  llight  tpllight  tplinform  llightlinform treat_post linform  ///
	,a(citycode  year) cluster(citycode)
		est store m1

	reghdfe lgdp tpllightlinform  llight  tpllight  tplinform  llightlinform treat_post linform	$control ///
	,a(citycode  year) cluster(citycode)
		est store m2

	outreg2 [m1 m2] using $tables\table5-1.xls,         ///
				stat(coef se) bdec(4)  title("Model") replace ///
				keep(llight tpllight treat_post  tplinform tpllightlinform linform llightlinform )  ///
				addtext(City FE, YES, Year FE, YES)

	
	*2.增长压力

	reghdfe lgdp  tpllightpre llight tpllight tppre llightpre treat_post pressure  ///
		,a(citycode year) cluster(citycode)
		est store m1

	reghdfe lgdp tpllightpre llight tpllight tppre llightpre treat_post pressure $control ///
		,a(citycode year) cluster(citycode)
		est store m2

	outreg2 [m1 m2] using $tables\table5-2.xls,         ///
            stat(coef se) bdec(4)  title("Model") replace ///
            keep(llight tpllightpre tpllight treat_post  tppre  pressure llightpre) ///
			addtext(City FE, YES, Year FE, YES)
	
	
***********************# 附录III 表A2 稳健性检验 #***********************
					
	
	use $working_data\workdata.dta ,clear
		keep if  year<=2013 & year>=2000
		drop if  lgdp==. |treat_post==. |llight==.

		
	* 1.聚类到省份层面
	
	reghdfe lgdp tpllight llight treat_post tllight pllight  $control ///
	,a(citycode year) cluster(pro)
		
		est store m1
	
	outreg2 [m1] using $tables\附录IIItableA2.xls,                           ///
				stat(coef se) bdec(4)  title("Model") replace        ///
				keep(llight tpllight treat_post  tllight pllight  )  ///
				addtext(City FE, YES, Year FE, YES)
	
	
	* 2.采用DMSP和VIIRS整合后的长时间序列数据

	use $working_data\workdata.dta ,clear
		keep if  year<=2022 & year>=2000
   		drop if  lgdp==. |treat_post==. |llight==.           
	
	reghdfe lgdp tpllight2 llight2 treat_post tllight2 pllight2 $control  ///
	,a(citycode year) cluster(citycode)	
		est store m2
	
    outreg2 [m2] using $tables\附录IIItableA2.xls,       ///
				stat(coef se) bdec(4)  title("Model") append ///
				keep(llight2 tpllight2 treat_post  tllight2 pllight2  )  ///
				addtext(City FE, YES, Year FE, YES)
				
				
	
	use $working_data\workdata.dta ,clear
		keep if  year<=2013&year>=2000
		drop if  lgdp==. |treat_post==. |llight==.

	
	* 3.排除竞争性假说：省直管县

	reghdfe lgdp tpllight llight treat_post tllight pllight 全面省直管县_汇总到市  $control ///
	,a(citycode year) cluster(citycode)
		est store m3

	* 4.加入滞后项

	xtset citycode year
	reghdfe lgdp tpllight llight treat_post tllight pllight l.llight $control ///
		,a(citycode  year) cluster(citycode)
	est store m4
	
	* 5.加入高阶多项式

	reghdfe lgdp tpllight llight treat_post tllight pllight llight_sq  $control  ///
	,a(citycode  year) cluster(citycode)
		est store m5

	* 6.控制省委书记和省长年龄与任期特征

	reghdfe lgdp tpllight llight treat_post tllight pllight  age_省委书记 age_省长 tennu_省委书记 tennu_省长  $control  ///
	,a(citycode year) cluster(citycode)
		est store m6

	outreg2 [ m3 m4 m5 m6] using $tables\附录IIItableA2.xls,       ///
				stat(coef se) bdec(4)  title("Model") append ///
				keep(llight tpllight treat_post  tllight pllight 全面省直管县_汇总到市 ///
				l.llight llight_sq age_省委书记 age_省长 tennu_省委书记 tennu_省长 ///
				llight2 tpllight2 treat_post  tllight2 pllight2)  ///
				addtext(City FE, YES, Year FE, YES)

	
	

