

/*******************************************************************************
*
*	Statistical Management System and Statistical Data Quality
*
*******************************************************************************/	

	
	clear all                 //Remove everything from the memory, refresh.
    cap log close             //Close any open log file.
    set more off              //Show the result all at once.
    set rmsg on

	gl root=" C:\Users\lenovo\Desktop\2024-00207_数据"         //设定工作路径
	cd $root
	
	gl dofiles="$root\2024-00207_程序代码"
	gl working_data="$root\2024-00207_使用数据"
	gl tables="$root\2024-00207_日志文件"
    gl control="c.lpopu_ind2000#i.year c.指数2000#i.year   c.urban2000#i.year  c.lhaiba2000#i.year c.labor_ra2000#i.year "
	
	
***********************# 图2 #***********************
	
	use $working_data\workdata.dta ,clear
		
		keep if  year<=2013 & year>=2000
		drop if lgdp==. |llight==.|treat_post==.
	
	binscatter lgdp llight if treat==0 ,by(post)
    graph save "Graph" $tables\图2_a.gph,replace 

	use $working_data\workdata.dta ,clear
		
		keep if  year<=2013 & year>=2000
		drop if lgdp==. |llight==.|treat_post==.
	
	binscatter lgdp llight if treat==1 ,by(post)
    graph save "Graph" $tables\图2_b.gph,replace 
	


***********************# 图3 #***********************
		
	/****** 图3(a) ******/	
	
	use $working_data\workdata.dta ,clear
		
		keep if  year<=2013 & year>=2000
		drop if lgdp==. |llight==.|treat_post==.

	gl PRE="  pre_6 pre_5 pre_4 pre_3 pre_2 "      								//Treat*D*ln(lights)
	gl POST=" current post_1 post_2 post_3 post_4 post_5 post_6 post_7 "   		//Treat*D*ln(lights)


	reghdfe  lgdp  $PRE $POST  llight treat_post tllight pllight  ,a(citycode year) cluster(citycode)

	* 获得回归系数和标准误 
	g se = .
	g coef = .
	levelsof time, l(times)
	forvalue t=1/7 {
		replace coef = _b[post_`t'] if time == `t'
		replace se = _se[post_`t'] if time == `t'
		}
	forvalue t = 2/6{
		replace coef = _b[pre_`t'] if time ==- `t'
		replace se = _se[pre_`t'] if time == -`t'
		}
	
	replace coef = 0 if time ==-1
	replace se =0 if time == -1
	replace coef = _b[current] if time ==0
	replace se = _se[current] if time == 0
	
	* 构建置信区间
	g ci_top = coef+1.96*se
	g ci_bottom = coef - 1.96*se
	
	* 根据time_to_treat把重复了的剔除掉
	keep time coef se ci_*
	duplicates drop
	sort time
	
	* 创建连接的系数散点图，使用 rcap 中包含的 CI和水平和垂直方向为0的线
	summ ci_top
	local top_range = r(max)
	summ ci_bottom
	local bottom_range = r(min)
	keep if time<=7
	keep if time>=-6
	twoway (sc coef time, connect(line) ,  ///           
		ylabel(-0.5(0.2)0.3) xlabel(-6(1)7 )  )  ///   
		(rcap ci_top ci_bottom time)	///
		(function y = 0, range(time)) ///
		(function y = -1, range(-0.5 0.3) lpattern(dash) horiz) , ///
		xtitle("政策实施相对时间") caption("95% Confidence Intervals Shown")
	graph save "Graph" $tables\图3_a.gph,replace 
	

	/****** 图3(b) ******/	
	
		use $working_data\workdata.dta ,clear
		
		keep if  year<=2013 & year>=2000
		drop if lgdp==. |llight==.|treat_post==.

	gl PRE="  pre_6 pre_5 pre_4 pre_3 pre_2 "      								//Treat*D*ln(lights)
	gl POST=" current post_1 post_2 post_3 post_4 post_5 post_6 post_7 "   		//Treat*D*ln(lights)

	
	reghdfe  lgdp  $PRE $POST  llight treat_post tllight pllight $control ,a(citycode year) cluster(citycode)

	* 获得回归系数和标准误 
	g se = .
	g coef = .
	levelsof time, l(times)
	forvalue t=1/7 {
		replace coef = _b[post_`t'] if time == `t'
		replace se = _se[post_`t'] if time == `t'
		}
	forvalue t = 2/6{
		replace coef = _b[pre_`t'] if time ==- `t'
		replace se = _se[pre_`t'] if time == -`t'
		}
	
	replace coef = 0 if time ==-1
	replace se =0 if time == -1
	replace coef = _b[current] if time ==0
	replace se = _se[current] if time == 0
	
	* 构建置信区间
	g ci_top = coef+1.96*se
	g ci_bottom = coef - 1.96*se
	
	* 根据time_to_treat把重复了的剔除掉
	keep time coef se ci_*
	duplicates drop
	sort time
	
	* 创建连接的系数散点图，使用 rcap 中包含的 CI和水平和垂直方向为0的线
	summ ci_top
	local top_range = r(max)
	summ ci_bottom
	local bottom_range = r(min)
	keep if time<=7
	keep if time>=-6
	twoway (sc coef time, connect(line) ,  ///           
		ylabel(-0.5(0.2)0.3) xlabel(-6(1)7 )  )  ///   
		(rcap ci_top ci_bottom time)	///
		(function y = 0, range(time)) ///
		(function y = -1, range(-0.5 0.3) lpattern(dash) horiz) , ///
		xtitle("政策实施相对时间") caption("95% Confidence Intervals Shown")
	
	graph save "Graph" $tables\图3_b.gph,replace 

	/****** 附录II 图A1 ******/	
		
	
	clear
	cd $working_data
	gen b=.
	gen se=.
	gen T=.
	save boost,replace 
	forvalues i=1(1)500 {
	use 安慰剂检验.dta,clear
	keep citycode year
	xtset citycode  year
	bysort citycode: keep if year == 2006
	sample 8, count
	keep citycode
	save temp,replace
	use 安慰剂检验.dta,clear
	merge m:1 citycode using temp
	drop treat   tllight  tpllight treat_post
	gen treat=(_merge==3)
	gen treat_post=treat*post
	gen tllight=treat*llight
	gen tpllight=treat_post * llight
	reghdfe lrgdp llight tpllight treat_post  tllight pllight,a(citycode year) cluster(citycode)
	gen b=_b[tpllight]    
	gen se=_se[tpllight] 
	keep b se
	gen T=b/se
	duplicates drop  b,force    
	save boosttime,replace  
	use boost , clear
	append using boosttime   
	save boost ,replace 
		
	}
	dpplot b ,xline(-0.3053)  xlabel(-0.4(0.1)0.4, grid) xtitle("回归系数") ytitle("概率密度")
		
	graph save "Graph" $tables\附录II_图A1_安慰剂检验.gph,replace 
