*-------------------------------------------------------------------------------
* 教育公平与人力资本积累——基于高考招生专项计划的实证研究
* Authors：张 庆  宋 弘  罗吉罡 
* Data folders: $data
* Purpose: 实证分析
* Version: June, 2024
*-------------------------------------------------------------------------------


****准备工作

set more off
clear all
set matsize 8000
set maxvar  32767
capture log close


**# 定义全局变量

*--定义工作路径

global workpath "E:\高校专项计划"
global data "$workpath\data"
global result "$workpath\result"
global code "$workpath\code"
global log "$workpath\log"
global rawdata "$workpath\rawdata"


log using "$log\2023-01178-reg",replace

*-- 定义回归变量

global depvar1 "if_cohort1"
global depvar2 "if_cohort2"
global depvar3 "if_post1"
global depvar4 "if_post2"

global i_controls "gender ethnicity_han familysize feduc_ifhighsch meduc_ifhighsch feduc_ifcol meduc_ifcol"

global i_controls2 "age gender ethnicity_han familysize feduc_ifhighsch meduc_ifhighsch feduc_ifcol meduc_ifcol fincome2"

global fe1 "birthy countyid"
global fe2 "birthy countyid i.provcd#c.corhort_t"
global fe3 "year countyid"
global fe4 "year countyid i.provcd#c.t"

global cluster2 "county_cohort"
global cluster3 "county_year"

glo event1 "pre_6 pre_5 pre_4 pre_3 pre_2  post_0 post_1 post_2 post_3 post_4 post_5 post_66"
glo event2 "pre2_6 pre2_5 pre2_4 pre2_3 pre2_2 post2_0 post2_1 post2_2 post2_3 post2_4 post2_5 post2_66"

global poverty "i.povertycounty#i.if_cohort1"
global other "if_free if_cal"


cd "$data"


**# 表 2 专项计划对人力资本水平的影响

capture program drop baseline_2020

program baseline_2020

use cfps_sample_2020_new,clear


**# -1.baseline-国家专项


	eststo clear
	local num = 1
	
foreach var of varlist eduy_im high_if collage_if {

	reghdfe `var' $depvar1, absorb($fe1) cluster($cluster2)
	
		eststo baseline_`x'_`num'  		
		estadd local cohort_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local prov_cohorttrend 	"No"	
		estadd local ind_control 		"No"	
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num
	
	reghdfe `var' $depvar1 , absorb($fe2) cluster($cluster2)
			
		eststo baseline_`x'_`num'  		
		estadd local cohort_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local prov_cohorttrend 	"Yes"	
		estadd local ind_control 		"No"	
		
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num
	
	reghdfe `var' $depvar1  $i_controls, absorb($fe2) cluster($cluster2)
	
		eststo baseline_`x'_`num'  		
		estadd local cohort_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local prov_cohorttrend 	"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num

		esttab baseline_* , append nogaps keep($depvar1) b(%9.3f) se(%9.3f) stats(cohort_fe  county_fe prov_cohorttrend ind_control  N r_2 , fmt(%9.3f %9.3f %9.3f %9.3f %9.0fc %9.3f ) labels("Cohort FEs" "County FEs" "Province-cohort trend" "Individual controls" "N" " R^2 " )) star(* 0.1 ** 0.05 *** 0.01) 
}



**# -2.baseline -地区专项

	eststo clear
	local num = 1
	
foreach var of varlist eduy_im high_if collage_if{

	 reghdfe `var' $depvar2, absorb($fe1) cluster($cluster2)

		eststo baseline_`x'_`num'  		
		estadd local cohort_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local prov_cohorttrend 	"No"	
		estadd local ind_control 		"No"	
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num
	
	 reghdfe `var' $depvar2 , absorb($fe2) cluster($cluster2)
		
		eststo baseline_`x'_`num'  		
		estadd local cohort_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local prov_cohorttrend 	"Yes"	
		estadd local ind_control 		"No"	
		
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num
	
	 reghdfe `var' $depvar2  $i_controls , absorb($fe2) cluster($cluster2)
	
		eststo baseline_`x'_`num'  		
		estadd local cohort_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local prov_cohorttrend 	"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num

		
		esttab baseline_* , append nogaps keep($depvar2) b(%9.3f) se(%9.3f) stats(cohort_fe  county_fe prov_cohorttrend ind_control  N r_2 , fmt(%9.3f %9.3f %9.3f %9.3f %9.0fc %9.3f ) labels("Cohort FEs" "County FEs" "Province-cohort trend" "Individual controls" "N" " R^2 " )) star(* 0.1 ** 0.05 *** 0.01)
		
}

end

baseline_2020


**# 图1 平行趋势检验

capture program drop parallel_2020

program parallel_2020

use cfps_sample_2020_new,replace


#delimit ;
	cap drop beta ;	cap drop ub; cap drop lb; cap drop y; cap drop variable;
	gen beta=. ; gen ub=. ; gen lb=. ; gen y=. ; gen variable="";
#delimit cr

**# eduy_1


reghdfe eduy_im $event1 $i_controls , absorb($fe2) cluster($cluster2)	


    replace beta=_b[pre_6] in 2
	replace   ub=_b[pre_6]+invttail(e(df_r),0.05)*_se[pre_6] in 2
	replace   lb=_b[pre_6]-invttail(e(df_r),0.05)*_se[pre_6] in 2
	replace y= -6 in 2
	
	replace beta=_b[pre_5] in 3
	replace   ub=_b[pre_5]+invttail(e(df_r),0.05)*_se[pre_5] in 3
	replace   lb=_b[pre_5]-invttail(e(df_r),0.05)*_se[pre_5] in 3
	replace y=-5 in 3
	
	replace beta=_b[pre_4] in 4
	replace   ub=_b[pre_4]+invttail(e(df_r),0.05)*_se[pre_4] in 4
	replace   lb=_b[pre_4]-invttail(e(df_r),0.05)*_se[pre_4] in 4
	replace y=-4 in 4
	
	replace beta=_b[pre_3] in 5
	replace   ub=_b[pre_3]+invttail(e(df_r),0.05)*_se[pre_3] in 5
	replace   lb=_b[pre_3]-invttail(e(df_r),0.05)*_se[pre_3] in 5
	replace y=-3 in 5
	
		replace beta=_b[pre_2] in 6
	replace   ub=_b[pre_2]+invttail(e(df_r),0.05)*_se[pre_2] in 6
	replace   lb=_b[pre_2]-invttail(e(df_r),0.05)*_se[pre_2] in 6
	replace y=-2 in 6
	
	replace beta=0 in 7
	replace   ub=0 in 7
	replace   lb=0 in 7
	replace y=-1 in 7
	
	
	replace beta=_b[post_0] in 8
	replace   ub=_b[post_0]+invttail(e(df_r),0.05)*_se[post_0] in 8
	replace   lb=_b[post_0]-invttail(e(df_r),0.05)*_se[post_0] in 8
	replace y=0 in 8
	
	replace beta=_b[post_1] in 9
	replace   ub=_b[post_1]+invttail(e(df_r),0.05)*_se[post_1] in 9
	replace   lb=_b[post_1]-invttail(e(df_r),0.05)*_se[post_1] in 9
	replace y=1 in 9	
	
	replace beta=_b[post_2] in 10
	replace   ub=_b[post_2]+invttail(e(df_r),0.05)*_se[post_2] in 10
	replace   lb=_b[post_2]-invttail(e(df_r),0.05)*_se[post_2] in 10
	replace y=2 in 10	
	
		replace beta=_b[post_3] in 11
	replace   ub=_b[post_3]+invttail(e(df_r),0.05)*_se[post_3] in 11
	replace   lb=_b[post_3]-invttail(e(df_r),0.05)*_se[post_3] in 11
	replace y=3 in 11	
	
		replace beta=_b[post_4] in 12
	replace   ub=_b[post_4]+invttail(e(df_r),0.05)*_se[post_4] in 12
	replace   lb=_b[post_4]-invttail(e(df_r),0.05)*_se[post_4] in 12
	replace y=4 in 12	
	
		replace beta=_b[post_5] in 13
	replace   ub=_b[post_5]+invttail(e(df_r),0.05)*_se[post_5] in 13
	replace   lb=_b[post_5]-invttail(e(df_r),0.05)*_se[post_5] in 13
	replace y=5 in 13	
	
		replace beta=_b[post_66] in 14
	replace   ub=_b[post_66]+invttail(e(df_r),0.05)*_se[post_66] in 14
	replace   lb=_b[post_66]-invttail(e(df_r),0.05)*_se[post_66] in 14
	replace y=6 in 14	

	replace variable="Years of Education" in 2/14
	
	cap label drop y_l
	label define y_l -6 "-6" -5 "-5" -4 "-4"-3 "-3"	-2 "-2"	-1 "-1" 0 "0" 1 "1" 2 "2" 3 "3" 4 "4" 5 "5"  6 ">=6"
	label values y y_l

twoway (rspike ub lb y if variable=="Years of Education", lc(black) lp(solid) lw(thin) ) ///
		(connect beta y if variable=="Years of Education", msize(small) mc(black) lc(black) lp(solid) lw(thin)), ///
		scheme(s1mono)  yline(0, lc(gs10) lp(dash) lw(thin)) xline(-1, lc(gs10) lp(dash) lw(thin)) ///
		title("Panel A. 受教育年限-国家专项") xlabel(-6(1)6, valuelabel) xtitle("相对时间")    legend(off) 
		
	
graph save "$result\ES1_1.gph",replace
graph export "$result\ES1_1.png",replace

 
**# eduy_2

#delimit ;
	cap drop beta ;	cap drop ub; cap drop lb; cap drop y; cap drop variable;
	gen beta=. ; gen ub=. ; gen lb=. ; gen y=. ; gen variable="";
#delimit cr


reghdfe eduy_im $event2 $i_controls  , absorb($fe2) cluster($cluster2)	


    replace beta=_b[pre2_6] in 2
	replace   ub=_b[pre2_6]+invttail(e(df_r),0.05)*_se[pre2_6] in 2
	replace   lb=_b[pre2_6]-invttail(e(df_r),0.05)*_se[pre2_6] in 2
	replace y= -6 in 2
	
	replace beta=_b[pre2_5] in 3
	replace   ub=_b[pre2_5]+invttail(e(df_r),0.05)*_se[pre2_5] in 3
	replace   lb=_b[pre2_5]-invttail(e(df_r),0.05)*_se[pre2_5] in 3
	replace y=-5 in 3
	
	replace beta=_b[pre2_4] in 4
	replace   ub=_b[pre2_4]+invttail(e(df_r),0.05)*_se[pre2_4] in 4
	replace   lb=_b[pre2_4]-invttail(e(df_r),0.05)*_se[pre2_4] in 4
	replace y=-4 in 4
	
	replace beta=_b[pre2_3] in 5
	replace   ub=_b[pre2_3]+invttail(e(df_r),0.05)*_se[pre2_3] in 5
	replace   lb=_b[pre2_3]-invttail(e(df_r),0.05)*_se[pre2_3] in 5
	replace y=-3 in 5
	
		replace beta=_b[pre2_2] in 6
	replace   ub=_b[pre2_2]+invttail(e(df_r),0.05)*_se[pre2_2] in 6
	replace   lb=_b[pre2_2]-invttail(e(df_r),0.05)*_se[pre2_2] in 6
	replace y=-2 in 6
	
	replace beta=0 in 7
	replace   ub=0 in 7
	replace   lb=0 in 7
	replace y=-1 in 7
	
	
	replace beta=_b[post2_0] in 8
	replace   ub=_b[post2_0]+invttail(e(df_r),0.05)*_se[post2_0] in 8
	replace   lb=_b[post2_0]-invttail(e(df_r),0.05)*_se[post2_0] in 8
	replace y=0 in 8
	
	replace beta=_b[post2_1] in 9
	replace   ub=_b[post2_1]+invttail(e(df_r),0.05)*_se[post2_1] in 9
	replace   lb=_b[post2_1]-invttail(e(df_r),0.05)*_se[post2_1] in 9
	replace y=1 in 9	
	
	replace beta=_b[post2_2] in 10
	replace   ub=_b[post2_2]+invttail(e(df_r),0.05)*_se[post2_2] in 10
	replace   lb=_b[post2_2]-invttail(e(df_r),0.05)*_se[post2_2] in 10
	replace y=2 in 10	
	
		replace beta=_b[post2_3] in 11
	replace   ub=_b[post2_3]+invttail(e(df_r),0.05)*_se[post2_3] in 11
	replace   lb=_b[post2_3]-invttail(e(df_r),0.05)*_se[post2_3] in 11
	replace y=3 in 11	
	
		replace beta=_b[post2_4] in 12
	replace   ub=_b[post2_4]+invttail(e(df_r),0.05)*_se[post2_4] in 12
	replace   lb=_b[post2_4]-invttail(e(df_r),0.05)*_se[post2_4] in 12
	replace y=4 in 12	
	
		replace beta=_b[post2_5] in 13
	replace   ub=_b[post2_5]+invttail(e(df_r),0.05)*_se[post2_5] in 13
	replace   lb=_b[post2_5]-invttail(e(df_r),0.05)*_se[post2_5] in 13
	replace y=5 in 13	
	
		replace beta=_b[post2_66] in 14
	replace   ub=_b[post2_66]+invttail(e(df_r),0.05)*_se[post2_66] in 14
	replace   lb=_b[post2_66]-invttail(e(df_r),0.05)*_se[post2_66] in 14
	replace y=6 in 14	

	replace variable="Years of Education" in 2/14
	
	cap label drop y_l
	label define y_l -6 "-6" -5 "-5" -4 "-4"-3 "-3"	-2 "-2"	-1 "-1" 0 "0" 1 "1" 2 "2" 3 "3" 4 "4" 5 "5"  6 ">=6"
	label values y y_l

twoway (rspike ub lb y if variable=="Years of Education", lc(black) lp(solid) lw(thin) ) ///
		(connect beta y if variable=="Years of Education", msize(small) mc(black) lc(black) lp(solid) lw(thin)), ///
		scheme(s1mono)  yline(0, lc(gs10) lp(dash) lw(thin)) xline(-1, lc(gs10) lp(dash) lw(thin)) ///
		title("Panel B. 受教育年限-三大专项") xlabel(-6(1)6, valuelabel) xtitle("相对时间")    legend(off) 
		
graph save "$result\ES1_2.gph",replace
graph export "$result\ES1_2.png",replace

#delimit ;
	cap drop beta ;	cap drop ub; cap drop lb; cap drop y; cap drop variable;
	gen beta=. ; gen ub=. ; gen lb=. ; gen y=. ; gen variable="";
#delimit cr



**# high_1


reghdfe high_if $event1 $i_controls , absorb($fe2) cluster($cluster2)	


    replace beta=_b[pre_6] in 2
	replace   ub=_b[pre_6]+invttail(e(df_r),0.05)*_se[pre_6] in 2
	replace   lb=_b[pre_6]-invttail(e(df_r),0.05)*_se[pre_6] in 2
	replace y= -6 in 2
	
	replace beta=_b[pre_5] in 3
	replace   ub=_b[pre_5]+invttail(e(df_r),0.05)*_se[pre_5] in 3
	replace   lb=_b[pre_5]-invttail(e(df_r),0.05)*_se[pre_5] in 3
	replace y=-5 in 3
	
	replace beta=_b[pre_4] in 4
	replace   ub=_b[pre_4]+invttail(e(df_r),0.05)*_se[pre_4] in 4
	replace   lb=_b[pre_4]-invttail(e(df_r),0.05)*_se[pre_4] in 4
	replace y=-4 in 4
	
	replace beta=_b[pre_3] in 5
	replace   ub=_b[pre_3]+invttail(e(df_r),0.05)*_se[pre_3] in 5
	replace   lb=_b[pre_3]-invttail(e(df_r),0.05)*_se[pre_3] in 5
	replace y=-3 in 5
	
		replace beta=_b[pre_2] in 6
	replace   ub=_b[pre_2]+invttail(e(df_r),0.05)*_se[pre_2] in 6
	replace   lb=_b[pre_2]-invttail(e(df_r),0.05)*_se[pre_2] in 6
	replace y=-2 in 6
	
	replace beta=0 in 7
	replace   ub=0 in 7
	replace   lb=0 in 7
	replace y=-1 in 7
	
	
	replace beta=_b[post_0] in 8
	replace   ub=_b[post_0]+invttail(e(df_r),0.05)*_se[post_0] in 8
	replace   lb=_b[post_0]-invttail(e(df_r),0.05)*_se[post_0] in 8
	replace y=0 in 8
	
	replace beta=_b[post_1] in 9
	replace   ub=_b[post_1]+invttail(e(df_r),0.05)*_se[post_1] in 9
	replace   lb=_b[post_1]-invttail(e(df_r),0.05)*_se[post_1] in 9
	replace y=1 in 9	
	
	replace beta=_b[post_2] in 10
	replace   ub=_b[post_2]+invttail(e(df_r),0.05)*_se[post_2] in 10
	replace   lb=_b[post_2]-invttail(e(df_r),0.05)*_se[post_2] in 10
	replace y=2 in 10	
	
		replace beta=_b[post_3] in 11
	replace   ub=_b[post_3]+invttail(e(df_r),0.05)*_se[post_3] in 11
	replace   lb=_b[post_3]-invttail(e(df_r),0.05)*_se[post_3] in 11
	replace y=3 in 11	
	
		replace beta=_b[post_4] in 12
	replace   ub=_b[post_4]+invttail(e(df_r),0.05)*_se[post_4] in 12
	replace   lb=_b[post_4]-invttail(e(df_r),0.05)*_se[post_4] in 12
	replace y=4 in 12	
	
		replace beta=_b[post_5] in 13
	replace   ub=_b[post_5]+invttail(e(df_r),0.05)*_se[post_5] in 13
	replace   lb=_b[post_5]-invttail(e(df_r),0.05)*_se[post_5] in 13
	replace y=5 in 13	
	
		replace beta=_b[post_66] in 14
	replace   ub=_b[post_66]+invttail(e(df_r),0.05)*_se[post_66] in 14
	replace   lb=_b[post_66]-invttail(e(df_r),0.05)*_se[post_66] in 14
	replace y=6 in 14	

	replace variable="Years of Education" in 2/14
	
	cap label drop y_l
	label define y_l -6 "-6" -5 "-5" -4 "-4"-3 "-3"	-2 "-2"	-1 "-1" 0 "0" 1 "1" 2 "2" 3 "3" 4 "4" 5 "5"  6 ">=6"
	label values y y_l

twoway (rspike ub lb y if variable=="Years of Education", lc(black) lp(solid) lw(thin) ) ///
		(connect beta y if variable=="Years of Education", msize(small) mc(black) lc(black) lp(solid) lw(thin)), ///
		scheme(s1mono)  yline(0, lc(gs10) lp(dash) lw(thin)) xline(-1, lc(gs10) lp(dash) lw(thin)) ///
		title("Panel C. 高中教育-国家专项") xlabel(-6(1)6, valuelabel) xtitle("相对时间")    legend(off) 
		
	
graph save "$result\ES3_1.gph",replace
graph export "$result\ES3_1.png",replace

 
**# high_2

#delimit ;
	cap drop beta ;	cap drop ub; cap drop lb; cap drop y; cap drop variable;
	gen beta=. ; gen ub=. ; gen lb=. ; gen y=. ; gen variable="";
#delimit cr


reghdfe high_if $event2 $i_controls , absorb($fe2) cluster($cluster2)	


    replace beta=_b[pre2_6] in 2
	replace   ub=_b[pre2_6]+invttail(e(df_r),0.05)*_se[pre2_6] in 2
	replace   lb=_b[pre2_6]-invttail(e(df_r),0.05)*_se[pre2_6] in 2
	replace y= -6 in 2
	
	replace beta=_b[pre2_5] in 3
	replace   ub=_b[pre2_5]+invttail(e(df_r),0.05)*_se[pre2_5] in 3
	replace   lb=_b[pre2_5]-invttail(e(df_r),0.05)*_se[pre2_5] in 3
	replace y=-5 in 3
	
	replace beta=_b[pre2_4] in 4
	replace   ub=_b[pre2_4]+invttail(e(df_r),0.05)*_se[pre2_4] in 4
	replace   lb=_b[pre2_4]-invttail(e(df_r),0.05)*_se[pre2_4] in 4
	replace y=-4 in 4
	
	replace beta=_b[pre2_3] in 5
	replace   ub=_b[pre2_3]+invttail(e(df_r),0.05)*_se[pre2_3] in 5
	replace   lb=_b[pre2_3]-invttail(e(df_r),0.05)*_se[pre2_3] in 5
	replace y=-3 in 5
	
		replace beta=_b[pre2_2] in 6
	replace   ub=_b[pre2_2]+invttail(e(df_r),0.05)*_se[pre2_2] in 6
	replace   lb=_b[pre2_2]-invttail(e(df_r),0.05)*_se[pre2_2] in 6
	replace y=-2 in 6
	
	replace beta=0 in 7
	replace   ub=0 in 7
	replace   lb=0 in 7
	replace y=-1 in 7
	
	
	replace beta=_b[post2_0] in 8
	replace   ub=_b[post2_0]+invttail(e(df_r),0.05)*_se[post2_0] in 8
	replace   lb=_b[post2_0]-invttail(e(df_r),0.05)*_se[post2_0] in 8
	replace y=0 in 8
	
	replace beta=_b[post2_1] in 9
	replace   ub=_b[post2_1]+invttail(e(df_r),0.05)*_se[post2_1] in 9
	replace   lb=_b[post2_1]-invttail(e(df_r),0.05)*_se[post2_1] in 9
	replace y=1 in 9	
	
	replace beta=_b[post2_2] in 10
	replace   ub=_b[post2_2]+invttail(e(df_r),0.05)*_se[post2_2] in 10
	replace   lb=_b[post2_2]-invttail(e(df_r),0.05)*_se[post2_2] in 10
	replace y=2 in 10	
	
		replace beta=_b[post2_3] in 11
	replace   ub=_b[post2_3]+invttail(e(df_r),0.05)*_se[post2_3] in 11
	replace   lb=_b[post2_3]-invttail(e(df_r),0.05)*_se[post2_3] in 11
	replace y=3 in 11	
	
		replace beta=_b[post2_4] in 12
	replace   ub=_b[post2_4]+invttail(e(df_r),0.05)*_se[post2_4] in 12
	replace   lb=_b[post2_4]-invttail(e(df_r),0.05)*_se[post2_4] in 12
	replace y=4 in 12	
	
		replace beta=_b[post2_5] in 13
	replace   ub=_b[post2_5]+invttail(e(df_r),0.05)*_se[post2_5] in 13
	replace   lb=_b[post2_5]-invttail(e(df_r),0.05)*_se[post2_5] in 13
	replace y=5 in 13	
	
		replace beta=_b[post2_66] in 14
	replace   ub=_b[post2_66]+invttail(e(df_r),0.05)*_se[post2_66] in 14
	replace   lb=_b[post2_66]-invttail(e(df_r),0.05)*_se[post2_66] in 14
	replace y=6 in 14	

	replace variable="Years of Education" in 2/14
	
	cap label drop y_l
	label define y_l -6 "-6" -5 "-5" -4 "-4"-3 "-3"	-2 "-2"	-1 "-1" 0 "0" 1 "1" 2 "2" 3 "3" 4 "4" 5 "5"  6 ">=6"
	label values y y_l

twoway (rspike ub lb y if variable=="Years of Education", lc(black) lp(solid) lw(thin) ) ///
		(connect beta y if variable=="Years of Education", msize(small) mc(black) lc(black) lp(solid) lw(thin)), ///
		scheme(s1mono)  yline(0, lc(gs10) lp(dash) lw(thin)) xline(-1, lc(gs10) lp(dash) lw(thin)) ///
		title("Panel D. 高中教育-三大专项") xlabel(-6(1)6, valuelabel) xtitle("相对时间")    legend(off) 
		
graph save "$result\ES3_2.gph",replace
graph export "$result\ES3_2.png",replace


**# collage_1
#delimit ;
	cap drop beta ;	cap drop ub; cap drop lb; cap drop y; cap drop variable;
	gen beta=. ; gen ub=. ; gen lb=. ; gen y=. ; gen variable="";
#delimit cr


reghdfe collage_if $event1 $i_controls , absorb($fe2) cluster($cluster2)	


    replace beta=_b[pre_6] in 2
	replace   ub=_b[pre_6]+invttail(e(df_r),0.05)*_se[pre_6] in 2
	replace   lb=_b[pre_6]-invttail(e(df_r),0.05)*_se[pre_6] in 2
	replace y= -6 in 2
	
	replace beta=_b[pre_5] in 3
	replace   ub=_b[pre_5]+invttail(e(df_r),0.05)*_se[pre_5] in 3
	replace   lb=_b[pre_5]-invttail(e(df_r),0.05)*_se[pre_5] in 3
	replace y=-5 in 3
	
	replace beta=_b[pre_4] in 4
	replace   ub=_b[pre_4]+invttail(e(df_r),0.05)*_se[pre_4] in 4
	replace   lb=_b[pre_4]-invttail(e(df_r),0.05)*_se[pre_4] in 4
	replace y=-4 in 4
	
	replace beta=_b[pre_3] in 5
	replace   ub=_b[pre_3]+invttail(e(df_r),0.05)*_se[pre_3] in 5
	replace   lb=_b[pre_3]-invttail(e(df_r),0.05)*_se[pre_3] in 5
	replace y=-3 in 5
	
		replace beta=_b[pre_2] in 6
	replace   ub=_b[pre_2]+invttail(e(df_r),0.05)*_se[pre_2] in 6
	replace   lb=_b[pre_2]-invttail(e(df_r),0.05)*_se[pre_2] in 6
	replace y=-2 in 6
	
	replace beta=0 in 7
	replace   ub=0 in 7
	replace   lb=0 in 7
	replace y=-1 in 7
	
	
	replace beta=_b[post_0] in 8
	replace   ub=_b[post_0]+invttail(e(df_r),0.05)*_se[post_0] in 8
	replace   lb=_b[post_0]-invttail(e(df_r),0.05)*_se[post_0] in 8
	replace y=0 in 8
	
	replace beta=_b[post_1] in 9
	replace   ub=_b[post_1]+invttail(e(df_r),0.05)*_se[post_1] in 9
	replace   lb=_b[post_1]-invttail(e(df_r),0.05)*_se[post_1] in 9
	replace y=1 in 9	
	
	replace beta=_b[post_2] in 10
	replace   ub=_b[post_2]+invttail(e(df_r),0.05)*_se[post_2] in 10
	replace   lb=_b[post_2]-invttail(e(df_r),0.05)*_se[post_2] in 10
	replace y=2 in 10	
	
		replace beta=_b[post_3] in 11
	replace   ub=_b[post_3]+invttail(e(df_r),0.05)*_se[post_3] in 11
	replace   lb=_b[post_3]-invttail(e(df_r),0.05)*_se[post_3] in 11
	replace y=3 in 11	
	
		replace beta=_b[post_4] in 12
	replace   ub=_b[post_4]+invttail(e(df_r),0.05)*_se[post_4] in 12
	replace   lb=_b[post_4]-invttail(e(df_r),0.05)*_se[post_4] in 12
	replace y=4 in 12	
	
		replace beta=_b[post_5] in 13
	replace   ub=_b[post_5]+invttail(e(df_r),0.05)*_se[post_5] in 13
	replace   lb=_b[post_5]-invttail(e(df_r),0.05)*_se[post_5] in 13
	replace y=5 in 13	
	
		replace beta=_b[post_66] in 14
	replace   ub=_b[post_66]+invttail(e(df_r),0.05)*_se[post_66] in 14
	replace   lb=_b[post_66]-invttail(e(df_r),0.05)*_se[post_66] in 14
	replace y=6 in 14	

	replace variable="Years of Education" in 2/14
	
	cap label drop y_l
	label define y_l -6 "-6" -5 "-5" -4 "-4"-3 "-3"	-2 "-2"	-1 "-1" 0 "0" 1 "1" 2 "2" 3 "3" 4 "4" 5 "5"  6 ">=6"
	label values y y_l

twoway (rspike ub lb y if variable=="Years of Education", lc(black) lp(solid) lw(thin) ) ///
		(connect beta y if variable=="Years of Education", msize(small) mc(black) lc(black) lp(solid) lw(thin)), ///
		scheme(s1mono)  yline(0, lc(gs10) lp(dash) lw(thin)) xline(-1, lc(gs10) lp(dash) lw(thin)) ///
		title("Panel E. 大学教育-国家专项") xlabel(-6(1)6, valuelabel) xtitle("相对时间")    legend(off) 
		
	
graph save "$result\ES4_1.gph",replace
graph export "$result\ES4_1.png",replace

 
**# collage_2

#delimit ;
	cap drop beta ;	cap drop ub; cap drop lb; cap drop y; cap drop variable;
	gen beta=. ; gen ub=. ; gen lb=. ; gen y=. ; gen variable="";
#delimit cr


reghdfe collage_if $event2 $i_controls , absorb($fe2) cluster($cluster2)	


    replace beta=_b[pre2_6] in 2
	replace   ub=_b[pre2_6]+invttail(e(df_r),0.05)*_se[pre2_6] in 2
	replace   lb=_b[pre2_6]-invttail(e(df_r),0.05)*_se[pre2_6] in 2
	replace y= -6 in 2
	
	replace beta=_b[pre2_5] in 3
	replace   ub=_b[pre2_5]+invttail(e(df_r),0.05)*_se[pre2_5] in 3
	replace   lb=_b[pre2_5]-invttail(e(df_r),0.05)*_se[pre2_5] in 3
	replace y=-5 in 3
	
	replace beta=_b[pre2_4] in 4
	replace   ub=_b[pre2_4]+invttail(e(df_r),0.05)*_se[pre2_4] in 4
	replace   lb=_b[pre2_4]-invttail(e(df_r),0.05)*_se[pre2_4] in 4
	replace y=-4 in 4
	
	replace beta=_b[pre2_3] in 5
	replace   ub=_b[pre2_3]+invttail(e(df_r),0.05)*_se[pre2_3] in 5
	replace   lb=_b[pre2_3]-invttail(e(df_r),0.05)*_se[pre2_3] in 5
	replace y=-3 in 5
	
		replace beta=_b[pre2_2] in 6
	replace   ub=_b[pre2_2]+invttail(e(df_r),0.05)*_se[pre2_2] in 6
	replace   lb=_b[pre2_2]-invttail(e(df_r),0.05)*_se[pre2_2] in 6
	replace y=-2 in 6
	
	replace beta=0 in 7
	replace   ub=0 in 7
	replace   lb=0 in 7
	replace y=-1 in 7
	
	
	replace beta=_b[post2_0] in 8
	replace   ub=_b[post2_0]+invttail(e(df_r),0.05)*_se[post2_0] in 8
	replace   lb=_b[post2_0]-invttail(e(df_r),0.05)*_se[post2_0] in 8
	replace y=0 in 8
	
	replace beta=_b[post2_1] in 9
	replace   ub=_b[post2_1]+invttail(e(df_r),0.05)*_se[post2_1] in 9
	replace   lb=_b[post2_1]-invttail(e(df_r),0.05)*_se[post2_1] in 9
	replace y=1 in 9	
	
	replace beta=_b[post2_2] in 10
	replace   ub=_b[post2_2]+invttail(e(df_r),0.05)*_se[post2_2] in 10
	replace   lb=_b[post2_2]-invttail(e(df_r),0.05)*_se[post2_2] in 10
	replace y=2 in 10	
	
		replace beta=_b[post2_3] in 11
	replace   ub=_b[post2_3]+invttail(e(df_r),0.05)*_se[post2_3] in 11
	replace   lb=_b[post2_3]-invttail(e(df_r),0.05)*_se[post2_3] in 11
	replace y=3 in 11	
	
		replace beta=_b[post2_4] in 12
	replace   ub=_b[post2_4]+invttail(e(df_r),0.05)*_se[post2_4] in 12
	replace   lb=_b[post2_4]-invttail(e(df_r),0.05)*_se[post2_4] in 12
	replace y=4 in 12	
	
		replace beta=_b[post2_5] in 13
	replace   ub=_b[post2_5]+invttail(e(df_r),0.05)*_se[post2_5] in 13
	replace   lb=_b[post2_5]-invttail(e(df_r),0.05)*_se[post2_5] in 13
	replace y=5 in 13	
	
		replace beta=_b[post2_66] in 14
	replace   ub=_b[post2_66]+invttail(e(df_r),0.05)*_se[post2_66] in 14
	replace   lb=_b[post2_66]-invttail(e(df_r),0.05)*_se[post2_66] in 14
	replace y=6 in 14	

	replace variable="Years of Education" in 2/14
	
	cap label drop y_l
	label define y_l -6 "-6" -5 "-5" -4 "-4"-3 "-3"	-2 "-2"	-1 "-1" 0 "0" 1 "1" 2 "2" 3 "3" 4 "4" 5 "5"  6 ">=6"
	label values y y_l

twoway (rspike ub lb y if variable=="Years of Education", lc(black) lp(solid) lw(thin) ) ///
		(connect beta y if variable=="Years of Education", msize(small) mc(black) lc(black) lp(solid) lw(thin)), ///
		scheme(s1mono)  yline(0, lc(gs10) lp(dash) lw(thin)) xline(-1, lc(gs10) lp(dash) lw(thin)) ///
	title("Panel F. 大学教育-三大专项") xlabel(-6(1)6, valuelabel) xtitle("相对时间")    legend(off) 
		
graph save "$result\ES4_2.gph",replace
graph export "$result\ES4_2.png",replace

graph combine  "$result\ES1_1.gph" "$result\ES1_2.gph"  "$result\ES3_1.gph" "$result\ES3_2.gph"  "$result\ES4_1.gph" "$result\ES4_2.gph", scheme(s1mono) cols(2)  altshrink 
	
graph save "$result\图1.gph",replace
graph export "$result\图1.png",replace



end

parallel_2020


**# 表 3 溢出效应

capture program drop spillover

program spillover

use cfps_urban_2020,replace
//利用城镇样本进行溢出效应分析

	capture drop province1 if_treat_p1 if_cohort_p1 province2 if_treat_p2 if_cohort_p2
	bys province: egen province1 = min(countryplan),missing
	gen if_cohort_p1=(birthy+18>=province1)
	gen if_treat_p1=if_treat1*if_cohort_p1

	bys province: egen province2 = min(allplan),missing
	gen if_cohort_p2=(birthy+18>=province2)
	gen if_treat_p2=if_treat2*if_cohort_p2

	glo spillover1 "if_treat_p1 if_cohort_p1"
	glo spillover2 "if_treat_p2 if_cohort_p2"

	eststo clear
	local num = 1
	
	reghdfe eduy_im $spillover1 $i_controls , absorb($fe2) cluster($cluster2)

		eststo baseline_`x'_`num'  		
		estadd local cohort_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local prov_cohorttrend 	"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num

		
	reghdfe high_if $spillover1 $i_controls , absorb($fe2) cluster($cluster2)

		eststo baseline_`x'_`num'  		
		estadd local cohort_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local prov_cohorttrend 	"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num
		
	reghdfe collage_if $spillover1 $i_controls , absorb($fe2) cluster($cluster2)

		eststo baseline_`x'_`num'  		
		estadd local cohort_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local prov_cohorttrend 	"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num
		
		
		
	reghdfe eduy_im $spillover2 $i_controls , absorb($fe2) cluster($cluster2)

		eststo baseline_`x'_`num'  		
		estadd local cohort_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local prov_cohorttrend 	"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num

	reghdfe high_if $spillover2 $i_controls , absorb($fe2) cluster($cluster2)

		eststo baseline_`x'_`num'  		
		estadd local cohort_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local prov_cohorttrend 	"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num
		
	reghdfe collage_if $spillover2 $i_controls , absorb($fe2) cluster($cluster2)

		eststo baseline_`x'_`num'  		
		estadd local cohort_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local prov_cohorttrend 	"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num
		
		esttab baseline_* , append nogaps keep($spillover1 $spillover2 ) b(%9.3f) se(%9.3f) stats(cohort_fe  county_fe prov_cohorttrend ind_control  N r_2 , fmt(%9.3f %9.3f %9.3f %9.3f %9.0fc %9.3f ) labels("Cohort FEs" "County FEs" "Province-cohort trend" "Individual controls" "N" " R^2 " )) star(* 0.1 ** 0.05 *** 0.01)
		
		

end


spillover

**# 表4 专项计划对儿童人力资本投资的影响

capture program drop invest_1020

program invest_1020

use cfps_child_1020,clear

	capture drop sample_if
	ppmlhdfe edufee $depvar3 $i_controls2 , absorb($fe3) cluster($cluster3)

	gen sample_if=e(sample)
	keep if sample_if==1

	eststo clear
	local num = 1
	

	ppmlhdfe edufee $depvar3 , absorb($fe3) cluster($cluster3)

		eststo baseline_`x'_`num'  		
		estadd local year_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local ind_control 		"No"			
		estadd ysumm		
		local ++num
		
	ppmlhdfe edufee $depvar3 $i_controls2 , absorb($fe3) cluster($cluster3)

		eststo baseline_`x'_`num'  		
		estadd local year_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		local ++num

	ppmlhdfe edufee $depvar4 , absorb($fe3) cluster($cluster3)

		eststo baseline_`x'_`num'  		
		estadd local year_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local ind_control 		"No"			
		estadd ysumm		
		local ++num

	ppmlhdfe edufee $depvar4 $i_controls2 , absorb($fe3) cluster($cluster3)

		eststo baseline_`x'_`num'  		
		estadd local year_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		local ++num
		
		esttab baseline_* , append nogaps keep($depvar3 $depvar4) b(%9.3f) se(%9.3f) stats(year_fe  county_fe ind_control  N  , fmt(%9.3f %9.3f %9.3f %9.0fc ) labels("Year FEs" "County FEs"  "Individual controls" "N"  )) star(* 0.1 ** 0.05 *** 0.01)		
		


end

invest_1020


**# 表5 家庭教育预期与教养环境

capture program drop expect_1020

program expect_1020

use cfps_child_1020,clear

	capture drop sample_if
	ppmlhdfe edufee $depvar3 $i_controls2 , absorb($fe3) cluster($cluster3)

	gen sample_if=e(sample)
	keep if sample_if==1

	eststo clear
	local num = 1
	
		
	reghdfe  expect_p_eduy $depvar3  $i_controls2  , absorb($fe3) cluster($cluster3)

		eststo baseline_`x'_`num'  		
		estadd local year_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num
		

	reghdfe  zee_expect_p_grade $depvar3  $i_controls2 , absorb($fe3) cluster($cluster3)

		eststo baseline_`x'_`num'  		
		estadd local year_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num
		

	reghdfe zee_studycare_fan_age $depvar3  $i_controls2  , absorb($fe3) cluster($cluster3)

		eststo baseline_`x'_`num'  		
		estadd local year_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num		

	reghdfe expect_self_eduy $depvar3  $i_controls2  , absorb($fe3) cluster($cluster3)

		eststo baseline_`x'_`num'  		
		estadd local year_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num
		
		reghdfe zee_child_respon_1_age $depvar3  $i_controls2, absorb($fe3) cluster($cluster3)

		eststo baseline_`x'_`num'  		
		estadd local year_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num
		
	reghdfe zee_child_respon_2_age $depvar3  $i_controls2, absorb($fe3) cluster($cluster3)
	
		eststo baseline_`x'_`num'  		
		estadd local year_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num
		
	reghdfe zee_child_respon_3_age $depvar3  $i_controls2, absorb($fe3) cluster($cluster3)

		eststo baseline_`x'_`num'  		
		estadd local year_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num
		

		esttab baseline_* , append nogaps keep($depvar3 ) b(%9.3f) se(%9.3f) stats(year_fe  county_fe ind_control  N  r_2, fmt(%9.3f  %9.3f  %9.3f %9.0fc %9.3f ) labels("Year FEs" "County FEs"  "Individual controls" "N" "R^2" )) star(* 0.1 ** 0.05 *** 0.01)	




end

expect_1020



**# 表6 进一步分析

capture program drop invest_edu

program invest_edu

use cfps_child_1020,clear

	capture drop sample_if
	ppmlhdfe edufee $depvar3 $i_controls2 , absorb($fe3) cluster($cluster3)

	gen sample_if=e(sample)
	keep if sample_if==1

	eststo clear
	local num = 1
	
	ppmlhdfe edufee $depvar3 $i_controls2 if feduc<3, absorb($fe3) cluster($cluster3)

		eststo baseline_`x'_`num'  		
		estadd local year_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		local ++num
		
	ppmlhdfe edufee $depvar3 $i_controls2 if feduc==3, absorb($fe3) cluster($cluster3)

		eststo baseline_`x'_`num'  		
		estadd local year_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		local ++num

	ppmlhdfe edufee $depvar3 $i_controls2 if feduc>=4 , absorb($fe3) cluster($cluster3)

		eststo baseline_`x'_`num'  		
		estadd local year_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		local ++num

		esttab baseline_* , append nogaps keep($depvar3) b(%9.3f) se(%9.3f) stats(year_fe  county_fe ind_control  N  , fmt(%9.3f %9.3f %9.3f %9.0fc ) labels("Year FEs" "County FEs"  "Individual controls" "N"  )) star(* 0.1 ** 0.05 *** 0.01)	




end

invest_edu



**# 表Ⅲ1 主要变量的描述性统计

capture program drop summary

program summary

use cfps_sample_2020_new,replace

	logout, save("$result\summary1") word replace: tabstat  eduy_im middle_if high_if collage_if $depvar1 $depvar2 $i_controls feduc meduc, stats(N mean sd  min max  )  c(stat)

use cfps_child_1020,replace

	ppmlhdfe edufee $depvar3 $i_controls2 , absorb($fe3) cluster($cluster3)
	keep if e(sample)==1

	logout, save("$result\summary2") word replace: tabstat  edufee studycare_fan expect_p_eduy expect_p_grade expect_self_eduy child_respon_1 child_respon_2 child_respon_3 $depvar3 $depvar4 $i_controls2 feduc meduc,  stats(N mean sd  min max )  c(stat)


end

summary



**# 图Ⅵ1 平行趋势检验-排除入学年龄和学制不同的影响


capture program drop parallel_r

program parallel_r

use cfps_sample_2020_new, replace

*-- 国家专项

preserve

	drop if pre_2==1
	drop if pre_1==1
	drop if post_0==1


#delimit ;
	cap drop beta ;	cap drop ub; cap drop lb; cap drop y; cap drop variable;
	gen beta=. ; gen ub=. ; gen lb=. ; gen y=. ; gen variable="";
#delimit cr


reghdfe eduy_im $event1 $i_controls  , absorb($fe2) cluster($cluster2)	

    replace beta=_b[pre_6] in 2
	replace   ub=_b[pre_6]+invttail(e(df_r),0.05)*_se[pre_6] in 2
	replace   lb=_b[pre_6]-invttail(e(df_r),0.05)*_se[pre_6] in 2
	replace y= -6 in 2
	
	replace beta=_b[pre_5] in 3
	replace   ub=_b[pre_5]+invttail(e(df_r),0.05)*_se[pre_5] in 3
	replace   lb=_b[pre_5]-invttail(e(df_r),0.05)*_se[pre_5] in 3
	replace y=-5 in 3
	
	replace beta=_b[pre_4] in 4
	replace   ub=_b[pre_4]+invttail(e(df_r),0.05)*_se[pre_4] in 4
	replace   lb=_b[pre_4]-invttail(e(df_r),0.05)*_se[pre_4] in 4
	replace y=-4 in 4
	
	replace beta=_b[pre_3] in 5
	replace   ub=_b[pre_3]+invttail(e(df_r),0.05)*_se[pre_3] in 5
	replace   lb=_b[pre_3]-invttail(e(df_r),0.05)*_se[pre_3] in 5
	replace y=-3 in 5
	
	replace beta=_b[pre_2] in 6
	replace   ub=_b[pre_2]+invttail(e(df_r),0.05)*_se[pre_2] in 6
	replace   lb=_b[pre_2]-invttail(e(df_r),0.05)*_se[pre_2] in 6
	replace y=-2 in 6
	
	replace beta=0 in 7
	replace   ub=0 in 7
	replace   lb=0 in 7
	replace y=-1 in 7
	
	
	replace beta=_b[post_0] in 8
	replace   ub=_b[post_0]+invttail(e(df_r),0.05)*_se[post_0] in 8
	replace   lb=_b[post_0]-invttail(e(df_r),0.05)*_se[post_0] in 8
	replace y=0 in 8
	
	replace beta=_b[post_1] in 9
	replace   ub=_b[post_1]+invttail(e(df_r),0.05)*_se[post_1] in 9
	replace   lb=_b[post_1]-invttail(e(df_r),0.05)*_se[post_1] in 9
	replace y=1 in 9	
	
	replace beta=_b[post_2] in 10
	replace   ub=_b[post_2]+invttail(e(df_r),0.05)*_se[post_2] in 10
	replace   lb=_b[post_2]-invttail(e(df_r),0.05)*_se[post_2] in 10
	replace y=2 in 10	
	
	replace beta=_b[post_3] in 11
	replace   ub=_b[post_3]+invttail(e(df_r),0.05)*_se[post_3] in 11
	replace   lb=_b[post_3]-invttail(e(df_r),0.05)*_se[post_3] in 11
	replace y=3 in 11	
	
	replace beta=_b[post_4] in 12
	replace   ub=_b[post_4]+invttail(e(df_r),0.05)*_se[post_4] in 12
	replace   lb=_b[post_4]-invttail(e(df_r),0.05)*_se[post_4] in 12
	replace y=4 in 12	
	
	replace beta=_b[post_5] in 13
	replace   ub=_b[post_5]+invttail(e(df_r),0.05)*_se[post_5] in 13
	replace   lb=_b[post_5]-invttail(e(df_r),0.05)*_se[post_5] in 13
	replace y=5 in 13	
	
	replace beta=_b[post_66] in 14
	replace   ub=_b[post_66]+invttail(e(df_r),0.05)*_se[post_66] in 14
	replace   lb=_b[post_66]-invttail(e(df_r),0.05)*_se[post_66] in 14
	replace y=6 in 14	

	replace variable="Years of Education" in 2/14
	
	cap label drop y_l
	label define y_l -6 "-6" -5 "-5" -4 "-4"-3 "-3"	-2 "-2"	-1 "-1" 0 "0" 1 "1" 2 "2" 3 "3" 4 "4" 5 "5"  6 "6+"
	label values y y_l

twoway (rspike ub lb y if variable=="Years of Education", lc(black) lp(solid) lw(thin) ) ///
		(connect beta y if variable=="Years of Education" & y<=-3, msize(small) mc(black) lc(black) lp(solid) lw(thin)) ///
				(connect beta y if variable=="Years of Education" & y>=1, msize(small) mc(black) lc(black) lp(solid) lw(thin)), ///
		scheme(s1mono)  yline(0, lc(gs10) lp(dash) lw(thin)) xline(-1, lc(gs10) lp(dash) lw(thin)) ///
		title("Panel A. 受教育年限-国家专项") xlabel(-6(1)6, valuelabel) xtitle("相对时间")    legend(off) 
		
	
graph save "$result\ES1_1r.gph",replace
graph export "$result\ES1_1r.png",replace




#delimit ;
	cap drop beta ;	cap drop ub; cap drop lb; cap drop y; cap drop variable;
	gen beta=. ; gen ub=. ; gen lb=. ; gen y=. ; gen variable="";
#delimit cr


reghdfe high_if $event1 $i_controls , absorb($fe2) cluster($cluster2)	


    replace beta=_b[pre_6] in 2
	replace   ub=_b[pre_6]+invttail(e(df_r),0.05)*_se[pre_6] in 2
	replace   lb=_b[pre_6]-invttail(e(df_r),0.05)*_se[pre_6] in 2
	replace y= -6 in 2
	
	replace beta=_b[pre_5] in 3
	replace   ub=_b[pre_5]+invttail(e(df_r),0.05)*_se[pre_5] in 3
	replace   lb=_b[pre_5]-invttail(e(df_r),0.05)*_se[pre_5] in 3
	replace y=-5 in 3
	
	replace beta=_b[pre_4] in 4
	replace   ub=_b[pre_4]+invttail(e(df_r),0.05)*_se[pre_4] in 4
	replace   lb=_b[pre_4]-invttail(e(df_r),0.05)*_se[pre_4] in 4
	replace y=-4 in 4
	
	replace beta=_b[pre_3] in 5
	replace   ub=_b[pre_3]+invttail(e(df_r),0.05)*_se[pre_3] in 5
	replace   lb=_b[pre_3]-invttail(e(df_r),0.05)*_se[pre_3] in 5
	replace y=-3 in 5
	
		replace beta=_b[pre_2] in 6
	replace   ub=_b[pre_2]+invttail(e(df_r),0.05)*_se[pre_2] in 6
	replace   lb=_b[pre_2]-invttail(e(df_r),0.05)*_se[pre_2] in 6
	replace y=-2 in 6
	
	replace beta=0 in 7
	replace   ub=0 in 7
	replace   lb=0 in 7
	replace y=-1 in 7
	
	
	replace beta=_b[post_0] in 8
	replace   ub=_b[post_0]+invttail(e(df_r),0.05)*_se[post_0] in 8
	replace   lb=_b[post_0]-invttail(e(df_r),0.05)*_se[post_0] in 8
	replace y=0 in 8
	
	replace beta=_b[post_1] in 9
	replace   ub=_b[post_1]+invttail(e(df_r),0.05)*_se[post_1] in 9
	replace   lb=_b[post_1]-invttail(e(df_r),0.05)*_se[post_1] in 9
	replace y=1 in 9	
	
	replace beta=_b[post_2] in 10
	replace   ub=_b[post_2]+invttail(e(df_r),0.05)*_se[post_2] in 10
	replace   lb=_b[post_2]-invttail(e(df_r),0.05)*_se[post_2] in 10
	replace y=2 in 10	
	
		replace beta=_b[post_3] in 11
	replace   ub=_b[post_3]+invttail(e(df_r),0.05)*_se[post_3] in 11
	replace   lb=_b[post_3]-invttail(e(df_r),0.05)*_se[post_3] in 11
	replace y=3 in 11	
	
		replace beta=_b[post_4] in 12
	replace   ub=_b[post_4]+invttail(e(df_r),0.05)*_se[post_4] in 12
	replace   lb=_b[post_4]-invttail(e(df_r),0.05)*_se[post_4] in 12
	replace y=4 in 12	
	
		replace beta=_b[post_5] in 13
	replace   ub=_b[post_5]+invttail(e(df_r),0.05)*_se[post_5] in 13
	replace   lb=_b[post_5]-invttail(e(df_r),0.05)*_se[post_5] in 13
	replace y=5 in 13	
	
		replace beta=_b[post_66] in 14
	replace   ub=_b[post_66]+invttail(e(df_r),0.05)*_se[post_66] in 14
	replace   lb=_b[post_66]-invttail(e(df_r),0.05)*_se[post_66] in 14
	replace y=6 in 14	

	replace variable="Years of Education" in 2/14
	
	cap label drop y_l
	label define y_l -6 "-6" -5 "-5" -4 "-4"-3 "-3"	-2 "-2"	-1 "-1" 0 "0" 1 "1" 2 "2" 3 "3" 4 "4" 5 "5"  6 "6+"
	label values y y_l

twoway (rspike ub lb y if variable=="Years of Education", lc(black) lp(solid) lw(thin) ) ///
		(connect beta y if variable=="Years of Education" & y<=-3, msize(small) mc(black) lc(black) lp(solid) lw(thin)) ///
				(connect beta y if variable=="Years of Education" & y>=1, msize(small) mc(black) lc(black) lp(solid) lw(thin)), ///
		scheme(s1mono)  yline(0, lc(gs10) lp(dash) lw(thin)) xline(-1, lc(gs10) lp(dash) lw(thin)) ///
		title("Panel C. 高中教育-国家专项") xlabel(-6(1)6, valuelabel) xtitle("相对时间")    legend(off) 
		
	
graph save "$result\ES3_1r.gph",replace
graph export "$result\ES3_1r.png",replace

#delimit ;
	cap drop beta ;	cap drop ub; cap drop lb; cap drop y; cap drop variable;
	gen beta=. ; gen ub=. ; gen lb=. ; gen y=. ; gen variable="";
#delimit cr


reghdfe collage_if $event1 $i_controls , absorb($fe2) cluster($cluster2)	


    replace beta=_b[pre_6] in 2
	replace   ub=_b[pre_6]+invttail(e(df_r),0.05)*_se[pre_6] in 2
	replace   lb=_b[pre_6]-invttail(e(df_r),0.05)*_se[pre_6] in 2
	replace y= -6 in 2
	
	replace beta=_b[pre_5] in 3
	replace   ub=_b[pre_5]+invttail(e(df_r),0.05)*_se[pre_5] in 3
	replace   lb=_b[pre_5]-invttail(e(df_r),0.05)*_se[pre_5] in 3
	replace y=-5 in 3
	
	replace beta=_b[pre_4] in 4
	replace   ub=_b[pre_4]+invttail(e(df_r),0.05)*_se[pre_4] in 4
	replace   lb=_b[pre_4]-invttail(e(df_r),0.05)*_se[pre_4] in 4
	replace y=-4 in 4
	
	replace beta=_b[pre_3] in 5
	replace   ub=_b[pre_3]+invttail(e(df_r),0.05)*_se[pre_3] in 5
	replace   lb=_b[pre_3]-invttail(e(df_r),0.05)*_se[pre_3] in 5
	replace y=-3 in 5
	
		replace beta=_b[pre_2] in 6
	replace   ub=_b[pre_2]+invttail(e(df_r),0.05)*_se[pre_2] in 6
	replace   lb=_b[pre_2]-invttail(e(df_r),0.05)*_se[pre_2] in 6
	replace y=-2 in 6
	
	replace beta=0 in 7
	replace   ub=0 in 7
	replace   lb=0 in 7
	replace y=-1 in 7
	
	
	replace beta=_b[post_0] in 8
	replace   ub=_b[post_0]+invttail(e(df_r),0.05)*_se[post_0] in 8
	replace   lb=_b[post_0]-invttail(e(df_r),0.05)*_se[post_0] in 8
	replace y=0 in 8
	
	replace beta=_b[post_1] in 9
	replace   ub=_b[post_1]+invttail(e(df_r),0.05)*_se[post_1] in 9
	replace   lb=_b[post_1]-invttail(e(df_r),0.05)*_se[post_1] in 9
	replace y=1 in 9	
	
	replace beta=_b[post_2] in 10
	replace   ub=_b[post_2]+invttail(e(df_r),0.05)*_se[post_2] in 10
	replace   lb=_b[post_2]-invttail(e(df_r),0.05)*_se[post_2] in 10
	replace y=2 in 10	
	
		replace beta=_b[post_3] in 11
	replace   ub=_b[post_3]+invttail(e(df_r),0.05)*_se[post_3] in 11
	replace   lb=_b[post_3]-invttail(e(df_r),0.05)*_se[post_3] in 11
	replace y=3 in 11	
	
		replace beta=_b[post_4] in 12
	replace   ub=_b[post_4]+invttail(e(df_r),0.05)*_se[post_4] in 12
	replace   lb=_b[post_4]-invttail(e(df_r),0.05)*_se[post_4] in 12
	replace y=4 in 12	
	
		replace beta=_b[post_5] in 13
	replace   ub=_b[post_5]+invttail(e(df_r),0.05)*_se[post_5] in 13
	replace   lb=_b[post_5]-invttail(e(df_r),0.05)*_se[post_5] in 13
	replace y=5 in 13	
	
		replace beta=_b[post_66] in 14
	replace   ub=_b[post_66]+invttail(e(df_r),0.05)*_se[post_66] in 14
	replace   lb=_b[post_66]-invttail(e(df_r),0.05)*_se[post_66] in 14
	replace y=6 in 14	

	replace variable="Years of Education" in 2/14
	
	cap label drop y_l
	label define y_l -6 "-6" -5 "-5" -4 "-4"-3 "-3"	-2 "-2"	-1 "-1" 0 "0" 1 "1" 2 "2" 3 "3" 4 "4" 5 "5"  6 "6+"
	label values y y_l

twoway (rspike ub lb y if variable=="Years of Education", lc(black) lp(solid) lw(thin) ) ///
		(connect beta y if variable=="Years of Education" & y<=-3, msize(small) mc(black) lc(black) lp(solid) lw(thin)) ///
				(connect beta y if variable=="Years of Education" & y>=1, msize(small) mc(black) lc(black) lp(solid) lw(thin)), ///
		scheme(s1mono)  yline(0, lc(gs10) lp(dash) lw(thin)) xline(-1, lc(gs10) lp(dash) lw(thin)) ///
		title("Panel E. 大学教育-国家专项") xlabel(-6(1)6, valuelabel) xtitle("相对时间")    legend(off) 
		
	
graph save "$result\ES4_1r.gph",replace
graph export "$result\ES4_1r.png",replace

restore

**# 所有专项

preserve

	drop if pre2_2==1
	drop if pre2_1==1
	drop if post2_0==1


#delimit ;
	cap drop beta ;	cap drop ub; cap drop lb; cap drop y; cap drop variable;
	gen beta=. ; gen ub=. ; gen lb=. ; gen y=. ; gen variable="";
#delimit cr


reghdfe eduy_im $event2 $i_controls , absorb($fe2) cluster($cluster2)	


    replace beta=_b[pre2_6] in 2
	replace   ub=_b[pre2_6]+invttail(e(df_r),0.05)*_se[pre2_6] in 2
	replace   lb=_b[pre2_6]-invttail(e(df_r),0.05)*_se[pre2_6] in 2
	replace y= -6 in 2
	
	replace beta=_b[pre2_5] in 3
	replace   ub=_b[pre2_5]+invttail(e(df_r),0.05)*_se[pre2_5] in 3
	replace   lb=_b[pre2_5]-invttail(e(df_r),0.05)*_se[pre2_5] in 3
	replace y=-5 in 3
	
	replace beta=_b[pre2_4] in 4
	replace   ub=_b[pre2_4]+invttail(e(df_r),0.05)*_se[pre2_4] in 4
	replace   lb=_b[pre2_4]-invttail(e(df_r),0.05)*_se[pre2_4] in 4
	replace y=-4 in 4
	
	replace beta=_b[pre2_3] in 5
	replace   ub=_b[pre2_3]+invttail(e(df_r),0.05)*_se[pre2_3] in 5
	replace   lb=_b[pre2_3]-invttail(e(df_r),0.05)*_se[pre2_3] in 5
	replace y=-3 in 5
	
		replace beta=_b[pre2_2] in 6
	replace   ub=_b[pre2_2]+invttail(e(df_r),0.05)*_se[pre2_2] in 6
	replace   lb=_b[pre2_2]-invttail(e(df_r),0.05)*_se[pre2_2] in 6
	replace y=-2 in 6
	
	replace beta=0 in 7
	replace   ub=0 in 7
	replace   lb=0 in 7
	replace y=-1 in 7
	
	
	replace beta=_b[post2_0] in 8
	replace   ub=_b[post2_0]+invttail(e(df_r),0.05)*_se[post2_0] in 8
	replace   lb=_b[post2_0]-invttail(e(df_r),0.05)*_se[post2_0] in 8
	replace y=0 in 8
	
	replace beta=_b[post2_1] in 9
	replace   ub=_b[post2_1]+invttail(e(df_r),0.05)*_se[post2_1] in 9
	replace   lb=_b[post2_1]-invttail(e(df_r),0.05)*_se[post2_1] in 9
	replace y=1 in 9	
	
	replace beta=_b[post2_2] in 10
	replace   ub=_b[post2_2]+invttail(e(df_r),0.05)*_se[post2_2] in 10
	replace   lb=_b[post2_2]-invttail(e(df_r),0.05)*_se[post2_2] in 10
	replace y=2 in 10	
	
		replace beta=_b[post2_3] in 11
	replace   ub=_b[post2_3]+invttail(e(df_r),0.05)*_se[post2_3] in 11
	replace   lb=_b[post2_3]-invttail(e(df_r),0.05)*_se[post2_3] in 11
	replace y=3 in 11	
	
		replace beta=_b[post2_4] in 12
	replace   ub=_b[post2_4]+invttail(e(df_r),0.05)*_se[post2_4] in 12
	replace   lb=_b[post2_4]-invttail(e(df_r),0.05)*_se[post2_4] in 12
	replace y=4 in 12	
	
		replace beta=_b[post2_5] in 13
	replace   ub=_b[post2_5]+invttail(e(df_r),0.05)*_se[post2_5] in 13
	replace   lb=_b[post2_5]-invttail(e(df_r),0.05)*_se[post2_5] in 13
	replace y=5 in 13	
	
		replace beta=_b[post2_66] in 14
	replace   ub=_b[post2_66]+invttail(e(df_r),0.05)*_se[post2_66] in 14
	replace   lb=_b[post2_66]-invttail(e(df_r),0.05)*_se[post2_66] in 14
	replace y=6 in 14	

	replace variable="Years of Education" in 2/14
	
	cap label drop y_l
	label define y_l -6 "-6" -5 "-5" -4 "-4"-3 "-3"	-2 "-2"	-1 "-1" 0 "0" 1 "1" 2 "2" 3 "3" 4 "4" 5 "5"  6 "6+"
	label values y y_l

twoway (rspike ub lb y if variable=="Years of Education", lc(black) lp(solid) lw(thin) ) ///
	(connect beta y if variable=="Years of Education" & y<=-3, msize(small) mc(black) lc(black) lp(solid) lw(thin)) ///
				(connect beta y if variable=="Years of Education" & y>=1, msize(small) mc(black) lc(black) lp(solid) lw(thin)), ///
		scheme(s1mono)  yline(0, lc(gs10) lp(dash) lw(thin)) xline(-1, lc(gs10) lp(dash) lw(thin)) ///
		title("Panel B. 受教育年限-三大专项") xlabel(-6(1)6, valuelabel) xtitle("相对时间")    legend(off) 
		
graph save "$result\ES1_2r.gph",replace
graph export "$result\ES1_2r.png",replace


#delimit ;
	cap drop beta ;	cap drop ub; cap drop lb; cap drop y; cap drop variable;
	gen beta=. ; gen ub=. ; gen lb=. ; gen y=. ; gen variable="";
#delimit cr


reghdfe high_if $event2 $i_controls , absorb($fe2) cluster($cluster2)	


    replace beta=_b[pre2_6] in 2
	replace   ub=_b[pre2_6]+invttail(e(df_r),0.05)*_se[pre2_6] in 2
	replace   lb=_b[pre2_6]-invttail(e(df_r),0.05)*_se[pre2_6] in 2
	replace y= -6 in 2
	
	replace beta=_b[pre2_5] in 3
	replace   ub=_b[pre2_5]+invttail(e(df_r),0.05)*_se[pre2_5] in 3
	replace   lb=_b[pre2_5]-invttail(e(df_r),0.05)*_se[pre2_5] in 3
	replace y=-5 in 3
	
	replace beta=_b[pre2_4] in 4
	replace   ub=_b[pre2_4]+invttail(e(df_r),0.05)*_se[pre2_4] in 4
	replace   lb=_b[pre2_4]-invttail(e(df_r),0.05)*_se[pre2_4] in 4
	replace y=-4 in 4
	
	replace beta=_b[pre2_3] in 5
	replace   ub=_b[pre2_3]+invttail(e(df_r),0.05)*_se[pre2_3] in 5
	replace   lb=_b[pre2_3]-invttail(e(df_r),0.05)*_se[pre2_3] in 5
	replace y=-3 in 5
	
		replace beta=_b[pre2_2] in 6
	replace   ub=_b[pre2_2]+invttail(e(df_r),0.05)*_se[pre2_2] in 6
	replace   lb=_b[pre2_2]-invttail(e(df_r),0.05)*_se[pre2_2] in 6
	replace y=-2 in 6
	
	replace beta=0 in 7
	replace   ub=0 in 7
	replace   lb=0 in 7
	replace y=-1 in 7
	
	
	replace beta=_b[post2_0] in 8
	replace   ub=_b[post2_0]+invttail(e(df_r),0.05)*_se[post2_0] in 8
	replace   lb=_b[post2_0]-invttail(e(df_r),0.05)*_se[post2_0] in 8
	replace y=0 in 8
	
	replace beta=_b[post2_1] in 9
	replace   ub=_b[post2_1]+invttail(e(df_r),0.05)*_se[post2_1] in 9
	replace   lb=_b[post2_1]-invttail(e(df_r),0.05)*_se[post2_1] in 9
	replace y=1 in 9	
	
	replace beta=_b[post2_2] in 10
	replace   ub=_b[post2_2]+invttail(e(df_r),0.05)*_se[post2_2] in 10
	replace   lb=_b[post2_2]-invttail(e(df_r),0.05)*_se[post2_2] in 10
	replace y=2 in 10	
	
		replace beta=_b[post2_3] in 11
	replace   ub=_b[post2_3]+invttail(e(df_r),0.05)*_se[post2_3] in 11
	replace   lb=_b[post2_3]-invttail(e(df_r),0.05)*_se[post2_3] in 11
	replace y=3 in 11	
	
		replace beta=_b[post2_4] in 12
	replace   ub=_b[post2_4]+invttail(e(df_r),0.05)*_se[post2_4] in 12
	replace   lb=_b[post2_4]-invttail(e(df_r),0.05)*_se[post2_4] in 12
	replace y=4 in 12	
	
		replace beta=_b[post2_5] in 13
	replace   ub=_b[post2_5]+invttail(e(df_r),0.05)*_se[post2_5] in 13
	replace   lb=_b[post2_5]-invttail(e(df_r),0.05)*_se[post2_5] in 13
	replace y=5 in 13	
	
		replace beta=_b[post2_66] in 14
	replace   ub=_b[post2_66]+invttail(e(df_r),0.05)*_se[post2_66] in 14
	replace   lb=_b[post2_66]-invttail(e(df_r),0.05)*_se[post2_66] in 14
	replace y=6 in 14	

	replace variable="Years of Education" in 2/14
	
	cap label drop y_l
	label define y_l -6 "-6" -5 "-5" -4 "-4"-3 "-3"	-2 "-2"	-1 "-1" 0 "0" 1 "1" 2 "2" 3 "3" 4 "4" 5 "5"  6 "6+"
	label values y y_l

twoway (rspike ub lb y if variable=="Years of Education", lc(black) lp(solid) lw(thin) ) ///
	(connect beta y if variable=="Years of Education" & y<=-3, msize(small) mc(black) lc(black) lp(solid) lw(thin)) ///
				(connect beta y if variable=="Years of Education" & y>=1, msize(small) mc(black) lc(black) lp(solid) lw(thin)), ///
		scheme(s1mono)  yline(0, lc(gs10) lp(dash) lw(thin)) xline(-1, lc(gs10) lp(dash) lw(thin)) ///
		title("Panel D. 高中教育-三大专项") xlabel(-6(1)6, valuelabel) xtitle("相对时间")    legend(off) 
		
graph save "$result\ES3_2r.gph",replace
graph export "$result\ES3_2r.png",replace

#delimit ;
	cap drop beta ;	cap drop ub; cap drop lb; cap drop y; cap drop variable;
	gen beta=. ; gen ub=. ; gen lb=. ; gen y=. ; gen variable="";
#delimit cr


reghdfe collage_if $event2 $i_controls , absorb($fe2) cluster($cluster2)	


    replace beta=_b[pre2_6] in 2
	replace   ub=_b[pre2_6]+invttail(e(df_r),0.05)*_se[pre2_6] in 2
	replace   lb=_b[pre2_6]-invttail(e(df_r),0.05)*_se[pre2_6] in 2
	replace y= -6 in 2
	
	replace beta=_b[pre2_5] in 3
	replace   ub=_b[pre2_5]+invttail(e(df_r),0.05)*_se[pre2_5] in 3
	replace   lb=_b[pre2_5]-invttail(e(df_r),0.05)*_se[pre2_5] in 3
	replace y=-5 in 3
	
	replace beta=_b[pre2_4] in 4
	replace   ub=_b[pre2_4]+invttail(e(df_r),0.05)*_se[pre2_4] in 4
	replace   lb=_b[pre2_4]-invttail(e(df_r),0.05)*_se[pre2_4] in 4
	replace y=-4 in 4
	
	replace beta=_b[pre2_3] in 5
	replace   ub=_b[pre2_3]+invttail(e(df_r),0.05)*_se[pre2_3] in 5
	replace   lb=_b[pre2_3]-invttail(e(df_r),0.05)*_se[pre2_3] in 5
	replace y=-3 in 5
	
		replace beta=_b[pre2_2] in 6
	replace   ub=_b[pre2_2]+invttail(e(df_r),0.05)*_se[pre2_2] in 6
	replace   lb=_b[pre2_2]-invttail(e(df_r),0.05)*_se[pre2_2] in 6
	replace y=-2 in 6
	
	replace beta=0 in 7
	replace   ub=0 in 7
	replace   lb=0 in 7
	replace y=-1 in 7
	
	
	replace beta=_b[post2_0] in 8
	replace   ub=_b[post2_0]+invttail(e(df_r),0.05)*_se[post2_0] in 8
	replace   lb=_b[post2_0]-invttail(e(df_r),0.05)*_se[post2_0] in 8
	replace y=0 in 8
	
	replace beta=_b[post2_1] in 9
	replace   ub=_b[post2_1]+invttail(e(df_r),0.05)*_se[post2_1] in 9
	replace   lb=_b[post2_1]-invttail(e(df_r),0.05)*_se[post2_1] in 9
	replace y=1 in 9	
	
	replace beta=_b[post2_2] in 10
	replace   ub=_b[post2_2]+invttail(e(df_r),0.05)*_se[post2_2] in 10
	replace   lb=_b[post2_2]-invttail(e(df_r),0.05)*_se[post2_2] in 10
	replace y=2 in 10	
	
		replace beta=_b[post2_3] in 11
	replace   ub=_b[post2_3]+invttail(e(df_r),0.05)*_se[post2_3] in 11
	replace   lb=_b[post2_3]-invttail(e(df_r),0.05)*_se[post2_3] in 11
	replace y=3 in 11	
	
		replace beta=_b[post2_4] in 12
	replace   ub=_b[post2_4]+invttail(e(df_r),0.05)*_se[post2_4] in 12
	replace   lb=_b[post2_4]-invttail(e(df_r),0.05)*_se[post2_4] in 12
	replace y=4 in 12	
	
		replace beta=_b[post2_5] in 13
	replace   ub=_b[post2_5]+invttail(e(df_r),0.05)*_se[post2_5] in 13
	replace   lb=_b[post2_5]-invttail(e(df_r),0.05)*_se[post2_5] in 13
	replace y=5 in 13	
	
		replace beta=_b[post2_66] in 14
	replace   ub=_b[post2_66]+invttail(e(df_r),0.05)*_se[post2_66] in 14
	replace   lb=_b[post2_66]-invttail(e(df_r),0.05)*_se[post2_66] in 14
	replace y=6 in 14	

	replace variable="Years of Education" in 2/14
	
	cap label drop y_l
	label define y_l -6 "-6" -5 "-5" -4 "-4"-3 "-3"	-2 "-2"	-1 "-1" 0 "0" 1 "1" 2 "2" 3 "3" 4 "4" 5 "5"  6 "6+"
	label values y y_l

twoway (rspike ub lb y if variable=="Years of Education", lc(black) lp(solid) lw(thin) ) ///
	(connect beta y if variable=="Years of Education" & y<=-3, msize(small) mc(black) lc(black) lp(solid) lw(thin)) ///
				(connect beta y if variable=="Years of Education" & y>=1, msize(small) mc(black) lc(black) lp(solid) lw(thin)), ///
		scheme(s1mono)  yline(0, lc(gs10) lp(dash) lw(thin)) xline(-1, lc(gs10) lp(dash) lw(thin)) ///
		title("Panel F. 大学教育-三大专项") xlabel(-6(1)6, valuelabel) xtitle("相对时间")    legend(off) 
		
graph save "$result\ES4_2r.gph",replace
graph export "$result\ES4_2r.png",replace

	
restore
	
graph combine  "$result\ES1_1r.gph" "$result\ES1_2r.gph" "$result\ES3_1r.gph" "$result\ES3_2r.gph" "$result\ES4_1r.gph" "$result\ES4_2r.gph", scheme(s1mono) cols(2)  altshrink 

graph save "$result\图Ⅵ1.gph",replace
graph export "$result\图Ⅵ1.png",replace



end

parallel_r


**# 表 Ⅵ1-2 稳健性检验：国家（三大）专项计划


capture program drop robust12

program robust12


**# 国家专项

foreach var of varlist eduy_im high_if collage_if{

	eststo clear
	local num = 1
	
use cfps_sample_2020_new,replace
	
*--1.排除留级跳级因素影响	

	preserve

	drop if pre_2==1
	drop if pre_1==1
	drop if post_0==1

	reghdfe `var' $depvar1 $i_controls , absorb($fe2) cluster($cluster2)

		eststo baseline_`x'_`num'  		
		estadd local cohort_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local prov_cohorttrend 	"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num

	restore
	
	
*--2.排除原有差异影响	
	
	reghdfe `var' $depvar1  $i_controls $poverty , absorb($fe2) cluster($cluster2)
	
		eststo baseline_`x'_`num'  		
		estadd local cohort_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local prov_cohorttrend 	"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num

*--3.排除控制free compulsory 和CAL政策影响	

	 reghdfe `var' $depvar1  $i_controls $other , absorb($fe2) cluster($cluster2)
	
		eststo baseline_`x'_`num'  		
		estadd local cohort_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local prov_cohorttrend 	"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num
		
		
*--4.排除免费师范生政策影响（生成师范生政策控制变量）

	gen cohort_2008=(birthy<=1990)
	gen shifan=cohort_2008*east
	
	 reghdfe `var' $depvar1  $i_controls shifan if sample_if==1, absorb($fe2) cluster($cluster2)

		eststo baseline_`x'_`num'  		
		estadd local cohort_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local prov_cohorttrend 	"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num	
		
*--5.排除高校扩招政策影响（删去1999年之前参加高考个体）	

	 reghdfe `var' $depvar1  $i_controls  if birthy >=1981, absorb($fe2) cluster($cluster2)
	
		eststo baseline_`x'_`num'  		
		estadd local cohort_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local prov_cohorttrend 	"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num	
	
*--6.进一步保留农村户口

	 reghdfe `var' $depvar1  $i_controls  if hk_rural==1, absorb($fe2) cluster($cluster2)
		
		eststo baseline_`x'_`num'  		
		estadd local cohort_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local prov_cohorttrend 	"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num	
			
*--7.保留12岁迁移样本

use "$rawdata/cfps_all_2020",replace

	drop if urban==1
	
	 reghdfe `var' $depvar1  $i_controls  , absorb($fe2) cluster($cluster2)	
		
		eststo baseline_`x'_`num'  		
		estadd local cohort_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local prov_cohorttrend 	"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num		
	
		esttab baseline_* , append nogaps keep($depvar1) b(%9.3f) se(%9.3f) stats(cohort_fe  county_fe prov_cohorttrend ind_control  N r_2 , fmt(%9.3f %9.3f %9.3f %9.3f %9.0fc %9.3f ) labels("Cohort FEs" "County FEs" "Province-cohort trend" "Individual controls" "N" " R^2 " )) star(* 0.1 ** 0.05 *** 0.01)	
	
	

}

**# 三大专项

foreach var of varlist eduy_im high_if collage_if{

	eststo clear
	local num = 1
	
use cfps_sample_2020_new,replace
	
*--1.排除留级跳级因素影响
	
	preserve

	drop if pre2_2==1
	drop if pre2_1==1
	drop if post2_0==1

	reghdfe `var' $depvar2 $i_controls if sample_if==1, absorb($fe2) cluster($cluster2)

		eststo baseline_`x'_`num'  		
		estadd local cohort_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local prov_cohorttrend 	"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num
		
	restore
	
*--2.排除原有差异影响	
	
	reghdfe `var' $depvar2  $i_controls $poverty , absorb($fe2) cluster($cluster2)
	
		eststo baseline_`x'_`num'  		
		estadd local cohort_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local prov_cohorttrend 	"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num

*--3.排除控制free compulsory 和CAL政策影响	

	 reghdfe `var' $depvar2  $i_controls $other , absorb($fe2) cluster($cluster2)
	
		eststo baseline_`x'_`num'  		
		estadd local cohort_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local prov_cohorttrend 	"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num
		
		
*--4.排除免费师范生政策影响（生成师范生政策控制变量）

	gen cohort_2008=(birthy<=1990)
	gen shifan=cohort_2008*east
	
	 reghdfe `var' $depvar2  $i_controls shifan if sample_if==1, absorb($fe2) cluster($cluster2)

		eststo baseline_`x'_`num'  		
		estadd local cohort_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local prov_cohorttrend 	"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num	
		
*--5.排除高校扩招政策影响（删去1999年之前参加高考个体）	

	 reghdfe `var' $depvar2  $i_controls  if birthy >=1981, absorb($fe2) cluster($cluster2)
	
		eststo baseline_`x'_`num'  		
		estadd local cohort_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local prov_cohorttrend 	"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num	
	
*--6.进一步保留农村户口

	 reghdfe `var' $depvar2  $i_controls  if hk_rural==1, absorb($fe2) cluster($cluster2)
		
		eststo baseline_`x'_`num'  		
		estadd local cohort_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local prov_cohorttrend 	"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num	
			
*--7.保留12岁迁移样本

use "$rawdata/cfps_all_2020",replace

	drop if urban==1
	
	 reghdfe `var' $depvar2  $i_controls  , absorb($fe2) cluster($cluster2)	
		
		eststo baseline_`x'_`num'  		
		estadd local cohort_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local prov_cohorttrend 	"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num		
	
		esttab baseline_* , append nogaps keep($depvar2 ) b(%9.3f) se(%9.3f) stats(cohort_fe  county_fe prov_cohorttrend ind_control  N r_2 , fmt(%9.3f %9.3f %9.3f %9.3f %9.0fc %9.3f ) labels("Cohort FEs" "County FEs" "Province-cohort trend" "Individual controls" "N" " R^2 " )) star(* 0.1 ** 0.05 *** 0.01)	
	
}




end

robust12


**# 表Ⅵ3 三大计划的累积效应和不同效应检验

capture program drop robust3

program robust3

use cfps_sample_2020_new,replace


	replace regionplan=2014 if regionplan<2014
	replace collageplan=2014 if collageplan<2014

	gen plan_num=0

	foreach var of varlist countryplan collageplan regionplan{
		replace plan_num=plan_num+1 if `var'<=birthy+18	
	}


	eststo clear
	local num = 1
	
foreach var of varlist eduy_im  high_if collage_if{	
		
	 reghdfe `var' plan_num  $i_controls  , absorb($fe2) cluster($cluster2)
		
		eststo baseline_`x'_`num'  		
		estadd local cohort_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local prov_cohorttrend 	"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num		
	
}



foreach var of varlist eduy_im  high_if collage_if{	

	 reghdfe `var' $depvar2  $i_controls if countryplan==., absorb($fe2) cluster($cluster2)

		eststo baseline_`x'_`num'  		
		estadd local cohort_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local prov_cohorttrend 	"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		estadd scalar r_2 			= e(r2)
		local ++num		
		

}


		esttab baseline_* , append nogaps keep(plan_num $depvar2 ) b(%9.3f) se(%9.3f) stats(cohort_fe  county_fe prov_cohorttrend ind_control  N r_2 , fmt(%9.3f %9.3f %9.3f %9.3f %9.0fc %9.3f ) labels("Cohort FEs" "County FEs" "Province-cohort trend" "Individual controls" "N" " R^2 " )) star(* 0.1 ** 0.05 *** 0.01)	
	

end

robust3




**# 表Ⅶ1 稳健性检验：儿童人力资本投资


capture program drop robust_4

program robust_4

use cfps_child_1020,clear

	capture drop sample_if
	qui: ppmlhdfe edufee $depvar3 $i_controls2 , absorb($fe3) cluster($cluster3)

	gen sample_if=e(sample)
	keep if sample_if==1

	eststo clear
	local num = 1
	
	ppmlhdfe edufee_tr $depvar3 $i_controls2 , absorb($fe3) cluster($cluster3)

		eststo baseline_`x'_`num'  		
		estadd local year_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		local ++num

	ppmlhdfe expense_prop $depvar3 $i_controls2 , absorb($fe3) cluster($cluster3)
	
		eststo baseline_`x'_`num'  		
		estadd local year_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		local ++num

	ppmlhdfe income_prop $depvar3 $i_controls2 , absorb($fe3) cluster($cluster3)
	
		eststo baseline_`x'_`num'  		
		estadd local year_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		local ++num

	ppmlhdfe edufee $depvar3 $i_controls2  if_edupa, absorb($fe3) cluster($cluster3)

		eststo baseline_`x'_`num'  		
		estadd local year_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		local ++num
		
	gen edufee_num=edufee if edufee>0
	gen log_edufee_num=ln(edufee_num)
	gen log_edufee_num_0=log_edufee_num
	replace log_edufee_num_0=0 if log_edufee_num==.

	tobit  log_edufee_num_0  $depvar3  $i_controls2 i.year i.countyid , ll(0) vce(cluster $cluster3)
	margins, dydx($depvar3)

		eststo baseline_`x'_`num'  		
		estadd local year_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		local ++num


	 twopm edufee $depvar3  $i_controls2   i.year i.countyid, firstpart(logit) secondpart(regress, log)

		eststo baseline_`x'_`num'  		
		estadd local year_fe 			"Yes"
		estadd local county_fe 			"Yes"
		estadd local ind_control 		"Yes"			
		estadd ysumm		
		local ++num



		esttab baseline_* , append nogaps keep($depvar3 ) b(%9.3f) se(%9.3f) stats(year_fe  county_fe ind_control  N , fmt(%9.3f  %9.3f  %9.3f %9.0fc  ) labels("Year FEs" "County FEs"  "Individual controls" "N"  )) star(* 0.1 ** 0.05 *** 0.01)	


	
end

robust_4

log close


