




/*

主要内容：
	2015-2017小时数据: 描述性统计、实证分析（模型一主回归）
用到的数据：网约_trip, 巡游_trip, weather
生成的表格&图: 表2 Panel A, 表4 Panel A, 表4 Panel B

*/



// 运行数据处理脚本 data_process_2019.do
do data_process_2019.do


// 网约车&巡游车行程数据 -> 小时工作信息



* 结构化处理巡游车2019年数据
use "巡游_trip.dta", replace
data_structured_2019
data_flag_2019
keep if date(substr(hour_variable,1,8),"YMD") >= date("20190616","YMD") & date(substr(hour_variable,1,8),"YMD") <= date("20190622", "YMD")
gen wangyue = 0
save "巡游_小时.dta", replace
// 描述性统计: 对应表2 - Panel A
sum  hour_income hour_duration hour_distance if flag != 1   

* 结构化处理网约车2019年数据
use "网约_trip.dta", replace
data_structured_2019
data_flag_2019
keep if date(substr(hour_variable,1,8),"YMD") >= date("20190616","YMD") & date(substr(hour_variable,1,8),"YMD") <= date("20190622", "YMD")
gen wangyue = 1 
save "网约_小时.dta", replace
// 描述性统计: 对应表2 - Panel A
sum hour_income hour_duration  hour_distance if flag != 1     


* 巡游车、网约车工作小时数据合并
append using "巡游_小时.dta"
save "网约&巡游_小时.dta", replace

* 与网约车id与所有小时两两匹配数据合并，生成小时实证样本
merge_hour_data "网约&巡游_小时"
save "网约&巡游_小时_实证样本.dta", replace



// 小时劳动供给模型的实证结果：表4 Panel A
* 将driver_id转为数值型变量
encode driver_id, gen(driver_id_num)
* 将hourvariable转换为Stata的datetime格式
gen double hour_variable1 = clock(hour_variable, "YMDh")
format hour_variable1 %tc
* 设置面板数据结构
xtset driver_id_num  hour_variable1, delta(1 hour)



* 线性概率模型，不包含个体和日期固定效应
reghdfe whether_work whether_rain wangyue c.whether_rain#c.wangyue ///
    i.hour if weekday == 1 & flag != 1, vce(cluster driver_id)
est store m4_11
outreg2 using result4_1.doc, replace  bdec(3) tdec(2) keep(whether_rain wangyue c.whether_rain#c.wangyue)



* 线性概率模型，包含个体和日期固定效应
reghdfe whether_work whether_rain  c.whether_rain#c.wangyue ///
    i.hour if weekday == 1 & flag != 1, absorb(driver_id week) vce(cluster driver_id)
est store m4_12
outreg2 using result4_1.doc, append  bdec(3) tdec(3) keep(whether_rain  c.whether_rain#c.wangyue)


* 逻辑回归模型，不包含个体和日期固定效应
logit whether_work whether_rain wangyue c.whether_rain#c.wangyue ///
    i.hour if weekday == 1 & flag != 1, vce(cluster driver_id)
est store m4_13
outreg2 using result4_1.doc, append  bdec(3) tdec(3) keep(whether_rain wangyue c.whether_rain#c.wangyue) ///
addstat(Pseudo R-squared, `e(r2_p)')


* 逻辑回归模型，包含个体和日期固定效应
xtlogit whether_work whether_rain  c.whether_rain#c.wangyue ///
    i.hour i.week if weekday == 1 & flag != 1 , fe 
est store m4_14

outreg2 using result4_1.doc, append  bdec(3) tdec(3) keep(whether_rain  c.whether_rain#c.wangyue) ///
addstat(Pseudo R-squared, `e(r2_p)')

	
	

// 小时劳动供给模型的实证结果：表4 Panel B


* 生被解释变量
gen lnhour_income = log(hour_income+1)
gen lnhour_duration = log(hour_duration+1)           // 计算每小时持续时间的对数
gen lnhour_velocity = log(hour_velocity+1)           // 计算每小时速度的对数



* 被解释变量为小时收入，不包含个体和日期固定效应
reghdfe lnhour_income whether_rain wangyue c.whether_rain#c.wangyue ///
    i.hour if weekday == 1 & flag != 1, vce(cluster driver_id)
est store m4_21
outreg2 using result4_2.doc, replace  bdec(3) tdec(2) keep(whether_rain wangyue c.whether_rain#c.wangyue)

* 被解释变量为小时收入，包含个体和日期固定效应
reghdfe lnhour_income whether_rain  c.whether_rain#c.wangyue ///
    i.hour if weekday == 1 & flag != 1, absorb(driver_id week) vce(cluster driver_id)
est store m4_22
outreg2 using result4_2.doc, append  bdec(3) tdec(2) keep(whether_rain wangyue c.whether_rain#c.wangyue)

* 被解释变量为载客概率，不包含个体和日期固定效应
reghdfe lnhour_duration whether_rain wangyue c.whether_rain#c.wangyue ///
    i.hour if weekday == 1 & flag != 1, vce(cluster driver_id)
est store m4_23
outreg2 using result4_2.doc, append  bdec(3) tdec(2) keep(whether_rain wangyue c.whether_rain#c.wangyue)

* 被解释变量为载客概率，包含个体和日期固定效应
reghdfe lnhour_duration whether_rain  c.whether_rain#c.wangyue ///
    i.hour if weekday == 1 & flag != 1, absorb(driver_id week) vce(cluster driver_id)                    
est store m4_24
outreg2 using result4_2.doc, append  bdec(3) tdec(2) keep(whether_rain wangyue c.whether_rain#c.wangyue)

* 被解释变量为载客速度，不包含个体和日期固定效应
reghdfe lnhour_velocity whether_rain wangyue c.whether_rain#c.wangyue ///
    i.hour if weekday == 1 & flag != 1, vce(cluster driver_id)
est store m4_25
outreg2 using result4_2.doc, append  bdec(3) tdec(2) keep(whether_rain wangyue c.whether_rain#c.wangyue)

* 被解释变量为载客概率，包含个体和日期固定效应
reghdfe lnhour_velocity whether_rain  c.whether_rain#c.wangyue ///
    i.hour if weekday == 1 & flag != 1, absorb(driver_id week) vce(cluster driver_id)
est store m4_26
outreg2 using result4_2.doc, append  bdec(3) tdec(2) keep(whether_rain wangyue c.whether_rain#c.wangyue)


	

	














