


/*

主要内容：
	2019班次数据: 描述性统计、实证分析（模型二）
用到的数据：网约_trip, 巡游_trip, weather
生成的表格&图: 表2 Panel B, 表5, 图III1

*/



// 运行数据处理脚本 data_process_shift.do
do data_process_shift.do


// 针对网约车样本构造班次、实证回归

use "网约_trip.dta", replace

* 生成行程信息
trip_info

* 根据行程间隔时长的分布确定划分班次的标准
histogram trip_gap if trip_gap > 2 & trip_gap < 24, ///
xlabel(2 (1) 24) yscale(range(0 0.2)) ylabel(0 (0.05) 0.2) ///
xtitle("小时") ///
title("行程间隔时长分布（>2 & <24）") subtitle("网约车")  scheme(s1mono) name("trip_gap_online", replace)
graph export "trip_gap_online.png", as(png) name("trip_gap_online")  replace



* 按照行程间隔时长=5小时为标准，划分班次
local shift_gap = 5
divide_shift `shift_gap'
* 构造班次信息
shift_info
* 用flag对异常值进行标注
shift_flag
* 用max_shift_flag对出现异常值的班次进行标记
bysort shift_id: egen max_shift_flag = max(flag)


// 班次信息描述性统计: 对应表2 - Panel B
sum shift_income shift_duration shift_distance if trip_id == 1 & max_shift_flag != 1   


// 生成回归所需变量
* 修改收入单位
replace shift_acc_income = shift_acc_income/100 
* 生成累积收入和累积时长的分组变量: group_accduration*  group_accincome*
gen_group_var
* 生成降雨变量: whether_rain
match_rain
* 生成控制变量: dest_week, dest_hour
gen_conrol



// 回归分析：表5

local condition " if max_shift_flag != 1 &  dest_weekday == 1"

reghdfe whether_stop whether_rain shift_acc_income shift_acc_duration  `condition', ///
absorb(driver_id dest_week dest_hour ) vce(cluster shift_id) 
est store m51
outreg2 using result5.doc, replace  bdec(3) tdec(3) keep(whether_rain shift_acc_income shift_acc_duration )


reghdfe whether_stop whether_rain group_accduration* group_accincome* `condition', ///
absorb(driver_id dest_weekday dest_hour) vce(cluster shift_id) 
est store m52
outreg2 using result5.doc, append  bdec(3) tdec(3) keep(whether_rain )


reghdfe whether_stop whether_rain c.base_group_accincome1#c.group_accduration*   c.base_group_accduration1#c.group_accincome*  ///
c.group_accduration*#c.group_accincome*  `condition', ///
absorb(driver_id dest_weekday dest_hour) vce(cluster shift_id) 
est store m53
outreg2 using result5.doc, append  bdec(3) tdec(3) keep(whether_rain)
* 后续通过python程序画二维参数图
outreg2 using result5_1.doc, replace  bdec(3) tdec(3) ///
keep(c.base_group_accincome1#c.group_accduration*   c.base_group_accduration1#c.group_accincome* c.group_accduration*#c.group_accincome*)



// 针对巡游车样本构造班次、实证回归

use "巡游_trip.dta", replace

* 生成行程信息
trip_info

* 根据行程间隔时长的分布确定划分班次的标准
histogram trip_gap if trip_gap > 2 & trip_gap < 24, ///
xlabel(2 (1) 24) yscale(range(0 0.2)) ylabel(0 (0.05) 0.2) ///
xtitle("小时") ///
title("行程间隔时长分布（>2 & <24）") subtitle("巡游车")  scheme(s1mono) name("trip_gap_cruising", replace)
graph export "trip_gap_cruising.png", as(png) name("trip_gap_cruising")  replace



* 按照行程间隔时长=6小时为标准，划分班次
local shift_gap = 6
divide_shift `shift_gap'
* 构造班次信息
shift_info
* 用flag对异常值进行标注
shift_flag
* 用max_shift_flag对出现异常值的班次进行标记
bysort shift_id: egen max_shift_flag = max(flag)


// 班次信息描述性统计: 对应表2 - Panel B
sum shift_income shift_duration shift_distance if trip_id == 1 & max_shift_flag != 1   


// 生成回归所需变量
* 修改收入单位
replace shift_acc_income = shift_acc_income/100 
* 生成累积收入和累积时长的分组变量: group_accduration*  group_accincome*
gen_group_var
* 生成降雨变量: whether_rain
match_rain
* 生成控制变量: dest_week, dest_hour
gen_conrol



// 回归分析：表5

local condition " if max_shift_flag != 1 &  dest_weekday == 1"

reghdfe whether_stop whether_rain shift_acc_income shift_acc_duration  `condition', ///
absorb(driver_id dest_week dest_hour ) vce(cluster shift_id) 
est store m54
outreg2 using result5.doc, append  bdec(3) tdec(3) keep(whether_rain shift_acc_income shift_acc_duration )


reghdfe whether_stop whether_rain group_accduration* group_accincome*  `condition', ///
absorb(driver_id dest_weekday dest_hour) vce(cluster shift_id) 
est store m55
outreg2 using result5.doc, append  bdec(3) tdec(3) keep(whether_rain )


reghdfe whether_stop whether_rain  c.base_group_accincome1#c.group_accduration*   c.base_group_accduration1#c.group_accincome*  ///
c.group_accduration*#c.group_accincome*  `condition', ///
absorb(driver_id dest_weekday dest_hour) vce(cluster shift_id) 
est store m56

outreg2 using result5.doc, append  bdec(3) tdec(3) keep(whether_rain)
* 后续通过python程序画二维参数图
outreg2 using result5_2.doc, replace  bdec(3) tdec(3) ///
keep(c.base_group_accincome1#c.group_accduration*   c.base_group_accduration1#c.group_accincome* c.group_accduration*#c.group_accincome*)















