

/*

主要内容：利用2019班次数据，研究驾驶员临时休息决策
生成的表格&图：表VII1

*/



// 针对网约车样本构造班次、实证回归

use "网约_trip.dta", replace

* 生成行程信息
trip_info


* 按照行程间隔时长=5小时为标准，划分班次
local shift_gap = 5
divide_shift `shift_gap'
* 构造班次信息
shift_info
* 用flag对异常值进行标注
shift_flag
* 用max_shift_flag对出现异常值的班次进行标记
bysort shift_id: egen max_shift_flag = max(flag)


// 生成回归所需变量
* 修改收入单位
replace shift_acc_income = shift_acc_income/100 
* 生成累积收入和累积时长的分组变量: group_accduration*  group_accincome*
gen_group_var
* 生成降雨变量: whether_rain
match_rain
* 生成控制变量: dest_week, dest_hour
gen_conrol


gen whether_break = .
replace whether_break = 0 if trip_gap <= 1
replace whether_break = 1 if  trip_gap > 1 & trip_gap < 5




// 回归分析：表VII1

local condition " if max_shift_flag != 1 &  dest_weekday == 1"

reghdfe whether_break whether_rain shift_acc_income shift_acc_duration  `condition', ///
absorb(driver_id dest_week dest_hour ) vce(cluster shift_id) 
est store mVII1


reghdfe whether_break whether_rain group_accduration* group_accincome* `condition', ///
absorb(driver_id dest_weekday dest_hour) vce(cluster shift_id) 
est store mVII2


reghdfe whether_break whether_rain c.base_group_accincome1#c.group_accduration*   c.base_group_accduration1#c.group_accincome*  ///
c.group_accduration*#c.group_accincome*  `condition', ///
absorb(driver_id dest_weekday dest_hour) vce(cluster shift_id) 
est store mVII3







// 针对巡游车样本构造班次、实证回归

use "巡游_trip.dta", replace

* 生成行程信息
trip_info


* 按照行程间隔时长=6小时为标准，划分班次
local shift_gap = 6
divide_shift `shift_gap'
* 构造班次信息
shift_info
* 用flag对异常值进行标注
shift_flag
* 用max_shift_flag对出现异常值的班次进行标记
bysort shift_id: egen max_shift_flag = max(flag)


// 生成回归所需变量
* 修改收入单位
replace shift_acc_income = shift_acc_income/100 
* 生成累积收入和累积时长的分组变量: group_accduration*  group_accincome*
gen_group_var
* 生成降雨变量: whether_rain
match_rain
* 生成控制变量: dest_week, dest_hour
gen_conrol


gen whether_break = .
replace whether_break = 0 if trip_gap <= 1
replace whether_break = 1 if  trip_gap > 1 & trip_gap < 6



// 回归分析：表5

local condition " if max_shift_flag != 1 &  dest_weekday == 1"

reghdfe whether_break whether_rain shift_acc_income shift_acc_duration  `condition', ///
absorb(driver_id dest_week dest_hour ) vce(cluster shift_id) 
est store mVII4


reghdfe whether_break whether_rain group_accduration* group_accincome*  `condition', ///
absorb(driver_id dest_weekday dest_hour) vce(cluster shift_id) 
est store mVII5


reghdfe whether_break whether_rain  c.base_group_accincome1#c.group_accduration*   c.base_group_accduration1#c.group_accincome*  ///
c.group_accduration*#c.group_accincome*  `condition', ///
absorb(driver_id dest_weekday dest_hour) vce(cluster shift_id) 
est store mVII6










