* CAUTION!!!: ABSOLUTE path set here
global OUTPATH "$PATH\结果存放"

log using "LOG", replace
* tabIII1: correlation between CAT & export upgrade 

**# import data
use "dataMech.dta", clear


**# prepare
destring year, replace
encode city, gen(icity)
order icity, after(city)
xtset icity year

replace IFDI = log(IFDI)
replace IFDIproxy = log(IFDIproxy) 
replace IFDIht = log(IFDIht)
replace IFDIg7 = log(IFDIg7)
replace IFDIother = log(IFDIother)

replace fin = log(fin)
replace passenger = log(passenger)
replace freight = log(freight)
replace sciEx = log(sciEx)
replace university = log(university)
replace professor = log(professor)

winsor2 Y*, replace cuts(1 99)
winsor2 IFDI*, replace cuts(1 99)

global X1 "Vshr1 Vshr2 fin"
global X2 "passenger freight"
global X3 "sciEx university professor"


**# PRODY

replace prody1 = log(1 + prody1)
replace prody2 = log(1 + prody2)
replace prody3 = log(1 + prody3)

reghdfe prody1 L5.Y1_7, absorb(city year) cluster(city)
outreg2 using "$OUTPATH/tabIII1", keep(L5.Y1_7) excel dec(4) addtext("city FE", "Y", "year FE", "Y")

reghdfe prody2 L5.Y1_7, absorb(city year) cluster(city)
outreg2 using "$OUTPATH/tabIII1", keep(L5.Y1_7) excel dec(4) addtext("city FE", "Y", "year FE", "Y")

reghdfe prody3 L5.Y1_7, absorb(city year) cluster(city)
outreg2 using "$OUTPATH/tabIII1", keep(L5.Y1_7) excel dec(4) addtext("city FE", "Y", "year FE", "Y")














