***************************关键变量介绍***************************
/*交通事故数据集中的关键变量：
外地原告：虚拟变量，该变量为0时表示原告、被告均来自本省（即和法院所在省相同），为1表示原告来自外省，被告来自本省，为-1时表示其他情况
外地原告_city：虚拟变量，该变量为0时表示原告、被告均来自本市（即和法院所在市相同），为1表示原告来自外市，被告来自本市，为-1时表示其他情况
外地被告：虚拟变量，该变量为0时表示原告、被告均来自本省（即和法院所在省相同），为1表示被告来自外省，原告来自本省，为-1时表示其他情况
外地被告_city：虚拟变量，该变量为0时表示原告、被告均来自本市（即和法院所在市相同），为1表示被告来自外市，原告来自本市，为-1时表示其他情况
外原外被：虚拟变量，该变量为0时表示原告、被告均来自本省（即和法院所在省相同），为1表示原告来自外省，原告来自外省，为-1时表示其他情况
外原外被_city：虚拟变量，该变量为0时表示原告、被告均来自本市（即和法院所在市相同），为1表示原告来自外市，被告来自外市，为-1时表示其他情况
win_rate_yuangao：原告胜率，为0到1的数值变量
win_rate_beigao ：被告胜率，为0到1的数值变量
win_rate_二审_yuangao 
电动车原告 ：原告驾驶非机动车，01虚拟变量，为1表示原告驾驶了非机动车
行人原告 ：原告是行人，01虚拟变量，为1表示原告是行人
death_and_injury ：原告有伤亡，01虚拟变量，为1表示原告有伤亡
上诉 ：是否上诉，01虚拟变量，为1表示上诉
jianyichengxu ：是否采用简易程序，01虚拟变量，为1表示采用
free_code ：是否采用自由裁量，01虚拟变量，为1表示采用
zhengren ：是否传唤证人，01虚拟变量，为1表示传唤
words_body ：文书正文字数
city_court:法院所在城市
qu_court:法院所在县区
reform：i城市t年是否进行司法体制改革，若进行，reform=1，反之为0
*/

use "/Volumes/Elements2/mark_data/裁判文书全量数据（已完成）/交通事故数据集.dta",clear

***************************表1 交通事故案件的描述性统计***************************

*生成type_city变量，1、2、3、4对应（本市，本市）、（本市、外市）、（外市、本市）、（外市、外市）
gen type_city=0 
replace type_city=3 if 外地原告_city==1 
replace type_city=2 if 外地被告_city==1 
replace type_city=4 if 外原外被_city==1
replace type_city=1 if 外地原告_city==0 

*生成type_pro变量，1、2、3、4对应（本省，本省）、（本省、外省）、（外省、本省）、（外省、外省）
gen type_pro=0 
replace type_pro=3 if 外地原告==1 
replace type_pro=2 if 外地被告==1 
replace type_pro=4 if 外原外被==1
replace type_pro=1 if 外地原告==0 


*案件变量全样本的描述统计
tabstat win_rate_yuangao 电动车原告 行人原告 death_and_injury 上诉 jianyichengxu free_code zhengren words_body if win_rate_yuangao!=.,stat(N mean sd min max)  format(%9.0g)       
*本地-本地、本地-外地、外地-本地、外地-外地的样本数,有近4000的样本不属于4类案件，因此总数要略小于总样本数
tabstat type_pro if type_pro!=0,by(type_pro) stat(N) 

tabstat type_city if type_city!=0,by(type_city) stat(N)

*省份层面：案件关键变量的描述统计，分案件类型
tabstat win_rate_yuangao 电动车原告 行人原告 death_and_injury 上诉 jianyichengxu free_code zhengren words_body if type_pro!=0 ,by(type_pro) stat(mean)  

*城市层面：案件关键变量的描述统计，分案件类型
tabstat win_rate_yuangao 电动车原告 行人原告 death_and_injury 上诉 jianyichengxu free_code zhengren words_body if type_city!=0,by(type_city) stat(mean)  


***************************表2 本地原告vs外地原告胜率回归结果***************************

*案件层面控制变量
global judge_yuan "电动车原告 行人原告 death_and_injury 上诉 jianyichengxu free_code zhengren words_body"

*超过99%的交通事故一审案件都是在基层法院审理，因此基准回归采用的样本为一审在基层法院的案子，only_city_court为1时表示一审发生在市级或更高级法院的交通事故案件。
gen only_city_court=0
replace only_city_court=1 if city_court!="" & qu_court==""

/*
基准回归样本里仅包含（本地，本地）、（外地，本地）的案件，即外地原告变量为0或为1的样本，不包含为-1时的样本
时间固定效应：year
市级固定效应：n_city_court 
县区级固定效应：n_qu_court 
下同
*/
qui reg win_rate_yuangao 外地原告 $judge_yuan i.year i.n_city_court if 外地原告!=-1 & only_city_court!=1, vce(cluster pro_pair_id)
est store m1_pro

qui reghdfe win_rate_yuangao 外地原告 $judge_yuan if 外地原告!=-1 & only_city_court!=1,absorb(year n_qu_court) vce(cluster pro_pair_id)
est store m2_pro

qui reg win_rate_yuangao 外地原告_city $judge_yuan i.year i.n_city_court if 外地原告_city!=-1 & only_city_court!=1, vce(cluster city_pair_id)
est store m1_city

qui reghdfe win_rate_yuangao 外地原告_city $judge_yuan if 外地原告_city!=-1 & only_city_court!=1,absorb(year n_qu_court) vce(cluster city_pair_id)
est store m2_city


esttab m1_pro m2_pro m1_city m2_city , b(3) se(3) r2(3) keep(外地原告  外地原告_city $judge_yuan ) starlevel(* 0.1 ** 0.05 *** 0.01) 

***************************表3 司法体制改革与非正式制度下的本地偏好***************************

*生成reform和外地原告、外地原告_city的交乘项
gen 外地原告_reform=外地原告*reform if 外地原告!=-1
gen 外地原告_city_reform=外地原告_city*reform if 外地原告_city!=-1

qui reg win_rate_yuangao 外地原告 reform 外地原告_reform $judge_yuan i.year i.n_city_court if 外地原告!=-1 & only_city_court!=1, vce(cluster pro_pair_id)
est store mr1

qui reghdfe win_rate_yuangao 外地原告 reform 外地原告_reform $judge_yuan if 外地原告!=-1 & only_city_court!=1,absorb(year n_qu_court) vce(cluster pro_pair_id)
est store mr2

qui reg win_rate_yuangao 外地原告_city reform 外地原告_city_reform $judge_yuan  i.year i.n_city_court if 外地原告_city!=-1 & only_city_court!=1, vce(cluster city_pair_id)
est store mr3

qui reghdfe win_rate_yuangao 外地原告_city reform 外地原告_city_reform $judge_yuan if 外地原告_city!=-1 & only_city_court!=1,absorb(year n_qu_court) vce(cluster city_pair_id)
est store mr4

esttab mr1 mr2 mr3 mr4, b(3) se(3) r2(3) keep(外地原告 外地原告_city 外地原告_reform 外地原告_city_reform $judge_yuan reform) starlevel(* 0.1 ** 0.05 *** 0.01) 

***************************表4 本地偏好的稳健性检验结果***************************

*****************Panel A: 分数响应模型、Tobit模型*****************

qui fracreg logit win_rate_yuangao 外地原告 $judge_yuan i.year i.n_city_court if 外地原告!=-1 & only_city_court!=1, vce(cluster pro_pair_id)  iter(50) tolerance(1e-6)
est store m_pro_fra

qui fracreg logit win_rate_yuangao 外地原告_city $judge_yuan i.year i.n_city_court if 外地原告_city!=-1 & only_city_court!=1, vce(cluster city_pair_id) iter(50) tolerance(1e-6)
est store m_city_fra

qui tobit win_rate_yuangao 外地原告 $judge_yuan i.year i.n_city_court if 外地原告!=-1 & only_city_court!=1, vce(cluster pro_pair_id) 
est store m_pro_tobit

qui tobit win_rate_yuangao 外地原告_city $judge_yuan i.year i.n_city_court if 外地原告_city!=-1 & only_city_court!=1, vce(cluster city_pair_id) 
est store m_city_tobit

esttab m_pro_fra m_city_fra m_pro_tobit m_city_tobit , b(3) se(3) r2(3) pr2(3) keep(外地原告  外地原告_city $judge_yuan ) starlevel(* 0.1 ** 0.05 *** 0.01) 


*****************Panel B: 二审胜率替换一审胜率*****************

*生成新的原告胜率win_rate_yuangao_替换二审，即把有二审的案件的胜率，替换为二审胜率
gen win_rate_yuangao_替换二审=win_rate_yuangao 
replace win_rate_yuangao_替换二审=win_rate_二审_yuangao if win_rate_二审_yuangao!=. 

qui reg win_rate_yuangao_替换二审 外地原告 $judge_yuan i.year i.n_city_court if 外地原告!=-1 & only_city_court!=1, vce(cluster pro_pair_id)
est store m1_pro_二审

qui reghdfe win_rate_yuangao_替换二审 外地原告 $judge_yuan if 外地原告!=-1 & only_city_court!=1,absorb(year n_qu_court) vce(cluster pro_pair_id)
est store m2_pro_二审

qui reg win_rate_yuangao_替换二审 外地原告_city $judge_yuan i.year i.n_city_court if 外地原告_city!=-1 & only_city_court!=1, vce(cluster city_pair_id)
est store m1_city_二审

qui reghdfe win_rate_yuangao_替换二审 外地原告_city $judge_yuan if 外地原告_city!=-1 & only_city_court!=1,absorb(year n_qu_court) vce(cluster city_pair_id)
est store m2_city_二审

esttab m1_pro_二审 m2_pro_二审 m1_city_二审 m2_city_二审, b(3) se(3) r2(3) keep(外地原告  外地原告_city $judge_yuan ) starlevel(* 0.1 ** 0.05 *** 0.01) 

*****************Panel C: 外地被告*****************

qui reg win_rate_beigao 外地被告 $judge_yuan i.year i.n_city_court if 外地被告!=-1 & only_city_court!=1, vce(cluster pro_pair_id)
est store m1_pro_beigao

qui reg win_rate_beigao 外地被告_city $judge_yuan i.year i.n_city_court if 外地被告_city!=-1 & only_city_court!=1, vce(cluster city_pair_id)
est store m1_city_beigao

qui reghdfe win_rate_beigao 外地被告 $judge_yuan if 外地被告!=-1 & only_city_court!=1 ,absorb(year n_qu_court) vce(cluster pro_pair_id)
est store m2_pro_beigao

qui reghdfe win_rate_beigao 外地被告_city $judge_yuan if 外地被告_city!=-1 & only_city_court!=1,absorb(year n_qu_court) vce(cluster city_pair_id)
est store m2_city_beigao

esttab m1_pro_beigao m2_pro_beigao m1_city_beigao m2_city_beigao , b(3) se(3) r2(3) keep(外地被告   外地被告_city $judge_yuan ) starlevel(* 0.1 ** 0.05 *** 0.01) 

*****************Panel D: 市级法院案件*****************

qui reg win_rate_yuangao 外地原告 $judge_yuan i.year i.n_city_court if 外地原告!=-1 & only_city_court==1, vce(cluster pro_pair_id)
est store m1_only_city

qui reg win_rate_yuangao 外地原告_city $judge_yuan i.year i.n_city_court if 外地原告_city!=-1 & only_city_court==1, vce(cluster city_pair_id)
est store m2_only_city

esttab m1_only_city m2_only_city , b(3) se(3) r2(3) keep(外地原告 外地原告_city $judge_yuan ) starlevel(* 0.1 ** 0.05 *** 0.01) 

*****************分城市本地偏好指数估计*****************
encode city_court ,gen(n_city_court_new)
gen city_id_new=n_city_court_new 

*其中_b[外地原告_city]表示外地原告_city的系数，即各城市的本地偏好指数
statsby _b[外地原告_city] e(N),by(city_id_new) saving("/Users/csh/Desktop/数据文件/分城市本地偏好指数.dta",replace):reg win_rate_yuangao 外地原告_city $judge_yuan i.year i.n_qu_court  if 外地原告_city!=-1 & only_city_court!=1  & year<=2017

***************************图1 分城市本地偏好指数***************************
use "/Users/csh/Desktop/数据文件/分城市本地偏好指数.dta",clear
rename _stat_1 本地偏好指数
*要求每个城市的样本量大于30
graph bar 本地偏好指数 if 本地偏好指数!=. & _stat_2>=30 , over(city_id_new, sort(1) descending reverse) ytitle("城市本地偏好指数") graphregion(fcolor(white))

***************************关键变量介绍***************************
/*贸易和本地偏好数据集中的关键变量（变量后面加2表示卖出地的变量）：
本地偏好指数：根据2013-2017的案件样本，分城市估计外地原告的回归系数，即为各城市的本地偏好指数
本地偏好指数_inv：买入地本地偏好指数（将估计出的本地偏好指数取相反数，即本地偏好指数_inv越大表示本地偏好程度越高）
本地偏好指数2_inv：卖出地本地偏好指数（将估计出的本地偏好指数取相反数，即本地偏好指数2_inv越大表示本地偏好程度越高）
政府支出比例:各城市一般预算支出与地区生产总值的比值
公路密度：各城市公路里程和土地面积的比值
人均_FDI：各城市人均FDI
人均_FDI_diff：城市对的人均FDI差值的绝对值，再取对数
gdp_diff：城市对的人均GDP差值的绝对值，再取对数
distance：城市对之间的距离
altitude_diff：城市对之间的海拔差距
mean_remote：城市对的偏远度均值
tri_diff：城市对的崎岖度差距
贸易总额_双边 ：城市对的贸易量
贸易金额_工业品_双边 ：城市对工业品的贸易量
人均地区生产总值元：各城市的人均GDP
年底总人口户籍人口万人：各城市年底总人口户籍人口
方言距离2015：城市对的方言距离
barrier_贸易总额：城市对的贸易成本，计算公式见原文
w_3_本地偏好指数：各城市的非当地本地偏好综合指数（delta=3） 
w_5_本地偏好指数：各城市的非当地本地偏好综合指数（delta=5）  
w_7_本地偏好指数：各城市的非当地本地偏好综合指数（delta=7） 
接受程度：基于2017年中国流动人口卫生计生动态监测调查得到的“接受”程度
排外程度：基于2017年中国流动人口卫生计生动态监测调查得到的“排外”程度
Scc：城市对的产业结构相似度
ln_贸易总量：省份对的贸易量（对数），以2017年区域间投入产出表计算
ln_贸易总量_发票：省份对的贸易量（对数），以2017年增值税发票数据计算
ln_贸易总量_工业品 ：省份对的工业品贸易量（对数），以2017年区域间投入产出表计算
ln_贸易总量_工业品_发票：省份对的工业品贸易量（对数），以2017年增值税发票数据计算
ln_贸易总量_水电燃气 ：省份对的水电燃气贸易量（对数），以2017年区域间投入产出表计算
ln_贸易总量_水电燃气_发票：省份对的水电燃气贸易量（对数），以2017年增值税发票数据计算
*/

*导入数据集
use "/Users/csh/Desktop/数据文件/贸易和本地偏好数据集.dta",clear

***************************表II1 主要指标描述性统计*************************** 
gen 政府支出比例=一般预算支出亿元/地区生产总值亿元
gen 政府支出比例2=一般预算支出亿元2/地区生产总值亿元2

gen 公路密度=公路里程公里/土地面积平方公里
gen 公路密度2=公路里程公里2/土地面积平方公里2

gen 人均_FDI=外商直接投资额实际使用额万美元/年底总人口户籍人口万人
gen 人均_FDI2=外商直接投资额实际使用额万美元2/年底总人口户籍人口万人2


*城市对数据描述统计
tabstat distance mean_remote altitude_diff river tri_diff  贸易总额_双边,stat(N mean sd min max )

*城市层面数据描述统计
preserve 
duplicates drop cityname 人均地区生产总值元 年底总人口户籍人口万人 政府支出比例 公路密度,force
tabstat 人均地区生产总值元 年底总人口户籍人口万人 政府支出比例 公路密度,stat(N mean sd min max )
restore 

***************************表5 本地偏好与地级市贸易的回归结果***************************
*为变量取对数
replace distance=log(distance)
replace altitude_diff=log(altitude_diff)
replace mean_remote=log(mean_remote)
replace tri_diff=log(tri_diff)
replace 贸易总额_双边=log(贸易总额_双边)  
replace 贸易金额_工业品_双边=log(贸易金额_工业品_双边)  
replace 人均地区生产总值元=log(人均地区生产总值元)
replace 人均地区生产总值元2=log(人均地区生产总值元2)
replace 年底总人口户籍人口万人=log(年底总人口户籍人口万人)
replace 年底总人口户籍人口万人2=log(年底总人口户籍人口万人2)
replace 方言距离2015 =log(方言距离2015)
gen barrier_贸易总额_ln=log(barrier_贸易总额)
gen 人均_FDI_diff=log(abs(人均_FDI-人均_FDI2))
gen gdp_diff=人均地区生产总值元 - 人均地区生产总值元2
replace gdp_diff=log(abs(gdp_diff))

global x "distance mean_remote altitude_diff river tri_diff"

qui reg 贸易总额_双边 边界 mean_border_num $x 人均地区生产总值元 人均地区生产总值元2 本地偏好指数_inv 本地偏好指数2_inv ,robust
est store m1

qui reg 贸易总额_双边 边界 mean_border_num $x 人均地区生产总值元 人均地区生产总值元2 本地偏好指数_inv 本地偏好指数2_inv 公路密度 公路密度2,robust
est store m2

qui reg 贸易总额_双边 边界 mean_border_num $x 人均地区生产总值元 人均地区生产总值元2 本地偏好指数_inv 本地偏好指数2_inv highway,robust
est store m3

qui reg 贸易总额_双边 边界 mean_border_num $x 人均地区生产总值元 人均地区生产总值元2 本地偏好指数_inv 本地偏好指数2_inv   方言距离2015 ,robust
est store m4

qui reg 贸易总额_双边 边界 mean_border_num $x 人均地区生产总值元 人均地区生产总值元2 本地偏好指数_inv 本地偏好指数2_inv ln_买入地向卖出地迁徙指数 ln_卖出地向买入地迁徙指数 ,robust
est store m5

esttab m1 m2 m3 m4 m5, b(3) se(3) r2(3) keep(本地偏好指数_inv 本地偏好指数2_inv  边界 mean_border_num $x 人均地区生产总值元 人均地区生产总值元2 公路密度 公路密度2 highway 方言距离2015 ln_买入地向卖出地迁徙指数 ln_卖出地向买入地迁徙指数) starlevel(* 0.1 ** 0.05 *** 0.01) 

***************************表6 本地偏好与贸易成本的回归结果***************************
qui reg barrier_贸易总额_ln 边界 mean_border_num $x 人均地区生产总值元 人均地区生产总值元2 本地偏好指数_inv 本地偏好指数2_inv,robust
est store m1

qui reg barrier_贸易总额_ln 边界 mean_border_num $x 人均地区生产总值元 人均地区生产总值元2 本地偏好指数_inv 本地偏好指数2_inv 公路密度 公路密度2  ,robust
est store m2

qui reg barrier_贸易总额_ln 边界 mean_border_num $x 人均地区生产总值元 人均地区生产总值元2 本地偏好指数_inv 本地偏好指数2_inv  highway ,robust
est store m3

qui reg barrier_贸易总额_ln 边界 mean_border_num $x 人均地区生产总值元 人均地区生产总值元2 本地偏好指数_inv 本地偏好指数2_inv   方言距离2015 ,robust
est store m4

qui reg barrier_贸易总额_ln 边界 mean_border_num $x 人均地区生产总值元 人均地区生产总值元2 本地偏好指数_inv 本地偏好指数2_inv  ln_买入地向卖出地迁徙指数 ln_卖出地向买入地迁徙指数 ,robust
est store m5

esttab m1 m2 m3 m4 m5, b(3) se(3) r2(3) keep(本地偏好指数_inv 本地偏好指数2_inv  边界 mean_border_num $x 人均地区生产总值元 人均地区生产总值元2 公路密度 公路密度2 highway 方言距离2015 ln_买入地向卖出地迁徙指数 ln_卖出地向买入地迁徙指数) starlevel(* 0.1 ** 0.05 *** 0.01) 


***************************表7 本地偏好对贸易的转移和挤出效应***************************

*delta=5，贸易量
qui reg 贸易总额_双边 边界 mean_border_num $x 本地偏好指数_inv 本地偏好指数2_inv  人均地区生产总值元 人均地区生产总值元2  w_5_本地偏好指数  w_5_本地偏好指数2,robust
est store mm1

*delta=3 ，贸易量
qui reg 贸易总额_双边 边界 mean_border_num $x 本地偏好指数_inv 本地偏好指数2_inv  人均地区生产总值元 人均地区生产总值元2  w_3_本地偏好指数 w_3_本地偏好指数2,robust
est store mm2

*delta=7，贸易量
qui reg 贸易总额_双边 边界 mean_border_num $x 本地偏好指数_inv 本地偏好指数2_inv  人均地区生产总值元 人均地区生产总值元2  w_7_本地偏好指数 w_7_本地偏好指数2,robust
est store mm3

*delta=5，贸易成本
qui reg barrier_贸易总额_ln 边界 mean_border_num $x 本地偏好指数_inv 本地偏好指数2_inv  人均地区生产总值元 人均地区生产总值元2  w_5_本地偏好指数  w_5_本地偏好指数2 ,robust
est store m2_test_1_1

*delta=3 ，贸易成本
qui reg barrier_贸易总额_ln 边界 mean_border_num $x 本地偏好指数_inv 本地偏好指数2_inv  人均地区生产总值元 人均地区生产总值元2  w_3_本地偏好指数 w_3_本地偏好指数2 ,robust
est store m2_test_1_2

*delta=7，贸易成本
qui reg barrier_贸易总额_ln 边界 mean_border_num $x 本地偏好指数_inv 本地偏好指数2_inv  人均地区生产总值元 人均地区生产总值元2  w_7_本地偏好指数 w_7_本地偏好指数2 ,robust
est store m2_test_1_3

esttab mm1 mm2 mm3 m2_test_1_1 m2_test_1_2 m2_test_1_3, b(3) se(3) r2(3) keep(边界 mean_border_num w_5_本地偏好指数  w_5_本地偏好指数2  w_3_本地偏好指数 w_3_本地偏好指数2 w_7_本地偏好指数 w_7_本地偏好指数2 人均地区生产总值元 人均地区生产总值元2 本地偏好指数_inv 本地偏好指数2_inv) starlevel(* 0.1 ** 0.05 *** 0.01) 

***************************表III1 “排外”感知与城市本地偏好指数***************************
*城市层面的数据集
preserve  
duplicates drop cityid 接受程度 排外程度 本地偏好指数_inv  人均地区生产总值元 年底总人口户籍人口万人 公路密度,force
qui reg 接受程度 本地偏好指数_inv ,robust
est store m1 
qui reg 排外程度 本地偏好指数_inv ,robust
est store m2
qui reg 接受程度 本地偏好指数_inv  人均地区生产总值元 公路密度 年底总人口户籍人口万人 政府支出比例 ,robust
est store m3 
qui reg 排外程度 本地偏好指数_inv  人均地区生产总值元  公路密度 年底总人口户籍人口万人 政府支出比例 ,robust
est store m4
restore 

esttab m1 m2 m3 m4, b(3) se(4) r2(3) keep(年底总人口户籍人口万人 本地偏好指数_inv  人均地区生产总值元  公路密度 政府支出比例) starlevel(* 0.1 ** 0.05 *** 0.01) 



***************************表IV1 本地偏好与地级市贸易的稳健性检验A***************************
gen 直辖市=0
replace 直辖市=1 if cityname=="北京市" | cityname=="上海市" | cityname=="重庆市" | cityname=="天津市" | cityname2=="北京市" | cityname2=="上海市" | cityname2=="重庆市" | cityname2=="天津市" 

gen 一线城市=0
replace 一线城市=1 if cityname=="北京市" | cityname=="上海市" | cityname=="广州市" | cityname=="深圳市" | cityname2=="北京市" | cityname2=="上海市" | cityname2=="广州市" | cityname2=="深圳市" 

gen 新一线城市=0
replace 新一线城市=1 if cityname=="成都市" | cityname=="重庆市" | cityname=="杭州市" | cityname=="西安市" | cityname=="武汉市" | cityname=="苏州市" | cityname=="郑州市" | cityname=="南京市" | cityname=="天津市" | cityname=="长沙市" | cityname=="东莞市" | cityname=="宁波市" | cityname=="佛山市" | cityname=="合肥市" | cityname=="青岛市" | cityname2=="成都市" | cityname2=="重庆市" | cityname2=="杭州市" | cityname2=="西安市" | cityname2=="武汉市" | cityname2=="苏州市" | cityname2=="郑州市" | cityname2=="南京市" | cityname2=="天津市" | cityname2=="长沙市" | cityname2=="东莞市" | cityname2=="宁波市" | cityname2=="佛山市" | cityname2=="合肥市" | cityname2=="青岛市" 

gen 计划单列市=0
replace 计划单列市=1 if cityname=="深圳市" | cityname=="厦门市" | cityname=="宁波市" | cityname=="青岛市" | cityname=="大连市"  | cityname2=="深圳市" | cityname2=="厦门市" | cityname2=="宁波市" | cityname2=="青岛市" | cityname2=="大连市"

gen 省会城市=0
replace 省会城市=1 if cityname=="济南市" | cityname=="石家庄市" | cityname=="长春市" | cityname=="哈尔滨市" | cityname=="沈阳市" | cityname=="呼和浩特市" | cityname=="乌鲁木齐市" | cityname=="兰州市" | cityname=="银川市" | cityname=="太原市" | cityname=="西安市" | cityname=="郑州市" | cityname=="合肥市" | cityname=="南京市" | cityname=="杭州市" | cityname=="福州市" | cityname=="广州市" | cityname=="南昌市" | cityname=="海口市" | cityname=="南宁市" | cityname=="贵阳市" | cityname=="长沙市" | cityname=="武汉市" | cityname=="成都市" | cityname=="昆明市" |cityname=="拉萨市" | cityname=="西宁市" | cityname2=="济南市" | cityname2=="石家庄市" | cityname2=="长春市" | cityname2=="哈尔滨市" | cityname2=="沈阳市" | cityname2=="呼和浩特市" | cityname2=="乌鲁木齐市" | cityname2=="兰州市" | cityname2=="银川市" | cityname2=="太原市" | cityname2=="西安市" | cityname2=="郑州市" | cityname2=="合肥市" | cityname2=="南京市" | cityname2=="杭州市" | cityname2=="福州市" | cityname2=="广州市" | cityname2=="南昌市" | cityname2=="海口市" | cityname2=="南宁市" | cityname2=="贵阳市" | cityname2=="长沙市" | cityname2=="武汉市" | cityname2=="成都市" | cityname2=="昆明市" |cityname2=="拉萨市" | cityname2=="西宁市" 


qui reg 贸易总额_双边 边界 mean_border_num $x 人均地区生产总值元 人均地区生产总值元2 本地偏好指数_inv 本地偏好指数2_inv if 一线城市==0 ,robust
est store m1_test_1_1

qui reg 贸易总额_双边 边界 mean_border_num $x 人均地区生产总值元 人均地区生产总值元2 本地偏好指数_inv 本地偏好指数2_inv if (新一线城市==0 | 一线城市==0),robust
est store m1_test_1_2

qui reg 贸易总额_双边 边界 mean_border_num $x 人均地区生产总值元 人均地区生产总值元2 本地偏好指数_inv 本地偏好指数2_inv if (省会城市==0 | 直辖市==0),robust
est store m1_test_1_3

qui reg 贸易总额_双边 边界 mean_border_num $x 人均地区生产总值元 人均地区生产总值元2 本地偏好指数_inv 本地偏好指数2_inv if 计划单列市==0,robust
est store m1_test_1_4

*制造业贸易量
qui reg 贸易金额_工业品_双边 边界 mean_border_num $x 人均地区生产总值元 人均地区生产总值元2 本地偏好指数_inv 本地偏好指数2_inv ,robust
est store m1_test_1_5

esttab m1_test_1_1 m1_test_1_2 m1_test_1_3 m1_test_1_4 m1_test_1_5, b(3) se(4) r2(3) keep(边界 mean_border_num $x 人均地区生产总值元 人均地区生产总值元2 本地偏好指数_inv 本地偏好指数2_inv) starlevel(* 0.1 ** 0.05 *** 0.01) 


***************************表IV2 本地偏好与地级市贸易的稳健性检验B***************************
*Scc为产业结构相似度
qui reg 贸易总额_双边 边界 mean_border_num  $x 人均地区生产总值元 人均地区生产总值元2 本地偏好指数_inv 本地偏好指数2_inv Scc ,robust
est store m1_Scc

qui reg 贸易总额_双边 边界 mean_border_num $x 人均地区生产总值元 人均地区生产总值元2 本地偏好指数_inv 本地偏好指数2_inv gdp_diff,robust
est store m1_gdp_diff

qui reg 贸易总额_双边 边界 mean_border_num $x 人均地区生产总值元 人均地区生产总值元2 本地偏好指数_inv 本地偏好指数2_inv 人均_FDI_diff,robust
est store m1_FDI_diff

esttab m1_Scc m1_gdp_diff m1_FDI_diff, b(4) se(4) r2(4) keep(本地偏好指数_inv 本地偏好指数2_inv  边界 mean_border_num $x 人均地区生产总值元 人均地区生产总值元2 Scc gdp_diff 人均_FDI_diff) starlevel(* 0.1 ** 0.05 *** 0.01) 

***************************图A1  数据可靠性验证***************************
use "/Users/csh/Desktop/数据文件/贸易数据相关性验证.dta",clear

twoway (scatter ln_贸易总量 ln_贸易总量_发票,mc(gs6) graphregion(color(gs14)) ytitle("省到省投入产出表金额，取Log") xtitle("省到省发票金额，取Log") title("省到省数据对比：对数值")) (lfit ln_贸易总量 ln_贸易总量_发票, lpattern(dash) lc(black)) 

twoway (scatter ln_贸易总量_工业品 ln_贸易总量_工业品_发票,mc(gs6) graphregion(color(gs14)) ytitle("省到省投入产出表金额，取Log") xtitle("省到省发票金额，取Log") title("省到省数据对比：对数值（工业品）")) (lfit ln_贸易总量_工业品 ln_贸易总量_工业品_发票, lpattern(dash) lc(black)) 

twoway (scatter ln_贸易总量_水电燃气 ln_贸易总量_水电燃气_发票,mc(gs6) graphregion(color(gs14)) ytitle("省到省投入产出表金额，取Log") xtitle("省到省发票金额，取Log") title("省到省数据对比：对数值（电热水燃气产品）")) (lfit ln_贸易总量_水电燃气 ln_贸易总量_水电燃气_发票, lpattern(dash) lc(black)) 




