
clear all

log using 2023-01202_logfile, text replace

*===============================================================================
**
* 本文档包括了正文和附录的代码，在提交的程序代码中，所有图表按照文中出现顺序输出
**
*===============================================================================


use 数据1,clear  //数据1 是将武汉出生队列追踪调查与空气污染数据匹配后的数据


*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
*                             以下为正文中的图表
*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>


*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*正文表2 主要变量的描述统计
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

sum Health  PM_all  PM_1_12 PM_13_28  PM_29 PM_l PM_m PM_s FS FS_1_12  FS_13_28 FS_29 ///
Prepare  Lockdown Educ Ln_Income  PM_45 Gw Sun Rain PerGDP  Density Firm


/*以下为每个变量的具体含义，这些变量都可以和正文表2一一对应。

Health    为新生儿早期健康；               PM_all   为孕期PM2.5浓度；

PM_1_12   为怀孕1-12周的PM2.5浓度；        PM_13_28 为怀孕13-28周的PM2.5浓度
 
PM_29     为怀孕29周及之后的PM2.5浓度；    PM_l     为孕期PM2.5轻度污染及以上天数

PM_m      为孕期PM2.5中度污染及以上天数；  PM_s     为孕期PM2.5重度污染及以上天数

FS        为孕期平均风速；                 FS_1_12  为怀孕1-12周的平均风速

FS_13_28  为怀孕13-28周的平均风速；        FS_29     为怀孕29周及之后的平均风速

Prepare   为是否备孕，是=1，否=0；         Lockdown 为是否封城期间怀孕，是=1，否=0；

Educ      为母亲受教育程度，为分类变量，初中及以下学历=1，高中学历=2；大专及以上学历=3；

Ln_Income 为家庭年收入（元）对数；         PM_45    为怀孕前45天PM2.5浓度；
 
Gw        为孕期高温天数（天）；           Sun      为孕期累计日照时数（小时）； 

Rain      为孕期累计降雨量（mm）；         PerGDP   为地区人均生产总值（万元）； 

Density   为人口密度  ；                   Firm     为规模以上工业企业数量。
*/




*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*正文表3 孕期空气污染对新生儿早期健康的影响
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

global control Prepare Lockdown i.Educ  Ln_Income PM_45 Gw Sun Rain PerGDP Density Firm   //所有的控制变量

global control_family Prepare Lockdown i.Educ  Ln_Income PM_45 Gw Sun Rain  //家庭层面的控制变量

* PerGDP Density Firm   为地区层面控制变量

/*Month 为新生儿的出生月份；Area为主城区虚拟变量 */

ivreg2 Health  (PM_all=FS)  $control_family   ,cluster(Community)               //正文表3第（1）列
est store m1

ivreg2 Health  (PM_all=FS)  $control       i.Month i.Area  ,cluster(Community)  //正文表3第（2）列
est store m2

ivreg2 Health  (PM_l=FS)    $control       i.Month i.Area ,cluster(Community)   //正文表3第（3）列
est store m3

ivreg2 Health  (PM_m=FS)    $control       i.Month i.Area ,cluster(Community)   //正文表3第（4）列
est store m4

ivreg2 Health  (PM_s=FS)    $control       i.Month i.Area ,cluster(Community)   //正文表3第（5）列
est store m5

esttab m1 m2 m3 m4 m5   using 正文表3.rtf, mtitle(`mt')  b(%6.4f) se(%10.4f) nogap compress  ///
order(PM_all  PM_l  PM_m PM_s ) ///
keep(PM_all  PM_l  PM_m PM_s   ) ///
            star(* 0.1 ** 0.05 *** 0.01)    replace
	

		
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*正文图1 孕期不同阶段空气污染对新生儿早期健康的影响
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	
ivregress 2sls Health (PM_1_12 PM_13_28 PM_29 = FS_1_12 FS_13_28 FS_29) $control i.Month i.Area, cluster(Community) 

/*以下代码是对上述回归系数的可视化命令*/
coefplot,  ///
keep(PM_1_12 PM_13_28 PM_29)  ///
coeflabels(PM_1_12 = "孕早期PM2.5浓度" PM_13_28 = "孕中期PM2.5浓度" PM_29 = "孕晚期PM2.5浓度") ///
vertical  ///
yline(0, lp(dash) lcolor(gs10))  ///
ytitle("不同怀孕阶段PM2.5系数")  ///
addplot(line @b @at, lcolor(black) mcolor(black) lpattern(solid)) ///
ciopts(lpattern(dash) recast(rcap) msize(medium) lcolor(black)) ///
msymbol(circle_hollow) mcolor(black) ///
ci(90) ///
graphregion(color(white) lcolor(black)) ///
plotregion(lcolor(black)) ///
xscale(noline ) xlabel(, nogrid) ///
yscale(noline ) ylabel(, nogrid)







*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*正文表4 孕期空气污染对生理性特征指标和功能性特征指标的影响
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
	
*表4 Panel A 孕期空气污染对生理性特征指标的影响

		
*Abnormal_weight  表示出生体重异常程度				
ivreg2    Abnormal_weight  (PM_all=FS)  $control       i.Month i.Area  ,cluster(Community)   //正文表4 Panel A第（1）列
est store Abnormal_weight  


*Abnormal_weak 表示早产程度
ivreg2    Abnormal_weak    (PM_all=FS)  $control       i.Month i.Area  ,cluster(Community)   //正文表4 Panel A第（2）列 
est store Abnormal_weak  
  
  
*Score  表示1分钟内阿氏评分  
ivreg2    Score            (PM_all=FS)  $control       i.Month i.Area  ,cluster(Community)   //正文表4 Panel A第（3）列  
est store Score  
  
  
*Birth_defect 表示先天性缺陷  
ivreg2    Birth_defect     (PM_all=FS)  $control       i.Month i.Area  ,cluster(Community)   //正文表4 Panel A第（4）列 
est store Birth_defect   
  
  
*Specialcare 表示特殊照料  
ivreg2    Specialcare      (PM_all=FS)  $control       i.Month i.Area  ,cluster(Community)   //正文表4 Panel A第（5）列 
est store Specialcare   
  
esttab  Abnormal_weight Abnormal_weak Score Birth_defect Specialcare  ///
using 表4Panel_A_孕期空气污染对生理性特征指标的影响.rtf, mtitle(`mt') ///
b(%6.4f) se(%10.4f) nogap compress  ///
keep(PM_all     )  star(* 0.1 ** 0.05 *** 0.01)   replace		
	



*表4 Panel B 孕期空气污染对功能性特征指标的影响	


*Zpingfen 表示Z评分	
ivreg2    Zpingfen  (PM_all=FS)  $control       i.Month i.Area  ,cluster(Community)    //正文表4 Panel B第（1）列  
est store Zpingfen  


*Sleep  表示睡眠情况
ivreg2    Sleep    (PM_all=FS)  $control       i.Month i.Area  ,cluster(Community)     //正文表4 Panel B第（2）列
est store Sleep  
  

*Communication  表示沟通能区得分
ivreg2    Communication    (PM_all=FS)  $control   i.Month i.Area  ,cluster(Community)  //正文表4 Panel B第（3）列  
est store Communication  
  

*Gross_motor 表示粗大动作能区得分
ivreg2    Gross_motor     (PM_all=FS)  $control   i.Month i.Area  ,cluster(Community)  //正文表4 Panel B第（4）列  
est store Gross_motor   
  

*Fine_motor 表示精细动作能区得分
ivreg2    Fine_motor      (PM_all=FS)  $control   i.Month i.Area  ,cluster(Community)  //正文表4 Panel B第（5）列  
est store Fine_motor   


*Problem_solving 表示解决问题能区得分  
ivreg2    Problem_solving  (PM_all=FS)  $control  i.Month i.Area  ,cluster(Community)   //正文表4 Panel B第（6）列   
est store Problem_solving  


*Persona_social 表示个人-社会能区得分
ivreg2    Persona_social    (PM_all=FS)  $control  i.Month i.Area  ,cluster(Community)  //正文表4 Panel B第（7）列   
est store Persona_social  
  
  
*Social_mood 表示社交-情绪得分 
ivreg2    Social_mood       (PM_all=FS)  $control  i.Month i.Area  ,cluster(Community)  //正文表4 Panel B第（8）列  
est store Social_mood  
  
 
/*将 正文表4 所有的模型用esttab输出*/ 
esttab  Zpingfen Sleep Communication  Gross_motor Fine_motor Problem_solving Persona_social  Social_mood  ///
using 表4Panel_B_孕期空气污染对功能性特征指标的影响.rtf, mtitle(`mt') ///
b(%6.4f) se(%10.4f) nogap compress  ///
keep(PM_all     )  star(* 0.1 ** 0.05 *** 0.01)   replace		
	
	
	
	


*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*正文表5 机制分析
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

*Complications 表示是否有孕产期并发症，是=1，否=0
ivreg2    Complications     (PM_all=FS)  $control    i.Month i.Area  ,cluster(Community)      //正文表5 第（1）列
est store Complications


ivprobit Complications      (PM_all=FS)  $control    i.Month i.Area , vce(cluster Community)   
margins, dydx(PM_all) predict(pr) post       //正文表5 第（2）列，报告IV-Pobit模型的平均边际效应
est store margins_Complications



*Check_dummy   为正文中"产前检查_离散"变量
ivreg2    Check_dummy      (PM_all=FS)  $control     i.Month i.Area  ,cluster(Community)     //正文表5 第（3）列
est store Check_dummy

ivprobit Check_dummy       (PM_all=FS)  $control     i.Month i.Area , vce(cluster Community)    
margins, dydx(PM_all) predict(pr) post     //正文表5 第（4）列，报告IV-Pobit模型的平均边际效应
est store margins_Check_dummy



*Check_continuous 为正文中"产前检查_连续"变量。
ivreg2    Check_continuous   (PM_all=FS)  $control   i.Month i.Area  ,cluster(Community)     //正文表5 第（5）列
est store Check_continuous

				
/*将 正文表5 所有的模型用esttab输出*/ 			
esttab Complications  margins_Complications Check_dummy  margins_Check_dummy Check_continuous ///
 using 表5_机制分析.rtf, mtitle(`mt')  b(%6.4f) se(%10.4f)   nogap compress  ///
keep(PM_all ) star(* 0.1 ** 0.05 *** 0.01)   replace					




*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*正文图2 孕期空气污染对新生儿早期健康影响的异质性分析
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
/*由于区分收入和母亲受教育程度的异质性时，需要将相应的变量从原本的控制变量中“拿”出来，
故本文重新定义了两个全局暂元，这两个全局暂元只会在做特定的异质性分析时用到。
*/
global Income_control   Prepare Lockdown  i.Educ   PM_45 Gw Sun Rain PerGDP Density Firm   //按收入做异质性时用到的控制变量

global educ_control    Prepare Lockdown   Ln_Income PM_45 Gw Sun Rain PerGDP Density Firm  //按新生儿母亲受教育程度做异质性时的控制变量
			
*区分社会经济地位

/*用收入刻画社会经济地位,Income表示家庭收入，单位是万元，均值是18.05457*/
ivreg2 Health  (PM_all=FS)  $Income_control i.Month i.Area  if Income<18.05457,cluster(Community)
est store low_Income


ivreg2 Health  (PM_all=FS)  $Income_control i.Month i.Area  if Income>=18.05457&Income!=.a	 ,cluster(Community)
est store high_Income


/*用房产数量刻画社会经济地位，Houses表示房产数量*/
ivreg2 Health  (PM_all=FS)  $control i.Month i.Area if Houses<=1,cluster(Community)
est store Houses_1

ivreg2 Health  (PM_all=FS)  $control i.Month i.Area if Houses>=2&Houses!=.a ,cluster(Community)
est store Houses_2


/*用母亲学历数量刻画社会经济地位，Higher_education表示母亲学历是否在本科及以上，是=1，否=0*/
ivreg2 Health  (PM_all=FS)  $educ_control  i.Month i.Area  if Higher_education==0,cluster(Community)
est store low_educ		
		
ivreg2 Health  (PM_all=FS)  $educ_control  i.Month i.Area  if Higher_education==1,cluster(Community)
est store high_educ



*区分生育年龄，Age表示女性生育年龄
ivreg2 Health (PM_all=FS)   $control  i.Month i.Area if Age<=35, cluster(Community)
est store low_Age

ivreg2 Health (PM_all=FS)   $control  i.Month i.Area if Age>35&Age!=., cluster(Community)
est store high_Age



*区分女性孕前BMI，BMI_dummy表示孕前BMI是否正常，是=1，否=0
ivreg2  Health  (PM_all=FS) $control  i.Month i.Area if BMI_dummy==0,cluster(Community)
est store BMI_normal

ivreg2  Health  (PM_all=FS) $control  i.Month i.Area if BMI_dummy==1,cluster(Community)  
est store BMI_abnormal



*区分新生儿性别，Male表示性别，男性=1，女性=0
ivreg2 Health  (PM_all=FS) $control  i.Month i.Area  if Male==1,cluster(Community)
est store Male		
		
ivreg2 Health  (PM_all=FS) $control  i.Month i.Area  if Male==0,cluster(Community)
est store feMale


*异质性分析的回归系数可视化代码，以下代码可以直接画出正文图2
coefplot (low_Income, label("低收入") ms(O) msize(2) mcolor(black))        ///
         (high_Income, label("高收入") ms(O) msize(1) mcolor(black))       ///
         (Houses_1, label("不超过1套房") ms(Oh) msize(2) mcolor(black))    ///
         (Houses_2, label("至少2套房") ms(Oh) msize(1) mcolor(black))      ///
         (low_educ, label("低学历") ms(+) ms(D) msize(2) mcolor(black))    ///
         (high_educ, label("高学历") ms(x) ms(D) msize(1) mcolor(black))   ///
         (low_Age, label("低龄产妇") ms(T) msize(2) mcolor(black))         ///
         (high_Age, label("高龄产妇") ms(T) msize(1) mcolor(black))        ///
         (BMI_normal, label("孕前BMI不正常") ms(Th) msize(2) mcolor(black)) ///
         (BMI_abnormal, label("孕前BMI正常") ms(Th) msize(1) mcolor(black)) ///
         (Male, label("男孩") ms(V) ms(Dh) msize(2) mcolor(black))         ///
         (feMale, label("女孩") ms(^) ms(Dh) msize(1) mcolor(black)),      ///
         keep(PM_all) drop(_cons) yline(0, lp(dash) lcolor(gs10))          ///
         ciopts(lpattern(dash) recast(rcap) lcolor(black))   ci(90)        ///
         ytitle("回归估计系数")                                              ///
         xtitle("")                                             ///
         graphregion(color(white) lcolor(black))                           ///
         plotregion(lcolor(black))                                         ///
         vertical nolabel                                                  ///
         xscale(noline) xlabel(1 "孕期PM2.5浓度", nogrid)                  ///
         yscale(noline) ylabel(, nogrid)                                   ///
         plotregion(margin(l+0 r+0 t+0 b+0) lcolor(black))






			 
	
*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
*                             以下为附录中的表
*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>	

*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*附录I-表I1 针对各环境监测站点空气污染的描述统计
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

use  数据2,clear   //整个do文档中，仅附录II-表II1需用到数据2，其他图表输出均使用数据1。

/*数据2 为武汉市各环境监测站点在2019年3月1日—2020年月12月31日间的空气污染数据，
  该数据存储了 站点编码  站点名称  Air_pollu Air_pollu_l  Air_pollu_m  和Air_pollu_s 这6个变量。

  Air_pollu    表示武汉市各环境监测站点在2019年3月1日—2020年月12月31日间的PM2.5浓度均值

  Air_pollu_l  表示武汉市各环境监测站点在2019年3月1日—2020年月12月31日间PM2.5浓度在轻度污染及以上的天数

  Air_pollu_m  表示武汉市各环境监测站点在2019年3月1日—2020年月12月31日间PM2.5浓度在中度污染及以上的天数 

  Air_pollu_s  表示武汉市各环境监测站点在2019年3月1日—2020年月12月31日间PM2.5浓度在重度污染及以上的天数
*/
sum Air_pollu  Air_pollu_l  Air_pollu_m  Air_pollu_s





*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*附录III-表III1 稳健性检验：删除双胞胎样本(仅保留单胎样本)
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
use  数据1,clear	

global control Prepare Lockdown i.Educ  Ln_Income PM_45 Gw Sun Rain PerGDP Density Firm   //所有的控制变量



*Twin_identify 表示是否为双胞胎，是=1，否=0
	
ivreg2 Health  (PM_all=FS)  $control     i.Month i.Area if  Twin_identify==0 ,cluster(Community) //附录III-表III1第（1）列	
est store m1	
	
ivreg2 Health  (PM_l=FS)    $control       i.Month i.Area if  Twin_identify==0 ,cluster(Community) //附录III-表III1第（2）列
est store m2

ivreg2 Health  (PM_m=FS)    $control       i.Month i.Area if  Twin_identify==0 ,cluster(Community) //附录III-表III1第（3）列
est store m3

ivreg2 Health  (PM_s=FS)    $control       i.Month i.Area if  Twin_identify==0 ,cluster(Community) //附录III-表III1第（4）列
est store m4

esttab m1 m2 m3 m4  using 附录III_表III1.rtf, mtitle(`mt')  b(%6.4f) se(%10.4f) nogap compress  ///
keep( PM_all PM_l  PM_m PM_s   )  star(* 0.1 ** 0.05 *** 0.01)    replace
	



*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*附录III-表III2 稳健性检验：控制跨市迁移因素（剔除夫妻双方都不具有武汉户口的样本）
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
*Hukouf 表示新生儿父亲是否具有武汉户口，是=1，否=0；Hukoum 表示新生儿母亲是否具有武汉户口，是=1，否=0；

ivreg2 Health  (PM_all=FS)  $control       i.Month i.Area if  Hukouf==1|Hukoum==1 ,cluster(Community) //附录III-表III2第（1）列
est store m1


ivreg2 Health  (PM_l=FS)    $control       i.Month i.Area if  Hukouf==1|Hukoum==1 ,cluster(Community) //附录III-表III2第（2）列
est store m2


ivreg2 Health  (PM_m=FS)    $control       i.Month i.Area if  Hukouf==1|Hukoum==1 ,cluster(Community) //附录III-表III2第（3）列
est store m3


ivreg2 Health  (PM_s=FS)    $control       i.Month i.Area if  Hukouf==1|Hukoum==1 ,cluster(Community) //附录III-表III2第（4）列
est store m4


esttab m1 m2 m3  m4  using 附录III_表III2.rtf, mtitle(`mt')  b(%6.4f) se(%10.4f) nogap compress  ///
keep(PM_all  PM_l  PM_m PM_s   )  star(* 0.1 ** 0.05 *** 0.01)    replace		





*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*附录III -表III3 稳健性检验：控制市内通勤因素（仅对全职妈妈进行分析）
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	

*Fulltime_mother表示是否为全职妈妈，是=1，否=0
ivreg2 Health  (PM_all=FS)  $control       i.Month i.Area if  Fulltime_mother==1 ,cluster(Community) //附录III -表III3第（1）列
est store m1


ivreg2 Health  (PM_l=FS)    $control       i.Month i.Area if  Fulltime_mother==1 ,cluster(Community) //附录III -表III3第（2）列
est store m2


ivreg2 Health  (PM_m=FS)    $control       i.Month i.Area if  Fulltime_mother==1 ,cluster(Community) //附录III -表III3第（3）列
est store m3


ivreg2 Health  (PM_s=FS)    $control       i.Month i.Area if  Fulltime_mother==1 ,cluster(Community) //附录III -表III3第（4）列
est store m4


esttab m1 m2 m3 m4  using 附录III_表III3.rtf, mtitle(`mt')  b(%6.4f) se(%10.4f) nogap compress  ///
keep( PM_all PM_l  PM_m PM_s   )  star(* 0.1 ** 0.05 *** 0.01)    replace	




*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*附录III-表III4 稳健性检验：控制考虑疫情因素
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
*Infections_number表示各区累计确诊人数
ivreg2 Health  (PM_all=FS)  $control   Infections_number    i.Month i.Area  ,cluster(Community) //附录III-表III4第（1）列
est store m1


ivreg2 Health  (PM_l=FS)    $control   Infections_number    i.Month i.Area  ,cluster(Community) //附录III-表III4第（2）列
est store m2


ivreg2 Health  (PM_m=FS)    $control   Infections_number   i.Month i.Area  ,cluster(Community)  //附录III-表III4第（3）列
est store m3


ivreg2 Health  (PM_s=FS)    $control   Infections_number    i.Month i.Area  ,cluster(Community) //附录III-表III4第（4）列
est store m4


esttab m1 m2 m3 m4  using 附录III_表III4.rtf, mtitle(`mt')  b(%6.4f) se(%10.4f) nogap compress  ///
order(PM_all  PM_l  PM_m PM_s  Infections_number ) keep( PM_all PM_l  PM_m PM_s  Infections_number )  star(* 0.1 ** 0.05 *** 0.01)    replace	






*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*附录III-表III5  稳健性检验：仅针对武汉封城前出生样本
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

*武汉是2020年1月23日开始封城，且本文样本中的新生儿都是2020年出生。因而，封城前出生的新生儿的出生月份都是2020年1月。
*因此，在针对这部分样本进行回归时，无需再控制出生月份固定效应。同理，控制变量不包括"是否封城期间怀孕"变量。

global Lockdown_control  Prepare  i.Educ  Ln_Income PM_45 Gw Sun Rain PerGDP Density Firm  

*Lockdown_birth 表示是否封城前出生，是=1，否=0

ivreg2 Health  (PM_all=FS)  $Lockdown_control     i.Area if Lockdown_birth==1 ,cluster(Community) //附录III-表III5第（1）列
est store m1	
	
	
ivreg2 Health  (PM_l=FS)    $Lockdown_control     i.Area if Lockdown_birth==1 ,cluster(Community) //附录III-表III5第（2）列
est store m2


ivreg2 Health  (PM_m=FS)    $Lockdown_control     i.Area if Lockdown_birth==1 ,cluster(Community) //附录III-表III5第（3）列
est store m3


ivreg2 Health  (PM_s=FS)    $Lockdown_control     i.Area if Lockdown_birth==1 ,cluster(Community) //附录III-表III5第（4）列
est store m4


esttab m1 m2 m3 m4  using 附录III_表III5.rtf, mtitle(`mt')  b(%6.4f) se(%10.4f) nogap compress  ///
keep(PM_all  PM_l  PM_m PM_s   )  star(* 0.1 ** 0.05 *** 0.01)    replace			
		




*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*附录III-表III6  稳健性检验：替换被解释变量
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*Health_SZ  为用熵值法测算的新生儿早期健康指数

ivreg2 Health_SZ  (PM_all=FS)  $control    i.Month i.Area  ,cluster(Community)  //附录III-表III6第（1）列
est store m1


ivreg2 Health_SZ  (PM_l=FS)    $control    i.Month i.Area  ,cluster(Community)  //附录III-表III6第（2）列
est store m2


ivreg2 Health_SZ  (PM_m=FS)    $control    i.Month i.Area  ,cluster(Community)  //附录III-表III6第（3）列
est store m3


ivreg2 Health_SZ  (PM_s=FS)    $control    i.Month i.Area  ,cluster(Community)  //附录III-表III6第（4）列
est store m4


esttab m1 m2 m3 m4  using 附录III_表III6.rtf, mtitle(`mt')  b(%6.4f) se(%10.4f) nogap compress  ///
keep( PM_all PM_l  PM_m PM_s   )  star(* 0.1 ** 0.05 *** 0.01)    replace	





*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*附录III-表III7  稳健性检验：仅保留最近距离在8公里以内的样本
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*Distance 表示到最近环境监测站点的距离，单位是米

ivreg2 Health  (PM_all=FS)  $control    i.Month i.Area if Distance<=8000  ,cluster(Community) //附录III-表III7第（1）列
est store m1

ivreg2 Health  (PM_l=FS)    $control    i.Month i.Area if Distance<=8000  ,cluster(Community) //附录III-表III7第（2）列
est store m2

ivreg2 Health  (PM_m=FS)    $control    i.Month i.Area if Distance<=8000  ,cluster(Community) //附录III-表III7第（3）列
est store m3

ivreg2 Health  (PM_s=FS)    $control    i.Month i.Area if Distance<=8000  ,cluster(Community) //附录III-表III7第（4）列
est store m4

esttab m1 m2 m3 m4  using 附录III_表III7.rtf, mtitle(`mt')  b(%6.4f) se(%10.4f) nogap compress  ///
keep( PM_all PM_l  PM_m PM_s   )  star(* 0.1 ** 0.05 *** 0.01)    replace	




*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*附录III-表III8  稳健性检验：仅保留最近距离在6公里以内的样本
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

ivreg2 Health  (PM_all=FS)  $control    i.Month i.Area if Distance<=6000  ,cluster(Community)  //附录III-表III8第（1）列
est store m1

ivreg2 Health  (PM_l=FS)    $control    i.Month i.Area if Distance<=6000  ,cluster(Community)  //附录III-表III8第（2）列
est store m2

ivreg2 Health  (PM_m=FS)    $control    i.Month i.Area if Distance<=6000 ,cluster(Community)   //附录III-表III8第（3）列
est store m3

ivreg2 Health  (PM_s=FS)    $control    i.Month i.Area if Distance<=6000 ,cluster(Community)   //附录III-表III8第（4）列
est store m4

esttab m1 m2 m3 m4  using 附录III_表III8.rtf, mtitle(`mt')  b(%6.4f) se(%10.4f) nogap compress  ///
keep(PM_all  PM_l  PM_m PM_s   )  star(* 0.1 ** 0.05 *** 0.01)    replace	




*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*  附录IV 表A1  孕期空气污染对生理性特征指标和功能性特征指标的影响（IV-Probit）
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	

*Birth_defect 表示先天性缺陷   
ivprobit Birth_defect    (PM_all=FS)  $control     i.Month i.Area , vce(cluster Community)  
margins, dydx(PM_all) predict(pr) post     // 附录IV表A1 第（1）列，报告IV-Pobit模型的平均边际效应
est store margins_Birth_defect


*Specialcare 表示特殊照料
ivprobit Specialcare    (PM_all=FS)   $control     i.Month i.Area , vce(cluster Community)   
margins, dydx(PM_all) predict(pr) post    // 附录IV表A1 第（2）列，报告IV-Pobit模型的平均边际效应
est store margins_Specialcare


*Sleep  表示睡眠情况
ivprobit Sleep    (PM_all=FS)         $control     i.Month i.Area , vce(cluster Community)   
margins, dydx(PM_all) predict(pr) post    // 附录IV表A1 第（3）列，报告IV-Pobit模型的平均边际效应
est store margins_Sleep


esttab margins_Birth_defect  margins_Specialcare  margins_Sleep   ///
 using 附录IV_表A1.rtf, mtitle(`mt')  b(%6.4f) se(%10.4f)   nogap compress  ///
keep(PM_all ) star(* 0.1 ** 0.05 *** 0.01)   replace	


log close
		
		
		
		
		
		
		









































	