	clear all

	
*---*版本	
	version 17
	
	
*---*定义路径
	global path "/Users/ruanhuirh/Desktop/Stata/01_黄金收入年龄/04_提交/结果复制_20240901Ruan/data"
	cd "${path}"
	
	
*---*2014
	*描述性统计
	use data2014,clear
	sum y1 lny1 age gender hukou marriag education health experience profess hour education_fam
	*未修正的Mincer
	global control "age age2 gender hukou education_fam education hour marriage profess health"
	reghdfe lny1 $control, absorb(employer1 industry1 province1) cformat(%9.4f)
	di "golden age=" round(_b[age]/_b[age2] * -0.5, 1)
	
	*修正后的Mincer
	replace education=education_10
	replace experience=experience_10
	replace education_fam=education_fam_10
	gen inter=age*education
	gen education2=education^2
	reghdfe lny1 $control inter education2, absorb(employer1 industry1 province1) cformat(%9.4f)
	sum education
	local e_mean=r(mean)
	di "golden age=" round((_b[age] + _b[inter] * `e_mean') / _b[age2] * -0.5, 1)	
	
	
*---*2016
	*描述性统计
	use data2016,clear
	sum y1 lny1 age gender hukou marriag education health experience profess hour education_fam
	
	*未修正的Mincer
	global control "age age2 gender hukou education_fam education hour marriage profess health"
	reghdfe lny1 $control , absorb(employer1 industry1 province1) cformat(%9.4f)
	di "golden age=" round(_b[age]/_b[age2] * -0.5, 1)
	
	*修正后的Mincer
	replace education=education_10
	replace experience=experience_10
	replace education_fam=education_fam_10
	gen inter=age*education
	gen education2=education^2
	reghdfe lny1 $control inter education2, absorb(employer1 industry1 province1) cformat(%9.4f)
	sum education
	local e_mean=r(mean)
	di "golden age=" round((_b[age] + _b[inter] * `e_mean') / _b[age2] * -0.5, 1)	
	
	
*---*2018
	*描述性统计
	use data2018,clear
	sum y1 lny1 age gender hukou marriag education health experience profess hour education_fam
	
	*未修正的Mincer
	global control "age age2 gender hukou education_fam education hour marriage profess health"
		//$employer、$industry、$province表示一系列的雇主性质、行业、省份虚拟变量，用于控制固定效应
	global employer "employer_2 employer_3 employer_4 employer_5 employer_6 employer_7 employer_8 employer_9 employer_77"
	global industry "industry_2 industry_3 industry_4 industry_5 industry_6 industry_7 industry_8 industry_9 industry_10 industry_11 industry_12 industry_13 industry_14 industry_15 industry_16 industry_17 industry_18 industry_19 industry_21 industry_99"
	global province "province_12 province_13 province_14 province_15 province_21 province_22 province_23 province_31 province_32 province_33 province_34 province_35 province_36 province_37 province_41 province_42 province_43 province_44 province_45 province_46 province_50 province_51 province_52 province_53 province_54 province_61 province_62 province_63 province_64 province_65"
	
	reghdfe lny1 $control $province $employer $industry ,cformat(%9.4f)
	di "golden age=" round(_b[age]/_b[age2] * -0.5, 1)
	
	*修正后的Mincer
	replace education=education_10
	replace experience=experience_10
	replace education_fam=education_fam_10
	gen inter=age*education
	gen education2=education^2
	reghdfe lny1 $control inter education2 $province $employer $industry ,cformat(%9.4f)
	sum education
	local e_mean=r(mean)
	di "golden age=" round((_b[age] + _b[inter] * `e_mean') / _b[age2] * -0.5, 1)
	
	*Oaxaca-Blinder分解
	gen experience2=experience^2
	gen agegroup2 =1 if age>=31 & age<=39
	replace agegroup2=0 if age>=40 &age<=60
	gen agegroup3= 1 if age>=31 & age<=39
	replace agegroup3=0 if age>=18 &age<=30
		//基准
	global controld "gender hukou education experience experience2 marriage health"
	forvalue i=2/3{
	
	oaxaca lny1 $controld  $province $industry, by(agegroup`i') weight(1) relax cformat(%9.4f)
	di "Ratio of unexplained to difference=" round(_b[unexplained]/_b[difference],0.001)
		//加入父母受教育年限
	oaxaca lny1 $controld $province $industry education_fam, by(agegroup`i') weight(1) relax cformat(%9.4f)
	di "Ratio of unexplained to difference=" round(_b[unexplained]/_b[difference],0.001)
		//加入雇主性质
	oaxaca lny1 $controld $province $industry education_fam $employer, by(agegroup`i') weight(1) relax cformat(%9.4f)
	di "Ratio of unexplained to difference=" round(_b[unexplained]/_b[difference],0.001)
		//加入职业
	oaxaca lny1 $controld $province $industry education_fam $employer profess, by(agegroup`i') weight(1) relax cformat(%9.4f)
	di "Ratio of unexplained to difference=" round(_b[unexplained]/_b[difference],0.001)
		//加入每周工作时间
	oaxaca lny1 $controld $province $industry education_fam $employer profess hour, by(agegroup`i') weight(1) relax cformat(%9.4f)
	di "Ratio of unexplained to difference=" round(_b[unexplained]/_b[difference],0.001)
	
	}
	
/* 最后测试时间：2024年9月01日21:00 */
	