
%%  Plot Figure 1 
clear; clc;
[Data11,Text11,~]=xlsread('Data_All_In_MATLAB','Figure1','B2:H9');
YbyAge1 = Data11(:,1:3);
YbyAge2 = Data11(:,4:6);
AgeVar = Text11(2:end,1)';
AgeCty = Text11(1,2:4);
figure(1);
AgeX = 1:1:length(AgeVar);
for i=1:3
    subplot(1,3,i);
    AgePlotV = spcrv([[AgeX(1) AgeX AgeX(end)];[YbyAge1(1,i) YbyAge1(:,i)' YbyAge1(end,i)]],3);
    plot(AgePlotV(1,:),AgePlotV(2,:),'color',[0 0.4470 0.7410],'LineWidth',2); hold on;
    MaxID = find(YbyAge1(:,i)==max(YbyAge1(:,i)));
    MaxY = 0.7:0.005:max(AgePlotV(2,:));
    MaxX = ones(1,size(MaxY,2))*MaxID;
    if i==1
       plot(MaxX-0.1,MaxY,'r--','LineWidth',2);
    else
       AgePlotV2 = spcrv([[AgeX(1) AgeX AgeX(end)];[YbyAge2(1,i) YbyAge2(:,i)' YbyAge2(end,i)]],3);
       plot(AgePlotV2(1,:),AgePlotV2(2,:),'k--','LineWidth',2);
       plot(MaxX-0.1,MaxY,'r--','LineWidth',2);       
    end
    hold off;
    grid on;
    set(gca,'ygrid','on','gridlinestyle',':','Gridalpha',1,'LineWidth',1.1);
    axis([1 AgeX(5) 0.7 1.2]);
    set(gca,'TickLength',[0 0]);    
    set(gca,'xtick',1:1:AgeX(end));   
    set(gca,'ytick',0.7:0.1:1.2,'FontName','Times New Roman');
    set(gca,'FontSize',14,'FontName','Times New Roman');    
    set(gca,'xticklabel',AgeVar,'FontName','Microsft YaHei UI');
    ylabel('ȫƽı','Fontname','Fangsong');
    title(AgeCty(i),'FontSize',14,'Fontname','Fangsong')
    set(gca,'FontSize',14); 
    if i>1
       L=legend({'2012','2020'},'Fontname','Microsft YaHei UI','location','southeast');
       set(L,'Orientation','vertical','Box','on','FontName','Microsft YaHei UI','FontSize',14);     
    end
end  
set(gcf,'PaperPositionMode','manual','PaperUnits','inches','PaperPosition',[0 0 14 5]);
%print(gcf,'-dpng','-r800','ͼ1.ֲ֧ĹҼȽ.jpg');  % Save figure

%% Plot Figure 2 givien the data from Fang&Qiu(2023)
clear; clc;
CNData = readtable('Data_All_In_MATLAB.xlsx','sheet','Figure2');
Cohorts = [CNData.earnings, CNData.age, CNData.cohort];
Cohort1 = Cohorts(Cohorts(:,3)==1945,1:2);
  Cohort1b = sortrows (Cohort1,2);
  Nage1 = unique(Cohort1b(:,2));
  for i=1:length(Nage1)
      Cohort1C(i,1) = mean(Cohort1b(Cohort1b(:,2)==Nage1(i,1),1));
      Cohort1C(i,2) = Nage1(i,1);    
  end
  clear i Cohort1b Cohort1;
Cohort2 = Cohorts(Cohorts(:,3)==1955,1:2);
  Cohort2b = sortrows (Cohort2,2);
  Nage2 = unique(Cohort2b(:,2));
  for i=1:length(Nage2)
      Cohort2C(i,1) = mean(Cohort2b(Cohort2b(:,2)==Nage2(i,1),1));
      Cohort2C(i,2) = Nage2(i,1);    
  end
  clear i Cohort2b Cohort2;
Cohort3 = Cohorts(Cohorts(:,3)==1965,1:2);
  Cohort3b = sortrows (Cohort3,2);
  Nage3 = unique(Cohort3b(:,2));
  for i=1:length(Nage3)
      Cohort3C(i,1) = mean(Cohort3b(Cohort3b(:,2)==Nage3(i,1),1));
      Cohort3C(i,2) = Nage3(i,1);    
  end
  clear i Cohort3b Cohort3;
Cohort4 = Cohorts(Cohorts(:,3)==1975,1:2);
  Cohort4b = sortrows (Cohort4,2);
  Nage4 = unique(Cohort4b(:,2));
  for i=1:length(Nage4)
      Cohort4C(i,1) = mean(Cohort4b(Cohort4b(:,2)==Nage4(i,1),1));
      Cohort4C(i,2) = Nage4(i,1);    
  end
  clear i Cohort4b Cohort4;
Cohort5 = Cohorts(Cohorts(:,3)==1985,1:2);
  Cohort5b = sortrows (Cohort5,2);
  Nage5 = unique(Cohort5b(:,2));
  for i=1:length(Nage5)
      Cohort5C(i,1) = mean(Cohort5b(Cohort5b(:,2)==Nage5(i,1),1));
      Cohort5C(i,2) = Nage5(i,1);    
  end
  clear i Cohort5b Cohort5;      
Cross = [CNData.earnings, CNData.age, CNData.yeargroup];
Cross6 = Cross(Cross(:,3)==6,1:2);
  Cross6b = sortrows (Cross6,2);
  NageCross6 = unique(Cross6b(:,2));
  for i=1:length(NageCross6)
      Cross6C(i,1) = mean(Cross6b(Cross6b(:,2)==NageCross6(i,1),1));
      Cross6C(i,2) = NageCross6(i,1);    
  end
  clear i Cross6b Cross6;  
figure(2)  
p1 = plot(Cohort1C(:,2),Cohort1C(:,1),'color',[0 0.4470 0.7410],'LineWidth',1); hold on;
p1.Color(4) = 0.2;
p2 = plot(Cohort2C(:,2),Cohort2C(:,1),'color',[0 0.4470 0.7410],'LineWidth',1.5); hold on;
p2.Color(4) = 0.4;
p3 = plot(Cohort3C(:,2),Cohort3C(:,1),'color',[0 0.4470 0.7410],'LineWidth',2); hold on;
p3.Color(4) = 0.6;
p4 = plot(Cohort4C(:,2),Cohort4C(:,1),'color',[0 0.4470 0.7410],'LineWidth',2.5); hold on;
p4.Color(4) = 0.8;
p5 = plot(Cohort5C(1:9,2),Cohort5C(1:9,1),'color',[0 0.4470 0.7410],'LineWidth',3); hold on;
p5.Color(4) = 1.0;
c6 = plot(Cross6C(:,2),Cross6C(:,1),'k--','LineWidth',2.5); hold off;
c6.Color(4) = 1.0;
grid on;
set(gca,'ygrid','on','gridlinestyle',':','Gridalpha',0.2,'LineWidth',1);
axis([24 60 5000 52000]);
set(gca,'TickLength',[0 0]);    
set(gca,'ytick',10000:10000:50000,'FontName','Times New Roman');
set(gca,'yticklabel',{'10000','20000','30000','40000','50000'},'FontName','Times New Roman');
set(gca,'FontSize',15,'FontName','Times New Roman');    
xlabel('','Fontname','Fangsong');
ylabel('ƽ루Ԫ','Fontname','Fangsong');
set(gca,'FontSize',15); 
L=legend({'1940-1949','1950-1959','1960-1969','1970-1979','1980-1989','-'},'Fontname','Fangsong','location','northeast');
set(L,'Orientation','vertical','Box','on','FontSize',15,'numcolumns',2); 
set(gcf,'PaperPositionMode','manual','PaperUnits','inches','PaperPosition',[0 0 10 6]);
%print(gcf,'-dpng','-r800','ͼ2.йȺ.jpg'); % Save figure


%% Load & Rearrange the Raw CFPS2018 data 
clear; clc;
[Data_P0,Text_P0] = xlsread('Data_All_In_MATLAB.xlsx','CFPS2018Person');
[Data_F0,Text_F0] = xlsread('Data_All_In_MATLAB.xlsx','CFPS2018Family');
Text_P0(2:end,:) = [];
Text_F0(2:end,:) = [];
Data_P0 = Data_P0(Data_P0(:,41)==1,:);      % Remain agents employed now
Data_P0 = Data_P0(Data_P0(:,end-1)>=0|Data_P0(:,end-1)==-8,:); % Social Security
Data_P0 = Data_P0(Data_P0(:,end)>=0|Data_P0(:,end)==-8,:);     % Dwelling Pay
for i=1:size(Data_P0,1)
    if Data_P0(i,end-1)==-8
       Data_P0(i,end-1) = 0; 
    end
    if Data_P0(i,end)==-8
       Data_P0(i,end) = 0; 
    end    
end
Data_P0(:,end-1) = Data_P0(:,end-1)*12; % Monthly Payment to Annual
Data_P0(:,end) = Data_P0(:,end)*12;
% Estimate Personal consumption (per-head household consumption)
Consum_P = Data_F0(:,15)./Data_F0(:,16);
Column_P = [1,3,8,9,11,14,17,20,26,31,33,42,47,48]; % 14 Variables and their data choosen
Data_P = Data_P0(:,Column_P);
Text_P = Text_P0(1,Column_P);
Data_P = [Data_P,zeros(size(Data_P,1),1)];    % 15rd Variable is "Consumption"
Text_P = [Text_P,'֧'];
for i=1:size(Data_F0,1)
    Data_P(Data_P(:,2)==Data_F0(i,1),end) = Consum_P(i,1);
end
Data_P = Data_P(all(~isnan(Data_P),2),:);
Data_P = Data_P(Data_P(:,10)>0,:);  % Remain Disposable Income>0
Data_P = Data_P(Data_P(:,12)>0,:);  % Remove Working Hours<=0
% Estimate Pre-tax wage income
[TaxTable,~] = xlsread('Data_All_In.xlsx','TaxTable');     % Read income tax table
TaxTable(7,3)= inf;
Wage_AT = Data_P(:,10)-3500*12; % After-tax income above the deduction line
Wage_BT = 0*Wage_AT;     % Initialize before-tax income
for i=1:size(Wage_AT,1)
    if Wage_AT(i,1)<=0   % Before-tax income below the deduction line
       Wage_BT(i,1) = Wage_AT(i,1)+3500*12;
    else
       Band = zeros(7);     % Indicator to confirm the Income band 
       for j=1:7
           Y_try = (Wage_AT(i,1)-TaxTable(j,5))/(1-TaxTable(j,4));
           if Y_try>TaxTable(j,2) && Y_try<=TaxTable(j,3) % Bcked-out before-tax income should fall into (LB, RN]
              Band(j) = 1;
           else
              Band(j) = 0;
           end              
       end
       Wage_Band = find(Band==1); % Confirm the correct income band
       Wage_BT(i,1) = (Wage_AT(i,1)-TaxTable(Wage_Band,5))/(1-TaxTable(Wage_Band,4))+3500*12;  % Calculate before-tax income
    end
    Wage_BT(i,1) = Wage_BT(i,1) + Data_P(i,13) + Data_P(i,14);   % Add back Social Security & Dwelling Pay    
end
clear i j Y_try Band Wage_Band;
Data_P = [Data_P,Wage_BT];
Text_P = [Text_P,'˰ǰ'];
% Subgroups
Data_PU = Data_P(Data_P(:,4)==1,:);       % Urban
Data_PR = Data_P(Data_P(:,4)==0,:);       % Rural
DataPU_M = Data_P(Data_PU(:,5)==1,:);     % Male
DataPU_F = Data_P(Data_PU(:,5)==0,:);     % Female
% Save the used data to a new sheet
DataP_Use = [Data_P(:,end),Data_P(:,10),Data_P(:,15),Data_P(:,7),Data_P(:,5),Data_P(:,4),Data_P(:,3),Data_P(:,11),Data_P(:,8),Data_P(:,12)];
TextP_Use = [Text_P(end),Text_P(10),Text_P(15),Text_P(7),Text_P(5),Text_P(4),Text_P(3),Text_P(11),Text_P(8),Text_P(12)];
TextP_Use2= {'Income_Pre','Income_Post','Consume','Age','Gender','IfUrban','Provin','Height','Edu','Hours'};
xlswrite('Data_All_In_MATLAB.xlsx',[TextP_Use;TextP_Use2;num2cell(DataP_Use)],'SimuData');

%% Divide the population into different Age Groups
clear; clc;
Table_Run0 = readtable('Data_All_In_MATLAB.xlsx','sheet','SimuData','range','A2:J10000');
Table_Run1 = Table_Run0(Table_Run0.Age>=18 & Table_Run0.Age<60,:);   % Baseline
% Only focus on Male and Urban & normal full-time workers (upper bound=7*16=112)
Table_Run2 = Table_Run1(Table_Run1.Gender==1 & Table_Run1.Hours>=40 & Table_Run1.Hours<=112,:);
% Estimate hour wage for each person                                 
Wages = Table_Run2.Income_Pre./Table_Run2.Hours/52;
Table_Run2.Wage = Wages;
Table_Run3 = sortrows(Table_Run2,3);  % Sort by Age
Table_Run3(Table_Run3.Wage<9.5,:) = [];
clear Wages Table_Run0 Table_Run1 Table_Run2;
Nperson = size(Table_Run3.Income_Pre,1);
Ages = (18:1:59)'; 
NAges = size(Ages,1);
% Share of pop at age of each year
ShareA = zeros(NAges,1);
CumShareA = ShareA;
for i=1:NAges
    ShareA(i,1) = sum(Table_Run3.Age==Ages(i,1))/Nperson;    % Age-group shares
    CumShareA(i,1) = sum(Table_Run3.Age<=Ages(i,1))/Nperson; % Cumulative shares
end
clear i;    
AGroup = [18-1,30,39,59];                    % Grids for Age Groups
NAGroup = size(AGroup,2)-1;                  % No. of Age Groups
AGroupName = {'Young','Middle','MiddleOld'}; % For 3 Age Groups
% Set Wage Bins by command "sum(Table_Run3.Wage>0 & Table_Run3.Wage<=3)"
WGrid = [0;10.5;11.7;13.1;14.4;16;17.3;18.6;20;22;24;26;28.5;31;35.5;40;48;63;100;180;inf];
NWbin = size(WGrid,1)-1;
WTable = zeros(NWbin,4+NAGroup*2+1);         % Statistical Table for Wage Bins
WTable(:,1) = (1:1:NWbin)';
for i=1:NWbin
    ID1 = Table_Run3.Wage>WGrid(i,1) & Table_Run3.Wage<=WGrid(i+1,1);
    WTable(i,2) = min(Table_Run3.Wage(ID1==1,1));
    WTable(i,3) = max(Table_Run3.Wage(ID1==1,1));
    WTable(i,4) = mean(Table_Run3.Wage(ID1==1,1));
    for j=1:NAGroup
        WTable(i,4+NAGroup+j) = length(find(ID1==1 & Table_Run3.Age>AGroup(1,j) & Table_Run3.Age<=AGroup(1,j+1)));
    end
end 
for i=1:NWbin
    for j=1:NAGroup % Calculate population shares across wage bins for each age-group
        WTable(i,4+j) = WTable(i,4+NAGroup+j)/sum(WTable(:,4+NAGroup+j));
    end
end
WTable(:,end) = sum(WTable(:,4+NAGroup+1:end-1),2);
for j=1:NAGroup  % Calculate age-group shares in each wage level
    RowShares(:,j)= WTable(:,4+NAGroup+j)./WTable(:,end);
end
% Save Table A1
TableA1 = [WTable(:,1:4),WTable(:,8:10),RowShares];
WTable_Name = [{'Bin','MinW','MaxW','MeanW','Young No','Middle No','MiddleOld No','Young Share','Middle Share','MiddleOld Share'}];
xlswrite('Data_All_In_MATLAB.xlsx',[WTable_Name;num2cell(TableA1)],'A1');
WTable_Name2 = [{'Bin','MinW','MaxW','MeanW','Young Share','Middle Share','MiddleOld Share','Old Share','Young No','Middle No','MiddleOld No','Old No','Total No'}];
% Save the data for plotting Figure A2 in Excel (see the plot in "Data_All_In_MATLAB.xlsx")
xlswrite('CFPS2018Download.xlsx',[WTable_Name2;num2cell(WTable)],'Statistical Table2');
clear i j ID1;

%%
% Plot Figure 3 and Figure A1
figure(3)
Table_Run0 = readtable('Data_All_In_MATLAB.xlsx','sheet','SimuData','range','A2:J10000');
Table_Run1 = Table_Run0(Table_Run0.Age>17 & Table_Run0.Age<60,:);
YAge_M(:,1) = Table_Run3.Age;
YAge_M(:,2) = Table_Run3.Income_Pre;
Table_Run3b = Table_Run1(Table_Run1.Gender==0 & Table_Run1.Hours>=40 & Table_Run1.Hours<=112,:);
Table_Run3b(Table_Run3.Wage<9.5,:) = [];
YAge_F(:,1) = Table_Run3b.Age;
YAge_F(:,2) = Table_Run3b.Income_Pre;
clear Table_Run0 Table_Run1;
subplot(1,2,1);
  dataplot1 = [YAge_M(:,1),YAge_M(:,2)/10000];
  scatter(dataplot1(:,1),dataplot1(:,2),'MarkerEdgeColor',[0 0.4470 0.7410]);                    hold on;
  [curve1,~,~] = fit(dataplot1(:,1),dataplot1(:,2),'poly3');
  coeffit1 = coeffvalues(curve1);
  xfit1 = (18:1:59)';
  yfit1 = coeffit1(1)*xfit1.^3+coeffit1(2)*xfit1.^2+coeffit1(3)*xfit1+coeffit1(4);
  plot(xfit1,yfit1,'r','LineWidth',2);                       hold off;
  axis([15 60 0 60]);  
  set(gca,'FontSize',15,'Fontname','Times New Roman'); 
  xlabel('','Fontname','Microsft YaHei UI','FontSize',15);
  ylabel('루Ԫ','Fontname','Microsft YaHei UI','FontSize',15);  
  title('Ե˰ǰ','FontName','Microsft YaHei UI','FontSize',15);
L1=legend({'',''},'Fontname','Microsft YaHei UI','location','northeast');
  set(L1,'Orientation','vertical','Box','on','FontName','Microsft YaHei UI','FontSize',15);   
subplot(1,2,2);
  dataplot2 = [YAge_F(:,1),YAge_F(:,2)/10000];
  scatter(dataplot2(:,1),dataplot2(:,2),'MarkerEdgeColor',[0 0.4470 0.7410]);  hold on;
  [curve2,~,~] = fit(dataplot2(:,1),dataplot2(:,2),'poly3');
  coeffit2 = coeffvalues(curve2);
  xfit2 = (18:1:59)';
  yfit2 = coeffit2(1)*xfit2.^3+coeffit2(2)*xfit2.^2+coeffit2(3)*xfit2+coeffit2(4);
  plot(xfit2,yfit2,'r','LineWidth',2);                       hold off;
  axis([15 55 0 50]);
  set(gca,'FontSize',15,'Fontname','Times New Roman'); 
  xlabel('','Fontname','Microsft YaHei UI','FontSize',15);
  ylabel('루Ԫ','Fontname','Microsft YaHei UI','FontSize',15);    
  title('ŮԵ˰ǰ','FontName','Microsft YaHei UI','FontSize',15);
L2=legend({'',''},'Fontname','Microsft YaHei UI','location','northeast');
  set(L2,'Orientation','vertical','Box','on','FontName','Microsft YaHei UI','FontSize',15);  
set(gcf,'PaperPositionMode','manual','PaperUnits','inches','PaperPosition',[0 0 12 7]);
%exportgraphics(gcf,'ͼ3.оԱķֲ.jpg','Resolution',800);       

% Plot Figure A1 in Appendix A
Age_Wage0 = [Table_Run3.Age,Table_Run3.Wage];  % Load data on wage and age
Age_Wage1 = sortrows(Age_Wage0,1);             % Sort the data by age 
Age_Wage_Distr = [Ages, zeros(NAges,2)];
for i=1:NAges    % Calculate the average wage for each age
    Age_Wage_temp = Age_Wage1;
    row_remove = Age_Wage1(:,1) ~= Ages(i,1);
    Age_Wage_temp(row_remove,:) = [];
    Age_Wage_Distr(i,2) = mean(Age_Wage_temp(:,2)); % Average wage for each age
    Age_Wage_Distr(i,3) = length(Age_Wage_temp)/length(Age_Wage1); % Population share for each age    
end
clear i Age_Wage0 Age_Wage_temp;
Age_Wage_Bar = zeros(9,1);
Age_WageShare = Age_Wage_Distr(:,2).*Age_Wage_Distr(:,3);
Age_Wage_Bar(1,1) = sum(Age_WageShare(1:3,1))/sum(Age_Wage_Distr(1:3,3));
for i=1:7
    Age_Wage_Bar(i+1,1) = sum(Age_WageShare(3+(i-1)*5+1:3+i*5,1))/sum(Age_Wage_Distr(3+(i-1)*5+1:3+i*5,3));    
end
Age_Wage_Bar(9,1) = sum(Age_WageShare(39:42,1))/sum(Age_Wage_Distr(39:42,3));
figure(4);
   B1=bar(Age_Wage_Bar,0.4,'Edgecolor','none');
   set(gca,'xtick',1:9);
   set(gca,'xticklabel',{'<=20','21-25','26-30','31-35','36-40','41-45','46-50','51-55','>=56'},'Fontname','Times New Roman');
   axis([0.5 9.5 0 40]);
   set(gca,'ytick',0:5:40,'Fontname','Times New Roman');
   set(gca,'TickLength',[0 0]);
   xlabel('Ⱥ壨λ꣩','Fontname','');   
   ylabel('λʣλԪ','Fontname','');
   set(gca,'FontSize',12);
   set(B1,'Facecolor',[0,.5,.5],'FaceAlpha',0.5);   
set(gcf,'PaperPositionMode','manual','PaperUnits','inches','PaperPosition',[0 0 10 6]);
%   print(gcf,'-dpng','-r800','ͼA1._λʷֲͼ.jpg');     
   

%%  *************** Main Section for Simulation ******************
clc;
warning off;                                                                                                 
options=optimset('TolCon',1e-10,'TolFun',1e-10,'TolX',1e-10,'Display','iter','MaxFunEvals',10000000,'MaxIter',5000); 
I = NWbin;      % No. of Wage Bins
J = NAGroup;    % No. of Age Groups
G = 0;          % Government spending
Wage = WTable(:,4).*ones(I,J); % Wage Bins (Columns: Age groups, Rrows: Wage Bins)
pp = WTable(:,4+1:4+NAGroup);  % Population Proportions for each age group in each wage bin
pi = zeros(1,NAGroup);
for i=1:NAGroup
    pi(1,i) = NAGroup*sum(WTable(:,4+NAGroup+i))/sum(WTable(:,end));
end
porig = pp;
pop = ones(I,J);
for j=1:J
    meanwages(j)=sum(Wage(:,j).*pp(:,j)); % Meanwage by Age group
end
meanwages;  
clear i j;
% Parameters
sigma = 3.53;   % 1/(sigma-1)=0.395 
alpha = 2.60;                                         
gamma = 1.65;   % Final Baseline
tauc  = 0.16;   % Exo commodity tax rate
transf = 0;     % Exo lump-sum transfer
% Bundles are going to be as follows:
% Cell (i,j)  gives the consumption of age group j with wage rate i,
% Cell (i,2j) gives the income of age group j with wage rate i
% All told, matrix of results is (I x 2*J)
lb(1:I,1:(2*J)) = 0.01*ones(I,(2*J));                % lower bounds
Aub=[inf];   %upper bounds
Bub=[inf];   %upper bounds
ub(1:I,1:(2*J)) = [repmat(Aub,I,J),repmat(Bub,I,J)]; % upper bounds
% Starting guesses
Ag = ones(I,J); 
Bg = ones(I,J);
guess(1:I,1:(2*J)) = [Ag,Bg];

%---------------- Optimal Model: i.e., Condition on Age ----------------
'baseline'
[z,fval,exitflag,output,lambda]=fmincon(@TaxObjectiveOptimal,guess,[],[],[],[],lb,ub,...
    @TaxConstraintOptimal,options,Wage,pp,pi,alpha,sigma,gamma,tauc,transf,I,J,G);
y = zeros(I,J);  c = zeros(I,J);  l = zeros(I,J);
for i=1:I
    for j=1:J
        c(i,j) = z(i,j);
        y(i,j) = z(i,(J+j));
        Lagrange = [ lambda.eqnonlin; lambda.ineqnonlin ];       
        l(i,j) = y(i,j)/Wage(i,j);               % Labor Effort
        t(i,j) = y(i,j)+transf-(1+tauc)*c(i,j);  % Tax Payment
        clmargin(i,j) = c(i,j)^(-gamma)-1/Wage(i,j)*alpha*l(i,j)^(sigma-1);   % C-L margin
        U(i,j) = 1/(1-gamma)*(c(i,j)^(1-gamma)-1)-alpha/sigma*(l(i,j))^sigma; % Utility
    end
end
Uj = pi.*sum(pp.*U);
Welfare = sum(Uj');  % Total welfare
clear i j;
lav = mean(l,1);     % Average labor effort
lmax = max(l,[],1);
avt = t./y;

%% Plot Figure 5.Average Tax Rates
figure(6)
  plot(y(:,1)*5760,avt(:,1),'k:','LineWidth',1.5);                      hold on;
  plot(y(:,2)*5760,avt(:,2),'color',[0 0.4470 0.7410],'LineWidth',1.5); hold on;
  plot(y(1:end-1,3)*5760,avt(1:end-1,3),'r--','LineWidth',1.5);         hold off;
  axis([10000 max(max(y*5760,[],1)) -2 1]);
  set(gca,'TickLength',[0 0]);
  grid on;
  set(gca,'FontSize',10,'Fontname','Times New Roman');
  xlabel('ģˮƽԪ','Fontname','Microsft YaHei UI','FontSize',10);
  ylabel('ģƽ˰','Fontname','Microsft YaHei UI','FontSize',10);
L1=legend({'','׳',''},'Fontname','Microsft YaHei UI','location','southeast');
  set(L1,'Orientation','vertical','Box','off','FontName','Microsft YaHei UI','FontSize',10);
set(gcf,'PaperPositionMode','manual','PaperUnits','inches','PaperPosition',[0 0 12 5]);
%exportgraphics(gcf,'ͼ5.˰ģƽ˰.jpg','Resolution',800);  

%% Plot Figure A3.Marginal Tax Rates
mtr = zeros(NWbin,NAGroup);
for i=1:NWbin
    for j=1:NAGroup
        mtr(i,j) = 1-(1+tauc)*alpha*(l(i,j)^(sigma-1))*(c(i,j)^gamma)/WTable(i,4);
    end
end
figure(7)
  plot(y(:,1)*5760,mtr(:,1),'k:','LineWidth',1.5);                      hold on;
  plot(y(:,2)*5760,mtr(:,2),'color',[0 0.4470 0.7410],'LineWidth',1.5); hold on;
  plot(y(1:end-1,3)*5760,mtr(1:end-1,3),'r--','LineWidth',1.5);         hold off;
  axis([10000 max(max(y*5760,[],1)) 0 1]);
  set(gca,'TickLength',[0 0]);
  grid on;
  set(gca,'FontSize',10,'Fontname','Times New Roman');
  xlabel('ģˮƽԪ','Fontname','Microsft YaHei UI','FontSize',10);
  ylabel('ģ߼˰','Fontname','Microsft YaHei UI','FontSize',10);
L1=legend({'','׳',''},'Fontname','Microsft YaHei UI','location','northeast');
  set(L1,'Orientation','vertical','Box','off','FontName','Microsft YaHei UI','FontSize',10);
set(gcf,'PaperPositionMode','manual','PaperUnits','inches','PaperPosition',[0 0 12 5]);
%exportgraphics(gcf,'ͼA3.˰ģı߼˰.jpg','Resolution',800);  

%% Compute the Tax Schedule (Results for Table 3)
IBs = [50000:10000:100000,120000,150000,200000,250000,300000,350000,400000,450000,500000]';
ysim = y*5760;
csim = c*5760;
tsim = ysim+transf-(1+tauc)*csim;
Taxpay = zeros(length(IBs),3);
for i=1:length(IBs)
    for j=1:3
        id = max(find(ysim(:,j)<=IBs(i,1)));
        if id<length(ysim)
            Taxpay(i,j) = tsim(id,j)+ ((tsim(id+1,j)-tsim(id,j))/(ysim(id+1,j)-ysim(id,j)))*(IBs(i,1)-ysim(id,j));
        end
    end
end
TaxTable = [IBs,Taxpay];


%% ********************** Age-Independent Model **********************
clc;
warning off;                                                                                             
options=optimset('TolCon',1e-10,'TolFun',1e-10,'TolX',1e-10,'Display','iter','MaxFunEvals',10000000,'MaxIter',5000); 
I = NWbin;      % No. of Wage Bins
J = NAGroup;    % No. of Age Groups
G = 0;          % Government spending
Wage = WTable(:,4).*ones(I,J);
pp = WTable(:,4+1:4+NAGroup); % Population Proportions for each age group in each wage bin
pi = zeros(1,NAGroup);
for i=1:NAGroup
    pi(1,i) = NAGroup*sum(WTable(:,4+NAGroup+i))/sum(WTable(:,end));
end
porig = pp;
pop = ones(I,J);
for j=1:J
    meanwages(j)=sum(Wage(:,j).*pp(:,j)); % Meanwage by Age group
end
meanwages;  
clear i j;
% Parameters
sigma = 3.53;   % 1/(sigma-1)=0.395 
alpha = 2.60;                                         
gamma = 1.65;   % Final Baseline
tauc  = 0.16;   % Exo commodity tax rate
transf = 0;     % Exo lump-sum transfer
lb(1:I,1:(2*J)) = 0.01*ones(I,(2*J));                % lower bounds
Aub=[inf];   %upper bounds
Bub=[inf];   %upper bounds
ub(1:I,1:(2*J)) = [repmat(Aub,I,J),repmat(Bub,I,J)]; % upper bounds
Ag = ones(I,J); 
Bg = ones(I,J);

pbmk0 = sum(WTable(:,4+NAGroup+1:4+NAGroup+NAGroup),2);
pbmk = ones(NWbin,NAGroup).*pbmk0/sum(pbmk0);
clear pbmk0;
guess(1:I,1:(2*J)) = [Ag,Bg];
'benchmark'
pp = pbmk;
[z4,fval,exitflag,output,lambda]=fmincon(@TaxObjectiveBenchmark,guess,[],[],[],[],lb,ub,...
    @TaxConstraintBenchmark,options,Wage,pp,alpha,sigma,gamma,tauc,transf,I,J,G);
pop = ones(I,J);
for i=1:I
    for j=1:J
        cbmk(i,j)=z4(i,j);
        ybmk(i,j)=z4(i,(J+j));
        Lagrangebmk=[ lambda.eqnonlin; lambda.ineqnonlin ];
        lbmk(i,j)=ybmk(i,j)/Wage(i,j);                % Labor Effort
        tbmk(i,j)=ybmk(i,j)+transf-(1+tauc)*cbmk(i,j); % Tax
        Ubmk(i,j)=1/(1-gamma)*(cbmk(i,j)^(1-gamma)-1)-alpha/sigma*(lbmk(i,j))^sigma; % Utility
    end
end
Ujbmk = sum(pp.*Ubmk);
Welfarebmk = sum(Ujbmk');
clear i j;
lbmkav = mean(lbmk,1);
lbmkmax = max(lbmk,[],1);
avtbmk = tbmk(:,1)./ybmk(:,1); 


%% Plot Figure 5.Welfare Comparison between Two Models
figure(8)
plot(U(:,1),'g:','LineWidth',1.5);                       hold on;
plot(U(:,2),'color',[0 0.4470 0.7410],'LineWidth',1.5);  hold on;
plot(U(:,3),'r--','LineWidth',1.5);                      hold on;
plot(Ubmk(:,2),'k-.x','LineWidth',1.5);                  hold off;
axis([1 length(Ubmk(:,2)) 1 1.5]);
grid on;
set(gca,'TickLength',[0 0]);
set(gca,'ytick',1:0.1:1.5);
set(gca,'FontSize',16,'Fontname','Times New Roman');
xlabel('λ','Fontname','Microsft YaHei UI','FontSize',16);
ylabel('˱׼Ч','Fontname','Microsft YaHei UI','FontSize',16);
LL=legend({'','׳','',''},'Fontname','Microsft YaHei UI','location','northwest');
   set(LL,'Orientation','vertical','Box','off','FontName','Microsft YaHei UI','FontSize',16);     
set(gcf,'PaperPositionMode','manual','PaperUnits','inches','PaperPosition',[0 0 12 5]);
%exportgraphics(gcf,'ͼ5.ḣȽ.jpg','Resolution',800);  


%% ********************* Benchmark with Windfall *********************
% This section calculates the windfall required to make Welfare
% in the bmk as high as in the Optimal policy as the age tax. 
% This windfall is denoted "R_bmkR" below
lb(1:I,1:(2*J+1))    = [0.01*ones(I,(2*J+1))];
guess(1:I,1:(2*J+1)) = [repmat(cbmk(:,2),1,J),repmat(ybmk(:,2),1,J),repmat(.01,I,1)];
'bmk with windfall'
pp=pbmk;
[z4,fval,exitflag,output,lambda]=fmincon(@TaxObjectiveWindfall,guess,[],[],[],[],lb,ub,...
    @TaxConstraintWindfall,options,Wage,pp,alpha,sigma,gamma,tauc,transf,I,J,G,Welfare);
for i=1:I
    for j=1:J
        cbmkR(i,j)=z4(i,j);
        ybmkR(i,j)=z4(i,(J+j));
        R_bmkR=z4(1,(2*J+1));
        Z=z4(2,(2*J+1));
        LagrangebmkR=[ lambda.eqnonlin; lambda.ineqnonlin ];
        lbmkR(i,j)=  ybmkR(i,j)/Wage(i,j);                  % Labor Effort
        tbmkR(i,j)=  ybmkR(i,j)+transf-(1+tauc)*cbmkR(i,j); % Tax
        UbmkR(i,j)=  1/(1-gamma)*(cbmkR(i,j)^(1-gamma)-1)-alpha/sigma*(lbmkR(i,j))^sigma; % Utility
    end
end
UjbmkR=       sum(pp.*UbmkR);
WelfarebmkR=  sum(UjbmkR');
totaly=sum((sum(pp.*ybmkR))');
RoverY=R_bmkR/totaly;  %Windfall as share of total output
%%Report results
format long
Wage
[y c l]
[ybmk cbmk lbmk]
[ybmkR cbmkR lbmkR]
[Welfare Welfarebmk WelfarebmkR]
RoverY

%% Inequality Reduction
% Age-Dependent
  Y1 = y(:,1).*WTable(:,8)./WTable(:,11);
  Y2 = y(:,2).*WTable(:,9)./WTable(:,11);
  Y3 = y(:,3).*WTable(:,10)./WTable(:,11);
  Y_pre0(:,1) = Y1+Y2+Y3;
  Y_pre0(:,2) = WTable(:,11)/Nperson;
  Y_pre1 = sortrows(Y_pre0,1);
  Y_pre(:,1) = cumsum(Y_pre1(:,1))/sum(Y_pre1(:,1));
  Y_pre(:,2) = cumsum(Y_pre1(:,2));
  C1 = c(:,1).*WTable(:,8)./WTable(:,11);
  C2 = c(:,2).*WTable(:,9)./WTable(:,11);
  C3 = c(:,3).*WTable(:,10)./WTable(:,11);
  C_post0(:,1) = C1+C2+C3;
  C_post0(:,2) = WTable(:,11)/Nperson;
  C_post1 = sortrows(C_post0,1);
  C_post(:,1) = cumsum(C_post1(:,1))/sum(C_post1(:,1));
  C_post(:,2) = cumsum(C_post1(:,2));
% Age-Independent with Windfall
  YBW_pre0(:,1) = ybmkR(:,2);
  YBW_pre0(:,2) = WTable(:,11)/Nperson;
  YBW_pre1 = sortrows(YBW_pre0,1);
  YBW_pre(:,1) = cumsum(YBW_pre1(:,1))/sum(YBW_pre1(:,1));
  YBW_pre(:,2) = cumsum(YBW_pre1(:,2));
  CBW_post0(:,1) = cbmkR(:,2);
  CBW_post0(:,2) = WTable(:,11)/Nperson;
  CBW_post1 = sortrows(CBW_post0,1);
  CBW_post(:,1) = cumsum(CBW_post1(:,1))/sum(CBW_post1(:,1));
  CBW_post(:,2) = cumsum(CBW_post1(:,2));

% Calculate Gini Coefficients
DC_post = zeros(NWbin,NWbin);
for i=1:NWbin
    for j=1:NWbin    
        DC_post(i,j)=abs(C_post(i,1)-C_post(j,1));
    end
end
GiniC_post = sum(sum(DC_post,2),1)/sum(C_post(:,1))/(2*NWbin);
DCBW_post = zeros(NWbin,NWbin);
for i=1:NWbin
    for j=1:NWbin    
        DCBW_post(i,j)=abs(CBW_post(i,1)-CBW_post(j,1));
    end
end
GiniCBW_post = sum(sum(DCBW_post,2),1)/sum(CBW_post(:,1))/(2*NWbin);
% Calculate Theil Indices
T1C_post = zeros(NWbin,1);
for i=1:NWbin
    T1C_post(i,1)=C_post(i,1)/mean(C_post(:,1))*(log(C_post(i,1)/mean(C_post(:,1))));
end
TheilC_post = mean(T1C_post(:,1));
T1CBW_post = zeros(NWbin,1);
for i=1:NWbin
    T1CBW_post(i,1)=CBW_post(i,1)/mean(CBW_post(:,1))*(log(CBW_post(i,1)/mean(CBW_post(:,1))));
end
TheilCBW_post = mean(T1CBW_post(:,1));

%% Estimate the Progressivity
RegY1 = log((1+tauc)*c(:,1));
RegX1 = log(y(:,1));
RegY2 = log((1+tauc)*c(:,2));
RegX2 = log(y(:,2));
RegY3 = log((1+tauc)*c(:,3));
RegX3 = log(y(:,3));
RegYAll = [RegY1;RegY2;RegY3];
RegXAll = [RegX1;RegX2;RegX3];
RegYBW = log((1+tauc)*cbmkR(:,2));
RegXBW = log(ybmkR(:,2));
Progressivity = zeros(3,5);     % Row: beta,se, P; Coulmn: 5 regressions
mdl1 = fitlm(RegX1,RegY1);
  esttable = mdl1.Coefficients;
  Progressivity(1,1) = 1-esttable.Estimate(2,1);
  Progressivity(2,1) = esttable.SE(2,1);  
  Progressivity(3,1) = esttable.pValue(2,1);
  clear esttable;
mdl2 = fitlm(RegX2,RegY2);
  esttable = mdl2.Coefficients;
  Progressivity(1,2) = 1-esttable.Estimate(2,1);
  Progressivity(2,2) = esttable.SE(2,1);  
  Progressivity(3,2) = esttable.pValue(2,1);
  clear esttable;
mdl3 = fitlm(RegX3,RegY3);
  esttable = mdl3.Coefficients;
  Progressivity(1,3) = 1-esttable.Estimate(2,1);
  Progressivity(2,3) = esttable.SE(2,1);  
  Progressivity(3,3) = esttable.pValue(2,1);
  clear esttable; 
mdl4 = fitlm(RegXAll,RegYAll);
  esttable = mdl4.Coefficients;
  Progressivity(1,4) = 1-esttable.Estimate(2,1);
  Progressivity(2,4) = esttable.SE(2,1);  
  Progressivity(3,4) = esttable.pValue(2,1);
  clear esttable;
mdl5 = fitlm(RegXBW,RegYBW);
  esttable = mdl5.Coefficients;
  Progressivity(1,5) = 1-esttable.Estimate(2,1);
  Progressivity(2,5) = esttable.SE(2,1);  
  Progressivity(3,5) = esttable.pValue(2,1);
  clear esttable;
% Variance of labor forces
VAR_Labor = [var([l(:,1);l(:,2);l(:,3)]),var(lbmkR(:,2))];
  


%% --- Objective function for Baseline
function [f] = TaxObjectiveOptimal(z,wage,p,pi,alpha,sigma,gamma,tauc,transf,I,J,G)     
for i=1:I
    for j=1:J
        c(i,j)=z(i,j);
        y(i,j)=z(i,(J+j));
        l(i,j)=y(i,j)/wage(i,j);              % Labor Effort
        t(i,j)=y(i,j)+transf-(1+tauc)*c(i,j); % Taxe
        clmargin(i,j)=c(i,j)^(-gamma)-1/wage(i,j)*alpha*l(i,j)^(sigma-1);   % C-L margin
        U(i,j)=1/(1-gamma)*(c(i,j)^(1-gamma)-1)-alpha/sigma*(l(i,j))^sigma; % Utility
     end
end
Uj = pi.*sum(p.*U);
Welfare = sum(Uj'); % Total welfare
f = -Welfare;
end
%% --- Constraints function for Baseline
function [Gineq,ceq]=TaxConstraintOptimal(z,wage,p,pi,alpha,sigma,gamma,tauc,transf,I,J,G)      
for i=1:I
    for j=1:J
          c(i,j)=z(i,j);
          y(i,j)=z(i,(J+j));
          l(i,j)=y(i,j)/wage(i,j);              % Labor Effort
          t(i,j)=y(i,j)+transf-(1+tauc)*c(i,j); % Tax
          clmargin(i,j)=c(i,j)^(-gamma)-1/wage(i,j)*alpha*l(i,j)^(sigma-1);   % C-L margin
          U(i,j)=1/(1-gamma)*(c(i,j)^(1-gamma)-1)-alpha/sigma*(l(i,j))^sigma; % Utility
    end
end
%Feasibility constraints
jtotal=pi.*sum(p.*(y-c)); % T+tauc*c = y+transf-(1+tauc)*c+tauc*c = y+transf-c
F = sum(jtotal')-G;
ceq(1) = -F;
%%%%%%%%%%%%%%%IC conditions%%%%%%%%%%%%%%%%%%%%%%%%%
    %Each person prefers to reveal their wage rather than pretend to be anyone
    %else, within each age group
    %Recall that the structure is expression<=0
for j=1:J
    for i=1:I
        for m=1:I
                Gineq((j-1)*(I*I)+(i-1)*I+m)= (1/(1-gamma)*(c(m,j)^(1-gamma)-1)-alpha/sigma*(y(m,j)/wage(i,j))^sigma)...
                                           - ((1/(1-gamma)*(c(i,j)^(1-gamma)-1)-alpha/sigma*(l(i,j))^sigma));
        end
    end
end
end

%% Objective function for Age-Independent
function [f] = TaxObjectiveBenchmark(z,wage,p,alpha,sigma,gamma,tauc,transf,I,J,G)      
for i=1:I
    for j=1:J
        c(i,j)=z(i,j);
        y(i,j)=z(i,(J+j));
        l(i,j)=  y(i,j)/wage(i,j);
        t(i,j)=  y(i,j)+transf-(1+tauc)*c(i,j);
        clmargin(i,j)= c(i,j)^(-gamma)-1/wage(i,j)*alpha*l(i,j)^(sigma-1);
        U(i,j)=  1/(1-gamma)*(c(i,j)^(1-gamma)-1)-alpha/sigma*(l(i,j))^sigma;
     end
end
Uj = sum(p.*U);
Welfare = sum(Uj');
f = -Welfare;
end
%% Constraints function for Age-Independent
function [Gineq,ceq]=TaxConstraintBenchmark(z,wage,p,alpha,sigma,gamma,tauc,transf,I,J,G);      
for i=1:I
    for j=1:J
        c(i,j)=z(i,j);
        y(i,j)=z(i,(J+j));      
        l(i,j)=  y(i,j)/wage(i,j);
        t(i,j)=  y(i,j)+transf-(1+tauc)*c(i,j);
        clmargin(i,j) = c(i,j)^(-gamma)-1/wage(i,j)*alpha*l(i,j)^(sigma-1);
        U(i,j) = 1/(1-gamma)*(c(i,j)^(1-gamma)-1)-alpha/sigma*(l(i,j))^sigma;
    end
end
%Feasibility constraints
jtotal = sum(p.*(y-c));
F = sum(jtotal')-G;
ceq(1) = -F;
%%%%%%%%%%%%%%%IC conditions%%%%%%%%%%%%%%%%%%%%%%%%%
for j=1:J
    for k=1:J
        for i=1:I
            for m=1:I
                Gineq((j-1)*J*I*I+(k-1)*(I*I)+(i-1)*I+m)= (1/(1-gamma)*(c(m,k)^(1-gamma)-1)-alpha/sigma*(y(m,k)/wage(i,k))^sigma)...
                                                       - ((1/(1-gamma)*(c(i,j)^(1-gamma)-1)-alpha/sigma*(l(i,j))^sigma));
            end
        end
    end
end
end

%% Objective function for Age-Independent with Windfall
function [f] = TaxObjectiveWindfall(z,wage,p,alpha,sigma,gamma,tauc,transf,I,J,G,Welfare);      
for i=1:I
    for j=1:J
        c(i,j)=z(i,j);
        y(i,j)=z(i,(J+j));
        R_bmkR=z(1,(2*J+1));
        Z=z(2,(2*J+1));
        l(i,j)=  y(i,j)/wage(i,j);
        t(i,j)=  y(i,j)+transf-(1+tauc)*c(i,j);
        clmargin(i,j)= c(i,j)^(-gamma)-1/wage(i,j)*alpha*l(i,j)^(sigma-1);
        U(i,j)=  1/(1-gamma)*(c(i,j)^(1-gamma)-1)-alpha/sigma*(l(i,j))^sigma;
     end
end
Uj = sum(p.*U);
Welfare = sum(Uj');
MinR = R_bmkR;        
f = MinR;
end
%% Constraints function for Age-Independent with Windfall
function [Gineq,ceq]=TaxConstraintWindfall(z,wage,p,alpha,sigma,gamma,tauc,transf,I,J,G,Welfare);      
for i=1:I
    for j=1:J
        c(i,j)=z(i,j);
        y(i,j)=z(i,(J+j));
        R_bmkR=z(1,(2*J+1));
        Z=z(2,(2*J+1));
        l(i,j)=  y(i,j)/wage(i,j);
        t(i,j)=  y(i,j)+transf-(1+tauc)*c(i,j);
        clmargin(i,j)= c(i,j)^(-gamma)-1/wage(i,j)*alpha*l(i,j)^(sigma-1);
        U(i,j)=  1/(1-gamma)*(c(i,j)^(1-gamma)-1)-alpha/sigma*(l(i,j))^sigma;
    end
end
UjbmkR = sum(p.*U);
WelfarebmkR = sum(UjbmkR');
%Feasibility constraints
jtotal=sum(p.*(y-c));
F = sum(jtotal')+R_bmkR-G;
ceq(1) = -F;
%Compensation constraint
ceq(2) = -WelfarebmkR+Welfare; 
%%%%%%%%%%%%%%%IC conditions%%%%%%%%%%%%%%%%%%%%%%%%%
for j=1:J
    for k=1:J
        for i=1:I
            for m=1:I
                Gineq((j-1)*J*I*I+(k-1)*(I*I)+(i-1)*I+m)= (1/(1-gamma)*(c(m,k)^(1-gamma)-1)-alpha/sigma*(y(m,k)/wage(i,k))^sigma)...
                                                        -((1/(1-gamma)*(c(i,j)^(1-gamma)-1)-alpha/sigma*(l(i,j))^sigma));
            end
        end
    end
end
end
