*******************************
*      三峡大坝code汇总       *
*         24.8.29             *
*******************************
clear
cd "D:\copy_working\12.13sanxia\24.8最终"
global raw .\raw_data
global temporary .\temporary
global table .\table
global figure .\figure

log using logfile,replace
***************************************TABLE***************************************

*******************************************************
*                  baseline                           *
*******************************************************
*--------------表1:三峡大坝蓄水和企业出口额的基准回归
use $temporary/send_data, clear
global con1 lnage lnsize lnlabor 
global con2 lnage lnsize lnlabor profit lngdp openness lnpeople 
reghdfe lnexport treat_year03 ,absorb(  id year   ) vce(cluster county_code)
estimates store e1
reghdfe lnexport treat_year03 ,absorb(  id  year_sector ) vce(cluster county_code)
estimates store e2
reghdfe lnexport treat_year03 $con1 ,absorb(  id  year_sector ) vce(cluster county_code)
estimates store e3
reghdfe lnexport treat_year03 $con2 ,absorb(  id  year_sector ) vce(cluster county_code)
estimates store e4
reghdfe lnexport treat_year03  $con2 lnrailway lnhighway ,absorb(  id  year_sector ) vce(cluster county_code)
estimates store e5
reghdfe lnexport treat_year03  $con2 lnrailway lnhighway if year!=2010,absorb(  id  year_sector ) vce(cluster county_code) 
estimates store e6
outreg2 [  e1 e2 e3 e4 e5 e6] using "$table\1出口额基准回归.docx",replace bdec(4) sdec(4)



*******************************************************
*                  稳健性检验                         *
*******************************************************
*---------------表2：借助三峡蓄水高度进行估计的结果
use $temporary/send_data, clear

reghdfe lnexport shuiweiceshi1  ,absorb(  id  year_sector) vce(cluster county_code)
estimates store shuiwei1
reghdfe lnexport shuiweiceshi1  $con2 lnrailway lnhighway,absorb(  id year_sector) vce(cluster county_code)
estimates store shuiwei2
reghdfe lnexport shuiweiceshi1 $con2 lnrailway lnhighway if year!=2010,absorb(  id    year_sector) vce(cluster county_code)
estimates store shuiwei3
outreg2 [  shuiwei1 shuiwei2 shuiwei3 ] using "$table\2wenjian_height.docx",replace bdec(4) sdec(4)



*******************************************************
*                         机制                        *
*******************************************************
*************************表3：渠道识别-水运运输成本依赖
use $temporary/send_data, clear
duplicates drop 水运成本占比,force //每类行业有该行业水运成本占比的数据，不同行业该成本都不同，这里只保留每个行业一个观测，从而计算行业的55%分位数
keep 水运成本占比
egen x = pctile(水运成本占比), p(55) //得到行业层面的55%分位数：0.4554712
tab x
/*
          x |      Freq.     Percent        Cum.
------------+-----------------------------------
   .4554712 |         77      100.00      100.00
------------+-----------------------------------
      Total |         77      100.00
*/

use $temporary/send_data, clear
gen Heavy1=1 if 水运成本占比>=0.4554712 //0.4554712来自egen x = pctile(水运成本占比), p(55) 中x值的值，是55%分位数
replace Heavy1=0 if 水运成本占比<=0.4554712 
replace Heavy1=. if 水运成本占比==.
* replace Heavy1=0 if Heavy1==. 
gen DDD= treat_year03*Heavy1
gen 水运成本DD=Heavy1*year03
gen DD=Heavy1*river_index
** 计算总的运输成本占比的实证结果；
reghdfe lnexport DDD  treat_year03 水运成本DD DD ,absorb(  id year    ) vce(cluster county_code)
estimates store chengben1
reghdfe lnexport DDD  treat_year03 水运成本DD DD lnrailway lnhighway ,absorb(  id year    ) vce(cluster county_code)
estimates store chengben2
reghdfe lnexport DDD  treat_year03 水运成本DD DD $con2 lnrailway lnhighway ,absorb(  id year   ) vce(cluster county_code)
estimates store chengben3
reghdfe lnexport DDD  treat_year03 水运成本DD DD $con2 lnrailway lnhighway if year!=2010,absorb(  id year   ) vce(cluster county_code)
estimates store chengben4
outreg2 [ chengben1 chengben2 chengben3 chengben4] using "$table\3渠道识别.docx",replace bdec(4) sdec(4)
*************************表4:渠道识别-增加水路运输概率
use $temporary/send_data, clear

reghdfe yanhaihaiguan treat_year03   ,absorb(  id  year_sector  ) vce(cluster county_code)
estimates store jizhi1 
reghdfe yanhaihaiguan treat_year03  $con1   ,absorb(  id year  year_sector ) vce(cluster county_code)
estimates store jizhi2 
reghdfe yanhaihaiguan treat_year03  $con2  ,absorb(  id year_sector  ) vce(cluster county_code)
estimates store jizhi3 
reghdfe yanhaihaiguan treat_year03  $con2 lnrailway lnhighway ,absorb(  id   year_sector ) vce(cluster county_code)
estimates store jizhi4
reghdfe yanhaihaiguan treat_year03  $con2 lnrailway lnhighway if year!=2010,absorb(  id   year_sector ) vce(cluster county_code)
estimates store jizhi5
outreg2 [  jizhi1 jizhi2 jizhi3 jizhi4 jizhi5] using "$table\4haiguan.docx",replace bdec(4) sdec(4)

*----------------------------------------------------------------------------*
*******************************************************
*                         附表                        *
*******************************************************
use $temporary/send_data, clear
*-------------------------表A2：变量描述性统计
gen Heavy1=1 if 水运成本占比>0.4554712
replace Heavy1=0 if 水运成本占比<=0.4554712
order lnexport lndiversity2 treat_year03 $con2   lnrailway lnhighway yanhaihaiguan Heavy1
keep lnexport lndiversity2 treat_year03 $con2   lnrailway lnhighway yanhaihaiguan Heavy1
outreg2 using "$table\A2描述性.doc", replace sum(log) title(Decriptive statistics)

*-------------------------表A3:出口额预期效应检验
use $temporary/send_data, clear
reghdfe lnexport treat_year03 treat_year02 $con1 lnrailway lnhighway ,absorb(  id    year year_sector ) vce(cluster county_code)
estimates store yuqi11
reghdfe lnexport treat_year03 treat_year02 $con2 lnrailway lnhighway ,absorb(  id    year_sector ) vce(cluster county_code)
estimates store yuqi12
reghdfe lnexport treat_year03 treat_year02 $con2 lnrailway lnhighway if year!=2010,absorb(  id    year_sector ) vce(cluster county_code)
estimates store yuqi13
reghdfe lnexport treat_year03 treat_year01 $con1 lnrailway lnhighway ,absorb(  id    year_sector ) vce(cluster county_code)
estimates store yuqi14
reghdfe lnexport treat_year03 treat_year01 $con2 lnrailway lnhighway ,absorb(  id    year_sector ) vce(cluster county_code)
estimates store yuqi15
reghdfe lnexport treat_year03 treat_year01 $con2 lnrailway lnhighway if year!=2010,absorb(  id    year_sector ) vce(cluster county_code) 
estimates store yuqi16
outreg2 [ yuqi11 yuqi12 yuqi13 yuqi14 yuqi15 yuqi16] using "$table\A3出口额预期.docx",replace bdec(4) sdec(4)

*---------------------------表A4：三峡大坝蓄水和企业出口产品多样性的基准回归
use $temporary/send_data, clear
reghdfe lndiversity2 treat_year03 ,absorb(  id year  ) vce(cluster county_code)
estimates store chan1
reghdfe lndiversity2 treat_year03 ,absorb(  id  year_sector ) vce(cluster county_code)
estimates store chan2
reghdfe lndiversity2 treat_year03 $con1 ,absorb(  id  year_sector ) vce(cluster county_code)
estimates store chan3
reghdfe lndiversity2 treat_year03 $con2 ,absorb(  id  year_sector ) vce(cluster county_code)
estimates store chan4
reghdfe lndiversity2 treat_year03  $con2 lnrailway lnhighway ,absorb(  id  year_sector ) vce(cluster county_code)
estimates store chan5
reghdfe lndiversity2 treat_year03  $con2 lnrailway lnhighway if year!=2010,absorb(  id  year_sector ) vce(cluster county_code)
estimates store chan6
outreg2 [  chan1 chan2 chan3 chan4 chan5 chan6] using "$table\A4出口产品基准回归.docx",replace bdec(4) sdec(4)

*---------------------------表A5:PSM-DID估计结果& 图A5-A7
use $temporary/send_data, clear
ren lngdp GDP
global xlist  " lnage lnsize lnlabor profit GDP openness lnpeople  lnrailway lnhighway "
set  seed 10000
gen  norvar_1 = runiform()
sort norvar_1
psmatch2 处理组 $xlist , outcome(lnexport) logit neighbor(1) ate ties common caliper(0.05) 
pstest $xlist , both graph
graph export "$figure/平衡检验.png", replace
//倾向得分值的核密度图
sum _pscore if 处理组 == 1, detail  //
*- 匹配前
sum _pscore if 处理组 == 0, detail
twoway(kdensity _pscore if 处理组 == 1, lpattern(solid)                     ///
              lcolor(black)                                                  ///
              lwidth(thin)                                                   ///
              scheme(qleanmono)                                              ///
              ytitle("{stSans:核}""{stSans:密}""{stSans:度}",                ///
                     size(medlarge) orientation(h))                          ///
              xtitle("{stSans:匹配前的倾向得分值}",                          ///
                     size(medlarge))                                         ///
              xline(0.5632   , lpattern(solid) lcolor(black))                ///
              xline(`r(mean)', lpattern(dash)  lcolor(black))                ///
              saving($figure/kensity_cs_before.png, replace))                            ///
      (kdensity _pscore if 处理组 == 0, lpattern(dash)),                    ///
      xlabel(     , labsize(medlarge) format(%02.1f))                        ///
      ylabel(0(1)4, labsize(medlarge))                                       ///
      legend(label(1 "{stSans:treated}")                                      ///
             label(2 "{stSans:untreated}")                                      ///
             size(medlarge) position(1) symxsize(10))

graph export "$figure/kensity_cs_before.png", replace
discard
*- 匹配后
sum _pscore if 处理组 == 0 & _weight != ., detail //均值0.5320

twoway(kdensity _pscore if 处理组 == 1, lpattern(solid)                     ///
              lcolor(black)                                                  ///
              lwidth(thin)                                                   ///
              scheme(qleanmono)                                              ///
              ytitle("{stSans:核}""{stSans:密}""{stSans:度}",                ///
                     size(medlarge) orientation(h))                          ///
              xtitle("{stSans:匹配后的倾向得分值}",                          ///
                     size(medlarge))                                         ///
              xline(0.5632   , lpattern(solid) lcolor(black))                ///
              xline(`r(mean)', lpattern(dash)  lcolor(black))                ///
              saving($figure/kensity_cs_after.png, replace))                             ///
      (kdensity _pscore if 处理组 == 0 & _weight != ., lpattern(dash)),     ///
      xlabel(     , labsize(medlarge) format(%02.1f))                        ///
      ylabel(0(1)4, labsize(medlarge))                                       ///
      legend(label(1 "{stSans:treated}")                                      ///
             label(2 "{stSans:untreated}")                                      ///
             size(medlarge) position(1) symxsize(10))
graph export "$figure/kensity_cs_after.png", replace

sum id if _weight ==.
drop if _weight ==.
reghdfe lnexport treat_year03 if _weight !=. ,absorb(  id year_sector  ) vce(cluster county_code)
estimates store 倾向1
reghdfe lnexport treat_year03  lnage lnsize lnlabor if _weight !=. ,absorb(  id year_sector     ) vce(cluster county_code)
estimates store 倾向2
reghdfe lnexport treat_year03  lnage lnsize lnlabor profit GDP  openness lnpeople  if _weight !=. ,absorb(  id  year_sector    ) vce(cluster county_code)
estimates store 倾向3
reghdfe lnexport treat_year03  lnage lnsize lnlabor profit GDP  openness lnpeople  lnrailway lnhighway if _weight !=.,absorb(  id year_sector) vce(cluster county_code)
estimates store 倾向4
reghdfe lnexport treat_year03  lnage lnsize lnlabor profit GDP  openness lnpeople  lnrailway lnhighway if _weight !=.& year!=2010,absorb(  id year_sector) vce(cluster county_code)
estimates store 倾向5
outreg2 [  倾向1 倾向2 倾向3 倾向4 倾向5] using "$table\A5wenjian_psm.docx",replace bdec(4) sdec(4)




*---------------------------表A6：剔除部分省份样本的回归结果
use $temporary/send_data, clear
ge shang=0
replace shang=1 if 省自治区直辖市=="西藏自治区"
replace shang=1 if 省自治区直辖市=="青海省"
replace shang=1 if 省自治区直辖市=="云南省"
reghdfe lnexport treat_year03  $con2 lnrailway lnhighway ,absorb(  id year_sector   ) vce(cluster county_code)
estimates store tichu11
reghdfe lnexport treat_year03  $con2 lnrailway lnhighway if shang==0,absorb(  id year_sector   ) vce(cluster county_code)
estimates store tichu12
*进一步剔除四川和重庆样本
replace shang=1 if 省自治区直辖市=="四川省"
replace shang=1 if 省自治区直辖市=="重庆市"
reghdfe lnexport treat_year03  $con2 lnrailway lnhighway if shang==0,absorb(  id year_sector   ) vce(cluster county_code)
estimates store tichu13
**剔除上海企业样本
ge shanghai=0
replace shanghai=1 if 省自治区直辖市=="上海市"
replace shang=1 if shanghai==1
reghdfe lnexport treat_year03 $con2 lnrailway lnhighway if shang==0,absorb(  id year_sector   ) vce(cluster county_code)
estimates store tichu14
outreg2 [   tichu11  tichu12  tichu13  tichu14  ] using "$table\A6wenjian_subsample.docx",replace bdec(4) sdec(4)


*-----------------------------表A7：基于中上游和下游的异质性分析结果
use $temporary/send_data, clear

reghdfe lnexport treat_year03 $con2  lnrailway lnhighway if shengfen==0,absorb(  id year  ) vce(cluster county_code)
estimates store yizhi1
reghdfe lnexport treat_year03 $con2  lnrailway lnhighway if shengfen==0 &year!=2010,absorb(  id year  ) vce(cluster county_code)
estimates store yizhi2


reghdfe lnexport treat_year03 $con2 lnrailway lnhighway if shengfen==1,absorb(  id year    ) vce(cluster county_code)
estimates store yizhi3
reghdfe lnexport treat_year03 $con2 lnrailway lnhighway if shengfen==1&year!=2010,absorb(  id year ) vce(cluster county_code)
estimates store yizhi4
outreg2 [   yizhi1 yizhi2 yizhi3 yizhi4  ] using "$table\A7上中下游.docx",replace bdec(4) sdec(4)
*bdiff,group(shengfen)  model(reghdfe lnexport treat_year03  $con2 lnrailway lnhighway ,absorb(  id  year_sector ) vce(cluster county_code)) r(100)

*----------------------------表A8：基于企业性质的异质性分析结果
use $temporary/send_data, clear
reghdfe lnexport treat_year03  $con2 if guoyou==1,absorb(  id year_sector ) vce(cluster county_code)
estimates store guo11
reghdfe lnexport treat_year03  $con2 lnrailway lnhighway if guoyou ==1,absorb(  id   year_sector ) vce(cluster county_code)
estimates store guo12
reghdfe lnexport treat_year03  $con2 lnrailway lnhighway if guoyou ==1 & year!=2010,absorb(  id   year_sector ) vce(cluster county_code)
estimates store guo13
reghdfe lnexport treat_year03  $con2 if feiguoyou==1,absorb(  id  year_sector ) vce(cluster county_code)
estimates store guo21
reghdfe lnexport treat_year03  $con2 lnrailway lnhighway if feiguoyou ==1,absorb(  id   year_sector ) vce(cluster county_code)
estimates store guo22
reghdfe lnexport treat_year03  $con2 lnrailway lnhighway if feiguoyou ==1&year!=2010,absorb(  id   year_sector ) vce(cluster county_code)
estimates store guo23
outreg2 [  guo11 guo12 guo13  guo21 guo22 guo23] using "$table\A8国有非国有.docx",replace bdec(4) sdec(4)

*bdiff,group(guoyou) model(reghdfe lnexport treat_year03  $con2 lnrailway lnhighway ,absorb(  id  year_sector ) vce(cluster county_code)) r(100)

*-----------------------------表A9：基于企业规模的异质性分析结果
astile type = 主营业务产品销售收入千元 , nq(2)
reghdfe lnexport treat_year03  $con2  if type==1,absorb(  id  year_sector ) vce(cluster county_code)
estimates store guimo11
reghdfe lnexport treat_year03  $con2 lnrailway lnhighway if type==1,absorb(  id  year_sector ) vce(cluster county_code)
estimates store guimo12
reghdfe lnexport treat_year03  $con2 lnrailway lnhighway if type==1&year!=2010,absorb(  id  year_sector ) vce(cluster county_code)
estimates store guimo13

reghdfe lnexport treat_year03  $con2 if type==2,absorb(  id  year_sector ) vce(cluster county_code)
estimates store guimo21
reghdfe lnexport treat_year03  $con2 lnrailway lnhighway if type==2,absorb(  id  year_sector ) vce(cluster county_code)
estimates store guimo22
reghdfe lnexport treat_year03  $con2 lnrailway lnhighway if type==2&year!=2010,absorb(  id  year_sector ) vce(cluster county_code)
estimates store guimo23
outreg2 [ guimo11 guimo12 guimo13 guimo21 guimo22 guimo23] using "$table\A9企业规模.docx",replace bdec(4) sdec(4)
replace type=0 if type==1
replace type=1 if type==2
*
*bdiff,group(type) model(reghdfe lnexport treat_year03  $con2 lnrailway lnhighway ,absorb(  id  year_sector ) vce(cluster county_code))


****************************************FIGURE***************************************
*----------------------图1： 2003-2021年三峡船闸过闸货运量、2000-2021年长江干线港口货物吞吐量和长江干线货物通过量变化趋势图
*excel制作

*----------------------图2：出口额平行趋势检验图
use $temporary/send_data, clear
gen policy = year - 2003
tab policy
forvalues i = 3(-1)1{
  gen pre_`i' = (policy == -`i' &  river_index== 1) 
}
gen current = (policy == 0 & river_index== 1)
forvalues j = 1(1)10{
  gen  post_`j' = (policy == `j' & river_index== 1)
}
drop pre_1
reghdfe lnexport  pre_* current  post_* lnage lnsize  lnlabor  ,absorb(  id   year_sector) vce(cluster county_code)
estimates store pingxing1
coefplot, baselevels ///
keep(pre_*  current post_*) ///
vertical ///
yline(0,lcolor(edkblue*0.8)) ///
xline(3, lwidth(vthin) lpattern(dash) lcolor(teal)) ///
ylabel(,labsize(*0.75)) xlabel(,labsize(*0.75)) ///
ytitle("系数", size(small)) ///
xtitle("year", size(small)) ///
addplot(line @b @at) ///
ciopts(lpattern(dash) recast(rcap) msize(medium)) ///
msymbol(circle_hollow) ///
scheme(s1mono)
graph export $figure/出口额平行趋势检验图.png, replace

*******************************************************
*                         附录：图                    *
*******************************************************
*-------------------------------图A1:长江流域流经省份及长江三峡地理位置

*-------------------------------图A2:三峡大坝平面布置图

*-------------------------------图A3:出口产品多样性的平行趋势检验图
reghdfe lndiversity2  pre_* current  post_* lnage lnsize  lnlabor  ,absorb(  id   year_sector) vce(cluster county_code)
estimates store pingxing1
coefplot, baselevels ///
keep(pre_*  current post_*) ///
vertical ///
yline(0,lcolor(edkblue*0.8)) ///
xline(3, lwidth(vthin) lpattern(dash) lcolor(teal)) ///
ylabel(,labsize(*0.75)) xlabel(,labsize(*0.75)) ///
ytitle("系数", size(small)) ///
xtitle("year", size(small)) ///
addplot(line @b @at) ///
ciopts(lpattern(dash) recast(rcap) msize(medium)) ///
msymbol(circle_hollow) ///
scheme(s1mono)
graph export $figure/出口产品多样性平行趋势检验图.png,replace
*--------------------------------图A4：长江三峡大坝蓄水水位示意图

*--------------------------------图A5-A7见上面

*--------------------------------图A8：企业出口深度边际安慰剂检验t值密度分布

permute treat_year03 beta = _b[treat_year03] se = _se[treat_year03] df = e(df_r), ///
 reps(500) seed(123) saving($temporary/anweiji.dta): ///
reghdfe lnexport treat_year03  $con2 lnrailway lnhighway ,absorb(  id  year_sector ) vce(cluster county_code)
use $temporary/anweiji, clear
gen t_value = beta / se
gen p_value = 2 * ttail(df, abs(beta/se))
twoway (scatter p_value beta, msymbol(smcircle hollow) mcolor(black) msize(tiny)) ///
       (kdensity beta, lp(solid) yaxis(2)), ///
       title("") ///
       xlabel(-0.1(0.1)0.2 0.1560 "0.1560", format(%7.1f) angle(0)) ///
       ylabel(0(0.2)1, format(%7.1f) angle(0) nogrid axis(1)) ///
       ylabel(0(10)60, format(%7.1f) angle(0) nogrid axis(2)) ///
       xtitle("coefficient") ///
       ytitle("p value", orientation(vertical) axis(1)) ///
       ytitle("Kernel density", orientation(vertical) axis(2)) ///
       xline(0.1528, lwidth(0.2) lcolor(red) lp(solid)) ///
       yline(0.1, lwidth(0.2) lp(dash)) ///
       legend(label(1 "p value") label(2 "Kernel density") pos(6) col(2)) ///
       plotregion(style(none)) ///
       graphregion(color(white))
graph export $figure/安慰剂.png, replace

log close